/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.teams.ITeamBase;
import com.flansmod.common.teams.ITeamObject;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.PlayerStats;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsRound;
import com.flansmod.common.types.InfoType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Vec3;

public abstract class GameType {
    public static List<GameType> gameTypeList = new ArrayList<GameType>();
    public static HashMap<String, GameType> gameTypes = new HashMap();
    public static TeamsManager teamsManager = TeamsManager.getInstance();
    public static Random rand = new Random();
    public boolean allowedForRoundsGenerator;
    public String name;
    public String shortName;
    public int numTeamsRequired;

    public static GameType getGameType(String type) {
        return gameTypes.get(type);
    }

    public GameType(String name, String shortName, int numTeams, boolean allowedForRoundsGenerator) {
        this.name = name;
        this.shortName = shortName;
        this.numTeamsRequired = numTeams;
        gameTypes.put(this.shortName, this);
        gameTypeList.add(this);
        this.allowedForRoundsGenerator = allowedForRoundsGenerator;
    }

    public abstract void roundStart();

    public abstract void roundEnd();

    public abstract void roundCleanup();

    public abstract boolean teamHasWon(Team var1);

    public void tick() {
    }

    public Team[] getTeamsCanSpawnAs(TeamsRound currentRound, EntityPlayer player) {
        return currentRound.teams;
    }

    public void playerJoined(EntityPlayerMP player) {
    }

    public void playerRespawned(EntityPlayerMP player) {
    }

    public void playerQuit(EntityPlayerMP player) {
    }

    public boolean playerAttacked(EntityPlayerMP player, DamageSource source) {
        return true;
    }

    public void playerKilled(EntityPlayerMP player, DamageSource source) {
    }

    public void baseAttacked(ITeamBase base, DamageSource source) {
    }

    public void objectAttacked(ITeamObject object, DamageSource source) {
    }

    public void baseClickedByPlayer(ITeamBase base, EntityPlayerMP player) {
    }

    public void objectClickedByPlayer(ITeamObject object, EntityPlayerMP player) {
    }

    public boolean playerCanLoot(ItemStack stack, InfoType infoType, EntityPlayer player, Team playerTeam) {
        return true;
    }

    public abstract Vec3 getSpawnPoint(EntityPlayerMP var1);

    public boolean setVariable(String variable, String value) {
        return false;
    }

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void saveToNBT(NBTTagCompound var1);

    public boolean sortScoreboardByTeam() {
        return true;
    }

    public boolean showZombieScore() {
        return false;
    }

    public boolean playerCanAttack(EntityPlayerMP attacker, Team attackerTeam, EntityPlayerMP victim, Team victimTeam) {
        return true;
    }

    public void entityKilled(Entity entity, DamageSource source) {
    }

    public void vehicleDestroyed(EntityDriveable driveable2, EntityPlayerMP attacker) {
        if (driveable2 != null && attacker != null) {
            EntityDriveable driveable = driveable2;
            ++GameType.getPlayerInfo((EntityPlayerMP)attacker).vehiclesDestroyed;
            if (driveable instanceof EntityPlane) {
                EntityPlane plane = (EntityPlane)driveable;
                if (plane.mode == EnumPlaneMode.PLANE || plane.mode == EnumPlaneMode.VTOL) {
                    GameType.getPlayerInfo(attacker).addExp(100.0f);
                    GameType.getPlayerInfo(attacker).savePlayerStats();
                } else if (plane.mode == EnumPlaneMode.HELI) {
                    GameType.getPlayerInfo(attacker).addExp(75.0f);
                    GameType.getPlayerInfo(attacker).savePlayerStats();
                }
            } else if (driveable instanceof EntityVehicle) {
                EntityVehicle vehicle = (EntityVehicle)driveable;
                if (vehicle.getVehicleType().tank) {
                    GameType.getPlayerInfo(attacker).addExp(75.0f);
                    GameType.getPlayerInfo(attacker).savePlayerStats();
                } else {
                    GameType.getPlayerInfo(attacker).addExp(50.0f);
                    GameType.getPlayerInfo(attacker).savePlayerStats();
                }
            }
        }
    }

    public void playerChoseTeam(EntityPlayerMP player, Team team, Team newTeam) {
    }

    public void playerChoseNewClass(EntityPlayerMP player, PlayerClass playerClass) {
    }

    public void playerDefected(EntityPlayerMP player, Team team, Team newTeam) {
    }

    public void playerEnteredTheGame(EntityPlayerMP player, Team team, PlayerClass playerClass) {
    }

    public static PlayerData getPlayerData(EntityPlayerMP player) {
        return PlayerHandler.getPlayerData((EntityPlayer)player);
    }

    public static PlayerStats getPlayerInfo(EntityPlayerMP player) {
        return PlayerHandler.getPlayerStats(player);
    }

    public static void sendPacketToPlayer(PacketBase packet, EntityPlayerMP player) {
        FlansMod.getPacketHandler().sendTo(packet, player);
    }

    public static String[] getPlayerNames() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }

    public static List<EntityPlayer> getPlayers() {
        return MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
    }

    public static void givePoints(EntityPlayerMP player, int points) {
        PlayerData data = GameType.getPlayerData(player);
        data.score += points;
        if (data.team != null) {
            data.team.score += points;
        }
    }

    public static EntityPlayerMP getPlayerFromDamageSource(DamageSource source) {
        EntityPlayerMP attacker = null;
        if (source instanceof EntityDamageSource && source.func_76346_g() instanceof EntityPlayerMP) {
            attacker = (EntityPlayerMP)source.func_76346_g();
        }
        return attacker;
    }

    public EntityPlayerMP getPlayer(String username) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username);
    }

    public boolean shouldAutobalance() {
        return true;
    }
}

