/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketAAGunAngles;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.network.PacketBaseEdit;
import com.flansmod.common.network.PacketBreakSound;
import com.flansmod.common.network.PacketBuyArmour;
import com.flansmod.common.network.PacketBuyWeapon;
import com.flansmod.common.network.PacketCraftDriveable;
import com.flansmod.common.network.PacketDriveableControl;
import com.flansmod.common.network.PacketDriveableDamage;
import com.flansmod.common.network.PacketDriveableGUI;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketDriveableKeyHeld;
import com.flansmod.common.network.PacketExplosion;
import com.flansmod.common.network.PacketFlak;
import com.flansmod.common.network.PacketFlashBang;
import com.flansmod.common.network.PacketGetPlayerClasses;
import com.flansmod.common.network.PacketGunFire;
import com.flansmod.common.network.PacketGunMode;
import com.flansmod.common.network.PacketGunPaint;
import com.flansmod.common.network.PacketGunRecoil;
import com.flansmod.common.network.PacketGunSpread;
import com.flansmod.common.network.PacketGunState;
import com.flansmod.common.network.PacketHashSend;
import com.flansmod.common.network.PacketHitMarker;
import com.flansmod.common.network.PacketImpactPoint;
import com.flansmod.common.network.PacketKillMessage;
import com.flansmod.common.network.PacketMGFire;
import com.flansmod.common.network.PacketMGMount;
import com.flansmod.common.network.PacketMechaControl;
import com.flansmod.common.network.PacketModConfig;
import com.flansmod.common.network.PacketMuzzleFlash;
import com.flansmod.common.network.PacketOffHandGunInfo;
import com.flansmod.common.network.PacketParticle;
import com.flansmod.common.network.PacketPlaneControl;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketReload;
import com.flansmod.common.network.PacketRepairDriveable;
import com.flansmod.common.network.PacketRequestDebug;
import com.flansmod.common.network.PacketRoundFinished;
import com.flansmod.common.network.PacketSeatCheck;
import com.flansmod.common.network.PacketSeatUpdates;
import com.flansmod.common.network.PacketSelectOffHandGun;
import com.flansmod.common.network.PacketSendPlayerClasses;
import com.flansmod.common.network.PacketSetPreferredAmmo;
import com.flansmod.common.network.PacketTeamInfo;
import com.flansmod.common.network.PacketTeamSelect;
import com.flansmod.common.network.PacketVehicleControl;
import com.flansmod.common.network.PacketVoteCast;
import com.flansmod.common.network.PacketVoting;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;

@ChannelHandler.Sharable
public class PacketHandler
extends MessageToMessageCodec<FMLProxyPacket, PacketBase> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private LinkedList<Class<? extends PacketBase>> packets = new LinkedList();
    private boolean modInitialised = false;

    public boolean registerPacket(Class<? extends PacketBase> cl) {
        if (this.packets.size() > 256) {
            FlansMod.log("Packet limit exceeded in Flan's Mod packet handler by packet " + cl.getCanonicalName() + ".");
            return false;
        }
        if (this.packets.contains(cl)) {
            FlansMod.log("Tried to register " + cl.getCanonicalName() + " packet class twice.");
            return false;
        }
        if (this.modInitialised) {
            FlansMod.log("Tried to register packet " + cl.getCanonicalName() + " after mod initialisation.");
            return false;
        }
        this.packets.add(cl);
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, PacketBase msg, List<Object> out) throws Exception {
        ByteBuf encodedData = Unpooled.buffer();
        Class<?> cl = msg.getClass();
        if (!this.packets.contains(cl)) {
            throw new NullPointerException("Packet not registered : " + cl.getCanonicalName());
        }
        byte discriminator = (byte)this.packets.indexOf(cl);
        encodedData.writeByte((int)discriminator);
        msg.encodeInto(ctx, encodedData);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(encodedData.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf encodedData = msg.payload();
        byte discriminator = encodedData.readByte();
        Class<? extends PacketBase> cl = this.packets.get(discriminator);
        if (cl == null) {
            throw new NullPointerException("Packet not registered for discriminator : " + discriminator);
        }
        PacketBase packet = cl.newInstance();
        packet.decodeInto(ctx, encodedData.slice());
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                packet.handleClientSide(this.getClientPlayer());
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                packet.handleServerSide(((NetHandlerPlayServer)netHandler).field_147369_b);
                break;
            }
        }
    }

    public void initialise() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("FlansMod", new ChannelHandler[]{this});
        this.registerPacket(PacketAAGunAngles.class);
        this.registerPacket(PacketBaseEdit.class);
        this.registerPacket(PacketBreakSound.class);
        this.registerPacket(PacketBuyArmour.class);
        this.registerPacket(PacketBuyWeapon.class);
        this.registerPacket(PacketCraftDriveable.class);
        this.registerPacket(PacketDriveableControl.class);
        this.registerPacket(PacketDriveableDamage.class);
        this.registerPacket(PacketDriveableGUI.class);
        this.registerPacket(PacketDriveableKey.class);
        this.registerPacket(PacketDriveableKeyHeld.class);
        this.registerPacket(PacketFlak.class);
        this.registerPacket(PacketExplosion.class);
        this.registerPacket(PacketGunFire.class);
        this.registerPacket(PacketGunMode.class);
        this.registerPacket(PacketGunPaint.class);
        this.registerPacket(PacketGunSpread.class);
        this.registerPacket(PacketKillMessage.class);
        this.registerPacket(PacketMechaControl.class);
        this.registerPacket(PacketMGFire.class);
        this.registerPacket(PacketMGMount.class);
        this.registerPacket(PacketOffHandGunInfo.class);
        this.registerPacket(PacketParticle.class);
        this.registerPacket(PacketPlaneControl.class);
        this.registerPacket(PacketPlaySound.class);
        this.registerPacket(PacketReload.class);
        this.registerPacket(PacketRepairDriveable.class);
        this.registerPacket(PacketRoundFinished.class);
        this.registerPacket(PacketSeatUpdates.class);
        this.registerPacket(PacketSeatCheck.class);
        this.registerPacket(PacketSelectOffHandGun.class);
        this.registerPacket(PacketTeamInfo.class);
        this.registerPacket(PacketTeamSelect.class);
        this.registerPacket(PacketVehicleControl.class);
        this.registerPacket(PacketVoteCast.class);
        this.registerPacket(PacketVoting.class);
        this.registerPacket(PacketRequestDebug.class);
        this.registerPacket(PacketFlashBang.class);
        this.registerPacket(PacketImpactPoint.class);
        this.registerPacket(PacketModConfig.class);
        this.registerPacket(PacketGunRecoil.class);
        this.registerPacket(PacketGunState.class);
        this.registerPacket(PacketHashSend.class);
        this.registerPacket(PacketMuzzleFlash.class);
        this.registerPacket(PacketHitMarker.class);
        this.registerPacket(PacketSetPreferredAmmo.class);
        this.registerPacket(PacketGetPlayerClasses.class);
        this.registerPacket(PacketSendPlayerClasses.class);
    }

    public void postInitialise() {
        if (this.modInitialised) {
            return;
        }
        this.modInitialised = true;
        Collections.sort(this.packets, new Comparator<Class<? extends PacketBase>>(){

            @Override
            public int compare(Class<? extends PacketBase> c1, Class<? extends PacketBase> c2) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(c1.getCanonicalName(), c2.getCanonicalName());
                if (com == 0) {
                    com = c1.getCanonicalName().compareTo(c2.getCanonicalName());
                }
                return com;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(PacketBase packet) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendTo(PacketBase packet, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToDimension(PacketBase packet, int dimensionID) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionID);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToServer(PacketBase packet) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    public void sendToAll(Packet packet) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148540_a(packet);
    }

    public void sendTo(Packet packet, EntityPlayerMP player) {
        player.field_71135_a.func_147359_a(packet);
    }

    public void sendToAllAround(Packet packet, NetworkRegistry.TargetPoint point) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148541_a(point.x, point.y, point.z, point.range, point.dimension, packet);
    }

    public void sendToDimension(Packet packet, int dimensionID) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148537_a(packet, dimensionID);
    }

    public void sendToServer(Packet packet) {
        Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a(packet);
    }

    public void sendToAllAround(PacketBase packet, double x, double y, double z, float range, int dimension) {
        this.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dimension, x, y, z, (double)range));
    }

    public void sendToDonut(PacketBase packet, double x, double y, double z, float minRange, float maxRange, int dimension) {
        List players = FMLCommonHandler.instance().getSide().isClient() ? Minecraft.func_71410_x().field_71441_e.field_73010_i : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        float minRangeSq = minRange * minRange;
        float maxRangeSq = maxRange * maxRange;
        for (Object p : players) {
            double dist;
            if (!(p instanceof EntityPlayerMP)) continue;
            EntityPlayerMP pl = (EntityPlayerMP)p;
            if (pl.field_71093_bK != dimension || !((dist = (pl.field_70165_t - x) * (pl.field_70165_t - x) + (pl.field_70163_u - y) * (pl.field_70163_u - y) + (pl.field_70161_v - z) * (pl.field_70161_v - z)) > (double)minRangeSq) || !(dist < (double)maxRangeSq)) continue;
            this.sendTo(packet, pl);
        }
    }

    public void sendToAllExcept(PacketBase packet, double x, double y, double z, float range, EntityPlayer player, int dimension) {
        List players = FMLCommonHandler.instance().getSide().isClient() ? Minecraft.func_71410_x().field_71441_e.field_73010_i : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        float rangeSq = range * range;
        for (Object p : players) {
            double dist;
            if (!(p instanceof EntityPlayerMP)) continue;
            EntityPlayerMP pl = (EntityPlayerMP)p;
            if (pl.field_71093_bK != dimension || pl.func_110124_au().equals(player.func_110124_au()) || !((dist = (pl.field_70165_t - x) * (pl.field_70165_t - x) + (pl.field_70163_u - y) * (pl.field_70163_u - y) + (pl.field_70161_v - z) * (pl.field_70161_v - z)) < (double)rangeSq)) continue;
            this.sendTo(packet, pl);
        }
    }
}

