/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns.boxes;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.GunBoxEntry;
import com.flansmod.common.guns.boxes.GunPage;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class GunBoxType
extends InfoType {
    public BlockGunBox block;
    public String topTexturePath;
    public String sideTexturePath;
    public String bottomTexturePath;
    public IIcon top;
    public IIcon side;
    public IIcon bottom;
    public int nextGun = -1;
    public GunBoxEntry[] gunEntries;
    public List<GunPage> gunPages = new ArrayList<GunPage>();
    public GunPage currentPage;
    public String guiTexturePath;
    public String gunBoxTextColor = "404040";
    public String itemListTextColor = "404040";
    public String itemTextColor = "404040";
    public String pageTextColor = "FFFFFF";
    public String buttonTextColor = "FFFFFF";
    public String buttonTextHoverColor = "FFFFA0";
    private static int lastIconIndex = 2;
    public static HashMap<String, GunBoxType> gunBoxMap = new HashMap();

    public GunBoxType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        this.gunEntries = new GunBoxEntry[8];
        this.currentPage = new GunPage("Default");
    }

    @Override
    public void postRead(TypeFile file) {
        this.currentPage.addGunList(Arrays.copyOf(this.gunEntries, this.nextGun + 1));
        this.gunPages.add(this.currentPage);
        gunBoxMap.put(this.shortName, this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        block25: {
            super.read(split, file);
            try {
                block24: {
                    if (split[0].equals("TopTexture")) {
                        this.topTexturePath = split[1];
                    }
                    if (split[0].equals("BottomTexture")) {
                        this.bottomTexturePath = split[1];
                    }
                    if (split[0].equals("SideTexture")) {
                        this.sideTexturePath = split[1];
                    }
                    if (split[0].equals("Page") || split[0].equals("SetPage")) {
                        String[] pageNameArray = Arrays.copyOfRange(split, 1, split.length);
                        StringBuilder pageName = new StringBuilder();
                        for (int i = 0; i < pageNameArray.length; ++i) {
                            pageName.append(pageNameArray[i]);
                            if (i + 1 >= pageNameArray.length) continue;
                            pageName.append(" ");
                        }
                        if (this.gunEntries[0] != null) {
                            this.currentPage.addGunList(Arrays.copyOf(this.gunEntries, this.nextGun + 1));
                            this.iteratePage(pageName.toString());
                        } else {
                            this.currentPage.setPageName(pageName.toString());
                        }
                    }
                    if (split[0].equals("AddGun")) {
                        try {
                            List<ItemStack> parts = this.getRecipe(split);
                            ++this.nextGun;
                            if (this.nextGun > this.gunEntries.length - 1) {
                                this.currentPage.addGunList(Arrays.copyOf(this.gunEntries, this.nextGun));
                                this.iteratePage("Default " + (this.gunPages.size() + 2));
                                ++this.nextGun;
                            }
                            this.gunEntries[this.nextGun] = new GunBoxEntry(InfoType.getType(split[1]), parts);
                        }
                        catch (Exception e) {
                            if (!FlansMod.printDebugLog) break block24;
                            FlansMod.log("Failed to add gun %s to box %s", split[1], this.shortName);
                        }
                    }
                }
                if (split[0].equals("AddAmmo") || split[0].equals("AddAltAmmo") || split[0].equals("AddAlternateAmmo")) {
                    try {
                        if (InfoType.getType(split[1]) != null && InfoType.getType((String)split[1]).item != null) {
                            this.gunEntries[this.nextGun].addAmmoEntry(new GunBoxEntry(InfoType.getType(split[1]), this.getRecipe(split)));
                        }
                    }
                    catch (Exception e) {
                        FlansMod.log("Failed to add ammo (%s) to box (%s)", split[1], this.shortName);
                    }
                }
                if (split[0].equals("GuiTexture")) {
                    this.guiTexturePath = split[1];
                }
                if (split[0].equals("GunBoxNameColor")) {
                    this.gunBoxTextColor = split[1];
                }
                if (split[0].equals("PageTextColor")) {
                    this.pageTextColor = split[1];
                }
                if (split[0].equals("ListTextColor")) {
                    this.itemListTextColor = split[1];
                }
                if (split[0].equals("ItemTextColor")) {
                    this.itemTextColor = split[1];
                }
                if (split[0].equals("ButtonTextColor")) {
                    this.buttonTextColor = split[1];
                }
                if (split[0].equals("ButtonTextHighlight")) {
                    this.buttonTextHoverColor = split[1];
                }
            }
            catch (Exception e) {
                FlansMod.log("Reading gun box file failed : " + this.shortName);
                if (!FlansMod.printStackTrace) break block25;
                FlansMod.log(e.toString());
            }
        }
    }

    public void iteratePage(String s) {
        this.gunPages.add(this.currentPage);
        this.gunEntries = new GunBoxEntry[8];
        this.nextGun = -1;
        this.currentPage = new GunPage(s);
    }

    public static GunBoxType getBox(String s) {
        return gunBoxMap.get(s);
    }

    public static GunBoxType getBox(Block block) {
        for (GunBoxType type : gunBoxMap.values()) {
            if (type.block != block) continue;
            return type;
        }
        return null;
    }

    public List<ItemStack> getRecipe(String[] split) {
        ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
        for (int i = 0; i < (split.length - 2) / 2; ++i) {
            if (split[i * 2 + 3].contains(".")) {
                recipe.add(GunBoxType.getRecipeElement(split[i * 2 + 3].split("\\.")[0], Integer.parseInt(split[i * 2 + 2]), Integer.valueOf(split[i * 2 + 3].split("\\.")[1]), this.shortName));
                continue;
            }
            recipe.add(GunBoxType.getRecipeElement(split[i * 2 + 3], Integer.parseInt(split[i * 2 + 2]), 0, this.shortName));
        }
        return recipe;
    }

    @Override
    public void addRecipe(Item par1Item) {
        block23: {
            if (this.smeltableFrom != null) {
                GameRegistry.addSmelting((ItemStack)GunBoxType.getRecipeElement(this.smeltableFrom, 0), (ItemStack)new ItemStack(this.item), (float)0.0f);
            }
            if (this.recipeLine == null) {
                return;
            }
            try {
                if (!this.shapeless) {
                    Object[] newRecipe1;
                    int last;
                    int rows = 3;
                    if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(1);
                        }
                        if (((String)this.recipe[0]).charAt(0) == ' ' && ((String)this.recipe[1]).charAt(0) == ' ' && ((String)this.recipe[2]).charAt(0) == ' ') {
                            for (i = 0; i < 3; ++i) {
                                this.recipe[i] = ((String)this.recipe[i]).substring(1);
                            }
                        }
                    }
                    if (((String)this.recipe[0]).charAt(last = ((String)this.recipe[0]).length() - 1) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                        int i;
                        for (i = 0; i < 3; ++i) {
                            this.recipe[i] = ((String)this.recipe[i]).substring(0, last);
                        }
                        if (((String)this.recipe[0]).charAt(--last) == ' ' && ((String)this.recipe[1]).charAt(last) == ' ' && ((String)this.recipe[2]).charAt(last) == ' ') {
                            for (i = 0; i < 3; ++i) {
                                this.recipe[i] = ((String)this.recipe[i]).substring(0, 0);
                            }
                        }
                    }
                    if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                        Object[] newRecipe = new Object[this.recipe.length - 1];
                        newRecipe[0] = this.recipe[1];
                        newRecipe[1] = this.recipe[2];
                        this.recipe = newRecipe;
                        --rows;
                        if (this.recipe[0].equals(" ") || this.recipe[0].equals("  ") || this.recipe[0].equals("   ")) {
                            newRecipe1 = new Object[this.recipe.length - 1];
                            newRecipe1[0] = this.recipe[1];
                            this.recipe = newRecipe1;
                            --rows;
                        }
                    }
                    if (this.recipe[rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                        Object[] newRecipe = new Object[this.recipe.length - 1];
                        newRecipe[0] = this.recipe[0];
                        newRecipe[1] = this.recipe[1];
                        this.recipe = newRecipe;
                        if (this.recipe[--rows - 1].equals(" ") || this.recipe[rows - 1].equals("  ") || this.recipe[rows - 1].equals("   ")) {
                            newRecipe1 = new Object[this.recipe.length - 1];
                            newRecipe1[0] = this.recipe[0];
                            this.recipe = newRecipe1;
                            --rows;
                        }
                    }
                    for (int i = 0; i < (this.recipeLine.length - 1) / 2; ++i) {
                        this.recipe[i * 2 + rows] = Character.valueOf(this.recipeLine[i * 2 + 1].charAt(0));
                        this.recipe[i * 2 + rows + 1] = this.recipeLine[i * 2 + 2].contains(".") ? GunBoxType.getRecipeElement(this.recipeLine[i * 2 + 2].split("\\.")[0], Integer.valueOf(this.recipeLine[i * 2 + 2].split("\\.")[1])) : GunBoxType.getRecipeElement(this.recipeLine[i * 2 + 2], 0);
                    }
                    GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this.block, this.recipeOutput, 0), (Object[])this.recipe);
                } else {
                    this.recipe = new Object[this.recipeLine.length - 1];
                    for (int i = 0; i < this.recipeLine.length - 1; ++i) {
                        this.recipe[i] = this.recipeLine[i + 1].contains(".") ? GunBoxType.getRecipeElement(this.recipeLine[i + 1].split("\\.")[0], Integer.valueOf(this.recipeLine[i + 1].split("\\.")[1])) : GunBoxType.getRecipeElement(this.recipeLine[i + 1], 0);
                    }
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.block, this.recipeOutput, 0), (Object[])this.recipe);
                }
            }
            catch (Exception e) {
                if (this.recipe != null) {
                    StringBuilder msg = new StringBuilder(" : ");
                    for (Object o : this.recipe) {
                        msg.append(" ").append(o);
                    }
                    FlansMod.log("Failed to add recipe for : " + this.shortName + msg);
                } else {
                    FlansMod.log("Failed to add recipe for : " + this.shortName);
                }
                if (!FlansMod.printStackTrace) break block23;
                e.printStackTrace();
            }
        }
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }
}

