/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task.multi;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ChunkRenderController;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.ChunkCoord;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.task.multi.ITask;
import org.apache.logging.log4j.Logger;

public abstract class BaseMapTask
implements ITask {
    static final Logger logger = JourneyMap.getLogger();
    protected static ChunkCoordIntPair[] keepAliveOffsets = new ChunkCoordIntPair[]{new ChunkCoordIntPair(0, -1), new ChunkCoordIntPair(-1, 0), new ChunkCoordIntPair(-1, -1)};
    private static BufferedImage blankChunkImage = null;
    private static BufferedImage blankChunkImageUnderground = null;
    final World world;
    final Collection<ChunkCoordIntPair> chunkCoords;
    final boolean flushCacheWhenDone;
    final ChunkRenderController renderController;
    final int elapsedLimit;
    final MapType mapType;

    public BaseMapTask(ChunkRenderController renderController, World world, MapType mapType, Collection<ChunkCoordIntPair> chunkCoords, boolean flushCacheWhenDone, int elapsedLimit) {
        this.renderController = renderController;
        this.world = world;
        this.mapType = mapType;
        this.chunkCoords = chunkCoords;
        this.flushCacheWhenDone = flushCacheWhenDone;
        this.elapsedLimit = elapsedLimit;
    }

    public void initTask(Minecraft mc, JourneyMap jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performTask(Minecraft mc, JourneyMap jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
        StatTimer timer = StatTimer.get(this.getClass().getSimpleName() + ".performTask", 5, this.elapsedLimit).start();
        this.initTask(mc, jm, jmWorldDir, threadLogging);
        int count = 0;
        try {
            if (mc.field_71441_e == null) {
                this.complete(true, false);
                return;
            }
            long start = System.nanoTime();
            Iterator<ChunkCoordIntPair> chunkIter = this.chunkCoords.iterator();
            int currentDimension = mc.field_71441_e.field_73011_w.field_76574_g;
            if (currentDimension != this.mapType.dimension) {
                if (threadLogging) {
                    logger.debug("Dimension changed, map task obsolete.");
                }
                timer.cancel();
                this.complete(true, false);
                return;
            }
            while (chunkIter.hasNext()) {
                if (!jm.isMapping().booleanValue()) {
                    if (threadLogging) {
                        logger.debug("JM isn't mapping, aborting");
                    }
                    timer.cancel();
                    this.complete(true, false);
                    return;
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ChunkCoordIntPair coord = chunkIter.next();
                ChunkMD chunkMd = DataCache.instance().getChunkMD(coord);
                if (chunkMd == null || !chunkMd.hasChunk()) continue;
                try {
                    ChunkCoord cCoord = ChunkCoord.fromChunkMD(jmWorldDir, this.mapType, chunkMd);
                    this.renderController.renderChunk(cCoord, chunkMd, this.mapType);
                    ++count;
                }
                catch (ChunkMD.ChunkMissingException e) {
                    logger.info(e.getMessage());
                }
            }
            if (!jm.isMapping().booleanValue()) {
                if (threadLogging) {
                    logger.debug("JM isn't mapping, aborting.");
                }
                timer.cancel();
                this.complete(true, false);
                return;
            }
            if (Thread.interrupted()) {
                timer.cancel();
                throw new InterruptedException();
            }
            RegionImageCache.instance().updateTextures(this.flushCacheWhenDone);
            this.chunkCoords.clear();
            this.complete(false, false);
            timer.stop();
        }
        catch (InterruptedException t) {
            JourneyMap.getLogger().warn("Task thread interrupted: " + this);
            timer.cancel();
            throw t;
        }
        catch (Throwable t) {
            String error = "Unexpected error in BaseMapTask: " + LogFormatter.toString(t);
            JourneyMap.getLogger().error(error);
            this.complete(false, true);
            timer.cancel();
        }
        finally {
            if (threadLogging) {
                timer.report();
            }
        }
    }

    protected abstract void complete(boolean var1, boolean var2);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "world=" + this.world + ", mapType=" + this.mapType + ", chunkCoords=" + this.chunkCoords + ", flushCacheWhenDone=" + this.flushCacheWhenDone + '}';
    }
}

