/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.base.Objects;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.techbrew.journeymap.model.ImageHolder;
import net.techbrew.journeymap.model.MapType;

public abstract class ImageSet {
    protected final Map<MapType, ImageHolder> imageHolders = Collections.synchronizedMap(new HashMap(8));

    protected abstract ImageHolder getHolder(MapType var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public BufferedImage getImage(MapType mapType) {
        return this.getHolder(mapType).getImage();
    }

    public boolean writeToDisk(boolean force) {
        boolean updated = false;
        for (ImageHolder imageHolder : this.imageHolders.values()) {
            if (!force && !imageHolder.isDirty()) continue;
            imageHolder.writeToDisk();
            updated = true;
        }
        return updated;
    }

    public boolean updatedSince(MapType mapType, long time) {
        for (ImageHolder imageHolder : this.imageHolders.values()) {
            if (!(mapType != null ? imageHolder.getMapType() == mapType && imageHolder.getImageTimestamp() > time : imageHolder.getImageTimestamp() > time)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (ImageHolder imageHolder : this.imageHolders.values()) {
            imageHolder.clear();
        }
        this.imageHolders.clear();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("imageHolders", this.imageHolders.entrySet()).toString();
    }

    protected abstract int getImageSize();

    protected ImageHolder addHolder(MapType mapType, File imageFile) {
        return this.addHolder(new ImageHolder(mapType, imageFile, this.getImageSize()));
    }

    protected ImageHolder addHolder(ImageHolder imageHolder) {
        this.imageHolders.put(imageHolder.mapType, imageHolder);
        return imageHolder;
    }
}

