/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import cpw.mods.fml.client.FMLClientHandler;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.Minecraft;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.BlockMDCache;

public class ChunkMD {
    public static final String PROP_IS_SLIME_CHUNK = "isSlimeChunk";
    public static final String PROP_LOADED = "loaded";
    public static final String PROP_LAST_RENDERED = "lastRendered";
    static final DataCache dataCache = DataCache.instance();
    private final SoftReference<Chunk> chunkReference;
    private final ChunkCoordIntPair coord;
    private final HashMap<String, Serializable> properties = new HashMap();

    public ChunkMD(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk can't be null");
        }
        this.chunkReference = new SoftReference<Chunk>(chunk);
        this.coord = new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h);
        this.setProperty(PROP_LOADED, Long.valueOf(System.currentTimeMillis()));
        this.properties.put(PROP_IS_SLIME_CHUNK, Boolean.valueOf(chunk.func_76617_a(987234911L).nextInt(10) == 0));
    }

    public Block getBlock(int x, int y, int z) {
        return this.getChunk().func_150810_a(x, y, z);
    }

    public int getSavedLightValue(EnumSkyBlock par1EnumSkyBlock, int x, int y, int z) {
        return this.getChunk().func_76614_a(par1EnumSkyBlock, x, Math.min(y, this.getWorldActualHeight() - 1), z);
    }

    public final BlockMD getTopBlockMD(int x, int y, int z) {
        BlockMD topBlockMd = null;
        while ((topBlockMd = dataCache.getBlockMD(this, x, y, z)) != null && (topBlockMd.isTransparentRoof() || topBlockMd.isAir() || topBlockMd.getAlpha() == 0.0f) && --y >= 0) {
        }
        return topBlockMd;
    }

    public int ceiling(int x, int z) {
        int chunkHeight;
        BlockMDCache blockMDCache = dataCache.getBlockMetadata();
        int y = chunkHeight = this.getHeightValue(x, z);
        try {
            while (y >= 0) {
                Block block = this.getBlock(x, y, z);
                if (block instanceof BlockAir) {
                    --y;
                    continue;
                }
                if (blockMDCache.hasFlag(block, BlockMD.Flag.HasAir) || blockMDCache.hasFlag(block, BlockMD.Flag.OpenToSky)) {
                    --y;
                    continue;
                }
                if (this.getChunk().func_76619_d(x, y, z)) {
                    --y;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            JourneyMap.getLogger().warn(e + " at " + x + "," + y + "," + z);
        }
        return Math.max(0, y);
    }

    public boolean hasChunk() {
        return this.chunkReference.get() != null;
    }

    public int getHeightValue(int x, int z) {
        return this.getChunk().func_76611_b(x, z);
    }

    public int getAbsoluteHeightValue(int x, int z) {
        return this.getChunk().func_76626_d(x, z);
    }

    public int getLightOpacity(BlockMD blockMD, int localX, int y, int localZ) {
        return blockMD.getBlock().getLightOpacity((IBlockAccess)this.getWorldObj(), (this.getCoord().field_77276_a << 4) + localX, y, (this.getCoord().field_77275_b << 4) + localZ);
    }

    public Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    public Serializable getProperty(String name, Serializable defaultValue) {
        Serializable currentValue = this.getProperty(name);
        if (currentValue == null) {
            this.setProperty(name, defaultValue);
            currentValue = defaultValue;
        }
        return currentValue;
    }

    public Serializable setProperty(String name, Serializable value) {
        return this.properties.put(name, value);
    }

    public int hashCode() {
        return this.getCoord().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkMD other = (ChunkMD)obj;
        return this.getCoord().equals((Object)other.getCoord());
    }

    public Chunk getChunk() {
        Chunk chunk = this.chunkReference.get();
        if (chunk == null) {
            throw new ChunkMissingException(this.getCoord());
        }
        return chunk;
    }

    public World getWorldObj() {
        return this.getChunk().field_76637_e;
    }

    public int getWorldActualHeight() {
        return this.getChunk().field_76637_e.func_72940_L();
    }

    public Boolean getHasNoSky() {
        return this.getChunk().field_76637_e.field_73011_w.field_76576_e;
    }

    public ChunkCoordIntPair getCoord() {
        return this.coord;
    }

    public boolean isSlimeChunk() {
        return (Boolean)this.getProperty(PROP_IS_SLIME_CHUNK, Boolean.FALSE);
    }

    public long getLoaded() {
        return (Long)this.getProperty(PROP_LOADED, Long.valueOf(0L));
    }

    public long getLastRendered() {
        return (Long)this.getProperty(PROP_LAST_RENDERED, Long.valueOf(0L));
    }

    public long setRendered() {
        long now = System.currentTimeMillis();
        this.setProperty(PROP_LAST_RENDERED, Long.valueOf(now));
        return now;
    }

    public int toBlockX(int localX) {
        return (this.coord.field_77276_a << 4) + localX;
    }

    public int toBlockZ(int localZ) {
        return (this.coord.field_77275_b << 4) + localZ;
    }

    public String toString() {
        return "ChunkMD{coord=" + this.coord + ", properties=" + this.properties + '}';
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ChunkCoordIntPair, Optional<ChunkMD>> {
        Minecraft mc = FMLClientHandler.instance().getClient();

        public Optional<ChunkMD> load(ChunkCoordIntPair coord) throws Exception {
            ChunkMD chunkMD = ChunkLoader.getChunkMdFromMemory((World)this.mc.field_71441_e, coord.field_77276_a, coord.field_77275_b);
            return Optional.fromNullable((Object)chunkMD);
        }
    }

    public static class ChunkMissingException
    extends RuntimeException {
        ChunkMissingException(ChunkCoordIntPair coord) {
            super("Chunk missing: " + coord);
        }
    }
}

