/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineHelper;
import ar.com.hjg.pngj.PngjExceptionInternal;

public class ImageLine {
    public final ImageInfo imgInfo;
    private int rown = 0;
    public final int[] scanline;
    public final byte[] scanlineb;
    protected FilterType filterUsed;
    final int channels;
    final int bitDepth;
    final int elementsPerRow;
    public final SampleType sampleType;
    public final boolean samplesUnpacked;

    public ImageLine(ImageInfo imgInfo) {
        this(imgInfo, SampleType.INT, false);
    }

    public ImageLine(ImageInfo imgInfo, SampleType stype, boolean unpackedMode) {
        this(imgInfo, stype, unpackedMode, null, null);
    }

    ImageLine(ImageInfo imgInfo, SampleType stype, boolean unpackedMode, int[] sci, byte[] scb) {
        this.imgInfo = imgInfo;
        this.channels = imgInfo.channels;
        this.bitDepth = imgInfo.bitDepth;
        this.filterUsed = FilterType.FILTER_UNKNOWN;
        this.sampleType = stype;
        this.samplesUnpacked = unpackedMode || !imgInfo.packed;
        int n = this.elementsPerRow = this.samplesUnpacked ? imgInfo.samplesPerRow : imgInfo.samplesPerRowPacked;
        if (stype == SampleType.INT) {
            this.scanline = sci != null ? sci : new int[this.elementsPerRow];
            this.scanlineb = null;
        } else if (stype == SampleType.BYTE) {
            this.scanlineb = scb != null ? scb : new byte[this.elementsPerRow];
            this.scanline = null;
        } else {
            throw new PngjExceptionInternal("bad ImageLine initialization");
        }
        this.rown = -1;
    }

    public int getRown() {
        return this.rown;
    }

    public void setRown(int n) {
        this.rown = n;
    }

    static void unpackInplaceInt(ImageInfo iminfo, int[] src, int[] dst, boolean scale) {
        int offset;
        int mask;
        int bitDepth = iminfo.bitDepth;
        if (bitDepth >= 8) {
            return;
        }
        int mask0 = ImageLineHelper.getMaskForPackedFormatsLs(bitDepth);
        int scalefactor = 8 - bitDepth;
        int offset0 = 8 * iminfo.samplesPerRowPacked - bitDepth * iminfo.samplesPerRow;
        if (offset0 != 8) {
            mask = mask0 << offset0;
            offset = offset0;
        } else {
            mask = mask0;
            offset = 0;
        }
        int i = iminfo.samplesPerRowPacked - 1;
        for (int j = iminfo.samplesPerRow - 1; j >= 0; --j) {
            int v = (src[i] & mask) >> offset;
            if (scale) {
                v <<= scalefactor;
            }
            dst[j] = v;
            mask <<= bitDepth;
            if ((offset += bitDepth) != 8) continue;
            mask = mask0;
            offset = 0;
            --i;
        }
    }

    static void packInplaceInt(ImageInfo iminfo, int[] src, int[] dst, boolean scaled) {
        int bitDepth = iminfo.bitDepth;
        if (bitDepth >= 8) {
            return;
        }
        int mask0 = ImageLineHelper.getMaskForPackedFormatsLs(bitDepth);
        int scalefactor = 8 - bitDepth;
        int offset0 = 8 - bitDepth;
        int offset = 8 - bitDepth;
        int v0 = src[0];
        dst[0] = 0;
        if (scaled) {
            v0 >>= scalefactor;
        }
        v0 = (v0 & mask0) << offset;
        int i = 0;
        for (int j = 0; j < iminfo.samplesPerRow; ++j) {
            int v = src[j];
            if (scaled) {
                v >>= scalefactor;
            }
            int n = i++;
            dst[n] = dst[n] | (v & mask0) << offset;
            if ((offset -= bitDepth) >= 0) continue;
            offset = offset0;
            dst[i] = 0;
        }
        dst[0] = dst[0] | v0;
    }

    static void unpackInplaceByte(ImageInfo iminfo, byte[] src, byte[] dst, boolean scale) {
        int offset;
        int mask;
        int bitDepth = iminfo.bitDepth;
        if (bitDepth >= 8) {
            return;
        }
        int mask0 = ImageLineHelper.getMaskForPackedFormatsLs(bitDepth);
        int scalefactor = 8 - bitDepth;
        int offset0 = 8 * iminfo.samplesPerRowPacked - bitDepth * iminfo.samplesPerRow;
        if (offset0 != 8) {
            mask = mask0 << offset0;
            offset = offset0;
        } else {
            mask = mask0;
            offset = 0;
        }
        int i = iminfo.samplesPerRowPacked - 1;
        for (int j = iminfo.samplesPerRow - 1; j >= 0; --j) {
            int v = (src[i] & mask) >> offset;
            if (scale) {
                v <<= scalefactor;
            }
            dst[j] = (byte)v;
            mask <<= bitDepth;
            if ((offset += bitDepth) != 8) continue;
            mask = mask0;
            offset = 0;
            --i;
        }
    }

    static void packInplaceByte(ImageInfo iminfo, byte[] src, byte[] dst, boolean scaled) {
        int bitDepth = iminfo.bitDepth;
        if (bitDepth >= 8) {
            return;
        }
        int mask0 = ImageLineHelper.getMaskForPackedFormatsLs(bitDepth);
        int scalefactor = 8 - bitDepth;
        int offset0 = 8 - bitDepth;
        int offset = 8 - bitDepth;
        int v0 = src[0];
        dst[0] = 0;
        if (scaled) {
            v0 >>= scalefactor;
        }
        v0 = (v0 & mask0) << offset;
        int i = 0;
        for (int j = 0; j < iminfo.samplesPerRow; ++j) {
            int v = src[j];
            if (scaled) {
                v >>= scalefactor;
            }
            int n = i++;
            dst[n] = (byte)(dst[n] | (v & mask0) << offset);
            if ((offset -= bitDepth) >= 0) continue;
            offset = offset0;
            dst[i] = 0;
        }
        dst[0] = (byte)(dst[0] | v0);
    }

    public ImageLine unpackToNewImageLine() {
        ImageLine newline = new ImageLine(this.imgInfo, this.sampleType, true);
        if (this.sampleType == SampleType.INT) {
            ImageLine.unpackInplaceInt(this.imgInfo, this.scanline, newline.scanline, false);
        } else {
            ImageLine.unpackInplaceByte(this.imgInfo, this.scanlineb, newline.scanlineb, false);
        }
        return newline;
    }

    public ImageLine packToNewImageLine() {
        ImageLine newline = new ImageLine(this.imgInfo, this.sampleType, false);
        if (this.sampleType == SampleType.INT) {
            ImageLine.packInplaceInt(this.imgInfo, this.scanline, newline.scanline, false);
        } else {
            ImageLine.packInplaceByte(this.imgInfo, this.scanlineb, newline.scanlineb, false);
        }
        return newline;
    }

    public FilterType getFilterUsed() {
        return this.filterUsed;
    }

    public void setFilterUsed(FilterType ft) {
        this.filterUsed = ft;
    }

    public int[] getScanlineInt() {
        return this.scanline;
    }

    public byte[] getScanlineByte() {
        return this.scanlineb;
    }

    public String toString() {
        return "row=" + this.rown + " cols=" + this.imgInfo.cols + " bpc=" + this.imgInfo.bitDepth + " size=" + this.scanline.length;
    }

    public static void showLineInfo(ImageLine line) {
        System.out.println(line);
        ImageLineHelper.ImageLineStats stats = new ImageLineHelper.ImageLineStats(line);
        System.out.println(stats);
        System.out.println(ImageLineHelper.infoFirstLastPixels(line));
    }

    public static enum SampleType {
        INT,
        BYTE;

    }
}

