/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.utils.PlayerItemPositionUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketMuzzleFlash
extends PacketBase {
    public int playerID;
    public String type;
    public float scale;
    public boolean showMuzzleFlashParticlesToShooter;
    public String gunType;

    public PacketMuzzleFlash() {
    }

    public PacketMuzzleFlash(EntityPlayer p, String particleType, float size, boolean showToShooter, String shortName) {
        this.playerID = p.func_145782_y();
        this.type = particleType;
        this.scale = size;
        this.showMuzzleFlashParticlesToShooter = showToShooter;
        this.gunType = shortName;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.playerID);
        this.writeUTF(data, this.type);
        data.writeFloat(this.scale);
        data.writeBoolean(this.showMuzzleFlashParticlesToShooter);
        this.writeUTF(data, this.gunType);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.playerID = data.readInt();
        this.type = this.readUTF(data);
        this.scale = data.readFloat();
        this.showMuzzleFlashParticlesToShooter = data.readBoolean();
        this.gunType = this.readUTF(data);
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log("Received muzzle flash packet on server. Disregarding.");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        Entity p;
        boolean isThisPlayer = this.playerID == clientPlayer.func_145782_y();
        GunType g = GunType.getGun(this.gunType);
        if (g == null || g.model == null) {
            return;
        }
        if ((!isThisPlayer || this.showMuzzleFlashParticlesToShooter && (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0 || g.showMuzzleFlashParticlesFirstPerson.booleanValue())) && (p = clientPlayer.field_70170_p.func_73045_a(this.playerID)) instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)p;
            AttachmentType barrelAttachment = g.getBarrel(entityPlayer.func_70694_bm());
            RotatedAxes axes = new RotatedAxes(entityPlayer.field_70759_as + 90.0f, entityPlayer.field_70125_A, 0.0f);
            Vector3f shoulderOffset = isThisPlayer ? new Vector3f(0.0f, -1.375f, 0.0f) : new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f handOffset = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f.add(shoulderOffset, g.muzzleFlashParticlesShoulderOffset, shoulderOffset);
            if (g.model.muzzleFlashPoint != null) {
                Vector3f.add(handOffset, g.model.muzzleFlashPoint, handOffset);
            } else {
                Vector3f.add(handOffset, new Vector3f(0.5f, 0.22f, 0.0f), handOffset);
            }
            if (barrelAttachment != null && barrelAttachment.model != null && barrelAttachment.model.attachmentFlashOffset != null) {
                Vector3f.add(handOffset, barrelAttachment.model.attachmentFlashOffset, handOffset);
            } else if (g.model.defaultBarrelFlashPoint != null) {
                Vector3f.add(handOffset, g.model.defaultBarrelFlashPoint, handOffset);
            }
            if (isThisPlayer) {
                Vector3f.add(handOffset, new Vector3f(-0.7, -0.35, 0.1), handOffset);
            }
            Vector3f.add(handOffset, g.muzzleFlashParticlesHandOffset, handOffset);
            Vector3f pos = PlayerItemPositionUtils.GetPlayerHandPosition(entityPlayer, shoulderOffset, handOffset, !isThisPlayer);
            Vector3f v = axes.getXAxis().translate((float)Math.random() * 2.0f - 1.0f, (float)Math.random() * 2.0f - 1.0f, (float)Math.random() * 2.0f - 1.0f).scale(0.05f);
            FlansMod.proxy.spawnParticle(this.type, pos.x, pos.y, pos.z, v.x, v.y, v.z, this.scale);
        }
    }
}

