/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.scripted.item.ScriptCustomItem;
import org.lwjgl.opengl.GL11;

public class CustomItemRenderer
implements IItemRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ResourceLocation enchant = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private final Random random = new Random();
    private int entityRenderTicks = 1;
    private int item3dRenderTicks = 1;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        InputStream inputstream = null;
        ScriptCustomItem scriptCustomItem = ItemScripted.GetWrapper(itemStack);
        if (scriptCustomItem.width == -1 || scriptCustomItem.height == -1) {
            try {
                IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(scriptCustomItem.texture));
                inputstream = iresource.func_110527_b();
                BufferedImage bufferedimage = ImageIO.read(inputstream);
                scriptCustomItem.width = bufferedimage.getWidth();
                scriptCustomItem.height = bufferedimage.getHeight();
                scriptCustomItem.saveItemData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (inputstream != null) {
                        inputstream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (scriptCustomItem.width == -1 || scriptCustomItem.height == -1) {
            return;
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glPushMatrix();
            this.renderInventoryCustomItem(scriptCustomItem);
            GL11.glPopMatrix();
            return;
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glPushMatrix();
            float bobbingY = (float)(Math.sin((float)this.entityRenderTicks / 40.0f) + 1.0) / 6.0f;
            GL11.glTranslatef((float)0.0f, (float)((Math.max(scriptCustomItem.scaleY, 1.0f) - 1.0f) * 0.25f), (float)0.0f);
            GL11.glRotatef((float)scriptCustomItem.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)scriptCustomItem.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)scriptCustomItem.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(scriptCustomItem.rotationXRate * (float)this.entityRenderTicks % 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(scriptCustomItem.rotationYRate * (float)this.entityRenderTicks % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(scriptCustomItem.rotationZRate * (float)this.entityRenderTicks % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)scriptCustomItem.scaleX, (float)scriptCustomItem.scaleY, (float)scriptCustomItem.scaleZ);
            GL11.glTranslatef((float)0.0f, (float)bobbingY, (float)0.0f);
            int color = scriptCustomItem.getColor();
            float itemRed = (float)(color >> 16 & 0xFF) / 255.0f;
            float itemGreen = (float)(color >> 8 & 0xFF) / 255.0f;
            float itemBlue = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)itemRed, (float)itemGreen, (float)itemBlue, (float)1.0f);
            EntityItem entityItem = (EntityItem)data[1];
            this.renderEntityCustomItem(scriptCustomItem, itemStack, entityItem);
            GL11.glPopMatrix();
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.9375f, (float)0.0625f, (float)0.0f);
        GL11.glRotatef((float)-315.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ((ItemScripted)itemStack.func_77973_b()).renderOffset(scriptCustomItem);
        GL11.glTranslatef((float)scriptCustomItem.translateX, (float)scriptCustomItem.translateY, (float)scriptCustomItem.translateZ);
        GL11.glRotatef((float)scriptCustomItem.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)scriptCustomItem.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)scriptCustomItem.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(scriptCustomItem.rotationXRate * (float)this.item3dRenderTicks % 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(scriptCustomItem.rotationYRate * (float)this.item3dRenderTicks % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(scriptCustomItem.rotationZRate * (float)this.item3dRenderTicks % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)scriptCustomItem.scaleX, (float)scriptCustomItem.scaleY, (float)scriptCustomItem.scaleZ);
        int color = scriptCustomItem.getColor();
        float itemRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float itemGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float itemBlue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)itemRed, (float)itemGreen, (float)itemBlue, (float)1.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.09375f, (float)0.0625f, (float)0.0f);
        EntityLivingBase entityLivingBase = (EntityLivingBase)data[1];
        this.renderItem3d(scriptCustomItem, entityLivingBase, itemStack);
        GL11.glPopMatrix();
    }

    public void renderEntityCustomItem(ScriptCustomItem scriptCustomItem, ItemStack itemStack, EntityItem entityItem) {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            ++this.entityRenderTicks;
        }
        int pass = 0;
        GL11.glPushMatrix();
        ResourceLocation location = new ResourceLocation(scriptCustomItem.texture);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        Tessellator tessellator = Tessellator.field_78398_a;
        float f14 = 0.0f;
        float f15 = 1.0f;
        float f4 = 0.0f;
        float f5 = 1.0f;
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.25f;
        if (RenderManager.field_78727_a.field_78733_k.field_74347_j) {
            GL11.glPushMatrix();
            if (RenderItem.field_82407_g) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)(((float)entityItem.field_70292_b / 20.0f + entityItem.field_70290_d) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            float f9 = 0.0625f;
            float f10 = 0.021875f;
            int j = itemStack.field_77994_a;
            int b0 = j < 2 ? 1 : (j < 16 ? 2 : (j < 32 ? 3 : 4));
            GL11.glTranslatef((float)(-f7), (float)(-f8), (float)(-((f9 + f10) * (float)b0 / 2.0f)));
            for (int k = 0; k < b0; ++k) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(f9 + f10));
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f15, (float)f4, (float)f14, (float)f5, (int)scriptCustomItem.width, (int)scriptCustomItem.height, (float)f9);
                if (!itemStack.hasEffect(pass)) continue;
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                RenderManager.field_78727_a.field_78724_e.func_110577_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f11 = 0.76f;
                GL11.glColor4f((float)(0.5f * f11), (float)(0.25f * f11), (float)(0.8f * f11), (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f12 = 0.125f;
                GL11.glScalef((float)f12, (float)f12, (float)f12);
                float f13 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f13, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)f9);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f12, (float)f12, (float)f12);
                f13 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f13), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)f9);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glPopMatrix();
        } else {
            int j = itemStack.field_77994_a;
            int b0 = j < 2 ? 1 : (j < 16 ? 2 : (j < 32 ? 3 : 4));
            for (int l = 0; l < b0; ++l) {
                GL11.glPushMatrix();
                if (l > 0) {
                    float f10 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float f16 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float f17 = (this.random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)f10, (float)f16, (float)f17);
                }
                if (!RenderItem.field_82407_g) {
                    GL11.glRotatef((float)(180.0f - RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a((double)(0.0f - f7), (double)(0.0f - f8), 0.0, (double)f14, (double)f5);
                tessellator.func_78374_a((double)(f6 - f7), (double)(0.0f - f8), 0.0, (double)f15, (double)f5);
                tessellator.func_78374_a((double)(f6 - f7), (double)(1.0f - f8), 0.0, (double)f15, (double)f4);
                tessellator.func_78374_a((double)(0.0f - f7), (double)(1.0f - f8), 0.0, (double)f14, (double)f4);
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    public void renderInventoryCustomItem(ScriptCustomItem scriptCustomItem) {
        GL11.glPushMatrix();
        int color = scriptCustomItem.getColor();
        float itemRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float itemGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float itemBlue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)itemRed, (float)itemGreen, (float)itemBlue, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        ResourceLocation location = new ResourceLocation(scriptCustomItem.texture);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
        this.renderCustomItemSlot(0, 0, 16, 16, itemRed, itemGreen, itemBlue);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3008);
        if (scriptCustomItem.item.hasEffect(0)) {
            this.renderEffect(Minecraft.func_71410_x().func_110434_K(), 0, 0);
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void renderEffect(TextureManager manager, int x, int y) {
        GL11.glDepthFunc((int)514);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        manager.func_110577_a(RES_ITEM_GLINT);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)0.5f, (float)0.25f, (float)0.8f, (float)1.0f);
        this.renderGlint(x - 2, y - 2, 20, 20);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2896);
        GL11.glDepthFunc((int)515);
    }

    private void renderGlint(int p_77018_2_, int p_77018_3_, int p_77018_4_, int p_77018_5_) {
        for (int j1 = 0; j1 < 2; ++j1) {
            OpenGlHelper.func_148821_a((int)772, (int)1, (int)0, (int)0);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            float f2 = (float)(Minecraft.func_71386_F() % (long)(3000 + j1 * 1873)) / (3000.0f + (float)(j1 * 1873)) * 256.0f;
            float f3 = 0.0f;
            Tessellator tessellator = Tessellator.field_78398_a;
            float f4 = 4.0f;
            if (j1 == 1) {
                f4 = -1.0f;
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(p_77018_2_ + 0), (double)(p_77018_3_ + p_77018_5_), 0.0, (double)((f2 + (float)p_77018_5_ * f4) * f), (double)((f3 + (float)p_77018_5_) * f1));
            tessellator.func_78374_a((double)(p_77018_2_ + p_77018_4_), (double)(p_77018_3_ + p_77018_5_), 0.0, (double)((f2 + (float)p_77018_4_ + (float)p_77018_5_ * f4) * f), (double)((f3 + (float)p_77018_5_) * f1));
            tessellator.func_78374_a((double)(p_77018_2_ + p_77018_4_), (double)(p_77018_3_ + 0), 0.0, (double)((f2 + (float)p_77018_4_) * f), (double)((f3 + 0.0f) * f1));
            tessellator.func_78374_a((double)(p_77018_2_ + 0), (double)(p_77018_3_ + 0), 0.0, (double)((f2 + 0.0f) * f), (double)((f3 + 0.0f) * f1));
            tessellator.func_78381_a();
        }
    }

    public void renderCustomItemSlot(int posX, int posY, int imageWidth, int imageHeight, float itemRed, float itemGreen, float itemBlue) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(itemRed, itemGreen, itemBlue, 1.0f);
        tessellator.func_78374_a((double)posX, (double)(posY + imageHeight), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(posX + imageWidth), (double)(posY + imageHeight), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(posX + imageWidth), (double)posY, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)posX, (double)posY, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public void renderItem3d(ScriptCustomItem scriptCustomItem, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        ++this.item3dRenderTicks;
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager texturemanager = mc.func_110434_K();
        int par3 = 0;
        ResourceLocation location = new ResourceLocation(scriptCustomItem.texture);
        texturemanager.func_110577_a(location);
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon icon = entityLivingBase.func_70620_b(itemStack, par3);
        if (icon == null) {
            return;
        }
        GL11.glEnable((int)32826);
        float f4 = 0.0f;
        float f5 = 0.3f;
        GL11.glTranslatef((float)(-f4), (float)(-f5), (float)0.0f);
        GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
        CustomItemRenderer.renderCustomItemIn2D(itemStack, tessellator, 1.0f, 0.0f, 0.0f, 1.0f, 0.0625f);
        if (itemStack.hasEffect(par3)) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            texturemanager.func_110577_a(enchant);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
    }

    public static void renderCustomItemIn2D(ItemStack itemStack, Tessellator p_78439_0_, float p_78439_1_, float p_78439_2_, float p_78439_3_, float p_78439_4_, float p_78439_7_) {
        float f9;
        float f8;
        float f7;
        int k;
        int width = ItemScripted.GetWrapper((ItemStack)itemStack).width;
        int height = ItemScripted.GetWrapper((ItemStack)itemStack).height;
        p_78439_0_.func_78382_b();
        p_78439_0_.func_78375_b(0.0f, 0.0f, 1.0f);
        p_78439_0_.func_78374_a(0.0, 0.0, 0.0, (double)p_78439_1_, (double)p_78439_4_);
        p_78439_0_.func_78374_a(1.0, 0.0, 0.0, (double)p_78439_3_, (double)p_78439_4_);
        p_78439_0_.func_78374_a(1.0, 1.0, 0.0, (double)p_78439_3_, (double)p_78439_2_);
        p_78439_0_.func_78374_a(0.0, 1.0, 0.0, (double)p_78439_1_, (double)p_78439_2_);
        p_78439_0_.func_78381_a();
        p_78439_0_.func_78382_b();
        p_78439_0_.func_78375_b(0.0f, 0.0f, -1.0f);
        p_78439_0_.func_78374_a(0.0, 1.0, (double)(0.0f - p_78439_7_), (double)p_78439_1_, (double)p_78439_2_);
        p_78439_0_.func_78374_a(1.0, 1.0, (double)(0.0f - p_78439_7_), (double)p_78439_3_, (double)p_78439_2_);
        p_78439_0_.func_78374_a(1.0, 0.0, (double)(0.0f - p_78439_7_), (double)p_78439_3_, (double)p_78439_4_);
        p_78439_0_.func_78374_a(0.0, 0.0, (double)(0.0f - p_78439_7_), (double)p_78439_1_, (double)p_78439_4_);
        p_78439_0_.func_78381_a();
        float f5 = 0.5f * (p_78439_1_ - p_78439_3_) / (float)width;
        float f6 = 0.5f * (p_78439_4_ - p_78439_2_) / (float)height;
        p_78439_0_.func_78382_b();
        p_78439_0_.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = p_78439_1_ + (p_78439_3_ - p_78439_1_) * f7 - f5;
            p_78439_0_.func_78374_a((double)f7, 0.0, (double)(0.0f - p_78439_7_), (double)f8, (double)p_78439_4_);
            p_78439_0_.func_78374_a((double)f7, 0.0, 0.0, (double)f8, (double)p_78439_4_);
            p_78439_0_.func_78374_a((double)f7, 1.0, 0.0, (double)f8, (double)p_78439_2_);
            p_78439_0_.func_78374_a((double)f7, 1.0, (double)(0.0f - p_78439_7_), (double)f8, (double)p_78439_2_);
        }
        p_78439_0_.func_78381_a();
        p_78439_0_.func_78382_b();
        p_78439_0_.func_78375_b(1.0f, 0.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = p_78439_1_ + (p_78439_3_ - p_78439_1_) * f7 - f5;
            f9 = f7 + 1.0f / (float)width;
            p_78439_0_.func_78374_a((double)f9, 1.0, (double)(0.0f - p_78439_7_), (double)f8, (double)p_78439_2_);
            p_78439_0_.func_78374_a((double)f9, 1.0, 0.0, (double)f8, (double)p_78439_2_);
            p_78439_0_.func_78374_a((double)f9, 0.0, 0.0, (double)f8, (double)p_78439_4_);
            p_78439_0_.func_78374_a((double)f9, 0.0, (double)(0.0f - p_78439_7_), (double)f8, (double)p_78439_4_);
        }
        p_78439_0_.func_78381_a();
        p_78439_0_.func_78382_b();
        p_78439_0_.func_78375_b(0.0f, 1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = p_78439_4_ + (p_78439_2_ - p_78439_4_) * f7 - f6;
            f9 = f7 + 1.0f / (float)height;
            p_78439_0_.func_78374_a(0.0, (double)f9, 0.0, (double)p_78439_1_, (double)f8);
            p_78439_0_.func_78374_a(1.0, (double)f9, 0.0, (double)p_78439_3_, (double)f8);
            p_78439_0_.func_78374_a(1.0, (double)f9, (double)(0.0f - p_78439_7_), (double)p_78439_3_, (double)f8);
            p_78439_0_.func_78374_a(0.0, (double)f9, (double)(0.0f - p_78439_7_), (double)p_78439_1_, (double)f8);
        }
        p_78439_0_.func_78381_a();
        p_78439_0_.func_78382_b();
        p_78439_0_.func_78375_b(0.0f, -1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = p_78439_4_ + (p_78439_2_ - p_78439_4_) * f7 - f6;
            p_78439_0_.func_78374_a(1.0, (double)f7, 0.0, (double)p_78439_3_, (double)f8);
            p_78439_0_.func_78374_a(0.0, (double)f7, 0.0, (double)p_78439_1_, (double)f8);
            p_78439_0_.func_78374_a(0.0, (double)f7, (double)(0.0f - p_78439_7_), (double)p_78439_1_, (double)f8);
            p_78439_0_.func_78374_a(1.0, (double)f7, (double)(0.0f - p_78439_7_), (double)p_78439_3_, (double)f8);
        }
        p_78439_0_.func_78381_a();
    }
}

