/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.potion.PotionEffect;

public class GrenadeType
extends ShootableType {
    public static ArrayList<GrenadeType> grenades = new ArrayList();
    public int meleeDamage = 1;
    public int throwDelay = 0;
    public String throwSound = "";
    public String dropItemOnThrow = null;
    public boolean canThrow = true;
    public boolean penetratesEntities = false;
    public boolean penetratesBlocks = false;
    public String bounceSound = "";
    public boolean sticky = false;
    public boolean stickToThrower = false;
    public boolean stickToEntity = false;
    public boolean stickToDriveable = false;
    public boolean stickToEntityAfter = false;
    public boolean allowStickSound = false;
    public int stickSoundRange = 10;
    public String stickSound;
    public boolean flashBang = false;
    public int flashTime = 200;
    public int flashRange = 8;
    public boolean flashSoundEnable = false;
    public int flashSoundRange = 16;
    public String flashSound;
    public boolean flashDamageEnable = false;
    public float flashDamage;
    public boolean flashEffects = false;
    public int flashEffectsID;
    public int flashEffectsDuration;
    public int flashEffectsLevel;
    public boolean motionSensor = false;
    public float motionSensorRange = 5.0f;
    public float motionSoundRange = 20.0f;
    public String motionSound;
    public int motionTime = 20;
    public float livingProximityTrigger = -1.0f;
    public float driveableProximityTrigger = -1.0f;
    public boolean detonateWhenShot = false;
    public boolean remote = false;
    public float damageToTriggerer = 0.0f;
    public int primeDelay = 0;
    public int explodeParticles = 0;
    public String explodeParticleType = "largesmoke";
    public boolean spinWhenThrown = true;
    public int smokeTime = 0;
    public String smokeParticleType = "explode";
    public ArrayList<PotionEffect> smokeEffects = new ArrayList();
    public float smokeRadius = 5.0f;
    public boolean isDeployableBag = false;
    public int numUses = 1;
    public float healAmount = 0.0f;
    public ArrayList<PotionEffect> potionEffects = new ArrayList();
    public int numClips = 0;

    public GrenadeType(TypeFile file) {
        super(file);
    }

    @Override
    protected void preRead(TypeFile file) {
        super.preRead(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        if (this.shortName != null && this.isValid) {
            grenades.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            this.meleeDamage = ConfigUtils.configInt(config, "MeleeDamage", this.meleeDamage);
            this.throwDelay = ConfigUtils.configInt(config, "ThrowDelay", this.throwDelay);
            this.meleeDamage = ConfigUtils.configInt(config, "MeleeDamage", this.meleeDamage);
            this.throwSound = ConfigUtils.configString(config, "ThrowSound", this.throwSound);
            this.dropItemOnThrow = ConfigUtils.configString(config, "DropItemOnThrow", this.dropItemOnThrow);
            this.canThrow = ConfigUtils.configBool(config, "CanThrow", this.canThrow);
            this.penetratesEntities = ConfigUtils.configBool(config, "PenetratesEntities", this.penetratesEntities);
            this.penetratesBlocks = ConfigUtils.configBool(config, "PenetratesBlocks", this.penetratesBlocks);
            this.bounceSound = ConfigUtils.configString(config, "BounceSound", this.bounceSound);
            this.livingProximityTrigger = ConfigUtils.configFloat(config, "LivingProximityTrigger", this.livingProximityTrigger);
            this.driveableProximityTrigger = ConfigUtils.configFloat(config, "VehicleProximityTrigger", this.driveableProximityTrigger);
            this.damageToTriggerer = ConfigUtils.configFloat(config, "DamageToTriggerer", this.damageToTriggerer);
            this.primeDelay = ConfigUtils.configInt(config, new String[]{"PrimeDelay", "TriggerDelay"}, this.primeDelay);
            this.sticky = ConfigUtils.configBool(config, "Sticky", this.sticky);
            this.stickToThrower = ConfigUtils.configBool(config, "StickToThrower", this.stickToThrower);
            this.stickToEntity = ConfigUtils.configBool(config, "StickToEntity", this.stickToEntity);
            this.stickToDriveable = ConfigUtils.configBool(config, "StickToDriveable", this.stickToDriveable);
            this.stickToEntityAfter = ConfigUtils.configBool(config, "StickToEntityAfter", this.stickToEntityAfter);
            this.allowStickSound = ConfigUtils.configBool(config, "AllowStickSound", this.allowStickSound);
            this.stickSoundRange = ConfigUtils.configInt(config, "StickSoundRange", this.stickSoundRange);
            this.stickSound = ConfigUtils.configSound(this.packName, config, "StickSound", this.stickSound);
            this.explodeParticles = ConfigUtils.configInt(config, "NumExplodeParticles", this.explodeParticles);
            this.explodeParticleType = ConfigUtils.configString(config, "ExplodeParticles", this.explodeParticleType);
            this.smokeTime = ConfigUtils.configInt(config, "SmokeTime", this.smokeTime);
            this.explodeParticles = ConfigUtils.configInt(config, "NumExplodeParticles", this.explodeParticles);
            this.smokeParticleType = ConfigUtils.configString(config, "SmokeParticles", this.smokeParticleType);
            ArrayList<String[]> splits = ConfigUtils.getSplitsFromKey(config, new String[]{"SmokeEffect"});
            for (String[] split : splits) {
                try {
                    this.smokeEffects.add(GrenadeType.getPotionEffect(split));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't add SmokeEffect for grenade", split, ex);
                }
            }
            this.smokeRadius = ConfigUtils.configFloat(config, "SmokeRadius", this.smokeRadius);
            this.spinWhenThrown = ConfigUtils.configBool(config, "SpinWhenThrown", this.spinWhenThrown);
            this.remote = ConfigUtils.configBool(config, "Remote", this.remote);
            this.flashBang = ConfigUtils.configBool(config, "FlashBang", this.flashBang);
            this.flashTime = ConfigUtils.configInt(config, "FlashTime", this.flashTime);
            this.flashRange = ConfigUtils.configInt(config, "FlashRange", this.flashRange);
            this.flashSoundEnable = ConfigUtils.configBool(config, "FlashSoundEnable", this.flashSoundEnable);
            this.flashSoundRange = ConfigUtils.configInt(config, "FlashSoundRange", this.flashSoundRange);
            this.flashSound = ConfigUtils.configSound(this.packName, config, "FlashSound", this.flashSound);
            this.flashDamageEnable = ConfigUtils.configBool(config, "FlashDamageEnable", this.flashDamageEnable);
            this.flashDamage = ConfigUtils.configFloat(config, "FlashDamage", this.flashDamage);
            this.flashEffects = ConfigUtils.configBool(config, "FlashEffects", this.flashEffects);
            this.flashEffectsID = ConfigUtils.configInt(config, "FlashEffectsID", this.flashEffectsID);
            this.flashEffectsDuration = ConfigUtils.configInt(config, "FlashEffectsDuration", this.flashEffectsDuration);
            this.flashEffectsLevel = ConfigUtils.configInt(config, "FlashEffectsLevel", this.flashEffectsLevel);
            this.flashBang = ConfigUtils.configBool(config, "FlashBang", this.flashBang);
            this.motionSensor = ConfigUtils.configBool(config, "MotionSensor", this.motionSensor);
            this.motionSensorRange = ConfigUtils.configFloat(config, "MotionSensorRange", this.motionSensorRange);
            this.motionSoundRange = ConfigUtils.configFloat(config, "MotionSoundRange", this.motionSoundRange);
            this.motionSound = ConfigUtils.configSound(this.packName, config, "MotionSound", this.motionSound);
            this.motionTime = ConfigUtils.configInt(config, "MotionTime", this.motionTime);
            this.detonateWhenShot = ConfigUtils.configBool(config, "DetonateWhenShot", this.detonateWhenShot);
            if (config.containsKey("DeployableBag")) {
                this.isDeployableBag = true;
            }
            this.numUses = ConfigUtils.configInt(config, "NumUses", this.numUses);
            this.healAmount = ConfigUtils.configFloat(config, "HealAmount", this.healAmount);
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"AddPotionEffect", "PotionEffect"});
            for (String[] split : splits) {
                try {
                    this.potionEffects.add(GrenadeType.getPotionEffect(split));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't add PotionEffect", split, ex);
                }
            }
            this.numClips = ConfigUtils.configInt(config, "NumClips", this.numClips);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error occurred while reading grenade file", null, ex);
            this.isValid = false;
        }
    }

    public static GrenadeType getGrenade(String s) {
        for (GrenadeType grenade : grenades) {
            if (!grenade.shortName.equals(s)) continue;
            return grenade;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelBase.class);
    }
}

