/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import cofh.api.energy.IEnergyContainerItem;
import com.flansmod.api.IControllable;
import com.flansmod.api.IExplodeable;
import com.flansmod.client.EntityCamera;
import com.flansmod.client.FlansModClient;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.BoxExplosion;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.driveables.PilotGun;
import com.flansmod.common.driveables.Seat;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.driveables.collisions.CollisionPlane;
import com.flansmod.common.driveables.collisions.CollisionShapeBox;
import com.flansmod.common.driveables.collisions.CollisionTest;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.eventhandlers.GunFiredEvent;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityDamageSourceFlans;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.FlansModExplosion;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.InventoryHelper;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.guns.raytracing.BulletHit;
import com.flansmod.common.guns.raytracing.DriveableHit;
import com.flansmod.common.network.PacketDriveableDamage;
import com.flansmod.common.network.PacketDriveableKeyHeld;
import com.flansmod.common.network.PacketParticle;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.teams.GameType;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class EntityDriveable
extends Entity
implements IControllable,
IExplodeable,
IEntityAdditionalSpawnData {
    public boolean syncFromServer = true;
    public int serverPositionTransitionTicker;
    public double field_70118_ct;
    public double field_70117_cu;
    public double field_70116_cv;
    public double serverYaw;
    public double serverPitch;
    public double serverRoll;
    public DriveableData driveableData;
    public String driveableType;
    public float throttle;
    public EntityWheel[] wheels;
    public boolean fuelling;
    public float prevRotationRoll;
    public Vector3f angularVelocity = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean leftMouseHeld = false;
    public boolean rightMouseHeld = false;
    public float shootDelayPrimary;
    public float shootDelaySecondary;
    public float minigunSpeedPrimary;
    public float minigunSpeedSecondary;
    public int currentGunPrimary;
    public int currentGunSecondary;
    public float harvesterAngle;
    public RotatedAxes prevAxes;
    public RotatedAxes axes;
    public EntitySeat[] seats;
    public int lockOnSoundDelay;
    private int[] emitterTimers;
    public int animCountLeft = 0;
    public int animFrameLeft = 0;
    public int animCountRight = 0;
    public int animFrameRight = 0;
    public boolean leftTurnHeld = false;
    public boolean rightTurnHeld = false;
    public boolean isShowedPosition = false;
    public int tickCount = 0;
    public boolean isRecoil = false;
    public float recoilPos = 0.0f;
    public float lastRecoilPos = 0.0f;
    public int recoilTimer = 0;
    public Vector3f lastPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean hugeBoat = false;
    public boolean onDeck = false;
    public double deckHeight = 0.0;
    public int deckCheck = 0;
    public int prevDeckCheck = 0;
    public boolean isMecha = false;
    public boolean disabled = false;
    public float propAngle = 0.0f;
    public float prevPropAngle = 0.0f;
    public float rotorAngle = 0.0f;
    public float prevRotorAngle = 0.0f;
    public int flareDelay = 0;
    public int ticksFlareUsing = 0;
    public boolean varFlare;
    public float drakonDoorAngle = 0.0f;
    public float drakonArmAngle = 0.0f;
    public float drakonRailAngle = 0.0f;
    public float prevDrakonDoorAngle = 0.0f;
    public float prevDrakonArmAngle = 0.0f;
    public float prevDrakonRailAngle = 0.0f;
    public boolean reloadingDrakon = false;
    public boolean canFireIT1 = true;
    public int stage = 1;
    public int reloadAnimTime = 0;
    public boolean toDeactivate = false;
    public int timeTillDeactivate = 0;
    public boolean canFire = true;
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase camera;
    protected int invulnerableUnmountCount;
    private ItemStack[][] prevInventoryItems = new ItemStack[][]{null, null};
    public Entity lastAtkEntity = null;
    public Float collisionHardness = Float.valueOf(0.0f);
    public int engineStartDelay;
    public EntityPlayer owner = null;
    public String ownerUUID = null;

    public EntityDriveable(World world) {
        super(world);
        this.axes = new RotatedAxes();
        this.prevAxes = new RotatedAxes();
        this.field_70156_m = true;
        if (FlansMod.driveableHitboxes) {
            this.func_70105_a(1.0f, 1.0f);
        } else {
            this.func_70105_a(0.0f, 0.0f);
        }
        this.field_70129_M = 0.375f;
        this.field_70158_ak = true;
        this.field_70155_l = 20000.0;
    }

    public EntityDriveable(World world, DriveableType t, DriveableData d, EntityPlayer owner) {
        this(world);
        this.driveableType = t.shortName;
        this.driveableData = d;
        if (owner != null) {
            this.owner = owner;
            this.ownerUUID = owner.func_110124_au().toString();
        } else {
            this.ownerUUID = null;
        }
    }

    protected void initType(DriveableType type, boolean clientSide) {
        int i;
        if (type == null) {
            return;
        }
        this.seats = new EntitySeat[type.numPassengers + 1];
        for (i = 0; i < type.numPassengers + 1; ++i) {
            if (clientSide) continue;
            this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
            this.field_70170_p.func_72838_d((Entity)this.seats[i]);
        }
        this.wheels = new EntityWheel[type.wheelPositions.length];
        for (i = 0; i < this.wheels.length; ++i) {
            if (clientSide) continue;
            this.wheels[i] = new EntityWheel(this.field_70170_p, this, i);
            this.field_70170_p.func_72838_d((Entity)this.wheels[i]);
        }
        this.field_70138_W = type.wheelStepHeight;
        this.field_70129_M = type.yOffset;
        this.emitterTimers = new int[type.emitters.size()];
        for (i = 0; i < type.emitters.size(); ++i) {
            this.emitterTimers[i] = this.field_70146_Z.nextInt(type.emitters.get((int)i).emitRate);
        }
        this.getEntityData().func_74757_a("CanMountEntity", type.canMountEntity);
        for (int ps = 0; ps < 2; ++ps) {
            int istart;
            EnumWeaponType weaponType;
            EnumWeaponType enumWeaponType = weaponType = ps == 0 ? type.primary : type.secondary;
            if (weaponType == EnumWeaponType.GUN) {
                weaponType = EnumWeaponType.NONE;
            }
            if ((istart = this.getInventoryStart(weaponType)) == this.driveableData.getAmmoInventoryStart()) {
                istart += type.numPassengerGunners;
            }
            int isize = this.getInventorySize(weaponType);
            if (istart < 0 && isize <= 0) continue;
            this.prevInventoryItems[ps] = new ItemStack[isize];
            for (int i2 = 0; i2 < isize; ++i2) {
                this.prevInventoryItems[ps][i2] = this.driveableData.func_70301_a(istart + i2);
            }
        }
        this.engineStartDelay = type.engineStartTime;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        this.driveableData.writeToNBT(tag);
        tag.func_74778_a("Type", this.driveableType);
        tag.func_74776_a("RotationYaw", this.axes.getYaw());
        tag.func_74776_a("RotationPitch", this.axes.getPitch());
        tag.func_74776_a("RotationRoll", this.axes.getRoll());
        if (!StringUtils.func_151246_b((String)this.ownerUUID)) {
            tag.func_74778_a("OwnerUUID", this.ownerUUID);
        }
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.driveableType = tag.func_74779_i("Type");
        if (DriveableType.getDriveable(this.driveableType) == null) {
            this.func_70106_y();
            return;
        }
        this.driveableData = new DriveableData(tag);
        this.initType(DriveableType.getDriveable(this.driveableType), false);
        this.field_70126_B = tag.func_74760_g("RotationYaw");
        this.field_70127_C = tag.func_74760_g("RotationPitch");
        this.prevRotationRoll = tag.func_74760_g("RotationRoll");
        this.axes = new RotatedAxes(this.field_70126_B, this.field_70127_C, this.prevRotationRoll);
        this.ownerUUID = tag.func_74764_b("OwnerUUID") ? tag.func_74779_i("OwnerUUID") : null;
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.driveableType);
        NBTTagCompound tag = new NBTTagCompound();
        this.driveableData.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)tag);
        data.writeFloat(this.axes.getYaw());
        data.writeFloat(this.axes.getPitch());
        data.writeFloat(this.axes.getRoll());
        for (EnumDriveablePart ep : EnumDriveablePart.values()) {
            DriveablePart part = this.getDriveableData().parts.get((Object)ep);
            data.writeFloat(part.health);
            data.writeBoolean(part.onFire);
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.driveableType = ByteBufUtils.readUTF8String((ByteBuf)data);
            this.driveableData = new DriveableData(ByteBufUtils.readTag((ByteBuf)data));
            this.initType(this.getDriveableType(), true);
            this.axes.setAngles(data.readFloat(), data.readFloat(), data.readFloat());
            this.field_70126_B = this.axes.getYaw();
            this.field_70127_C = this.axes.getPitch();
            this.prevRotationRoll = this.axes.getRoll();
            for (EnumDriveablePart ep : EnumDriveablePart.values()) {
                DriveablePart part = this.getDriveableData().parts.get((Object)ep);
                part.health = data.readFloat();
                part.onFire = data.readBoolean();
            }
        }
        catch (Exception e) {
            FlansMod.log("Failed to retrieve plane type from server.");
            super.func_70106_y();
            e.printStackTrace();
        }
        this.camera = new EntityCamera(this.field_70170_p, this);
        this.field_70170_p.func_72838_d((Entity)this.camera);
    }

    @Override
    public abstract void onMouseMoved(int var1, int var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return this.camera;
    }

    protected boolean canSit(int seat) {
        return this.getDriveableType().numPassengers >= seat && this.seats[seat].field_70153_n == null;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (this.getDriveableType().collisionDamageEnable && this.throttle > this.getDriveableType().collisionDamageThrottle) {
            if (entity instanceof EntityLiving) {
                entity.func_70097_a(DamageSource.field_76377_j, this.throttle * this.getDriveableType().collisionDamageTimes);
            } else if (entity instanceof EntityPlayer) {
                entity.func_70097_a(DamageSource.field_76377_j, this.throttle * this.getDriveableType().collisionDamageTimes);
            }
        }
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return -0.3;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (this.isMountedEntity(damagesource.func_76346_g())) {
            return false;
        }
        boolean broken = this.attackPart(EnumDriveablePart.core, damagesource, i);
        if (i > 0.0f) {
            this.checkPartsWhenAttacked();
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
        }
        return true;
    }

    public boolean isMountedEntity(Entity entity) {
        if (entity != null) {
            Entity entity2 = this.field_70170_p.func_73045_a(entity.func_145782_y());
            for (EntitySeat seat : this.seats) {
                if (seat.field_70153_n == null || seat.field_70153_n != entity && seat.field_70153_n != entity2) continue;
                return true;
            }
        }
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.camera.func_70106_y();
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.func_70106_y();
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70108_f(Entity entity) {
    }

    public void func_70056_a(double d, double d1, double d2, float f, float f1, int i) {
        if (this.field_70173_aa > 1) {
            return;
        }
        if (!(this.field_70153_n instanceof EntityPlayer) || !FlansMod.proxy.isThePlayer((EntityPlayer)this.field_70153_n)) {
            if (this.syncFromServer) {
                this.serverPositionTransitionTicker = i + 5;
            } else {
                double var10 = d - this.field_70165_t;
                double var12 = d1 - this.field_70163_u;
                double var14 = d2 - this.field_70161_v;
                double var16 = var10 * var10 + var12 * var12 + var14 * var14;
                if (var16 <= 1.0) {
                    return;
                }
                this.serverPositionTransitionTicker = 3;
            }
            this.field_70118_ct = d;
            this.field_70117_cu = d1;
            this.field_70116_cv = d2;
            this.serverYaw = f;
            this.serverPitch = f1;
        }
    }

    public void setIT1(boolean canFire, boolean reloading, int stag, int stageTime) {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            this.canFireIT1 = canFire;
            this.reloadingDrakon = reloading;
            this.stage = stag;
            this.reloadAnimTime = stageTime;
        }
    }

    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt, float steeringYaw) {
        if (this.field_70170_p.field_72995_K) {
            this.field_70118_ct = x;
            this.field_70117_cu = y;
            this.field_70116_cv = z;
            this.serverYaw = yaw;
            this.serverPitch = pitch;
            this.serverRoll = roll;
            this.serverPositionTransitionTicker = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.field_70126_B = yaw;
            this.field_70127_C = pitch;
            this.prevRotationRoll = roll;
            this.setRotation(yaw, pitch, roll);
        }
        this.field_70159_w = motX;
        this.field_70181_x = motY;
        this.field_70179_y = motZ;
        this.angularVelocity = new Vector3f(velYaw, velPitch, velRoll);
        this.throttle = throt;
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && key == 9 && this.getDriveableType().modePrimary == EnumFireMode.SEMIAUTO) {
            this.shoot(false);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && key == 8 && this.getDriveableType().modeSecondary == EnumFireMode.SEMIAUTO) {
            this.shoot(true);
            return true;
        }
        return false;
    }

    @Override
    public void updateKeyHeldState(int key, boolean held) {
        if (this.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKeyHeld(key, held));
            if (key == 2) {
                this.leftTurnHeld = true;
                this.rightTurnHeld = false;
            } else if (key == 3) {
                this.rightTurnHeld = true;
                this.leftTurnHeld = false;
            } else {
                this.leftTurnHeld = false;
                this.rightTurnHeld = false;
            }
        }
        switch (key) {
            case 9: {
                this.leftMouseHeld = held;
                break;
            }
            case 8: {
                this.rightMouseHeld = held;
            }
        }
    }

    public void shoot(boolean secondary) {
        DriveableType type = this.getDriveableType();
        if (this.seats[0] == null) {
            return;
        }
        if (type.IT1 && !this.canFireIT1 && type.weaponType(secondary) == EnumWeaponType.MISSILE) {
            return;
        }
        if (!this.canFire || this.isUnderWater() && !type.worksUnderWater) {
            return;
        }
        GunFiredEvent gunFiredEvent = new GunFiredEvent(this);
        MinecraftForge.EVENT_BUS.post((Event)gunFiredEvent);
        if (gunFiredEvent.isCanceled()) {
            return;
        }
        if (this.getShootDelay(secondary) <= 0.0f) {
            ArrayList<ShootPoint> shootPoints = type.shootPoints(secondary);
            EnumWeaponType weaponType = type.weaponType(secondary);
            if (shootPoints.size() == 0) {
                return;
            }
            int currentGun = this.getCurrentGun(secondary);
            if (type.alternate(secondary)) {
                currentGun = (currentGun + 1) % shootPoints.size();
                this.setCurrentGun(currentGun, secondary);
                this.shootEach(type, shootPoints.get(currentGun), currentGun, secondary, weaponType);
            } else {
                for (int i = 0; i < shootPoints.size(); ++i) {
                    this.shootEach(type, shootPoints.get(i), i, secondary, weaponType);
                }
            }
        }
    }

    public boolean driverIsCreative() {
        return this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
    }

    public void spawnParticle(ArrayList<DriveableType.ShootParticle> list, ShootPoint shootPoint, Vector3f v) {
        for (DriveableType.ShootParticle s : list) {
            float bkx = shootPoint.rootPos.position.x;
            float bky = shootPoint.rootPos.position.y;
            float bkz = shootPoint.rootPos.position.z;
            Vector3f velocity = new Vector3f(s.x, s.y, s.z);
            velocity = this.getDirection(shootPoint, velocity);
            if (shootPoint.rootPos.part == EnumDriveablePart.core) {
                Vector3f v2 = this.axes.findLocalVectorGlobally(shootPoint.rootPos.position);
                Vector3f v3 = this.rotate(this.seats[0].looking.findLocalVectorGlobally(shootPoint.offPos));
                Vector3f.add(v2, v3, v);
            }
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle(s.name, this.field_70165_t + (double)v.x, this.field_70163_u + (double)v.y, this.field_70161_v + (double)v.z, velocity.x, velocity.y, velocity.z), this.field_70165_t + (double)v.x, this.field_70163_u + (double)v.y, this.field_70161_v + (double)v.z, FlansMod.driveableUpdateRange, this.field_71093_bK);
            shootPoint.rootPos.position.x = bkx;
            shootPoint.rootPos.position.y = bky;
            shootPoint.rootPos.position.z = bkz;
        }
    }

    private void shootEach(DriveableType type, ShootPoint shootPoint, int currentGun, boolean secondary, EnumWeaponType weaponType) {
        float damageMultiplier;
        Vector3f gunVec = this.getFiringPosition(shootPoint);
        Vector3f lookVector = this.getLookVector(shootPoint);
        if (!secondary && type.fixedPrimaryFire) {
            lookVector = this.axes.findLocalVectorGlobally(type.primaryFireAngle);
            if (shootPoint.rootPos.part == EnumDriveablePart.turret) {
                lookVector = this.getPositionOnTurret(type.primaryFireAngle, false);
            }
            if (shootPoint.rootPos.part == EnumDriveablePart.barrel) {
                lookVector = this.getPositionOnTurret(type.primaryFireAngle, true);
            }
        }
        if (secondary && type.fixedSecondaryFire) {
            lookVector = this.axes.findLocalVectorGlobally(type.secondaryFireAngle);
            if (shootPoint.rootPos.part == EnumDriveablePart.turret) {
                lookVector = this.getPositionOnTurret(type.secondaryFireAngle, false);
            }
            if (shootPoint.rootPos.part == EnumDriveablePart.barrel) {
                lookVector = this.getPositionOnTurret(type.secondaryFireAngle, true);
            }
        }
        if (weaponType == EnumWeaponType.SHELL) {
            this.isRecoil = true;
        }
        if (shootPoint.rootPos.part == null) {
            return;
        }
        if (!this.isPartIntact(shootPoint.rootPos.part)) {
            return;
        }
        if (this.disabled) {
            return;
        }
        float f = damageMultiplier = secondary ? type.damageMultiplierSecondary : type.damageMultiplierPrimary;
        if (shootPoint.rootPos instanceof PilotGun && ((PilotGun)shootPoint.rootPos).type != null) {
            ShootableType bullet;
            ItemStack bulletItemStack;
            PilotGun pilotGun = (PilotGun)shootPoint.rootPos;
            GunType gunType = pilotGun.type;
            float shellSpeed = gunType.bulletSpeed;
            if (type.rangingGun) {
                shellSpeed = type.bulletSpeed;
            }
            if ((bulletItemStack = this.driveableData.ammo[this.getDriveableType().numPassengerGunners + currentGun]) != null && bulletItemStack.func_77973_b() instanceof ItemShootable && TeamsManager.bulletsEnabled && gunType.isAmmo(bullet = ((ItemShootable)bulletItemStack.func_77973_b()).type)) {
                this.spawnParticle(type.shootParticle(secondary), shootPoint, gunVec);
                this.field_70170_p.func_72838_d((Entity)((ItemShootable)bulletItemStack.func_77973_b()).getEntity(this.field_70170_p, Vector3f.add(new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), gunVec, null), lookVector, (EntityLivingBase)this.seats[0].field_70153_n, gunType.bulletSpread / 2.0f, gunType.damage * damageMultiplier, shellSpeed, bulletItemStack.func_77960_j(), type));
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSound(secondary), false);
                int damage = bulletItemStack.func_77960_j();
                bulletItemStack.func_77964_b(damage + 1);
                if (damage + 1 == bulletItemStack.func_77958_k()) {
                    bulletItemStack.func_77964_b(0);
                    if (!this.driverIsCreative()) {
                        --bulletItemStack.field_77994_a;
                        if (bulletItemStack.field_77994_a <= 0) {
                            this.onWeaponInventoryChanged(secondary);
                            bulletItemStack = null;
                        }
                        this.driveableData.func_70299_a(this.getDriveableType().numPassengerGunners + currentGun, bulletItemStack);
                    }
                }
                if (type.shootDelay(secondary) == -1.0f) {
                    this.setShootDelay(gunType.getShootDelay(), secondary);
                } else {
                    this.setShootDelay(type.shootDelay(secondary), secondary);
                }
            }
        } else {
            switch (weaponType) {
                case BOMB: {
                    if (!TeamsManager.bombsEnabled) break;
                    int slot = -1;
                    for (int i = this.driveableData.getBombInventoryStart(); i < this.driveableData.getBombInventoryStart() + type.numBombSlots; ++i) {
                        ItemStack bomb = this.driveableData.func_70301_a(i);
                        if (bomb == null || !(bomb.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)bomb.func_77973_b()).type, weaponType)) continue;
                        slot = i;
                    }
                    if (slot == -1) break;
                    boolean spread = false;
                    float shellSpeed = 0.0f;
                    ItemStack bulletStack = this.driveableData.func_70301_a(slot);
                    ItemBullet bulletItem = (ItemBullet)bulletStack.func_77973_b();
                    if (shootPoint.rootPos instanceof PilotGun) {
                        PilotGun pilotGun = (PilotGun)shootPoint.rootPos;
                        GunType gunType = pilotGun.type;
                    }
                    EntityShootable bulletEntity = bulletItem.getEntity(this.field_70170_p, Vec3.func_72443_a((double)((double)gunVec.x + this.field_70165_t), (double)((double)gunVec.y + this.field_70163_u), (double)((double)gunVec.z + this.field_70161_v)), this.axes.getYaw(), this.axes.getPitch(), this.field_70159_w, this.field_70181_x, this.field_70179_y, (EntityLivingBase)this.seats[0].field_70153_n, damageMultiplier, this.driveableData.func_70301_a(slot).func_77960_j(), type);
                    this.field_70170_p.func_72838_d((Entity)bulletEntity);
                    this.spawnParticle(type.shootParticle(secondary), shootPoint, gunVec);
                    if (type.shootSound(secondary) != null) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSound(secondary), false);
                    }
                    if (!this.driverIsCreative()) {
                        bulletStack.func_77964_b(bulletStack.func_77960_j() + 1);
                        if (bulletStack.func_77960_j() == bulletStack.func_77958_k()) {
                            bulletStack.func_77964_b(0);
                            --bulletStack.field_77994_a;
                            if (bulletStack.field_77994_a == 0) {
                                this.onWeaponInventoryChanged(secondary);
                                bulletStack = null;
                            }
                        }
                        this.driveableData.func_70299_a(slot, bulletStack);
                    }
                    if (type.shootDelay(secondary) == -1.0f) {
                        this.setShootDelay(1.0f, secondary);
                        break;
                    }
                    this.setShootDelay(type.shootDelay(secondary), secondary);
                    break;
                }
                case MISSILE: 
                case SHELL: {
                    this.tryRecoil();
                    if (!TeamsManager.shellsEnabled) break;
                    int slot = -1;
                    for (int i = this.driveableData.getMissileInventoryStart(); i < this.driveableData.getMissileInventoryStart() + type.numMissileSlots; ++i) {
                        ItemStack shell = this.driveableData.func_70301_a(i);
                        if (shell == null || !(shell.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)shell.func_77973_b()).type, weaponType)) continue;
                        slot = i;
                    }
                    if (slot == -1) break;
                    float spread = type.bulletSpread;
                    float shellSpeed = type.bulletSpeed;
                    ItemStack bulletStack = this.driveableData.func_70301_a(slot);
                    ItemBullet bulletItem = (ItemBullet)bulletStack.func_77973_b();
                    EntityShootable bulletEntity = bulletItem.getEntity(this.field_70170_p, Vector3f.add(gunVec, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), null), lookVector, (EntityLivingBase)this.seats[0].field_70153_n, spread, damageMultiplier, shellSpeed, this.driveableData.func_70301_a(slot).func_77960_j(), type);
                    this.field_70170_p.func_72838_d((Entity)bulletEntity);
                    this.spawnParticle(type.shootParticle(secondary), shootPoint, gunVec);
                    this.isRecoil = true;
                    if (type.shootSound(secondary) != null) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootSound(secondary), false);
                    }
                    if (!this.driverIsCreative()) {
                        bulletStack.func_77964_b(bulletStack.func_77960_j() + 1);
                        if (bulletStack.func_77960_j() == bulletStack.func_77958_k()) {
                            bulletStack.func_77964_b(0);
                            --bulletStack.field_77994_a;
                            if (bulletStack.field_77994_a == 0) {
                                this.onWeaponInventoryChanged(secondary);
                                bulletStack = null;
                            }
                        }
                        this.driveableData.func_70299_a(slot, bulletStack);
                    }
                    if (type.shootDelay(secondary) == -1.0f) {
                        this.setShootDelay(1.0f, secondary);
                    } else {
                        this.setShootDelay(type.shootDelay(secondary), secondary);
                    }
                    this.canFireIT1 = false;
                    break;
                }
                case GUN: {
                    break;
                }
            }
        }
    }

    public Vector3f getOrigin(ShootPoint dp) {
        Vector3f localGunVec = new Vector3f(dp.rootPos.position);
        if (dp.rootPos.part == EnumDriveablePart.turret) {
            Vector3f.sub(localGunVec, this.getDriveableType().turretOrigin, localGunVec);
            localGunVec = this.seats[0].looking.findLocalVectorGlobally(localGunVec);
            Vector3f.add(localGunVec, this.getDriveableType().turretOrigin, localGunVec);
        }
        return this.rotate(localGunVec);
    }

    public Vector3f getPositionOnTurret(Vector3f vecIn, boolean barrel) {
        Vector3f transform = vecIn;
        RotatedAxes yawOnlyLooking = new RotatedAxes(this.seats[0].looking.getYaw(), 0.0f, 0.0f);
        if (barrel) {
            yawOnlyLooking = this.seats[0].looking;
        }
        Vector3f.sub(transform, this.getDriveableType().turretOrigin, transform);
        transform = yawOnlyLooking.findLocalVectorGlobally(transform);
        Vector3f.add(transform, this.getDriveableType().turretOrigin, transform);
        Vector3f turretOriginOffset = new Vector3f(this.getDriveableType().turretOriginOffset);
        turretOriginOffset = yawOnlyLooking.findLocalVectorGloballyYaw(turretOriginOffset);
        Vector3f.add(transform, turretOriginOffset, transform);
        return this.rotate(transform);
    }

    public Vector3f getDirection(ShootPoint dp, Vector3f vIn) {
        Vector3f localGunVec = new Vector3f(vIn);
        localGunVec = this.seats[0].looking.findLocalVectorGlobally(localGunVec);
        return this.rotate(localGunVec);
    }

    public Vector3f getLookVector(ShootPoint dp) {
        return this.axes.getXAxis();
    }

    public Vector3f getFiringPosition(ShootPoint dp) {
        Vector3f rootVector = new Vector3f(dp.rootPos.position);
        Vector3f offsetVector = new Vector3f(dp.offPos);
        Vector3f localGunVec = new Vector3f(dp.rootPos.position);
        if (dp.rootPos.part == EnumDriveablePart.turret) {
            if (offsetVector.x == 0.0f && offsetVector.y == 0.0f && offsetVector.z == 0.0f) {
                Vector3f.sub(localGunVec, this.getDriveableType().turretOrigin, localGunVec);
                localGunVec = this.seats[0].looking.findLocalVectorGlobally(localGunVec);
                Vector3f.add(localGunVec, this.getDriveableType().turretOrigin, localGunVec);
            } else {
                RotatedAxes yawOnlyLooking = new RotatedAxes(this.seats[0].looking.getYaw(), 0.0f, 0.0f);
                Vector3f.sub(rootVector, this.getDriveableType().turretOrigin, rootVector);
                rootVector = yawOnlyLooking.findLocalVectorGlobally(rootVector);
                Vector3f.add(rootVector, this.getDriveableType().turretOrigin, rootVector);
                Vector3f.sub(offsetVector, this.getDriveableType().turretOrigin, offsetVector);
                offsetVector = this.seats[0].looking.findLocalVectorGlobally(offsetVector);
                Vector3f.add(rootVector, offsetVector, localGunVec);
            }
        }
        return this.rotate(localGunVec);
    }

    public boolean isEngineActive() {
        return (this.driverIsCreative() || this.driveableData.fuelInTank > 0.0f) && this.engineStartDelay == 0 || this.getDriveableType().fuelTankSize < 0;
    }

    public void correctWheelPos() {
        if (this.field_70173_aa % 200 == 0) {
            for (EntityWheel wheel : this.wheels) {
                if (wheel == null) continue;
                Vector3f target = this.axes.findLocalVectorGlobally(this.getDriveableType().wheelPositions[wheel.ID].position);
                target.x = (float)((double)target.x + this.field_70165_t);
                target.y = (float)((double)target.y + this.field_70163_u);
                target.z = (float)((double)target.z + this.field_70161_v);
                int tf = 1;
                int cf = 1;
                int range = 5;
                if (MathHelper.func_76135_e((float)(target.x - (float)wheel.field_70165_t)) > (float)range) {
                    wheel.field_70165_t = (target.x * (float)tf + (float)wheel.field_70165_t * (float)cf) / (float)(tf + cf);
                }
                if (MathHelper.func_76135_e((float)(target.y - (float)wheel.field_70163_u)) > (float)range) {
                    wheel.field_70163_u = (target.y * (float)tf + (float)wheel.field_70163_u * (float)cf) / (float)(tf + cf);
                }
                if (!(MathHelper.func_76135_e((float)(target.z - (float)wheel.field_70161_v)) > (float)range)) continue;
                wheel.field_70161_v = (target.z * (float)tf + (float)wheel.field_70161_v * (float)cf) / (float)(tf + cf);
            }
        }
    }

    public EntityPlayer getPlayerByUUID(UUID playerID) {
        if (MinecraftServer.func_71276_C() != null) {
            for (Object object : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                EntityPlayerMP player = (EntityPlayerMP)object;
                if (!player.func_110124_au().equals(playerID)) continue;
                return player;
            }
        }
        return null;
    }

    public void func_70071_h_() {
        Object part;
        super.func_70071_h_();
        DriveableType type = this.getDriveableType();
        DriveableData data = this.getDriveableData();
        if (this.owner == null && !StringUtils.func_151246_b((String)this.ownerUUID)) {
            this.owner = this.getPlayerByUUID(UUID.fromString(this.ownerUUID));
        }
        boolean bl = this.hugeBoat = this.getDriveableType().floatOnWater && this.getDriveableType().wheelStepHeight == 0.0f;
        if (this.hugeBoat) {
            for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                Object obj = this.field_70170_p.field_72996_f.get(i);
                if (obj instanceof EntityPlayer && !this.isPartOfThis((Entity)obj)) {
                    this.moveRiders((Entity)obj);
                }
                if (!(obj instanceof EntityWheel) || this.isPartOfThis((Entity)obj) || this.func_70032_d((Entity)obj) <= this.getDriveableType().bulletDetectionRadius) {
                    // empty if block
                }
                if (obj instanceof EntityDriveable && !this.isPartOfThis((Entity)obj) && !(this.func_70032_d((Entity)obj) <= this.getDriveableType().bulletDetectionRadius)) continue;
            }
        }
        boolean bl2 = this.onDeck = this.deckCheck != this.prevDeckCheck;
        if (type.IT1 && !this.disabled) {
            boolean fireButtonHeld = false;
            if (type.weaponType(false) == EnumWeaponType.MISSILE) {
                fireButtonHeld = this.leftMouseHeld;
            }
            if (type.weaponType(true) == EnumWeaponType.MISSILE) {
                fireButtonHeld = this.rightMouseHeld;
            }
            this.prevDrakonDoorAngle = this.drakonDoorAngle;
            this.prevDrakonArmAngle = this.drakonArmAngle;
            this.prevDrakonRailAngle = this.drakonRailAngle;
            if (this.canFireIT1) {
                this.reloadingDrakon = false;
            }
            if (this.stage == 0) {
                this.stage = 1;
            }
            if (this.stage == 8 && fireButtonHeld) {
                this.stage = 1;
                this.timeTillDeactivate = 5;
                this.toDeactivate = true;
            }
            if (this.timeTillDeactivate <= 0 && this.toDeactivate) {
                this.canFireIT1 = false;
                this.toDeactivate = false;
            }
            if (this.reloadAnimTime <= 0) {
                this.IT1Reload();
            }
            --this.reloadAnimTime;
            --this.timeTillDeactivate;
        }
        this.prevPropAngle = this.propAngle;
        this.prevRotorAngle = this.rotorAngle;
        if (this.throttle != 0.0f) {
            this.propAngle = (float)((double)this.propAngle + Math.pow(Math.abs(this.throttle), 0.4) * 1.5);
            this.rotorAngle += this.throttle / 7.0f;
        }
        if (this.leftMouseHeld && !this.disabled) {
            this.tryRecoil();
            this.setRecoilTimer();
        }
        this.lastRecoilPos = this.recoilPos;
        if (this.recoilPos > 180.0f - 180.0f / type.recoilTime) {
            this.recoilPos = 0.0f;
            this.isRecoil = false;
        }
        if (this.isRecoil) {
            this.recoilPos += 180.0f / type.recoilTime;
        }
        if (this.recoilTimer >= 0) {
            --this.recoilTimer;
        }
        this.checkInventoryChanged();
        if (this.isUnderWater() && !type.worksUnderWater && !this.hugeBoat) {
            this.throttle = 0.0f;
            this.disabled = true;
        } else {
            this.disabled = false;
        }
        if ((type.lockOnToLivings || type.lockOnToMechas || type.lockOnToPlanes || type.lockOnToPlayers || type.lockOnToVehicles) && !this.field_70170_p.field_72995_K && this.seats.length > 0 && this.lockOnSoundDelay <= 0 && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer) {
            Vector3f playerVecRelToVehicle = this.seats[0].playerLooking.findGlobalVectorLocally(new Vector3f(-1.0f, 0.0f, 0.0f));
            Vector3f playerVec = this.axes.findGlobalVectorLocally(playerVecRelToVehicle);
            for (Object obj : this.field_70170_p.field_72996_f) {
                Vector3f relPosVec;
                float angle;
                Entity entity = (Entity)obj;
                if (!(type.lockOnToMechas && entity instanceof EntityMecha || type.lockOnToVehicles && entity instanceof EntityVehicle || type.lockOnToPlanes && entity instanceof EntityPlane || type.lockOnToPlayers && entity instanceof EntityPlayer) && (!type.lockOnToLivings || !(entity instanceof EntityLivingBase)) || !(this.func_70068_e(entity) < (double)(type.maxRangeLockOn * type.maxRangeLockOn)) || !((double)(angle = Math.abs(Vector3f.angle(playerVec, relPosVec = new Vector3f(-entity.field_70165_t + this.seats[0].field_70165_t, -entity.field_70163_u + this.seats[0].field_70163_u, entity.field_70161_v - this.seats[0].field_70161_v)))) < Math.toRadians(type.canLockOnAngle))) continue;
                PacketPlaySound.sendSoundPacket(this.seats[0].field_70165_t, this.seats[0].field_70163_u, this.seats[0].field_70161_v, 10.0, this.field_71093_bK, type.lockOnSound, false);
                if (entity instanceof EntityDriveable) {
                    PacketPlaySound.sendSoundPacket(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ((EntityDriveable)entity).getDriveableType().lockedOnSoundRange, entity.field_71093_bK, ((EntityDriveable)entity).getDriveableType().lockingOnSound, false);
                }
                this.lockOnSoundDelay = type.lockOnSoundTime;
                break;
            }
        }
        if (this.lockOnSoundDelay > 0) {
            --this.lockOnSoundDelay;
        }
        if (this.field_70154_o != null) {
            this.invulnerableUnmountCount = 80;
        } else if (this.invulnerableUnmountCount > 0) {
            --this.invulnerableUnmountCount;
        }
        if (!this.field_70170_p.field_72995_K) {
            int i;
            for (i = 0; i < this.getDriveableType().numPassengers + 1; ++i) {
                if (this.seats[i] != null && this.seats[i].field_70175_ag) continue;
                this.seats[i] = new EntitySeat(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.seats[i]);
            }
            for (i = 0; i < type.wheelPositions.length; ++i) {
                if (this.wheels[i] != null && this.wheels[i].field_70175_ag) continue;
                this.wheels[i] = new EntityWheel(this.field_70170_p, this, i);
                this.field_70170_p.func_72838_d((Entity)this.wheels[i]);
            }
        }
        if (this.hasEnoughFuel() && this.isEngineActive()) {
            this.harvesterAngle += this.throttle / 5.0f;
        }
        if (type.harvestBlocks && type.harvestBoxSize != null && type.harvestBoxPos != null && TeamsManager.driveablesBreakBlocks) {
            Vector3f size = new Vector3f(type.harvestBoxSize.x / 16.0f, type.harvestBoxSize.y / 16.0f, type.harvestBoxSize.z / 16.0f);
            Vector3f pos = new Vector3f(type.harvestBoxPos.x / 16.0f, type.harvestBoxPos.y / 16.0f, type.harvestBoxPos.z / 16.0f);
            for (float x = pos.x; x <= pos.x + size.x; x += 1.0f) {
                for (float y = pos.y; y <= pos.y + size.y; y += 1.0f) {
                    for (float z = pos.z; z <= pos.z + size.z; z += 1.0f) {
                        ArrayList stacks;
                        int blockZ;
                        int blockY;
                        Vector3f v = this.axes.findLocalVectorGlobally(new Vector3f(x, y, z));
                        int blockX = (int)Math.round(this.field_70165_t + (double)v.x);
                        Block block = this.field_70170_p.func_147439_a(blockX, blockY = (int)Math.round(this.field_70163_u + (double)v.y), blockZ = (int)Math.round(this.field_70161_v + (double)v.z));
                        if (!type.materialsHarvested.contains(block.func_149688_o()) || !(block.func_149712_f(this.field_70170_p, blockX, blockY, blockZ) >= 0.0f)) continue;
                        if (type.collectHarvest) {
                            stacks = block.getDrops(this.field_70170_p, blockX, blockY, blockZ, this.field_70170_p.func_72805_g(blockX, blockY, blockZ), 0);
                            for (ItemStack stack : stacks) {
                                if (InventoryHelper.addItemStackToInventory(this.driveableData, stack, this.driverIsCreative()) || this.field_70170_p.field_72995_K || !this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) continue;
                                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), stack));
                            }
                        } else if (type.dropHarvest) {
                            stacks = block.getDrops(this.field_70170_p, blockX, blockY, blockZ, this.field_70170_p.func_72805_g(blockX, blockY, blockZ), 0);
                            for (ItemStack stack : stacks) {
                                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), stack));
                            }
                        }
                        this.field_70170_p.func_147480_a(blockX, blockY, blockZ, false);
                    }
                }
            }
        }
        for (DriveablePart part2 : this.getDriveableData().parts.values()) {
            Vector3f pos;
            if (part2.box == null) continue;
            part2.update(this);
            if (this.field_70170_p.field_72995_K) {
                if (part2.onFire) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f(part2.box.x + this.field_70146_Z.nextFloat() * part2.box.w, part2.box.y + this.field_70146_Z.nextFloat() * part2.box.h, part2.box.z + this.field_70146_Z.nextFloat() * part2.box.d));
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0);
                }
                if (part2.health > 0.0f && part2.health < part2.maxHealth / 2.0f) {
                    pos = this.axes.findLocalVectorGlobally(new Vector3f(part2.box.x + this.field_70146_Z.nextFloat() * part2.box.w, part2.box.y + this.field_70146_Z.nextFloat() * part2.box.h, part2.box.z + this.field_70146_Z.nextFloat() * part2.box.d));
                    this.field_70170_p.func_72869_a(part2.health < part2.maxHealth / 4.0f ? "largesmoke" : "smoke", this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 0.0, 0.0, 0.0);
                }
            }
            if (part2.onFire) {
                if (this.field_70170_p.func_72896_J() && this.field_70146_Z.nextInt(40) == 0) {
                    part2.onFire = false;
                }
                pos = this.axes.findLocalVectorGlobally(new Vector3f(part2.box.x + part2.box.w / 2.0f, part2.box.y + part2.box.h / 2.0f, part2.box.z + part2.box.d / 2.0f));
                if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z))).func_149688_o() != Material.field_151586_h) continue;
                part2.onFire = false;
                continue;
            }
            pos = this.axes.findLocalVectorGlobally(new Vector3f(part2.box.x / 16.0f + part2.box.w / 32.0f, part2.box.y / 16.0f + part2.box.h / 32.0f, part2.box.z / 16.0f + part2.box.d / 32.0f));
            if (this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)(this.field_70165_t + (double)pos.x)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)pos.y)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)pos.z))).func_149688_o() != Material.field_151587_i) continue;
            part2.onFire = true;
        }
        for (int i = 0; i < type.emitters.size(); ++i) {
            boolean canEmit;
            DriveableType.ParticleEmitter emitter = type.emitters.get(i);
            int n = i;
            this.emitterTimers[n] = this.emitterTimers[n] - 1;
            boolean inThrottle = false;
            part = this.getDriveableData().parts.get((Object)EnumDriveablePart.getPart(emitter.part));
            float healthPercentage = ((DriveablePart)part).health / ((DriveablePart)part).maxHealth;
            boolean bl3 = canEmit = this.isPartIntact(EnumDriveablePart.getPart(emitter.part)) && healthPercentage >= emitter.minHealth && healthPercentage <= emitter.maxHealth;
            if (this.throttle >= emitter.minThrottle && this.throttle <= emitter.maxThrottle) {
                inThrottle = true;
            }
            if (this.isMecha) {
                inThrottle = true;
            }
            if (this.emitterTimers[i] > 0) continue;
            if (inThrottle && canEmit) {
                Vector3f velocity = new Vector3f(0.0f, 0.0f, 0.0f);
                Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
                if (this.seats != null && this.seats[0] != null) {
                    Vector3f localPosition2;
                    if (EnumDriveablePart.getPart(emitter.part) != EnumDriveablePart.turret && EnumDriveablePart.getPart(emitter.part) != EnumDriveablePart.barrel) {
                        Vector3f localPosition = new Vector3f(emitter.origin.x + this.field_70146_Z.nextFloat() * emitter.extents.x - emitter.extents.x * 0.5f, emitter.origin.y + this.field_70146_Z.nextFloat() * emitter.extents.y - emitter.extents.y * 0.5f, emitter.origin.z + this.field_70146_Z.nextFloat() * emitter.extents.z - emitter.extents.z * 0.5f);
                        pos = this.axes.findLocalVectorGlobally(localPosition);
                        velocity = this.axes.findLocalVectorGlobally(emitter.velocity);
                    } else if (EnumDriveablePart.getPart(emitter.part) == EnumDriveablePart.turret || EnumDriveablePart.getPart(emitter.part) == EnumDriveablePart.head && !emitter.part.equals("barrel")) {
                        localPosition2 = new Vector3f(emitter.origin.x + this.field_70146_Z.nextFloat() * emitter.extents.x - emitter.extents.x * 0.5f, emitter.origin.y + this.field_70146_Z.nextFloat() * emitter.extents.y - emitter.extents.y * 0.5f, emitter.origin.z + this.field_70146_Z.nextFloat() * emitter.extents.z - emitter.extents.z * 0.5f);
                        pos = this.getPositionOnTurret(localPosition2, false);
                        velocity = this.getPositionOnTurret(emitter.velocity, false);
                    } else if (EnumDriveablePart.getPart(emitter.part) == EnumDriveablePart.barrel) {
                        localPosition2 = new Vector3f(emitter.origin.x + this.field_70146_Z.nextFloat() * emitter.extents.x - emitter.extents.x * 0.5f, emitter.origin.y + this.field_70146_Z.nextFloat() * emitter.extents.y - emitter.extents.y * 0.5f, emitter.origin.z + this.field_70146_Z.nextFloat() * emitter.extents.z - emitter.extents.z * 0.5f);
                        pos = this.getPositionOnTurret(localPosition2, true);
                        velocity = this.getPositionOnTurret(emitter.velocity, true);
                    }
                    FlansMod.getPacketHandler().sendToAllAround(new PacketParticle(emitter.effectType, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, velocity.x, velocity.y, velocity.z), this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, 150.0f, this.field_71093_bK);
                }
            }
            this.emitterTimers[i] = emitter.emitRate;
        }
        this.checkParts();
        this.field_70126_B = this.axes.getYaw();
        this.field_70127_C = this.axes.getPitch();
        this.prevRotationRoll = this.axes.getRoll();
        this.prevAxes = this.axes.clone();
        if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
            this.field_70153_n = null;
        }
        if (this.field_70153_n != null && this.field_70128_L) {
            this.field_70153_n.func_70078_a(null);
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70143_R = 0.0f;
        }
        if (this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n == null || !this.isEngineActive() && this.getDriveableType().maxThrottle != 0.0f && this.getDriveableType().maxNegativeThrottle != 0.0f) {
            this.throttle *= 0.99f;
        }
        if (this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n == null) {
            this.leftMouseHeld = false;
            this.rightMouseHeld = false;
        }
        if (this.shootDelayPrimary > 0.0f) {
            this.shootDelayPrimary -= 1.0f;
        }
        if (this.shootDelaySecondary > 0.0f) {
            this.shootDelaySecondary -= 1.0f;
        }
        if (this.getDriveableType().reloadSoundTick != 15214541 && this.shootDelayPrimary == (float)this.getDriveableType().reloadSoundTick) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.shootReloadSound, false);
        }
        if (this.field_70173_aa == 1) {
            this.setShootDelay(this.getDriveableType().placeTimePrimary, false);
            this.setShootDelay(this.getDriveableType().placeTimeSecondary, true);
            if (!this.field_70170_p.field_72995_K) {
                if (!this.getDriveableType().placeSoundPrimary.isEmpty()) {
                    PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.getDriveableType().placeSoundPrimary, false);
                }
                if (!this.getDriveableType().placeSoundSecondary.isEmpty()) {
                    PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.getDriveableType().placeSoundSecondary, false);
                }
            }
        }
        if (this.seats[0] != null && this.seats[0].field_70153_n != null && this.seats[0].field_70153_n instanceof EntityPlayer && this.field_70170_p.field_72995_K) {
            EntityPlayer p = (EntityPlayer)this.seats[0].field_70153_n;
            if (this.field_70173_aa < this.getDriveableType().placeTimePrimary && this.getShootDelay(false) % 100.0f == 0.0f) {
                p.func_146105_b((IChatComponent)new ChatComponentText("Primary gun ready to use in " + this.getShootDelay(false) / 20.0f + " seconds."));
            } else if (this.field_70173_aa == this.getDriveableType().placeTimePrimary) {
                p.func_146105_b((IChatComponent)new ChatComponentText("Primary gun ready to use!"));
            }
            if (this.field_70173_aa < this.getDriveableType().placeTimeSecondary && this.getShootDelay(true) % 100.0f == 0.0f) {
                p.func_146105_b((IChatComponent)new ChatComponentText("Secondary gun ready to use in " + this.getShootDelay(true) / 20.0f + " seconds."));
            } else if (this.field_70173_aa == this.getDriveableType().placeTimeSecondary) {
                p.func_146105_b((IChatComponent)new ChatComponentText("Secondary gun ready to use!"));
            }
            if (this.engineStartDelay > 0 && (double)this.engineStartDelay % 50.0 == 0.0) {
                p.func_146105_b((IChatComponent)new ChatComponentText("Engine starting.. " + (float)this.engineStartDelay / 20.0f + " seconds remaining."));
            } else if (this.engineStartDelay == 1) {
                p.func_146105_b((IChatComponent)new ChatComponentText("Engine started!"));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.leftMouseHeld && this.getDriveableType().modePrimary == EnumFireMode.FULLAUTO) {
                this.shoot(false);
            }
            if (this.rightMouseHeld && this.getDriveableType().modeSecondary == EnumFireMode.FULLAUTO) {
                this.shoot(true);
            }
            this.minigunSpeedPrimary *= 0.9f;
            this.minigunSpeedSecondary *= 0.9f;
            if (this.leftMouseHeld && this.getDriveableType().modePrimary == EnumFireMode.MINIGUN) {
                this.minigunSpeedPrimary += 0.1f;
                if (this.minigunSpeedPrimary > 1.0f) {
                    this.shoot(false);
                }
            }
            if (this.rightMouseHeld && this.getDriveableType().modeSecondary == EnumFireMode.MINIGUN) {
                this.minigunSpeedSecondary += 0.1f;
                if (this.minigunSpeedSecondary > 1.0f) {
                    this.shoot(true);
                }
            }
        }
        this.prevDeckCheck = this.deckCheck;
        if (this.engineStartDelay > 0) {
            --this.engineStartDelay;
        }
        int fuelMultiplier = 2;
        if (data.fuelInTank >= (float)type.fuelTankSize) {
            return;
        }
        for (int i = 0; i < data.func_70302_i_(); ++i) {
            ItemStack stack = data.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            Item item = stack.func_77973_b();
            if (data.engine.useRFPower) {
                if (!(item instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem energy = (IEnergyContainerItem)item;
                data.fuelInTank += (float)(fuelMultiplier * energy.extractEnergy(stack, data.engine.RFDrawRate, false) / data.engine.RFDrawRate);
                continue;
            }
            if (item instanceof ItemPart) {
                part = ((ItemPart)item).type;
                if (((PartType)part).category == 9) {
                    data.fuelInTank += (float)fuelMultiplier;
                    int damage = stack.func_77960_j();
                    stack.func_77964_b(damage + 1);
                    if (damage < stack.func_77958_k()) break;
                    stack.func_77964_b(0);
                    --stack.field_77994_a;
                    if (stack.field_77994_a > 0) break;
                    data.func_70299_a(i, null);
                    break;
                }
            } else if (FlansMod.hooks.BuildCraftLoaded && stack.func_77969_a(FlansMod.hooks.BuildCraftOilBucket) && data.fuelInTank + (float)(1000 * fuelMultiplier) <= (float)type.fuelTankSize) {
                data.fuelInTank += (float)(1000 * fuelMultiplier);
                data.func_70299_a(i, new ItemStack(Items.field_151133_ar));
            } else if (FlansMod.hooks.BuildCraftLoaded && stack.func_77969_a(FlansMod.hooks.BuildCraftFuelBucket) && data.fuelInTank + (float)(2000 * fuelMultiplier) <= (float)type.fuelTankSize) {
                data.fuelInTank += (float)(2000 * fuelMultiplier);
                data.func_70299_a(i, new ItemStack(Items.field_151133_ar));
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
        }
    }

    public void checkInventoryChanged() {
        DriveableType type = this.getDriveableType();
        if (type == null) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.driveableData.inventoryChanged) {
            return;
        }
        this.driveableData.inventoryChanged = false;
        try {
            for (int ps = 0; ps < 2; ++ps) {
                int i;
                int istart;
                EnumWeaponType weaponType;
                EnumWeaponType enumWeaponType = weaponType = ps == 0 ? type.primary : type.secondary;
                if (weaponType == EnumWeaponType.GUN) {
                    weaponType = EnumWeaponType.NONE;
                }
                if ((istart = this.getInventoryStart(weaponType)) == this.driveableData.getAmmoInventoryStart()) {
                    istart += type.numPassengerGunners;
                }
                int isize = this.getInventorySize(weaponType);
                if (istart < 0 && isize <= 0) continue;
                if (this.prevInventoryItems[ps] == null) {
                    this.prevInventoryItems[ps] = new ItemStack[isize];
                }
                for (i = 0; i < isize; ++i) {
                    ItemStack itemStack = this.driveableData.func_70301_a(istart + i);
                    if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemBullet) || this.prevInventoryItems[ps][i] != null && ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)this.prevInventoryItems[ps][i]) || !type.isValidAmmo(((ItemBullet)itemStack.func_77973_b()).type, weaponType)) continue;
                    this.onWeaponInventoryChanged(ps == 1);
                    break;
                }
                for (i = 0; i < isize; ++i) {
                    this.prevInventoryItems[ps][i] = this.driveableData.func_70301_a(istart + i);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onWeaponInventoryChanged(boolean secondary) {
        DriveableType type = this.getDriveableType();
        if (!secondary) {
            if (type.reloadTimePrimary > 0 && this.getShootDelay(secondary) <= 0.0f) {
                this.setShootDelay(type.reloadTimePrimary, secondary);
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.getDriveableType().reloadSoundPrimary, false);
            }
        } else if (type.reloadTimeSecondary > 0 && this.getShootDelay(secondary) <= 0.0f) {
            this.setShootDelay(type.reloadTimeSecondary, secondary);
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, this.getDriveableType().reloadSoundSecondary, false);
        }
    }

    public int getInventoryStart(EnumWeaponType wt) {
        switch (wt) {
            case GUN: 
            case NONE: {
                return this.driveableData.getAmmoInventoryStart();
            }
            case MISSILE: 
            case SHELL: {
                return this.driveableData.getMissileInventoryStart();
            }
            case BOMB: 
            case MINE: {
                return this.driveableData.getBombInventoryStart();
            }
        }
        return -1;
    }

    public int getInventorySize(EnumWeaponType wt) {
        switch (wt) {
            case GUN: 
            case NONE: {
                return this.driveableData.ammo.length;
            }
            case MISSILE: 
            case SHELL: {
                return this.driveableData.missiles.length;
            }
            case BOMB: 
            case MINE: {
                return this.driveableData.bombs.length;
            }
        }
        return -1;
    }

    public void checkForCollisions() {
        boolean damagePart = false;
        boolean crashInWater = false;
        double speed = this.getSpeedXYZ();
        for (DriveablePosition p : this.getDriveableType().collisionPoints) {
            MovingObjectPosition hit;
            if (this.driveableData.parts.get((Object)((Object)p.part)).dead) continue;
            Vector3f lastRelPos = this.prevAxes.findLocalVectorGlobally(p.position);
            Vec3 lastPos = Vec3.func_72443_a((double)(this.field_70169_q + (double)lastRelPos.x), (double)(this.field_70167_r + (double)lastRelPos.y), (double)(this.field_70166_s + (double)lastRelPos.z));
            Vector3f currentRelPos = this.axes.findLocalVectorGlobally(p.position);
            Vec3 currentPos = Vec3.func_72443_a((double)(this.field_70165_t + (double)currentRelPos.x), (double)(this.field_70163_u + (double)currentRelPos.y), (double)(this.field_70161_v + (double)currentRelPos.z));
            if (FlansMod.DEBUG && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, new Vector3f(lastPos), Vector3f.sub(currentRelPos, lastRelPos, null), 10, 1.0f, 0.0f, 0.0f));
            }
            if ((hit = this.field_70170_p.func_72901_a(lastPos, currentPos, crashInWater)) == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) continue;
            int x = hit.field_72311_b;
            int y = hit.field_72312_c;
            int z = hit.field_72309_d;
            Block blockHit = this.field_70170_p.func_147439_a(x, y, z);
            int meta = this.field_70170_p.func_72805_g(x, y, z);
            float blockHardness = blockHit.func_149712_f(this.field_70170_p, x, y, z);
            float damage = 0.0f;
            if ((double)blockHardness > 0.2) {
                damage = blockHardness * blockHardness * (float)speed;
            }
            if (null == blockHit.func_149668_a(this.field_70170_p, x, y, z)) {
                damage = 0.0f;
            }
            if (!(damage > 0.0f)) continue;
            damagePart = true;
            if (!this.attackPart(p.part, DamageSource.field_76368_d, damage) && TeamsManager.driveablesBreakBlocks) {
                this.field_70170_p.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)blockHit) + (meta << 12));
                if (this.field_70170_p.field_72995_K) continue;
                blockHit.func_149697_b(this.field_70170_p, x, y, z, meta, 1);
                this.field_70170_p.func_147468_f(x, y, z);
                continue;
            }
            this.field_70170_p.func_72876_a((Entity)this, currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c, 1.0f, false);
        }
        if (FlansMod.seatCollisions) {
            for (EntitySeat seat : this.seats) {
                Vec3 wheelMidPos;
                double checkY;
                Vec3 seatPos;
                MovingObjectPosition hit;
                if (seat == null || this.wheels == null || this.wheels[0] == null || this.wheels[1] == null || seat.field_70153_n == null) continue;
                DriveablePosition p = seat.getAsDriveablePosition();
                if (this.driveableData.parts.get((Object)((Object)p.part)).dead) continue;
                Vector3f fwd = this.axes.getXAxis();
                float a = 0.0f;
                if (this.getSpeedXZ() > 1.0) {
                    a = this.getSpeedXZ() > 2.0 ? 6.0f : 3.0f;
                }
                if ((hit = this.field_70170_p.func_72901_a(seatPos = Vec3.func_72443_a((double)(seat.field_70165_t + (double)(fwd.x * a)), (double)((checkY = Math.max((this.wheels[0].field_70163_u + this.wheels[1].field_70163_u) / 2.0 + (this instanceof EntityVehicle ? 1.5 : 0.0), seat.field_70163_u)) + (double)(fwd.y * a)), (double)(seat.field_70161_v + (double)(fwd.z * a))), wheelMidPos = Vec3.func_72443_a((double)((this.wheels[0].field_70165_t + this.wheels[1].field_70165_t) / 2.0), (double)checkY, (double)((this.wheels[0].field_70161_v + this.wheels[1].field_70161_v) / 2.0)), crashInWater)) == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) continue;
                int x = hit.field_72311_b;
                int y = hit.field_72312_c;
                int z = hit.field_72309_d;
                Block blockHit = this.field_70170_p.func_147439_a(x, y, z);
                this.collisionHardness = Float.valueOf(blockHit.func_149712_f(this.field_70170_p, x, y, z));
            }
        }
        if (damagePart && !this.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
        }
    }

    protected void func_70069_a(float k) {
        double fallDist = (this.field_70163_u - this.field_70167_r + this.field_70181_x) / 2.0;
        float damage = (float)(fallDist < -0.3 ? -fallDist * 50.0 : 0.0);
        boolean noDamage = true;
        if (damage > 0.0f && this.invulnerableUnmountCount == 0 && this.field_70173_aa > 20) {
            DriveableType type = this.getDriveableType();
            damage = (int)(damage * type.fallDamageFactor);
            this.attackPart(EnumDriveablePart.core, DamageSource.field_76379_h, damage);
            if (type.wheelPositions.length > 0) {
                this.attackPart(type.wheelPositions[0].part, DamageSource.field_76379_h, damage / 5.0f);
            }
            noDamage = false;
        }
    }

    public boolean attackPart(EnumDriveablePart ep, DamageSource source, float damage) {
        boolean isFriendly = false;
        if (ep == EnumDriveablePart.core) {
            this.lastAtkEntity = source.func_76364_f() instanceof EntityLivingBase ? source.func_76364_f() : (source.func_76346_g() instanceof EntityLivingBase ? source.func_76346_g() : null);
        }
        if (TeamsManager.getInstance().currentRound != null && source instanceof EntityDamageSourceFlans) {
            EntityPlayerMP driver = null;
            for (EntitySeat seat : this.seats) {
                if (seat.field_70153_n == null || !(seat.field_70153_n instanceof EntityPlayerMP)) continue;
                driver = (EntityPlayerMP)seat.field_70153_n;
            }
            if (driver != null) {
                EntityDamageSourceFlans dsf = (EntityDamageSourceFlans)source;
                EntityPlayerMP attacker = (EntityPlayerMP)dsf.shooter;
                PlayerData attackerData = PlayerHandler.getPlayerData((EntityPlayer)attacker);
                PlayerData driverData = PlayerHandler.getPlayerData(driver);
                if (attackerData.team.shortName.equals(driverData.team.shortName)) {
                    isFriendly = true;
                    damage = 0.0f;
                }
            }
        }
        DriveablePart part = this.driveableData.parts.get((Object)ep);
        return part.attack(damage, source.func_76347_k());
    }

    public Vector3f rotate(Vector3f inVec) {
        return this.axes.findLocalVectorGlobally(inVec);
    }

    public Vector3f rotate(Vec3 inVec) {
        return this.rotate(inVec.field_72450_a, inVec.field_72448_b, inVec.field_72449_c);
    }

    public Vector3f rotate(double x, double y, double z) {
        return this.rotate(new Vector3f((float)x, (float)y, (float)z));
    }

    public void rotateYaw(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalYaw(rotateBy);
        this.updatePrevAngles();
    }

    public void rotatePitch(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalPitch(rotateBy);
        this.updatePrevAngles();
    }

    public void rotateRoll(float rotateBy) {
        if (Math.abs(rotateBy) < 0.01f) {
            return;
        }
        this.axes.rotateLocalRoll(rotateBy);
        this.updatePrevAngles();
    }

    public void updatePrevAngles() {
        double dRoll;
        double dPitch;
        double dYaw = this.axes.getYaw() - this.field_70126_B;
        if (dYaw > 180.0) {
            this.field_70126_B += 360.0f;
        }
        if (dYaw < -180.0) {
            this.field_70126_B -= 360.0f;
        }
        if ((dPitch = (double)(this.axes.getPitch() - this.field_70127_C)) > 180.0) {
            this.field_70127_C += 360.0f;
        }
        if (dPitch < -180.0) {
            this.field_70127_C -= 360.0f;
        }
        if ((dRoll = (double)(this.axes.getRoll() - this.prevRotationRoll)) > 180.0) {
            this.prevRotationRoll += 360.0f;
        }
        if (dRoll < -180.0) {
            this.prevRotationRoll -= 360.0f;
        }
    }

    public void setRotation(float rotYaw, float rotPitch, float rotRoll) {
        this.axes.setAngles(rotYaw, rotPitch, rotRoll);
    }

    public boolean isPartOfThis(Entity ent) {
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            if (ent == seat) {
                return true;
            }
            if (seat.field_70153_n != ent) continue;
            return true;
        }
        return ent == this;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public DriveableType getDriveableType() {
        return DriveableType.getDriveable(this.driveableType);
    }

    public DriveableData getDriveableData() {
        return this.driveableData;
    }

    @Override
    public boolean isDead() {
        return this.field_70128_L;
    }

    @Override
    public Entity getControllingEntity() {
        return this.seats[0].getControllingEntity();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        ItemStack stack = new ItemStack(this.getDriveableType().item, 1, 0);
        stack.field_77990_d = new NBTTagCompound();
        this.driveableData.writeToNBT(stack.field_77990_d);
        return stack;
    }

    public boolean hasEnoughFuel() {
        return this.driverIsCreative() || this.driveableData.fuelInTank > Math.abs(this.driveableData.engine.fuelConsumption * this.throttle) || this.getDriveableType().fuelTankSize < 0;
    }

    public double getSpeedXYZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
    }

    public double getSpeedXZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public double getHackySpeedXYZ() {
        double dx = this.field_70165_t - this.field_70142_S;
        double dy = this.field_70163_u - this.field_70137_T;
        double dz = this.field_70161_v - this.field_70136_U;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public boolean landVehicle() {
        return false;
    }

    public boolean gearDown() {
        return true;
    }

    public boolean onGround() {
        return this.field_70122_E;
    }

    public void moveRiders(Entity rider) {
        if (this.isPartOfThis(rider)) {
            return;
        }
        boolean isHuman = false;
        boolean isDriveable = false;
        if (!(rider instanceof EntityPlayer)) {
            return;
        }
        Vector3f riderPos = new Vector3f(rider.field_70165_t, rider.field_70163_u, rider.field_70161_v);
        Vector3f riderMotion = new Vector3f(rider.field_70159_w, rider.field_70181_x, rider.field_70181_x);
        Vector3f vehicleMotion = new Vector3f(this.field_70165_t - (double)this.lastPos.x, this.field_70163_u - (double)this.lastPos.y, this.field_70161_v - (double)this.lastPos.z);
        if (rider instanceof EntityVehicle) {
            vehicleMotion = ((EntityVehicle)rider).lastPos;
        }
        Vector3f vehiclePos = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vector3f relativePos = Vector3f.sub(riderPos, vehiclePos, null);
        if (rider instanceof EntityPlayer) {
            isHuman = true;
        }
        if (rider instanceof EntityDriveable) {
            isDriveable = true;
        }
        relativePos = new Vector3f(relativePos.x, relativePos.y - (isHuman ? 0.55f : 0.0f), relativePos.z);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePos);
        Vector3f rotatedMotionVector = this.axes.findGlobalVectorLocally(riderMotion);
        Vector3f ellipsoid = new Vector3f(rider.field_70130_N / 2.0f, rider.field_70131_O, rider.field_70130_N / 2.0f);
        CollisionTest test = new CollisionTest(ellipsoid, new Vector3f(relativePos.x, relativePos.y, relativePos.z), riderMotion);
        test.collisionRecursiveDepth = 0;
        Vector3f eSpacePosition = test.ConvertR3ToESpace(test.R3Position);
        Vector3f eSpaceVelocity = test.velocity;
        DriveableType type = this.getDriveableType();
        if (type.fancyCollision) {
            for (CollisionShapeBox sbox : type.collisionBox) {
                this.checkCollision(test, sbox);
            }
        } else {
            for (DriveablePart ppart : this.getDriveableData().parts.values()) {
                ppart.rayTraceRider(this, test);
            }
        }
        if (test.didCollide) {
            boolean onTop;
            Vector3f finalPos = this.collideWithDriveable(test, eSpacePosition, eSpaceVelocity);
            if (finalPos == null) {
                finalPos = new Vector3f(0.0f, 0.0f, 0.0f);
                if (FlansMod.debugMode) {
                    FlansMod.log("EntityDriveable.java moveRiders> finalPos is null [1]");
                }
            }
            Vector3f velocity = Vector3f.sub(finalPos, test.basePoint, null);
            test.ConvertESpaceToR3(velocity);
            finalPos = new Vector3f(finalPos.x * test.eRad.x, finalPos.y * test.eRad.y, finalPos.z * test.eRad.z);
            if (finalPos == null) {
                finalPos = new Vector3f(0.0f, 0.0f, 0.0f);
                if (FlansMod.debugMode) {
                    FlansMod.log("EntityDriveable.java moveRiders> finalPos is null [2]");
                }
            }
            Vector3f diff = Vector3f.sub(finalPos, vehiclePos, null);
            if (!rider.field_70122_E || this.field_70163_u + (double)finalPos.y + 0.625 < (double)riderPos.y) {
                // empty if block
            }
            boolean stationary = this.throttle == 0.0f;
            test.ConvertESpaceToR3(finalPos);
            boolean bl = onTop = test.collisionPlaneNormal.y >= 0.5f;
            if (this.field_70163_u + (double)finalPos.y + 0.625 < (double)riderPos.y) {
                finalPos.y = riderPos.y - (float)this.field_70163_u - 0.625f;
            }
            if (!this.hugeBoat) {
                rider.func_70107_b(!onTop ? (double)(riderPos.x + finalPos.x / (48.0f * Math.abs(relativePos.x))) : (double)riderPos.x, onTop ? this.field_70163_u + (double)finalPos.y + 0.625 : (double)riderPos.y, !onTop ? (double)(riderPos.z + finalPos.z / (48.0f * Math.abs(relativePos.z))) : (double)riderPos.z);
            }
            if (this.hugeBoat && !stationary) {
                rider.func_70107_b((double)riderPos.x, this.field_70163_u + (double)finalPos.y + 0.59375, (double)riderPos.z);
            } else if (this.hugeBoat && stationary) {
                rider.func_70107_b((double)riderPos.x, this.field_70163_u + (double)finalPos.y + 0.625, (double)riderPos.z);
            }
            finalPos = Vector3f.sub(finalPos, riderPos, null);
            finalPos.normalise();
            rider.field_70181_x = 0.0;
            this.updateRiderPos(rider, test, finalPos, riderMotion);
            if (this.getDriveableType().collisionDamageEnable && !test.isOnTop && this.throttle > this.getDriveableType().collisionDamageThrottle) {
                boolean canDamage = true;
                if (TeamsManager.getInstance() != null && TeamsManager.getInstance().currentRound != null && rider instanceof EntityPlayerMP && this.seats[0].field_70153_n instanceof EntityPlayer) {
                    EntityPlayerMP attacker = (EntityPlayerMP)this.seats[0].field_70153_n;
                    EntityPlayerMP player = (EntityPlayerMP)rider;
                    GameType cfr_ignored_0 = TeamsManager.getInstance().currentRound.gametype;
                    if (GameType.getPlayerData(attacker) != null) {
                        GameType cfr_ignored_1 = TeamsManager.getInstance().currentRound.gametype;
                        if (GameType.getPlayerData((EntityPlayerMP)attacker).team != null) {
                            GameType cfr_ignored_2 = TeamsManager.getInstance().currentRound.gametype;
                            if (GameType.getPlayerData(player) != null) {
                                GameType cfr_ignored_3 = TeamsManager.getInstance().currentRound.gametype;
                                if (GameType.getPlayerData((EntityPlayerMP)player).team != null) {
                                    GameType cfr_ignored_4 = TeamsManager.getInstance().currentRound.gametype;
                                    GameType cfr_ignored_5 = TeamsManager.getInstance().currentRound.gametype;
                                    if (GameType.getPlayerData((EntityPlayerMP)player).team == GameType.getPlayerData((EntityPlayerMP)attacker).team) {
                                        canDamage = false;
                                    }
                                }
                            }
                        }
                    }
                }
                for (EntitySeat seat : this.seats) {
                    if (rider != seat.lastRiddenByEntity) continue;
                    canDamage = false;
                    break;
                }
                if (canDamage) {
                    if (rider instanceof EntityLiving) {
                        rider.func_70097_a(DamageSource.field_76377_j, this.throttle * this.getDriveableType().collisionDamageTimes);
                    } else if (rider instanceof EntityPlayer) {
                        rider.func_70097_a(DamageSource.field_76377_j, this.throttle * this.getDriveableType().collisionDamageTimes);
                    }
                }
            }
            if (rider instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)rider;
                player.field_70122_E = true;
                player.field_70160_al = false;
                player.field_70143_R = 0.0f;
            }
        } else if (rider instanceof EntityDriveable) {
            ((EntityDriveable)rider).deckHeight = 0.0;
        }
    }

    public DamageSource getBulletDamage(boolean headshot) {
        DriveableType type = this.getDriveableType();
        EntityLivingBase owner = (EntityLivingBase)this.seats[0].field_70153_n;
        if (owner instanceof EntityPlayer) {
            return new EntityDamageSourceFlans(this.getDriveableType().shortName, this, (EntityPlayer)owner, type, headshot, false).func_76349_b();
        }
        return new EntityDamageSourceIndirect(type.shortName, (Entity)this, (Entity)owner).func_76349_b();
    }

    public void checkCollision(CollisionTest tester, CollisionShapeBox box) {
        double distance = tester.nearestDistance;
        Vector3f collisionPoint = new Vector3f(0.0f, 0.0f, 0.0f);
        int surface = 0;
        Vector3f pos = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        RotatedAxes shift = this.axes;
        float f4 = box.pos.x + box.size.x;
        float f5 = -box.pos.y + box.size.y;
        float f6 = box.pos.z + box.size.z;
        box.pos = new Vector3f(box.pos.x, box.pos.y, box.pos.z);
        Vector3f p1 = new Vector3f(box.pos.x - box.p1.x, box.pos.y + box.size.y + box.p1.y - box.size.y + 0.625f, box.pos.z - box.p1.z);
        Vector3f p2 = new Vector3f(box.pos.x + box.size.x + box.p2.x, box.pos.y + box.size.y + box.p2.y - box.size.y + 0.625f, box.pos.z - box.p2.z);
        Vector3f p3 = new Vector3f(box.pos.x + box.size.x + box.p3.x, box.pos.y + box.size.y + box.p3.y - box.size.y + 0.625f, box.pos.z + box.size.z + box.p3.z);
        Vector3f p4 = new Vector3f(box.pos.x - box.p4.x, box.pos.y + box.size.y + box.p4.y - box.size.y + 0.625f, box.pos.z + box.size.z + box.p4.z);
        Vector3f p5 = new Vector3f(box.pos.x - box.p5.x, box.pos.y - box.p5.y - box.size.y + 0.625f, box.pos.z - box.p5.z);
        Vector3f p6 = new Vector3f(box.pos.x + box.size.x + box.p6.x, box.pos.y - box.p6.y - box.size.y + 0.625f, box.pos.z - box.p6.z);
        Vector3f p7 = new Vector3f(box.pos.x + box.size.x + box.p7.x, box.pos.y - box.p7.y - box.size.y + 0.625f, box.pos.z + box.size.z + box.p7.z);
        Vector3f p8 = new Vector3f(box.pos.x - box.p8.x, box.pos.y - box.p8.y - box.size.y + 0.625f, box.pos.z + box.size.z + box.p8.z);
        if (EnumDriveablePart.getPart(box.part) == EnumDriveablePart.turret && this.seats[0] != null) {
            p1 = this.getPositionOnTurret(p1, false);
            p2 = this.getPositionOnTurret(p2, false);
            p3 = this.getPositionOnTurret(p3, false);
            p4 = this.getPositionOnTurret(p4, false);
            p5 = this.getPositionOnTurret(p5, false);
            p6 = this.getPositionOnTurret(p6, false);
            p7 = this.getPositionOnTurret(p7, false);
            p8 = this.getPositionOnTurret(p8, false);
        } else {
            p1 = shift.findLocalVectorGlobally(p1);
            p2 = shift.findLocalVectorGlobally(p2);
            p3 = shift.findLocalVectorGlobally(p3);
            p4 = shift.findLocalVectorGlobally(p4);
            p5 = shift.findLocalVectorGlobally(p5);
            p6 = shift.findLocalVectorGlobally(p6);
            p7 = shift.findLocalVectorGlobally(p7);
            p8 = shift.findLocalVectorGlobally(p8);
        }
        double topFaceDist = 100.0;
        tester.checkTriangle(tester, p3, p2, p1);
        if (tester.didCollide && tester.nearestDistance < distance) {
            collisionPoint = tester.intersectionPoint;
            surface = 1;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p4, p3, p1);
        if (tester.didCollide && tester.nearestDistance < distance) {
            collisionPoint = tester.intersectionPoint;
            surface = 1;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        if (tester.didCollide) {
            tester.isOnTop = true;
            topFaceDist = tester.nearestDistance;
        }
        tester.checkTriangle(tester, p6, p7, p3);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 2;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p3, p2, p6);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 2;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p4, p1, p5);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 3;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p5, p8, p4);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 3;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p6, p5, p1);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 4;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p1, p2, p6);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 4;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p8, p7, p3);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 5;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p3, p4, p8);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 5;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p5, p6, p7);
        if (tester.didCollide && tester.nearestDistance < distance) {
            collisionPoint = tester.intersectionPoint;
            surface = 1;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        tester.checkTriangle(tester, p8, p7, p5);
        if (tester.didCollide && tester.nearestDistance < distance) {
            collisionPoint = tester.intersectionPoint;
            surface = 1;
            tester.part = EnumDriveablePart.getPart(box.part);
        }
        if (tester.didCollide) {
            tester.isOnTop = true;
            topFaceDist = tester.nearestDistance;
        }
        Vector3f.add(p1, pos, p1);
        Vector3f.add(p2, pos, p2);
        Vector3f.add(p3, pos, p3);
        Vector3f.add(p4, pos, p4);
        Vector3f.add(p5, pos, p5);
        Vector3f.add(p6, pos, p6);
        Vector3f.add(p7, pos, p7);
        Vector3f.add(p8, pos, p8);
        String particleType = "crit";
        if (FlansMod.DEBUG) {
            FlansMod.proxy.spawnParticle(particleType, p1.x, p1.y, p1.z, 0.0, 0.0, 0.0);
            FlansMod.proxy.spawnParticle(particleType, p2.x, p2.y, p2.z, 0.0, 0.0, 0.0);
            FlansMod.proxy.spawnParticle(particleType, p3.x, p3.y, p3.z, 0.0, 0.0, 0.0);
            FlansMod.proxy.spawnParticle(particleType, p4.x, p4.y, p4.z, 0.0, 0.0, 0.0);
            FlansMod.proxy.spawnParticle(particleType, p5.x, p5.y, p5.z, 0.0, 0.0, 0.0);
            FlansMod.proxy.spawnParticle(particleType, p6.x, p6.y, p6.z, 0.0, 0.0, 0.0);
            FlansMod.proxy.spawnParticle(particleType, p7.x, p7.y, p7.z, 0.0, 0.0, 0.0);
            FlansMod.proxy.spawnParticle(particleType, p8.x, p8.y, p8.z, 0.0, 0.0, 0.0);
            this.renderTri(p1, p2, p3);
            this.renderTri(p3, p4, p1);
        }
        if (tester.nearestDistance < topFaceDist) {
            tester.isOnTop = false;
        }
        if (surface == 1) {
            tester.isOnTop = true;
        }
    }

    public void renderTri(Vector3f p1, Vector3f p2, Vector3f p3) {
        Vector3f pos = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vector3f p1a = Vector3f.add(p1, pos, null);
        Vector3f p2a = Vector3f.add(p2, pos, null);
        Vector3f p3a = Vector3f.add(p3, pos, null);
        this.renderLine(p1a, p2a);
        this.renderLine(p2a, p3a);
        this.renderLine(p3a, p1a);
    }

    public void renderLine(Vector3f in, Vector3f out) {
        float dx = out.x - in.x;
        float dy = out.y - in.y;
        float dz = out.z - in.z;
        Vector3f diff = Vector3f.sub(out, in, null);
        diff.normalise();
        float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        for (int i = 0; i < 10; ++i) {
            float dist2 = distance / 10.0f * (float)i;
            Vector3f newVec = new Vector3f(in.x + dist2 * diff.x, in.y + dist2 * diff.y, in.z + dist2 * diff.z);
            FlansMod.proxy.spawnParticle("reddust", newVec.x, newVec.y, newVec.z, 0.0, 0.0, 0.0);
        }
    }

    public Vector3f collideWithDriveable(CollisionTest tester, Vector3f Pos2, Vector3f vel) {
        float unitScale = 0.0625f;
        float veryCloseDistance = 0.005f * unitScale;
        if (tester.collisionRecursiveDepth > 2) {
            return Pos2;
        }
        tester.basePoint = Pos2;
        tester.didCollide = false;
        if (this.getDriveableType().fancyCollision) {
            for (CollisionShapeBox sbox : this.getDriveableType().collisionBox) {
                this.checkCollision(tester, sbox);
            }
        } else {
            for (DriveablePart ppart : this.getDriveableData().parts.values()) {
                ppart.rayTraceRider(this, tester);
            }
        }
        tester.didCollide = false;
        if (false) {
            return Vector3f.add(Pos2, vel, null);
        }
        Vector3f destinationPoint = Vector3f.add(Pos2, vel, null);
        Vector3f newBasePoint = Pos2;
        if (tester.nearestDistance >= (double)veryCloseDistance) {
            vel.normalise();
            vel.scale((float)(tester.nearestDistance - (double)veryCloseDistance));
            newBasePoint = Vector3f.add(tester.basePoint, vel, null);
            if (vel.normalise().equals(new Vector3f(0.0f, 0.0f, 0.0f))) {
                return Vector3f.add(Pos2, vel, null);
            }
            vel.normalise();
            Vector3f.sub(tester.intersectionPoint, new Vector3f(vel.x * veryCloseDistance, vel.y * veryCloseDistance, vel.z * veryCloseDistance), tester.intersectionPoint);
        }
        Vector3f slidePlaneOrigin = tester.intersectionPoint;
        if (tester.intersectionPoint == null) {
            return Vector3f.add(Pos2, vel, null);
        }
        Vector3f slidePlaneNormal = Vector3f.sub(newBasePoint, tester.intersectionPoint, null);
        slidePlaneNormal.normalise();
        tester.collisionPlaneNormal = slidePlaneNormal;
        CollisionPlane plane = new CollisionPlane(slidePlaneOrigin, slidePlaneNormal);
        double sDV = plane.signedDistanceTo(destinationPoint);
        Vector3f scaledNormal = new Vector3f((double)slidePlaneNormal.x * sDV, (double)slidePlaneNormal.y * sDV, (double)slidePlaneNormal.z * sDV);
        Vector3f newDestPoint = Vector3f.sub(destinationPoint, scaledNormal, null);
        Vector3f newVelocityVector = Vector3f.sub(newDestPoint, tester.intersectionPoint, null);
        if (newVelocityVector.length() < veryCloseDistance) {
            return newBasePoint;
        }
        ++tester.collisionRecursiveDepth;
        return this.collideWithDriveable(tester, newBasePoint, newVelocityVector);
    }

    public void updateRiderPos(Entity rider, CollisionTest test, Vector3f pos, Vector3f motion) {
        boolean isDriveable = rider instanceof EntityDriveable;
        Vector3f vehicleMotion = this.lastPos;
        Vector3f riderMountPoint = new Vector3f(rider.field_70165_t - this.field_70165_t, rider.field_70163_u - this.field_70163_u, rider.field_70161_v - this.field_70161_v);
        float yawDiff = this.axes.getYaw() - this.prevAxes.getYaw();
        float pitchDiff = this.axes.getPitch() - this.prevAxes.getPitch();
        float rollDiff = this.axes.getRoll() - this.prevAxes.getRoll();
        RotatedAxes velAxes = new RotatedAxes(this.axes.getYaw() + yawDiff, this.axes.getPitch() + pitchDiff, this.axes.getRoll() + rollDiff);
        Vector3f currentLocalPos = this.axes.findGlobalVectorLocally(riderMountPoint);
        Vector3f nextGlobalPos = velAxes.findLocalVectorGlobally(currentLocalPos);
        Vector3f diff = new Vector3f(0.0f, 0.0f, 0.0f);
        if (nextGlobalPos == null) {
            nextGlobalPos = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        Vector3f.add(vehicleMotion, diff, diff);
        rider.func_70107_b((double)nextGlobalPos.x + this.field_70165_t + (this.hugeBoat ? (double)diff.x / 1.5 : 0.0), !isDriveable ? rider.field_70163_u : ((EntityDriveable)rider).deckHeight, (double)nextGlobalPos.z + this.field_70161_v + (this.hugeBoat ? (double)diff.z / 1.5 : 0.0));
        if (this.hugeBoat) {
            if (this.lastPos.x == 0.0f && this.lastPos.y == 0.0f && this.lastPos.z == 0.0f && rider.field_70181_x < 0.0) {
                rider.field_70181_x = 0.0;
            }
        } else if (this.lastPos.x != 0.0f || this.lastPos.y != 0.0f || this.lastPos.z != 0.0f) {
            rider.field_70159_w = diff.x;
            rider.field_70181_x = diff.y;
            rider.field_70179_y = diff.z;
        }
    }

    public ArrayList<BulletHit> attackFromBullet(Vector3f origin, Vector3f motion) {
        ArrayList<BulletHit> hits = new ArrayList<BulletHit>();
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            DriveableHit hit = part.rayTrace(this, rotatedPosVector, rotatedMotVector);
            if (hit == null) continue;
            hits.add(hit);
        }
        return hits;
    }

    public ArrayList<BulletHit> attackFromBulletButBetter(Vector3f origin, Vector3f motion, float size) {
        ArrayList<BulletHit> hits = new ArrayList<BulletHit>();
        Vector3f vehicleMotion = new Vector3f(this.field_70165_t - (double)this.lastPos.x, this.field_70163_u - (double)this.lastPos.y, this.field_70161_v - (double)this.lastPos.z);
        Vector3f vehiclePos = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vector3f relativePos = Vector3f.sub(origin, vehiclePos, null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePos);
        Vector3f rotatedMotionVector = this.axes.findGlobalVectorLocally(motion);
        Vector3f ellipsoid = new Vector3f(size, size, size);
        CollisionTest test = new CollisionTest(ellipsoid, new Vector3f(relativePos.x, relativePos.y, relativePos.z), motion);
        test.collisionRecursiveDepth = 0;
        Vector3f eSpacePosition = test.ConvertR3ToESpace(test.R3Position);
        Vector3f eSpaceVelocity = test.velocity;
        for (DriveablePart ppart : this.getDriveableData().parts.values()) {
            ppart.rayTraceRider(this, test);
        }
        if (test.didCollide) {
            Vector3f hitPos = new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f intersect2 = new Vector3f(test.ConvertESpaceToR3(test.intersectionPoint));
            Vector3f.sub(origin, intersect2, hitPos);
            float f = hitPos.length() / motion.length();
            DriveableHit hit = new DriveableHit(this, test.part, f);
            hits.add(hit);
        }
        return hits;
    }

    public float bulletHit(EntityBullet bullet, DriveableHit hit, float penetratingPower) {
        DriveablePart part = this.getDriveableData().parts.get((Object)hit.part);
        penetratingPower = bullet != null ? part.hitByBullet(bullet, hit, penetratingPower) : (penetratingPower -= 5.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.checkParts();
            FlansMod.getPacketHandler().sendToAllAround(new PacketDriveableDamage(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
        }
        return penetratingPower;
    }

    public DriveablePart raytraceParts(Vector3f origin, Vector3f motion) {
        Vector3f relativePosVector = Vector3f.sub(origin, new Vector3f((float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v), null);
        Vector3f rotatedPosVector = this.axes.findGlobalVectorLocally(relativePosVector);
        Vector3f rotatedMotVector = this.axes.findGlobalVectorLocally(motion);
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part.rayTrace(this, rotatedPosVector, rotatedMotVector) == null) continue;
            return part;
        }
        return null;
    }

    public boolean canHitPart(EnumDriveablePart part) {
        return true;
    }

    public void checkParts() {
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part == null || part.dead || !(part.health <= 0.0f) || !(part.maxHealth > 0.0f)) continue;
            this.killPart(part);
        }
        if (this.getDriveableData().parts.get((Object)((Object)EnumDriveablePart.core)).dead) {
            int seatNum = this.seats.length;
            DriveableType type = this.getDriveableType();
            if (!this.field_70170_p.field_72995_K) {
                for (EntitySeat seat : this.seats) {
                    if (!(seat.field_70153_n instanceof EntityPlayer)) continue;
                    Entity entity = seat.field_70153_n;
                    seat.field_70153_n.func_82142_c(false);
                    seat.field_70153_n.func_70078_a(null);
                    if (this.lastAtkEntity instanceof EntityPlayer) {
                        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.lastAtkEntity)), 1.0E7f);
                        continue;
                    }
                    if (!(this.lastAtkEntity instanceof EntityLivingBase)) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this.lastAtkEntity)), 1.0E7f);
                }
                if (type.isExplosionWhenDestroyed) {
                    new FlansModExplosion(this.field_70170_p, this, null, type, this.field_70165_t, this.field_70163_u, this.field_70161_v, type.deathExplosionRadius, type.deathExplosionPower, TeamsManager.explosions && type.deathExplosionBreaksBlocks, type.deathExplosionDamageVsLiving, type.deathExplosionDamageVsPlayer, type.deathExplosionDamageVsPlane, type.deathExplosionDamageVsVehicle, seatNum, seatNum, false);
                }
                if (!this.field_70170_p.field_72995_K && type.deathFireRadius > 0.1f) {
                    for (float i = -type.deathFireRadius; i < type.deathFireRadius; i += 1.0f) {
                        for (float j = -type.deathFireRadius; j < type.deathFireRadius; j += 1.0f) {
                            for (float k = -type.deathFireRadius; k < type.deathFireRadius; k += 1.0f) {
                                int x = MathHelper.func_76128_c((double)((double)i + this.field_70165_t));
                                int y = MathHelper.func_76128_c((double)((double)j + this.field_70163_u));
                                int z = MathHelper.func_76128_c((double)((double)k + this.field_70161_v));
                                if (!(i * i + j * j + k * k <= type.deathFireRadius * type.deathFireRadius) || this.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150350_a || !this.field_70146_Z.nextBoolean()) continue;
                                this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, 0, 3);
                            }
                        }
                    }
                }
                for (DriveablePart part : this.driveableData.parts.values()) {
                    if (!(part.health > 0.0f) || part.dead) continue;
                    this.killPart(part);
                }
            }
            this.func_70106_y();
            if (this.lastAtkEntity != null && this.lastAtkEntity instanceof EntityPlayerMP && TeamsManager.instance.currentRound != null) {
                TeamsManager.instance.currentRound.gametype.vehicleDestroyed(this, (EntityPlayerMP)this.lastAtkEntity);
            }
        }
    }

    public void checkPartsWhenAttacked() {
        for (DriveablePart part : this.getDriveableData().parts.values()) {
            if (part == null || part.dead || !(part.health <= 0.0f) || !(part.maxHealth > 0.0f)) continue;
            this.killPart(part);
        }
    }

    private void killPart(DriveablePart part) {
        if (part.dead) {
            return;
        }
        part.health = 0.0f;
        part.dead = true;
        DriveableType type = this.getDriveableType();
        if (!this.field_70170_p.field_72995_K) {
            ArrayList<ItemStack> drops;
            Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
            if (part.box != null) {
                pos = this.axes.findLocalVectorGlobally(new Vector3f(part.box.x / 16.0f + part.box.w / 32.0f, part.box.y / 16.0f + part.box.h / 32.0f, part.box.z / 16.0f + part.box.d / 32.0f));
            }
            if (type.partDeathExplosions.containsKey((Object)part.type)) {
                BoxExplosion exp = type.partDeathExplosions.get((Object)part.type);
                new FlansModExplosion(this.field_70170_p, this, null, type, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, exp.radius, exp.power, TeamsManager.explosions && exp.breaksBlocks, exp.damageVsLiving, exp.damageVsPlayer, exp.damageVsPlane, exp.damageVsVehicle, exp.particles, exp.particles, true);
            }
            if ((drops = type.getItemsRequired(part, this.getDriveableData().engine)) != null) {
                for (ItemStack stack : drops) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + (double)pos.x, this.field_70163_u + (double)pos.y, this.field_70161_v + (double)pos.z, stack.func_77946_l()));
                }
            }
            this.dropItemsOnPartDeath(pos, part);
            if (part.type == EnumDriveablePart.core) {
                for (int i = 0; i < this.getDriveableData().func_70302_i_(); ++i) {
                    ItemStack stack;
                    stack = this.getDriveableData().func_70301_a(i);
                    if (stack == null) continue;
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + this.field_70146_Z.nextGaussian(), this.field_70161_v + this.field_70146_Z.nextGaussian(), stack));
                }
            }
        }
        for (EnumDriveablePart child : part.type.getChildren()) {
            this.killPart(this.getDriveableData().parts.get((Object)child));
        }
    }

    protected abstract void dropItemsOnPartDeath(Vector3f var1, DriveablePart var2);

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    public void explode() {
    }

    @Override
    public float getCameraDistance() {
        return this.getDriveableType().cameraDistance;
    }

    public boolean isPartIntact(EnumDriveablePart part) {
        DriveablePart thisPart = this.getDriveableData().parts.get((Object)part);
        return thisPart.maxHealth == 0.0f || thisPart.health > 0.0f;
    }

    public boolean isPartExisting(EnumDriveablePart part) {
        return this.getDriveableData().parts.get((Object)((Object)part)).maxHealth != 0.0f;
    }

    public float getThrottleNerf() {
        int totalEngineRooms = 0;
        int deadEngineRooms = 0;
        int totalBoilerRooms = 0;
        int deadBoilerRooms = 0;
        for (EnumDriveablePart part : EnumDriveablePart.getEngineRooms()) {
            if (!this.isPartExisting(part)) continue;
            ++totalEngineRooms;
            if (this.isPartIntact(part)) continue;
            ++deadEngineRooms;
        }
        for (EnumDriveablePart part : EnumDriveablePart.getBoilerRooms()) {
            if (!this.isPartExisting(part)) continue;
            ++totalBoilerRooms;
            if (this.isPartIntact(part)) continue;
            ++deadBoilerRooms;
        }
        float engineNerf = totalEngineRooms > 0 ? (float)deadEngineRooms / (float)totalEngineRooms : 0.0f;
        float boilerNerf = totalBoilerRooms > 0 ? (float)deadBoilerRooms / (float)totalBoilerRooms : 0.0f;
        float overallNerf = Math.max(engineNerf, boilerNerf) * 0.8f;
        if (!this.isPartIntact(EnumDriveablePart.stern)) {
            overallNerf += 0.1f;
        }
        if (!this.isPartIntact(EnumDriveablePart.bow)) {
            overallNerf += 0.1f;
        }
        return overallNerf;
    }

    public abstract boolean hasMouseControlMode();

    public abstract String getBombInventoryName();

    public abstract String getMissileInventoryName();

    public boolean rotateWithTurret(Seat seat) {
        return seat.part == EnumDriveablePart.turret;
    }

    public String func_70005_c_() {
        return this.getDriveableType().name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showInventory(int seat) {
        return seat != 0 || !FlansModClient.controlModeMouse;
    }

    public float getShootDelay(boolean secondary) {
        return secondary ? this.shootDelaySecondary : this.shootDelayPrimary;
    }

    public boolean canLaunchIT1() {
        return this.canFireIT1;
    }

    public float getMinigunSpeed(boolean secondary) {
        return secondary ? this.minigunSpeedSecondary : this.minigunSpeedPrimary;
    }

    public int getCurrentGun(boolean secondary) {
        return secondary ? this.currentGunSecondary : this.currentGunPrimary;
    }

    public void setShootDelay(float i, boolean secondary) {
        this.setRecoilTimer();
        if (secondary) {
            this.shootDelaySecondary = i > this.shootDelaySecondary ? (this.shootDelaySecondary < 0.0f ? i + this.shootDelaySecondary : i) : this.shootDelaySecondary;
        } else {
            this.shootDelayPrimary = i > this.shootDelayPrimary ? (this.shootDelayPrimary < 0.0f ? i + this.shootDelayPrimary : i) : this.shootDelayPrimary;
        }
    }

    public void setMinigunSpeed(float f, boolean secondary) {
        if (secondary) {
            this.minigunSpeedSecondary = f;
        } else {
            this.minigunSpeedPrimary = f;
        }
    }

    public void setCurrentGun(int i, boolean secondary) {
        if (secondary) {
            this.currentGunSecondary = i;
        } else {
            this.currentGunPrimary = i;
        }
    }

    public void setEntityMarker(int tick) {
        this.isShowedPosition = true;
        this.tickCount = tick;
    }

    public void IT1Reload() {
        DriveableType type = this.getDriveableType();
        if (this.stage == 1) {
            this.drakonDoorAngle = this.moveToTarget(this.drakonDoorAngle, 0.0f, 5.0f);
            this.drakonArmAngle = this.moveToTarget(this.drakonArmAngle, 0.0f, 3.0f);
            this.drakonRailAngle = this.moveToTarget(this.drakonRailAngle, -10.0f, 5.0f);
            if (this.drakonRailAngle == -10.0f) {
                ++this.stage;
            }
        }
        if (this.stage == 2) {
            this.drakonDoorAngle = this.moveToTarget(this.drakonDoorAngle, -90.0f, 5.0f);
            this.drakonArmAngle = this.moveToTarget(this.drakonArmAngle, 0.0f, 3.0f);
            this.drakonRailAngle = this.moveToTarget(this.drakonRailAngle, -10.0f, 1.0f);
            if (this.drakonDoorAngle == -90.0f) {
                ++this.stage;
            }
        }
        if (this.stage == 3) {
            this.drakonDoorAngle = this.moveToTarget(this.drakonDoorAngle, -90.0f, 5.0f);
            this.drakonArmAngle = this.moveToTarget(this.drakonArmAngle, 179.0f, 3.0f);
            this.drakonRailAngle = this.moveToTarget(this.drakonRailAngle, -10.0f, 1.0f);
            if (this.drakonArmAngle == 179.0f) {
                ++this.stage;
            }
        }
        if (this.stage == 4) {
            this.drakonDoorAngle = this.moveToTarget(this.drakonDoorAngle, 0.0f, 10.0f);
            this.drakonArmAngle = this.moveToTarget(this.drakonArmAngle, 180.0f, 3.0f);
            this.drakonRailAngle = this.moveToTarget(this.drakonRailAngle, -10.0f, 1.0f);
            if (this.drakonDoorAngle == 0.0f && this.IT1Loaded()) {
                ++this.stage;
                this.reloadAnimTime = 60;
            }
        }
        if (this.stage == 5) {
            this.drakonDoorAngle = this.moveToTarget(this.drakonDoorAngle, -90.0f, 10.0f);
            this.drakonArmAngle = this.moveToTarget(this.drakonArmAngle, 180.0f, 3.0f);
            this.drakonRailAngle = this.moveToTarget(this.drakonRailAngle, -10.0f, 1.0f);
            this.reloadingDrakon = true;
            if (this.drakonDoorAngle == -90.0f) {
                ++this.stage;
            }
        }
        if (this.stage == 6) {
            this.drakonDoorAngle = this.moveToTarget(this.drakonDoorAngle, -90.0f, 5.0f);
            this.drakonArmAngle = this.moveToTarget(this.drakonArmAngle, 0.0f, 3.0f);
            this.drakonRailAngle = this.moveToTarget(this.drakonRailAngle, -10.0f, 1.0f);
            if (this.drakonArmAngle == 0.0f) {
                ++this.stage;
            }
        }
        if (this.stage == 7) {
            this.drakonDoorAngle = this.moveToTarget(this.drakonDoorAngle, 0.0f, 10.0f);
            this.drakonArmAngle = this.moveToTarget(this.drakonArmAngle, 0.0f, 3.0f);
            this.drakonRailAngle = this.moveToTarget(this.drakonRailAngle, 0.0f, 1.0f);
            if (this.drakonRailAngle == 0.0f && this.drakonDoorAngle == 0.0f) {
                ++this.stage;
                this.canFireIT1 = true;
                this.reloadingDrakon = false;
            }
        }
        if (this.stage == 8) {
            this.drakonDoorAngle = this.moveToTarget(this.drakonDoorAngle, 0.0f, 10.0f);
            this.drakonArmAngle = this.moveToTarget(this.drakonArmAngle, 0.0f, 3.0f);
            if (this.field_70170_p.field_72995_K && this.field_70173_aa > 2) {
                this.drakonRailAngle = this.moveToTarget(this.drakonRailAngle, -this.seats[0].looking.getPitch(), this.seats[0].seatInfo.aimingSpeed.y);
            }
            if (!this.IT1Loaded()) {
                this.stage = 1;
                this.canFireIT1 = false;
            }
        }
    }

    public float moveToTarget(float current, float target, float speed) {
        float pitchToMove;
        for (pitchToMove = (float)(Math.sqrt(target * target) - Math.sqrt(current * current)); pitchToMove > 180.0f; pitchToMove -= 360.0f) {
        }
        while (pitchToMove <= -180.0f) {
            pitchToMove += 360.0f;
        }
        float signDeltaY = 0.0f;
        if (pitchToMove > speed) {
            signDeltaY = 1.0f;
        } else if (pitchToMove < -speed) {
            signDeltaY = -1.0f;
        } else {
            signDeltaY = 0.0f;
            return target;
        }
        if (current > target) {
            current -= speed;
        } else if (current < target) {
            current += speed;
        }
        return current;
    }

    public boolean IT1Loaded() {
        DriveableType type = this.getDriveableType();
        boolean loaded = false;
        for (int i = this.driveableData.getMissileInventoryStart(); i < this.driveableData.getMissileInventoryStart() + type.numMissileSlots; ++i) {
            ItemStack shell = this.driveableData.func_70301_a(i);
            if (shell == null || !(shell.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)shell.func_77973_b()).type, EnumWeaponType.MISSILE)) continue;
            loaded = true;
        }
        return loaded;
    }

    public void tryRecoil() {
        int slot = -1;
        DriveableType type = this.getDriveableType();
        for (int i = this.driveableData.getMissileInventoryStart(); i < this.driveableData.getMissileInventoryStart() + type.numMissileSlots; ++i) {
            ItemStack shell = this.driveableData.func_70301_a(i);
            if (shell == null || !(shell.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)shell.func_77973_b()).type, EnumWeaponType.SHELL)) continue;
            slot = i;
        }
        if (this.recoilTimer <= 0 && slot != -1) {
            this.isRecoil = true;
        }
    }

    public void setRecoilTimer() {
        int slot = -1;
        DriveableType type = this.getDriveableType();
        for (int i = this.driveableData.getMissileInventoryStart(); i < this.driveableData.getMissileInventoryStart() + type.numMissileSlots; ++i) {
            ItemStack shell = this.driveableData.func_70301_a(i);
            if (shell == null || !(shell.func_77973_b() instanceof ItemBullet) || !type.isValidAmmo(((ItemBullet)shell.func_77973_b()).type, EnumWeaponType.SHELL)) continue;
            slot = i;
        }
        if (this.recoilTimer <= 0 && slot != -1) {
            this.recoilTimer = (int)this.getDriveableType().shootDelayPrimary;
        }
    }

    public boolean func_70112_a(double d) {
        double d1 = this.field_70155_l;
        return d < d1 * d1;
    }

    public boolean isUnderWater() {
        return this.field_70170_p.func_72953_d(this.field_70121_D.func_72329_c().func_72317_d(0.0, (double)this.getDriveableType().maxDepth, 0.0));
    }
}

