/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.KeyInputHandler;
import com.flansmod.client.TickHandlerClient;
import com.flansmod.client.TileEntitySpawnerRenderer;
import com.flansmod.client.debug.EntityDebugAABB;
import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.client.debug.RenderDebugAABB;
import com.flansmod.client.debug.RenderDebugDot;
import com.flansmod.client.debug.RenderDebugVector;
import com.flansmod.client.gui.GuiArmourBox;
import com.flansmod.client.gui.GuiDriveableCrafting;
import com.flansmod.client.gui.GuiDriveableFuel;
import com.flansmod.client.gui.GuiDriveableInventory;
import com.flansmod.client.gui.GuiDriveableMenu;
import com.flansmod.client.gui.GuiDriveableRepair;
import com.flansmod.client.gui.GuiGunBox;
import com.flansmod.client.gui.GuiGunModTable;
import com.flansmod.client.gui.GuiMechaInventory;
import com.flansmod.client.gui.GuiPaintjobTable;
import com.flansmod.client.model.RenderAAGun;
import com.flansmod.client.model.RenderBullet;
import com.flansmod.client.model.RenderFlag;
import com.flansmod.client.model.RenderFlagpole;
import com.flansmod.client.model.RenderGrenade;
import com.flansmod.client.model.RenderGun;
import com.flansmod.client.model.RenderMG;
import com.flansmod.client.model.RenderMecha;
import com.flansmod.client.model.RenderNull;
import com.flansmod.client.model.RenderParachute;
import com.flansmod.client.model.RenderPlane;
import com.flansmod.client.model.RenderVehicle;
import com.flansmod.client.particle.EntityAfterburn;
import com.flansmod.client.particle.EntityBigSmoke;
import com.flansmod.client.particle.EntityDebris1;
import com.flansmod.client.particle.EntityFMFlame;
import com.flansmod.client.particle.EntityFMMuzzleFlash;
import com.flansmod.client.particle.EntityFMSmoke;
import com.flansmod.client.particle.EntityFMTracer;
import com.flansmod.client.particle.EntityFMTracerGreen;
import com.flansmod.client.particle.EntityFMTracerRed;
import com.flansmod.client.particle.EntityFlare;
import com.flansmod.client.particle.EntityFlash;
import com.flansmod.client.particle.EntityRocketexhaust;
import com.flansmod.client.particle.EntitySmokeBurst;
import com.flansmod.client.particle.EntitySmokeGrenade;
import com.flansmod.common.CommonProxy;
import com.flansmod.common.ContentManager;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.EntityAAGun;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.network.PacketBuyArmour;
import com.flansmod.common.network.PacketBuyWeapon;
import com.flansmod.common.network.PacketCraftDriveable;
import com.flansmod.common.network.PacketGiveItem;
import com.flansmod.common.network.PacketRepairDriveable;
import com.flansmod.common.paintjob.TileEntityPaintjobTable;
import com.flansmod.common.teams.ArmourBoxType;
import com.flansmod.common.teams.BlockArmourBox;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.TileEntitySpawner;
import com.flansmod.common.tools.EntityParachute;
import com.flansmod.common.types.InfoType;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.discovery.ModCandidate;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityAuraFX;
import net.minecraft.client.particle.EntityBlockDustFX;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityBubbleFX;
import net.minecraft.client.particle.EntityCloudFX;
import net.minecraft.client.particle.EntityCritFX;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityDropParticleFX;
import net.minecraft.client.particle.EntityEnchantmentTableParticleFX;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkSparkFX;
import net.minecraft.client.particle.EntityFishWakeFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntityFootStepFX;
import net.minecraft.client.particle.EntityHeartFX;
import net.minecraft.client.particle.EntityHugeExplodeFX;
import net.minecraft.client.particle.EntityLargeExplodeFX;
import net.minecraft.client.particle.EntityLavaFX;
import net.minecraft.client.particle.EntityNoteFX;
import net.minecraft.client.particle.EntityPortalFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.particle.EntitySnowShovelFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.client.particle.EntitySplashFX;
import net.minecraft.client.particle.EntitySuspendFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientProxy
extends CommonProxy {
    public static String modelDir = "com.flansmod.client.model.";
    public static RenderGun gunRenderer;
    public static RenderGrenade grenadeRenderer;
    public static RenderPlane planeRenderer;
    public static RenderVehicle vehicleRenderer;
    public static RenderMecha mechaRenderer;
    public List<File> contentPacks;

    @Override
    public void load() {
        new FlansModClient().load();
        gunRenderer = new RenderGun();
        grenadeRenderer = new RenderGrenade();
        planeRenderer = new RenderPlane();
        vehicleRenderer = new RenderVehicle();
        mechaRenderer = new RenderMecha();
        for (GunType gunType : GunType.guns.values()) {
            MinecraftForgeClient.registerItemRenderer((Item)gunType.item, (IItemRenderer)gunRenderer);
        }
        for (GrenadeType grenadeType : GrenadeType.grenades) {
            MinecraftForgeClient.registerItemRenderer((Item)grenadeType.item, (IItemRenderer)grenadeRenderer);
        }
        for (PlaneType planeType : PlaneType.types) {
            MinecraftForgeClient.registerItemRenderer((Item)planeType.item, (IItemRenderer)planeRenderer);
        }
        for (VehicleType vehicleType : VehicleType.types) {
            MinecraftForgeClient.registerItemRenderer((Item)vehicleType.item, (IItemRenderer)vehicleRenderer);
        }
        for (MechaType mechaType : MechaType.types) {
            MinecraftForgeClient.registerItemRenderer((Item)mechaType.item, (IItemRenderer)mechaRenderer);
        }
        FMLCommonHandler.instance().bus().register((Object)new KeyInputHandler());
        new TickHandlerClient();
    }

    @Override
    public void forceReload() {
        Minecraft.func_71410_x().func_110436_a();
    }

    @Override
    public List<File> getContentList(Method method, ClassLoader classloader) {
        this.contentPacks = new ArrayList<File>();
        File[] files = FlansMod.flanDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() && !ContentManager.zipJar.matcher(file.getName()).matches()) continue;
                try {
                    method.invoke((Object)classloader, file.toURI().toURL());
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("modid", "FlansMod");
                    map.put("name", "Flan's Mod : " + file.getName());
                    map.put("version", "1");
                    FMLModContainer container = new FMLModContainer("com.flansmod.common.FlansMod", new ModCandidate(file, file, file.isDirectory() ? ContainerType.DIR : ContainerType.JAR), map);
                    container.bindMetadata(MetadataCollection.from(null, (String)""));
                    FMLClientHandler.instance().addModAsResource((ModContainer)container);
                }
                catch (Exception e) {
                    FlansMod.log("Failed to register content pack : " + file.getName());
                    e.printStackTrace();
                }
                FlansMod.log("Loaded content pack: " + file.getName());
                this.contentPacks.add(file);
            }
        }
        FlansMod.log("Loaded textures and models.");
        return this.contentPacks;
    }

    @Override
    public void loadFlanAssets() {
        Method method;
        ClassLoader classloader = MinecraftServer.class.getClassLoader();
        try {
            method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            FlansMod.logger.error("Failed to get class loader. All content loading will now fail.", (Throwable)e);
            return;
        }
        for (File file : Objects.requireNonNull(FlansMod.flanDir.listFiles())) {
            if (!file.isDirectory() && !ContentManager.zipJar.matcher(file.getName()).matches()) continue;
            try {
                method.invoke((Object)classloader, file.toURI().toURL());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("modid", "flansmod");
                map.put("name", "Flan's Mod : " + file.getName());
                map.put("version", "1");
                FMLModContainer container = new FMLModContainer(FlansMod.class.getCanonicalName(), new ModCandidate(file, file, file.isDirectory() ? ContainerType.DIR : ContainerType.JAR), map);
                container.bindMetadata(MetadataCollection.from(null, (String)""));
                FMLClientHandler.instance().addModAsResource((ModContainer)container);
            }
            catch (Exception e) {
                FlansMod.logger.error("Failed to load images for content pack : " + file.getName(), (Throwable)e);
            }
            FlansMod.logger.info("Loaded content pack : " + file.getName());
        }
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBullet.class, (Render)new RenderBullet());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (Render)new RenderGrenade());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlane.class, (Render)new RenderPlane());
        RenderingRegistry.registerEntityRenderingHandler(EntityVehicle.class, (Render)new RenderVehicle());
        RenderingRegistry.registerEntityRenderingHandler(EntityAAGun.class, (Render)new RenderAAGun());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlagpole.class, (Render)new RenderFlagpole());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlag.class, (Render)new RenderFlag());
        RenderingRegistry.registerEntityRenderingHandler(EntitySeat.class, (Render)new RenderNull());
        RenderingRegistry.registerEntityRenderingHandler(EntityWheel.class, (Render)new RenderNull());
        RenderingRegistry.registerEntityRenderingHandler(EntityMG.class, (Render)new RenderMG());
        RenderingRegistry.registerEntityRenderingHandler(EntityParachute.class, (Render)new RenderParachute());
        RenderingRegistry.registerEntityRenderingHandler(EntityDebugDot.class, (Render)new RenderDebugDot());
        RenderingRegistry.registerEntityRenderingHandler(EntityDebugVector.class, (Render)new RenderDebugVector());
        RenderingRegistry.registerEntityRenderingHandler(EntityDebugAABB.class, (Render)new RenderDebugAABB());
        RenderingRegistry.registerEntityRenderingHandler(EntityMecha.class, (Render)new RenderMecha());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySpawner.class, (TileEntitySpecialRenderer)new TileEntitySpawnerRenderer());
    }

    @Override
    public void doTutorialStuff(EntityPlayer player, EntityDriveable entityType) {
        if (!FlansModClient.doneTutorial) {
            FlansModClient.doneTutorial = true;
            player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.inventoryKey.func_151463_i()) + " to open the menu"));
            if (Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i() >= 0 && Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i() < 256) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i()) + " to get out"));
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText("Press <undefined> to get out"));
            }
            player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.controlSwitchKey.func_151463_i()) + " to switch controls"));
            if (entityType instanceof EntityPlane) {
                PlaneType type = PlaneType.getPlane(entityType.driveableType);
                Objects.requireNonNull(type, "Could not retrieve plane type!");
                if (type.hasGear) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.gearKey.func_151463_i()) + " to switch the gear"));
                }
                if (type.hasDoor) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.doorKey.func_151463_i()) + " to switch the doors"));
                }
                if (type.mode == EnumPlaneMode.VTOL) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.modeKey.func_151463_i()) + " to switch VTOL mode"));
                }
                if (type.hasWing) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Press " + Keyboard.getKeyName((int)KeyInputHandler.modeKey.func_151463_i()) + " to switch the wings"));
                }
            }
        }
    }

    @Override
    public void changeControlMode(EntityPlayer player) {
        if (FlansModClient.flipControlMode()) {
            player.func_146105_b((IChatComponent)new ChatComponentText("Mouse Control mode is now set to " + FlansModClient.controlModeMouse));
        }
    }

    @Override
    public boolean mouseControlEnabled() {
        return FlansModClient.controlModeMouse;
    }

    @Override
    public Object getClientGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if ((ID >= 6 && ID <= 10 || ID == 12) && player.field_70154_o == null) {
            return null;
        }
        switch (ID) {
            case 0: {
                return new GuiDriveableCrafting(player.field_71071_by, world, x, y, z);
            }
            case 1: {
                return new GuiDriveableRepair(player);
            }
            case 2: {
                return new GuiGunModTable(player.field_71071_by, world);
            }
            case 5: {
                return new GuiGunBox(player.field_71071_by, ((BlockGunBox)world.func_147439_a((int)x, (int)y, (int)z)).type, world);
            }
            case 6: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 0);
            }
            case 7: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 1);
            }
            case 8: {
                return new GuiDriveableFuel(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable);
            }
            case 9: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 2);
            }
            case 10: {
                return new GuiMechaInventory(player.field_71071_by, world, (EntityMecha)((EntitySeat)player.field_70154_o).driveable);
            }
            case 11: {
                return new GuiArmourBox(player.field_71071_by, ((BlockArmourBox)world.func_147439_a((int)x, (int)y, (int)z)).type);
            }
            case 12: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.field_70154_o).driveable, 3);
            }
            case 13: {
                return new GuiPaintjobTable(player.field_71071_by, world, (TileEntityPaintjobTable)world.func_147438_o(x, y, z));
            }
        }
        return null;
    }

    @Override
    public void openDriveableMenu(EntityPlayer player, World world, EntityDriveable driveable) {
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiDriveableMenu(player.field_71071_by, world, driveable));
    }

    private String getModelName(String in) {
        String[] split = in.split("\\.");
        if (split.length == 1) {
            return "com.flansmod.client.model.Model" + in;
        }
        if (split.length > 1) {
            if (FlansMod.getModelLocation(split[0]) != null) {
                StringBuilder location = new StringBuilder(FlansMod.getModelLocation(split[0]));
                for (int i = 1; i < split.length - 1; ++i) {
                    location.append(split[i]);
                }
                return location + ".Model" + split[1];
            }
            StringBuilder out = new StringBuilder("Model" + split[split.length - 1]);
            for (int i = split.length - 2; i >= 0; --i) {
                out.insert(0, split[i] + ".");
            }
            return modelDir + out;
        }
        return in;
    }

    @Override
    public <T> T loadModel(String s, String shortName, Class<T> typeClass) {
        if (s == null || s.equalsIgnoreCase("None") || shortName == null) {
            return null;
        }
        try {
            return typeClass.cast(Class.forName(this.getModelName(s)).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (InvocationTargetException ex) {
            FlansMod.logPackError("?", "?", shortName, "Model is incompatible, or you are in a dev environment", null, ex.getCause());
        }
        catch (ClassNotFoundException ex) {
            FlansMod.logPackError("?", "?", shortName, "Model (probably) not found", null, ex);
        }
        catch (Exception ex) {
            FlansMod.logPackError("?", "?", shortName, "Failed to load model (unknown cause)", null, ex);
        }
        return null;
    }

    @Override
    public void loadSound(String contentPack, String type, String sound) {
        FlansModResourceHandler.getSound(sound);
    }

    @Override
    public boolean isThePlayer(EntityPlayer player) {
        return player == FMLClientHandler.instance().getClient().field_71439_g;
    }

    @Override
    public EntityPlayer getThePlayer() {
        return FMLClientHandler.instance().getClient().field_71439_g;
    }

    @Override
    public boolean isOnSameTeamClientPlayer(EntityLivingBase entity) {
        return FMLClientHandler.instance().getClient().field_71439_g.func_142014_c(entity);
    }

    @Override
    public void buyGun(GunBoxType type, InfoType gun) {
        FlansMod.getPacketHandler().sendToServer(new PacketBuyWeapon(type, gun));
        FlansModClient.shootTimeLeft += 10.0f;
        FlansModClient.shootTimeRight += 10.0f;
    }

    @Override
    public void buyArmour(String shortName, int piece, ArmourBoxType box) {
        FlansMod.getPacketHandler().sendToServer(new PacketBuyArmour(box.shortName, shortName, piece));
        FlansModClient.shootTimeLeft += 10.0f;
        FlansModClient.shootTimeRight += 10.0f;
    }

    @Override
    public void addItem(EntityPlayer player, int id) {
        super.addItem(player, id);
        if (player.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketGiveItem(57));
        }
    }

    @Override
    public void craftDriveable(EntityPlayer player, DriveableType type) {
        super.craftDriveable(player, type);
        if (player.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketCraftDriveable(type.shortName));
        }
    }

    @Override
    public void repairDriveable(EntityPlayer driver, EntityDriveable driving, DriveablePart part) {
        super.repairDriveable(driver, driving, part);
        if (driver.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketRepairDriveable(part.type));
        }
    }

    @Override
    public boolean isScreenOpen() {
        return Minecraft.func_71410_x().field_71462_r != null;
    }

    @Override
    public boolean isKeyDown(int key) {
        switch (key) {
            case 0: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151463_i());
            }
            case 1: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151463_i());
            }
            case 2: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151463_i());
            }
            case 3: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151463_i());
            }
            case 4: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i());
            }
        }
        return false;
    }

    @Override
    public boolean keyDown(int keyCode) {
        return keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
    }

    @Override
    public void spawnParticle(String s, double x, double y, double z, double mx, double my, double mz) {
        this.spawnParticle(s, x, y, z, mx, my, mz, 1.0f);
    }

    @Override
    public void spawnParticle(String s, double x, double y, double z, double mx, double my, double mz, float scale) {
        try {
            ClientProxy.doSpawnParticle(s, x, y, z, mx, my, mz, scale);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static EntityFX doSpawnParticle(String particleType, double x, double y, double z, double vx, double vy, double vz, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient theWorld = mc.field_71441_e;
        if (mc.field_71451_h != null && mc.field_71452_i != null) {
            int i = mc.field_71474_y.field_74362_aa;
            if (i == 1 && theWorld.field_73012_v.nextInt(3) == 0) {
                i = 2;
            }
            double d6 = mc.field_71451_h.field_70165_t - x;
            double d7 = mc.field_71451_h.field_70163_u - y;
            double d8 = mc.field_71451_h.field_70161_v - z;
            Object entityfx = null;
            if (particleType.equals("hugeexplosion")) {
                entityfx = new EntityHugeExplodeFX((World)theWorld, x, y, z, vx, vy, vz);
                mc.field_71452_i.func_78873_a((EntityFX)entityfx);
            } else if (particleType.equals("largeexplode")) {
                entityfx = new EntityLargeExplodeFX(mc.field_71446_o, (World)theWorld, x, y, z, vx, vy, vz);
                mc.field_71452_i.func_78873_a((EntityFX)entityfx);
            } else if (particleType.equals("fireworksSpark")) {
                entityfx = new EntityFireworkSparkFX((World)theWorld, x, y, z, vx, vy, vz, mc.field_71452_i);
                mc.field_71452_i.func_78873_a((EntityFX)entityfx);
            }
            if (entityfx != null) {
                return entityfx;
            }
            double d9 = 160.0;
            if (d6 * d6 + d7 * d7 + d8 * d8 > d9 * d9) {
                return null;
            }
            if (i > 1) {
                return null;
            }
            if (particleType.equals("flansmod.flare")) {
                entityfx = new EntityFlare((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.smoker")) {
                entityfx = new EntitySmokeGrenade((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.flash")) {
                entityfx = new EntityFlash((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.smokeburst")) {
                entityfx = new EntitySmokeBurst((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.bigsmoke")) {
                entityfx = new EntityBigSmoke((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.debris1")) {
                entityfx = new EntityDebris1((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.fmflame")) {
                entityfx = new EntityFMFlame((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.fmtracer")) {
                entityfx = new EntityFMTracer((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.fmtracergreen")) {
                entityfx = new EntityFMTracerGreen((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.fmtracerred")) {
                entityfx = new EntityFMTracerRed((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.muzzleflash")) {
                entityfx = new EntityFMMuzzleFlash((World)theWorld, x, y, z, vx, vy, vz);
                entityfx.func_70541_f(scale);
            } else if (particleType.equals("flansmod.afterburn")) {
                entityfx = new EntityAfterburn((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.fmsmoke")) {
                entityfx = new EntityFMSmoke((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flansmod.rocketexhaust")) {
                entityfx = new EntityRocketexhaust((World)theWorld, x, y, z, vx, vy, vz);
            }
            if (particleType.equals("bubble")) {
                entityfx = new EntityBubbleFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("suspended")) {
                entityfx = new EntitySuspendFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("depthsuspend")) {
                entityfx = new EntityAuraFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("townaura")) {
                entityfx = new EntityAuraFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("crit")) {
                entityfx = new EntityCritFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("magicCrit")) {
                entityfx = new EntityCritFX((World)theWorld, x, y, z, vx, vy, vz);
                entityfx.func_70538_b(entityfx.func_70534_d() * 0.3f, entityfx.func_70542_f() * 0.8f, entityfx.func_70535_g());
                entityfx.func_94053_h();
            } else if (particleType.equals("smoke")) {
                entityfx = new EntitySmokeFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("mobSpell")) {
                entityfx = new EntitySpellParticleFX((World)theWorld, x, y, z, 0.0, 0.0, 0.0);
                entityfx.func_70538_b((float)vx, (float)vy, (float)vz);
            } else if (particleType.equals("mobSpellAmbient")) {
                entityfx = new EntitySpellParticleFX((World)theWorld, x, y, z, 0.0, 0.0, 0.0);
                entityfx.func_82338_g(0.15f);
                entityfx.func_70538_b((float)vx, (float)vy, (float)vz);
            } else if (particleType.equals("spell")) {
                entityfx = new EntitySpellParticleFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("instantSpell")) {
                entityfx = new EntitySpellParticleFX((World)theWorld, x, y, z, vx, vy, vz);
                ((EntitySpellParticleFX)entityfx).func_70589_b(144);
            } else if (particleType.equals("witchMagic")) {
                entityfx = new EntitySpellParticleFX((World)theWorld, x, y, z, vx, vy, vz);
                ((EntitySpellParticleFX)entityfx).func_70589_b(144);
                float f = theWorld.field_73012_v.nextFloat() * 0.5f + 0.35f;
                entityfx.func_70538_b(f, 0.0f, f);
            } else if (particleType.equals("note")) {
                entityfx = new EntityNoteFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("portal")) {
                entityfx = new EntityPortalFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("enchantmenttable")) {
                entityfx = new EntityEnchantmentTableParticleFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("explode")) {
                entityfx = new EntityExplodeFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("flame")) {
                entityfx = new EntityFlameFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("lava")) {
                entityfx = new EntityLavaFX((World)theWorld, x, y, z);
            } else if (particleType.equals("footstep")) {
                entityfx = new EntityFootStepFX(mc.field_71446_o, (World)theWorld, x, y, z);
            } else if (particleType.equals("splash")) {
                entityfx = new EntitySplashFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("wake")) {
                entityfx = new EntityFishWakeFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("largesmoke")) {
                entityfx = new EntitySmokeFX((World)theWorld, x, y, z, vx, vy, vz, 2.5f);
            } else if (particleType.equals("cloud")) {
                entityfx = new EntityCloudFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("reddust")) {
                entityfx = new EntityReddustFX((World)theWorld, x, y, z, (float)vx, (float)vy, (float)vz);
            } else if (particleType.equals("snowballpoof")) {
                entityfx = new EntityBreakingFX((World)theWorld, x, y, z, Items.field_151126_ay);
            } else if (particleType.equals("dripWater")) {
                entityfx = new EntityDropParticleFX((World)theWorld, x, y, z, Material.field_151586_h);
            } else if (particleType.equals("dripLava")) {
                entityfx = new EntityDropParticleFX((World)theWorld, x, y, z, Material.field_151587_i);
            } else if (particleType.equals("snowshovel")) {
                entityfx = new EntitySnowShovelFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("slime")) {
                entityfx = new EntityBreakingFX((World)theWorld, x, y, z, Items.field_151123_aH);
            } else if (particleType.equals("heart")) {
                entityfx = new EntityHeartFX((World)theWorld, x, y, z, vx, vy, vz);
            } else if (particleType.equals("angryVillager")) {
                entityfx = new EntityHeartFX((World)theWorld, x, y + 0.5, z, vx, vy, vz);
                entityfx.func_70536_a(81);
                entityfx.func_70538_b(1.0f, 1.0f, 1.0f);
            } else if (particleType.equals("happyVillager")) {
                entityfx = new EntityAuraFX((World)theWorld, x, y, z, vx, vy, vz);
                entityfx.func_70536_a(82);
                entityfx.func_70538_b(1.0f, 1.0f, 1.0f);
            } else if (particleType.startsWith("iconcrack_")) {
                String[] astring = particleType.split("_", 3);
                int j = Integer.parseInt(astring[1]);
                if (astring.length > 2) {
                    int k = Integer.parseInt(astring[2]);
                    entityfx = new EntityBreakingFX((World)theWorld, x, y, z, vx, vy, vz, Item.func_150899_d((int)j), k);
                } else {
                    entityfx = new EntityBreakingFX((World)theWorld, x, y, z, vx, vy, vz, Item.func_150899_d((int)j), 0);
                }
            } else if (particleType.startsWith("blockcrack_")) {
                String[] astring = particleType.split("_", 3);
                Block block = Block.func_149729_e((int)Integer.parseInt(astring[1]));
                int k = Integer.parseInt(astring[2]);
                entityfx = new EntityDiggingFX((World)theWorld, x, y, z, vx, vy, vz, block, k).func_90019_g(k);
            } else if (particleType.startsWith("blockdust_")) {
                String[] astring = particleType.split("_", 3);
                Block block = Block.func_149729_e((int)Integer.parseInt(astring[1]));
                int k = Integer.parseInt(astring[2]);
                entityfx = new EntityBlockDustFX((World)theWorld, x, y, z, vx, vy, vz, block, k).func_90019_g(k);
            }
            if (entityfx != null) {
                entityfx.func_70541_f(scale);
                mc.field_71452_i.func_78873_a((EntityFX)entityfx);
            }
            return entityfx;
        }
        return null;
    }

    @Override
    public float getMouseSensitivity() {
        return Minecraft.func_71410_x().field_71474_y.field_74341_c;
    }
}

