/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.GuiNpcMobSpawnerSelector;
import noppes.npcs.client.gui.SubGuiNpcBiomes;
import noppes.npcs.client.gui.SubGuiSpawningOptions;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNpcNaturalSpawns
extends GuiNPCInterface2
implements IGuiData,
IScrollData,
ITextfieldListener,
ICustomScrollListener,
ISliderListener {
    private GuiCustomScroll scroll;
    private HashMap<String, Integer> data = new HashMap();
    private SpawnData spawn = new SpawnData();
    private int slotSelected;

    public GuiNpcNaturalSpawns(EntityNPCInterface npc) {
        super(npc);
        Client.sendData(EnumPacketServer.NaturalSpawnGetAll, new Object[0]);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(143, 208);
        }
        this.scroll.guiLeft = this.guiLeft + 214;
        this.scroll.guiTop = this.guiTop + 4;
        this.addScroll(this.scroll);
        this.addButton(new GuiNpcButton(1, this.guiLeft + 358, this.guiTop + 38, 58, 20, "gui.add"));
        this.addButton(new GuiNpcButton(2, this.guiLeft + 358, this.guiTop + 61, 58, 20, "gui.remove"));
        if (this.spawn.id >= 0) {
            this.showSpawn();
        }
    }

    private void showSpawn() {
        this.addLabel(new GuiNpcLabel(1, "gui.title", this.guiLeft + 4, this.guiTop + 8));
        this.addTextField(new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 60, this.guiTop + 3, 140, 20, this.spawn.name));
        int y = this.guiTop + 30;
        this.addLabel(new GuiNpcLabel(3, "spawning.biomes", this.guiLeft + 4, y));
        this.addButton(new GuiNpcButton(3, this.guiLeft + 120, y - 5, 50, 20, "selectServer.edit"));
        this.addLabel(new GuiNpcLabel(4, "spawning.options", this.guiLeft + 4, y += 22));
        this.addButton(new GuiNpcButton(4, this.guiLeft + 120, y - 5, 50, 20, "selectServer.edit"));
        this.addSlider(new GuiNpcSlider(this, 5, this.guiLeft + 4, y += 17, 180, 20, (float)this.spawn.field_76292_a / 100.0f));
        this.addButton(new GuiNpcButton(25, this.guiLeft + 14, y += 23, 20, 20, "X"));
        this.addLabel(new GuiNpcLabel(6, "1:", this.guiLeft + 4, y + 5));
        this.addButton(new GuiNpcButton(6, this.guiLeft + 36, y, 170, 20, this.getTitle(this.spawn.compound1)));
        this.addButton(new GuiNpcButton(26, this.guiLeft + 14, y += 22, 20, 20, "X"));
        this.addLabel(new GuiNpcLabel(7, "2:", this.guiLeft + 4, y + 5));
        this.addButton(new GuiNpcButton(7, this.guiLeft + 36, y, 170, 20, this.getTitle(this.spawn.compound2)));
        this.addButton(new GuiNpcButton(27, this.guiLeft + 14, y += 22, 20, 20, "X"));
        this.addLabel(new GuiNpcLabel(8, "3:", this.guiLeft + 4, y + 5));
        this.addButton(new GuiNpcButton(8, this.guiLeft + 36, y, 170, 20, this.getTitle(this.spawn.compound3)));
        this.addButton(new GuiNpcButton(28, this.guiLeft + 14, y += 22, 20, 20, "X"));
        this.addLabel(new GuiNpcLabel(9, "4:", this.guiLeft + 4, y + 5));
        this.addButton(new GuiNpcButton(9, this.guiLeft + 36, y, 170, 20, this.getTitle(this.spawn.compound4)));
        this.addButton(new GuiNpcButton(29, this.guiLeft + 14, y += 22, 20, 20, "X"));
        this.addLabel(new GuiNpcLabel(10, "5:", this.guiLeft + 4, y + 5));
        this.addButton(new GuiNpcButton(10, this.guiLeft + 36, y, 170, 20, this.getTitle(this.spawn.compound5)));
    }

    private String getTitle(NBTTagCompound compound) {
        if (compound != null && compound.func_74764_b("ClonedName")) {
            return compound.func_74779_i("ClonedName");
        }
        return "gui.selectnpc";
    }

    @Override
    public void buttonEvent(GuiButton guibutton) {
        int id = guibutton.field_146127_k;
        if (id == 1) {
            this.save();
            String name = "New";
            while (this.data.containsKey(name)) {
                name = name + "_";
            }
            SpawnData spawn = new SpawnData();
            spawn.name = name;
            Client.sendData(EnumPacketServer.NaturalSpawnSave, spawn.writeNBT(new NBTTagCompound()));
        }
        if (id == 2 && this.data.containsKey(this.scroll.getSelected())) {
            Client.sendData(EnumPacketServer.NaturalSpawnRemove, this.spawn.id);
            this.spawn = new SpawnData();
            this.scroll.clear();
        }
        if (id == 3) {
            this.setSubGui(new SubGuiNpcBiomes(this.spawn));
        }
        if (id == 4) {
            this.setSubGui(new SubGuiSpawningOptions(this.spawn));
        }
        if (id >= 6 && id <= 10) {
            this.slotSelected = id - 5;
            this.setSubGui(new GuiNpcMobSpawnerSelector());
        }
        if (id == 25) {
            this.spawn.compound1 = new NBTTagCompound();
            this.func_73866_w_();
        }
        if (id == 26) {
            this.spawn.compound2 = new NBTTagCompound();
            this.func_73866_w_();
        }
        if (id == 27) {
            this.spawn.compound3 = new NBTTagCompound();
            this.func_73866_w_();
        }
        if (id == 28) {
            this.spawn.compound4 = new NBTTagCompound();
            this.func_73866_w_();
        }
        if (id == 29) {
            this.spawn.compound5 = new NBTTagCompound();
            this.func_73866_w_();
        }
    }

    @Override
    public void unFocused(GuiNpcTextField guiNpcTextField) {
        String name = guiNpcTextField.func_146179_b();
        if (name.isEmpty() || this.data.containsKey(name)) {
            guiNpcTextField.func_146180_a(this.spawn.name);
        } else {
            String old = this.spawn.name;
            this.data.remove(old);
            this.spawn.name = name;
            this.data.put(this.spawn.name, this.spawn.id);
            this.scroll.replace(old, this.spawn.name);
        }
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> data) {
        String name = this.scroll.getSelected();
        this.data = data;
        this.scroll.setList(list);
        if (name != null) {
            this.scroll.setSelected(name);
        }
        this.func_73866_w_();
    }

    @Override
    public void customScrollClicked(int i, int j, int k, GuiCustomScroll guiCustomScroll) {
        if (guiCustomScroll.id == 0) {
            this.save();
            String selected = this.scroll.getSelected();
            this.spawn = new SpawnData();
            Client.sendData(EnumPacketServer.NaturalSpawnGet, this.data.get(selected));
        }
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
        if (this.spawn.id >= 0) {
            Client.sendData(EnumPacketServer.NaturalSpawnSave, this.spawn.writeNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void setSelected(String selected) {
    }

    @Override
    public void closeSubGui(SubGuiInterface gui) {
        super.closeSubGui(gui);
        if (gui instanceof GuiNpcMobSpawnerSelector) {
            GuiNpcMobSpawnerSelector selector = (GuiNpcMobSpawnerSelector)gui;
            NBTTagCompound compound = selector.getCompound();
            if (compound != null) {
                switch (this.slotSelected) {
                    case 1: {
                        this.spawn.compound1 = compound;
                        break;
                    }
                    case 2: {
                        this.spawn.compound2 = compound;
                        break;
                    }
                    case 3: {
                        this.spawn.compound3 = compound;
                        break;
                    }
                    case 4: {
                        this.spawn.compound4 = compound;
                        break;
                    }
                    case 5: {
                        this.spawn.compound5 = compound;
                    }
                }
            }
            this.func_73866_w_();
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.spawn.readNBT(compound);
        this.setSelected(this.spawn.name);
        this.func_73866_w_();
    }

    @Override
    public void mouseDragged(GuiNpcSlider guiNpcSlider) {
        guiNpcSlider.field_146126_j = StatCollector.func_74838_a((String)"spawning.weightedChance") + ": " + (int)(guiNpcSlider.sliderValue * 100.0f);
    }

    @Override
    public void mousePressed(GuiNpcSlider guiNpcSlider) {
    }

    @Override
    public void mouseReleased(GuiNpcSlider guiNpcSlider) {
        this.spawn.field_76292_a = (int)(guiNpcSlider.sliderValue * 100.0f);
    }
}

