/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomTeleporter;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.QuestLogData;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumOptionType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.containers.ContainerNPCFollower;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerBankData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.event.DialogEvent;
import noppes.npcs.scripted.event.QuestEvent;
import noppes.npcs.scripted.interfaces.entity.IPlayer;
import noppes.npcs.scripted.interfaces.handler.data.IQuestObjective;
import noppes.npcs.scripted.interfaces.item.IItemStack;

public class NoppesUtilPlayer {
    public static void changeFollowerState(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Follower) {
            return;
        }
        RoleFollower role = (RoleFollower)npc.roleInterface;
        EntityPlayer owner = role.owner;
        if (owner == null || !owner.func_70005_c_().equals(player.func_70005_c_())) {
            return;
        }
        role.isFollowing = !role.isFollowing;
    }

    public static void hireFollower(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Follower) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCFollowerHire)) {
            return;
        }
        ContainerNPCFollowerHire container = (ContainerNPCFollowerHire)con;
        RoleFollower role = (RoleFollower)npc.roleInterface;
        NoppesUtilPlayer.followerBuy(role, (IInventory)container.currencyMatrix, player, npc);
    }

    public static void extendFollower(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Follower) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCFollower)) {
            return;
        }
        ContainerNPCFollower container = (ContainerNPCFollower)con;
        RoleFollower role = (RoleFollower)npc.roleInterface;
        NoppesUtilPlayer.followerBuy(role, container.currencyMatrix, player, npc);
    }

    public static void transport(EntityPlayerMP player, EntityNPCInterface npc, String location) {
        TransportLocation loc = TransportController.getInstance().getTransport(location);
        PlayerTransportData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).transportData;
        if (loc == null || !loc.isDefault() && !playerdata.transports.contains(loc.id)) {
            return;
        }
        NoppesUtilPlayer.teleportPlayer(player, loc.posX, loc.posY, loc.posZ, loc.dimension);
    }

    public static void teleportPlayer(EntityPlayerMP player, double posX, double posY, double posZ, int dimension) {
        if (player.field_71093_bK != dimension) {
            int dim = player.field_71093_bK;
            MinecraftServer server = MinecraftServer.func_71276_C();
            WorldServer wor = server.func_71218_a(dimension);
            if (wor == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Broken transporter. Dimenion does not exist"));
                return;
            }
            player.func_70012_b(posX, posY, posZ, player.field_70177_z, player.field_70125_A);
            server.func_71203_ab().transferPlayerToDimension(player, dimension, (Teleporter)new CustomTeleporter(wor));
            player.field_71135_a.func_147364_a(posX, posY, posZ, player.field_70177_z, player.field_70125_A);
            if (!wor.field_73010_i.contains(player)) {
                wor.func_72838_d((Entity)player);
            }
        } else {
            player.field_71135_a.func_147364_a(posX, posY, posZ, player.field_70177_z, player.field_70125_A);
        }
        player.field_70170_p.func_72866_a((Entity)player, false);
    }

    public static void teleportPlayer(EntityPlayerMP player, double posX, double posY, double posZ, float yaw, float pitch, int dimension) {
        if (player.field_71093_bK != dimension) {
            int dim = player.field_71093_bK;
            MinecraftServer server = MinecraftServer.func_71276_C();
            WorldServer wor = server.func_71218_a(dimension);
            if (wor == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Broken transporter. Dimenion does not exist"));
                return;
            }
            player.func_70012_b(posX, posY, posZ, yaw, pitch);
            server.func_71203_ab().transferPlayerToDimension(player, dimension, (Teleporter)new CustomTeleporter(wor));
            player.field_71135_a.func_147364_a(posX, posY, posZ, yaw, pitch);
            if (!wor.field_73010_i.contains(player)) {
                wor.func_72838_d((Entity)player);
            }
        } else {
            player.field_71135_a.func_147364_a(posX, posY, posZ, yaw, pitch);
        }
        player.field_70170_p.func_72866_a((Entity)player, false);
    }

    public static void disableMouseInput(EntityPlayerMP player, long time, int ... buttonIds) {
        StringBuilder stringedIds = new StringBuilder();
        for (int i = 0; i < buttonIds.length; ++i) {
            stringedIds.append(i);
            if (i >= buttonIds.length - 1) continue;
            stringedIds.append(";");
        }
        Server.sendData(player, EnumPacketClient.DISABLE_MOUSE_INPUT, time, stringedIds.toString());
    }

    public static void swingPlayerArm(EntityPlayerMP player) {
        Server.sendData(player, EnumPacketClient.SWING_PLAYER_ARM, new Object[0]);
    }

    private static void followerBuy(RoleFollower role, IInventory currencyInv, EntityPlayerMP player, EntityNPCInterface npc) {
        ItemStack currency = currencyInv.func_70301_a(0);
        if (currency == null) {
            return;
        }
        HashMap<ItemStack, Integer> cd = new HashMap<ItemStack, Integer>();
        for (int i : role.inventory.items.keySet()) {
            ItemStack is = role.inventory.items.get(i);
            if (is == null || is.func_77973_b() != currency.func_77973_b() || is.func_77981_g() && is.func_77960_j() != currency.func_77960_j()) continue;
            int days = 1;
            if (role.rates.containsKey(i)) {
                days = role.rates.get(i);
            }
            cd.put(is, days);
        }
        if (cd.size() == 0) {
            return;
        }
        int stackSize = currency.field_77994_a;
        int days = 0;
        int possibleDays = 0;
        int possibleSize = stackSize;
        while (true) {
            for (ItemStack item : cd.keySet()) {
                int newStackSize;
                int size;
                int posDays;
                int rDays = (Integer)cd.get(item);
                int rValue = item.field_77994_a;
                if (rValue > stackSize || possibleDays > (posDays = (size = stackSize - (newStackSize = stackSize % rValue)) / rValue * rDays)) continue;
                possibleDays = posDays;
                possibleSize = newStackSize;
            }
            if (stackSize == possibleSize) break;
            stackSize = possibleSize;
            days += possibleDays;
            possibleDays = 0;
        }
        if (days == 0) {
            return;
        }
        if (stackSize <= 0) {
            currencyInv.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(stackSize);
        }
        npc.say((EntityPlayer)player, new Line(NoppesStringUtils.formatText(role.dialogHire.replace("{days}", days + ""), new Object[]{player, npc})));
        role.setOwner((EntityPlayer)player);
        role.addDays(days);
    }

    public static void bankUpgrade(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Bank) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return;
        }
        ContainerNPCBankInterface container = (ContainerNPCBankInterface)con;
        Bank bank = BankController.getInstance().getBank(container.bankid);
        ItemStack item = bank.upgradeInventory.func_70301_a(container.slot);
        if (item == null) {
            return;
        }
        int price = item.field_77994_a;
        ItemStack currency = container.currencyMatrix.func_70301_a(0);
        if (currency == null || price > currency.field_77994_a) {
            return;
        }
        if (currency.field_77994_a - price == 0) {
            container.currencyMatrix.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(price);
        }
        player.func_71128_l();
        PlayerBankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bank.id);
        BankData bankData = data.getBank(bank.id);
        bankData.upgradedSlots.put(container.slot, true);
        bankData.openBankGui((EntityPlayer)player, npc, bank.id, container.slot);
    }

    public static void bankUnlock(EntityPlayerMP player, EntityNPCInterface npc) {
        if (npc.advanced.role != EnumRoleType.Bank) {
            return;
        }
        Container con = player.field_71070_bA;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return;
        }
        ContainerNPCBankInterface container = (ContainerNPCBankInterface)con;
        Bank bank = BankController.getInstance().getBank(container.bankid);
        ItemStack item = bank.currencyInventory.func_70301_a(container.slot);
        if (item == null) {
            return;
        }
        int price = item.field_77994_a;
        ItemStack currency = container.currencyMatrix.func_70301_a(0);
        if (currency == null || price > currency.field_77994_a) {
            return;
        }
        if (currency.field_77994_a - price == 0) {
            container.currencyMatrix.func_70299_a(0, null);
        } else {
            currency = currency.func_77979_a(price);
        }
        player.func_71128_l();
        PlayerBankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bank.id);
        BankData bankData = data.getBank(bank.id);
        if (bankData.unlockedSlots + 1 <= bank.maxSlots) {
            ++bankData.unlockedSlots;
        }
        bankData.openBankGui((EntityPlayer)player, npc, bank.id, container.slot);
    }

    public static void sendData(EnumPlayerPacket enu, Object ... obs) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (!Server.fillBuffer(buffer, enu, obs)) {
                return;
            }
            CustomNpcs.ChannelPlayer.sendToServer(new FMLProxyPacket(buffer, "CustomNPCsPlayer"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dialogSelected(int dialogId, int optionId, EntityPlayerMP player, EntityNPCInterface npc) {
        Dialog dialog = DialogController.instance.dialogs.get(dialogId);
        if (dialog == null) {
            return;
        }
        DialogOption option = dialog.options.get(optionId);
        if (!npc.isRemote()) {
            EventHooks.onDialogOption(new DialogEvent.DialogOption((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), dialog));
            EventHooks.onNPCDialogClosed(npc, (EntityPlayer)player, dialogId, optionId + 1, dialog);
            if (!dialog.hasDialogs((EntityPlayer)player) && !dialog.hasOtherOptions()) {
                EventHooks.onDialogClosed(new DialogEvent.DialogClosed((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), dialog));
                return;
            }
            if (option == null || option.optionType == EnumOptionType.DialogOption && (!option.isAvailable((EntityPlayer)player) || !option.hasDialog()) || option.optionType == EnumOptionType.Disabled || option.optionType == EnumOptionType.QuitOption) {
                EventHooks.onDialogClosed(new DialogEvent.DialogClosed((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), dialog));
                return;
            }
        }
        if (option.optionType == EnumOptionType.RoleOption) {
            if (npc.roleInterface != null) {
                npc.roleInterface.interact((EntityPlayer)player);
            } else {
                Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
            }
        } else if (option.optionType == EnumOptionType.DialogOption) {
            NoppesUtilServer.openDialog((EntityPlayer)player, npc, option.getDialog(), optionId + 1);
        } else if (option.optionType == EnumOptionType.CommandBlock) {
            Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
            NoppesUtilServer.runCommand((EntityPlayer)player, npc.func_70005_c_(), option.command);
        } else {
            Server.sendData(player, EnumPacketClient.GUI_CLOSE, new Object[0]);
        }
    }

    public static void sendTrackedQuestData(EntityPlayerMP player, Quest trackedQuest) {
        Quest quest = (Quest)PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData.trackedQuest;
        if (quest == null || trackedQuest == null || quest.id != trackedQuest.id) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Quest", (NBTBase)trackedQuest.writeToNBT(new NBTTagCompound()));
        compound.func_74778_a("CategoryName", trackedQuest.getCategory().getName());
        compound.func_74778_a("TurnInNPC", trackedQuest.getNpcName());
        NBTTagList nbtTagList = new NBTTagList();
        for (IQuestObjective objective : trackedQuest.questInterface.getObjectives((EntityPlayer)player)) {
            nbtTagList.func_74742_a((NBTBase)new NBTTagString(objective.getText()));
        }
        compound.func_74782_a("ObjectiveList", (NBTBase)nbtTagList);
        Server.sendData(player, EnumPacketClient.OVERLAY_QUEST_TRACKING, compound);
    }

    public static void sendQuestLogData(EntityPlayerMP player) {
        if (!PlayerQuestController.hasActiveQuests((EntityPlayer)player)) {
            return;
        }
        QuestLogData data = new QuestLogData();
        data.setData((EntityPlayer)player);
        Server.sendData(player, EnumPacketClient.GUI_DATA, data.writeNBT());
    }

    public static void questCompletion(EntityPlayerMP player, int questId) {
        PlayerData playerData = PlayerDataController.instance.getPlayerData((EntityPlayer)player);
        PlayerQuestData questData = playerData.questData;
        QuestData data = questData.activeQuests.get(questId);
        if (data == null) {
            return;
        }
        if (!data.quest.questInterface.isCompleted(playerData)) {
            return;
        }
        QuestEvent.QuestTurnedInEvent event = new QuestEvent.QuestTurnedInEvent((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), data.quest);
        event.expReward = data.quest.rewardExp;
        ArrayList<IItemStack> list = new ArrayList<IItemStack>();
        for (ItemStack item : data.quest.rewardItems.items.values()) {
            if (item.field_77994_a <= 0) continue;
            list.add(NpcAPI.Instance().getIItemStack(item));
        }
        if (!data.quest.randomReward) {
            event.itemRewards = list.toArray(new IItemStack[list.size()]);
        } else if (!list.isEmpty()) {
            event.itemRewards = new IItemStack[]{(IItemStack)list.get(player.func_70681_au().nextInt(list.size()))};
        }
        EventHooks.onQuestTurnedIn(event);
        for (IItemStack item : event.itemRewards) {
            if (item == null) continue;
            NoppesUtilServer.GivePlayerItem((Entity)player, (EntityPlayer)player, item.getMCItemStack());
        }
        data.quest.questInterface.handleComplete((EntityPlayer)player);
        if (data.quest.rewardExp > 0) {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            player.func_71023_q(data.quest.rewardExp);
        }
        data.quest.factionOptions.addPoints((EntityPlayer)player);
        if (data.quest.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_70005_c_(), data.quest.mail);
        }
        if (!data.quest.command.isEmpty()) {
            NoppesUtilServer.runCommand((EntityPlayer)player, "QuestCompletion", data.quest.command);
        }
        PlayerQuestController.setQuestFinished(data.quest, (EntityPlayer)player);
        if (data.quest.hasNewQuest()) {
            PlayerQuestController.addActiveQuest(data.quest.getNextQuest(), (EntityPlayer)player);
        }
    }

    public static boolean compareItems(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        if (item2 == null || item == null) {
            return false;
        }
        boolean oreMatched = false;
        OreDictionary.itemMatches((ItemStack)item, (ItemStack)item2, (boolean)false);
        int[] ids = OreDictionary.getOreIDs((ItemStack)item);
        if (ids.length > 0) {
            for (int id : ids) {
                boolean match1 = false;
                boolean match2 = false;
                for (ItemStack is : OreDictionary.getOres((Integer)id)) {
                    if (NoppesUtilPlayer.compareItemDetails(item, is, ignoreDamage, ignoreNBT)) {
                        match1 = true;
                    }
                    if (!NoppesUtilPlayer.compareItemDetails(item2, is, ignoreDamage, ignoreNBT)) continue;
                    match2 = true;
                }
                if (!match1 || !match2) continue;
                return true;
            }
        }
        return NoppesUtilPlayer.compareItemDetails(item, item2, ignoreDamage, ignoreNBT);
    }

    private static boolean compareItemDetails(ItemStack item, ItemStack item2, boolean ignoreDamage, boolean ignoreNBT) {
        if (item.func_77973_b() != item2.func_77973_b()) {
            return false;
        }
        if (!ignoreDamage && item.func_77960_j() != -1 && item.func_77960_j() != item2.func_77960_j()) {
            return false;
        }
        if (!(ignoreNBT || item.field_77990_d == null || item2.field_77990_d != null && item.field_77990_d.equals((Object)item2.field_77990_d))) {
            return false;
        }
        return ignoreNBT || item2.field_77990_d == null || item.field_77990_d != null;
    }

    public static boolean compareItems(EntityPlayer player, ItemStack item, boolean ignoreDamage, boolean ignoreNBT) {
        int size = 0;
        for (ItemStack is : player.field_71071_by.field_70462_a) {
            if (is == null || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
            size += is.field_77994_a;
        }
        return size >= item.field_77994_a;
    }

    public static void consumeItem(EntityPlayer player, ItemStack item, boolean ignoreDamage, boolean ignoreNBT) {
        if (item == null) {
            return;
        }
        int size = item.field_77994_a;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = player.field_71071_by.field_70462_a[i];
            if (is == null || !NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
            if (size >= is.field_77994_a) {
                size -= is.field_77994_a;
                player.field_71071_by.field_70462_a[i] = null;
                continue;
            }
            player.field_71071_by.field_70462_a[i].func_77979_a(size);
            break;
        }
    }

    public static void isGUIOpen(EntityPlayerMP player) {
        Server.sendData(player, EnumPacketClient.ISGUIOPEN, new Object[0]);
    }

    public static List<ItemStack> countStacks(IInventory inv, boolean ignoreDamage, boolean ignoreNBT) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (NoppesUtilServer.IsItemStackNull(item)) continue;
            boolean found = false;
            for (ItemStack is : list) {
                if (!NoppesUtilPlayer.compareItems(item, is, ignoreDamage, ignoreNBT)) continue;
                is.field_77994_a += item.field_77994_a;
                found = true;
                break;
            }
            if (found) continue;
            list.add(item.func_77946_l());
        }
        return list;
    }
}

