/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui.theme;

import java.awt.Color;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.component.BooleanPropertyButton;
import net.techbrew.journeymap.ui.theme.Theme;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ThemeButton
extends BooleanPropertyButton {
    protected Theme theme;
    protected Theme.Control.ButtonSpec buttonSpec;
    protected TextureImpl textureOn;
    protected TextureImpl textureHover;
    protected TextureImpl textureOff;
    protected TextureImpl textureDisabled;
    protected TextureImpl textureIcon;
    protected Color iconOnColor;
    protected Color iconOffColor;
    protected Color iconHoverColor;
    protected Color iconDisabledColor;
    protected String iconName;
    protected List<String> additionalTooltips;

    public ThemeButton(Theme theme, String rawLabel, String iconName) {
        this(theme, Constants.getString(rawLabel), Constants.getString(rawLabel), false, iconName);
    }

    public ThemeButton(Theme theme, String labelOn, String labelOff, boolean toggled, String iconName) {
        super(labelOn, labelOff, null, null);
        this.iconName = iconName;
        this.setToggled(toggled);
        this.updateTheme(theme);
    }

    protected ThemeButton(Theme theme, String labelOn, String labelOff, String iconName, PropertiesBase properties, AtomicBoolean property) {
        super(labelOn, labelOff, properties, property);
        this.iconName = iconName;
        this.updateTheme(theme);
    }

    public void updateTheme(Theme theme) {
        this.theme = theme;
        this.buttonSpec = this.getButtonSpec(theme);
        TextureCache tc = TextureCache.instance();
        if (this.buttonSpec.useThemeImages) {
            String pattern = this.getPathPattern();
            String prefix = this.buttonSpec.prefix;
            this.textureOn = tc.getThemeTexture(theme, String.format(pattern, prefix, "on"));
            this.textureOff = tc.getThemeTexture(theme, String.format(pattern, prefix, "off"));
            this.textureHover = tc.getThemeTexture(theme, String.format(pattern, prefix, "hover"));
            this.textureDisabled = tc.getThemeTexture(theme, String.format(pattern, prefix, "disabled"));
        } else {
            this.textureOn = null;
            this.textureOff = null;
            this.textureHover = null;
            this.textureDisabled = null;
        }
        this.iconOnColor = Theme.getColor(this.buttonSpec.iconOnColor);
        this.iconOffColor = Theme.getColor(this.buttonSpec.iconOffColor);
        this.iconHoverColor = Theme.getColor(this.buttonSpec.iconHoverColor);
        this.iconDisabledColor = Theme.getColor(this.buttonSpec.iconDisabledColor);
        this.textureIcon = tc.getThemeTexture(theme, String.format("icon/%s.png", this.iconName));
        this.setWidth(this.buttonSpec.width);
        this.setHeight(this.buttonSpec.height);
        this.setToggled(false, false);
    }

    public boolean hasValidTextures() {
        if (this.buttonSpec.useThemeImages) {
            return GL11.glIsTexture((int)this.textureOn.getGlTextureId(false)) && GL11.glIsTexture((int)this.textureOff.getGlTextureId(false));
        }
        return true;
    }

    protected String getPathPattern() {
        return "control/%sbutton_%s.png";
    }

    protected Theme.Control.ButtonSpec getButtonSpec(Theme theme) {
        return theme.control.button;
    }

    protected TextureImpl getActiveTexture(boolean isMouseOver) {
        if (this.isEnabled()) {
            TextureImpl activeTexture = isMouseOver ? (Mouse.isButtonDown((int)0) ? this.textureOn : this.textureHover) : this.textureOff;
            return activeTexture;
        }
        return this.textureDisabled;
    }

    protected Color getIconColor(boolean isMouseOver) {
        if (!this.isEnabled()) {
            return this.iconDisabledColor;
        }
        if (isMouseOver) {
            return this.iconHoverColor;
        }
        return this.toggled != false ? this.iconOnColor : this.iconOffColor;
    }

    @Override
    public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.isDrawButton()) {
            return;
        }
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        int hoverState = this.func_146114_a(this.field_146123_n);
        boolean isMouseOver = hoverState == 2;
        TextureImpl activeTexture = this.getActiveTexture(isMouseOver);
        int drawX = this.getX();
        int drawY = this.getY();
        if (this.buttonSpec.useThemeImages) {
            float buttonScale = 1.0f;
            if (this.buttonSpec.width != activeTexture.getWidth()) {
                buttonScale = 1.0f * (float)this.buttonSpec.width / (float)activeTexture.getWidth();
            }
            DrawUtil.drawImage(activeTexture, drawX, drawY, false, buttonScale, 0.0);
        } else {
            this.drawNativeButton(minecraft, mouseX, mouseY);
        }
        float iconScale = 1.0f;
        if (this.theme.icon.width != this.textureIcon.getWidth()) {
            iconScale = 1.0f * (float)this.theme.icon.width / (float)this.textureIcon.getWidth();
        }
        if (!this.buttonSpec.useThemeImages) {
            DrawUtil.drawColoredImage(this.textureIcon, 255, Color.black, (double)drawX + 0.5, (double)drawY + 0.5, iconScale, 0.0);
        }
        Color iconColor = this.getIconColor(isMouseOver);
        DrawUtil.drawColoredImage(this.textureIcon, 255, iconColor, drawX, drawY, iconScale, 0.0);
    }

    public void drawNativeButton(Minecraft minecraft, int mouseX, int mouseY) {
        int magic = 20;
        minecraft.func_110434_K().func_110577_a(field_146122_a);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = this.func_146114_a(this.field_146123_n);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBlendFunc((int)770, (int)771);
        this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + k * magic, this.field_146120_f / 2, this.field_146121_g);
        this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + k * magic, this.field_146120_f / 2, this.field_146121_g);
        this.func_146119_b(minecraft, mouseX, mouseY);
        int l = 0xE0E0E0;
    }

    public void setAdditionalTooltips(List<String> additionalTooltips) {
        this.additionalTooltips = additionalTooltips;
    }

    @Override
    public List<String> getTooltip() {
        if (!this.field_146125_m) {
            return null;
        }
        List<String> list = super.getTooltip();
        String style = null;
        style = !this.isEnabled() ? this.buttonSpec.tooltipDisabledStyle : (this.toggled != false ? this.buttonSpec.tooltipOnStyle : this.buttonSpec.tooltipOffStyle);
        list.add(0, style + this.field_146126_j);
        if (this.additionalTooltips != null) {
            list.addAll(this.additionalTooltips);
        }
        return list;
    }
}

