/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.task.multi;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ChunkRenderController;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.feature.Feature;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.io.nbt.ChunkLoader;
import net.techbrew.journeymap.io.nbt.RegionLoader;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.model.EntityDTO;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.task.multi.BaseMapTask;
import net.techbrew.journeymap.task.multi.ITask;
import net.techbrew.journeymap.task.multi.ITaskManager;
import org.apache.logging.log4j.Logger;

public class MapRegionTask
extends BaseMapTask {
    private static final int MAX_RUNTIME = 30000;
    private static final Logger logger = JourneyMap.getLogger();
    private static volatile long lastTaskCompleted;
    final RegionCoord rCoord;
    final Collection<ChunkCoordIntPair> retainedCoords;

    private MapRegionTask(ChunkRenderController renderController, World world, MapType mapType, RegionCoord rCoord, Collection<ChunkCoordIntPair> chunkCoords, Collection<ChunkCoordIntPair> retainCoords) {
        super(renderController, world, mapType, chunkCoords, true, 5000);
        this.rCoord = rCoord;
        this.retainedCoords = retainCoords;
    }

    public static BaseMapTask create(ChunkRenderController renderController, RegionCoord rCoord, MapType mapType, Minecraft minecraft) {
        boolean missing = false;
        WorldClient world = minecraft.field_71441_e;
        List<ChunkCoordIntPair> renderCoords = rCoord.getChunkCoordsInRegion(mapType.vSlice);
        ArrayList<ChunkCoordIntPair> retainedCoords = new ArrayList<ChunkCoordIntPair>(renderCoords.size());
        for (ChunkCoordIntPair coord : renderCoords) {
            for (ChunkCoordIntPair keepAliveOffset : keepAliveOffsets) {
                ChunkCoordIntPair keepAliveCoord = new ChunkCoordIntPair(coord.field_77276_a + keepAliveOffset.field_77276_a, coord.field_77275_b + keepAliveOffset.field_77275_b);
                if (renderCoords.contains(keepAliveCoord)) continue;
                retainedCoords.add(keepAliveCoord);
            }
        }
        return new MapRegionTask(renderController, (World)world, mapType, rCoord, renderCoords, retainedCoords);
    }

    @Override
    public final void performTask(Minecraft mc, JourneyMap jm, File jmWorldDir, boolean threadLogging) throws InterruptedException {
        ChunkMD chunkMD;
        AnvilChunkLoader loader = ChunkLoader.getAnvilChunkLoader(mc);
        int missing = 0;
        for (ChunkCoordIntPair coord : this.retainedCoords) {
            chunkMD = ChunkLoader.getChunkMD(loader, mc, coord);
            if (chunkMD == null) continue;
            DataCache.instance().addChunkMD(chunkMD);
        }
        for (ChunkCoordIntPair coord : this.chunkCoords) {
            chunkMD = ChunkLoader.getChunkMD(loader, mc, coord);
            if (chunkMD != null) {
                DataCache.instance().addChunkMD(chunkMD);
                continue;
            }
            ++missing;
        }
        logger.info(String.format("Chunks found in %s: %s/%s", this.rCoord, this.chunkCoords.size() - missing, this.chunkCoords.size()));
        if (this.chunkCoords.size() - missing >= 16) {
            super.performTask(mc, jm, jmWorldDir, threadLogging);
        } else {
            logger.info("Skipping underpopulated region: " + this.rCoord);
        }
    }

    @Override
    protected void complete(boolean cancelled, boolean hadError) {
        lastTaskCompleted = System.currentTimeMillis();
        if (!cancelled) {
            RegionImageCache.instance().flushToDisk();
        }
        DataCache.instance().invalidateChunkMDCache();
        if (hadError || cancelled) {
            logger.warn("MapRegionTask cancelled %s hadError %s", new Object[]{cancelled, hadError});
        }
    }

    @Override
    public int getMaxRuntime() {
        return 30000;
    }

    public static class Manager
    implements ITaskManager {
        final int mapTaskDelay = 0;
        RegionLoader regionLoader;
        boolean enabled;

        @Override
        public Class<? extends ITask> getTaskClass() {
            return MapRegionTask.class;
        }

        @Override
        public boolean enableTask(Minecraft minecraft, Object params) {
            boolean underground;
            EntityDTO player = DataCache.getPlayer();
            boolean cavesAllowed = FeatureManager.isAllowed(Feature.MapCaves);
            boolean worldHasSky = !player.entityLiving.field_70170_p.field_73011_w.field_76576_e;
            boolean bl = underground = player.entityLiving.field_70170_p.field_73011_w.field_76576_e || player.underground != false;
            if (underground && !cavesAllowed) {
                if (worldHasSky) {
                    underground = false;
                } else {
                    logger.info("Cave mapping not permitted.");
                    return false;
                }
            }
            boolean bl2 = this.enabled = params != null;
            if (!this.enabled) {
                return false;
            }
            if (System.currentTimeMillis() - lastTaskCompleted < (long)JourneyMap.getCoreProperties().autoMapPoll.get()) {
                return false;
            }
            this.enabled = false;
            if (minecraft.func_71387_A()) {
                try {
                    long time;
                    MapType mapType = underground ? MapType.underground(player) : ((time = minecraft.field_71441_e.func_72912_H().func_76073_f() % 24000L) < 13800L ? MapType.day(player) : MapType.night(player));
                    Boolean mapAll = params == null ? false : (Boolean)params;
                    this.regionLoader = new RegionLoader(minecraft, mapType, mapAll);
                    if (this.regionLoader.getRegionsFound() == 0) {
                        this.disableTask(minecraft);
                    } else {
                        this.enabled = true;
                    }
                }
                catch (Throwable t) {
                    String error = "Couldn't Auto-Map: " + t.getMessage();
                    ChatLog.announceError(error);
                    logger.error(error + ": " + LogFormatter.toString(t));
                }
            }
            return this.enabled;
        }

        @Override
        public boolean isEnabled(Minecraft minecraft) {
            return this.enabled;
        }

        @Override
        public void disableTask(Minecraft minecraft) {
            if (this.regionLoader != null) {
                if (this.regionLoader.isUnderground()) {
                    ChatLog.announceI18N("jm.common.automap_complete_underground", this.regionLoader.getVSlice());
                } else {
                    ChatLog.announceI18N("jm.common.automap_complete", new Object[0]);
                }
            }
            this.enabled = false;
            if (this.regionLoader != null) {
                RegionImageCache.instance().flushToDisk();
                RegionImageCache.instance().clear();
                this.regionLoader.getRegions().clear();
                this.regionLoader = null;
            }
        }

        @Override
        public BaseMapTask getTask(Minecraft minecraft) {
            if (!this.enabled) {
                return null;
            }
            if (this.regionLoader.getRegions().isEmpty()) {
                this.disableTask(minecraft);
                return null;
            }
            RegionCoord rCoord = this.regionLoader.getRegions().peek();
            ChunkRenderController chunkRenderController = JourneyMap.getInstance().getChunkRenderController();
            BaseMapTask baseMapTask = MapRegionTask.create(chunkRenderController, rCoord, this.regionLoader.getMapType(), minecraft);
            return baseMapTask;
        }

        @Override
        public void taskAccepted(ITask task, boolean accepted) {
            if (accepted) {
                this.regionLoader.getRegions().pop();
                float total = 1.0f * (float)this.regionLoader.getRegionsFound();
                float remaining = total - (float)this.regionLoader.getRegions().size();
                String percent = new DecimalFormat("##.#").format(remaining * 100.0f / total) + "%";
                if (this.regionLoader.isUnderground()) {
                    ChatLog.announceI18N("jm.common.automap_status_underground", this.regionLoader.getVSlice(), percent);
                } else {
                    ChatLog.announceI18N("jm.common.automap_status", percent);
                }
            }
        }
    }
}

