/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.properties.WebMapProperties;
import net.techbrew.journeymap.server.ActionService;
import net.techbrew.journeymap.server.DataService;
import net.techbrew.journeymap.server.DebugService;
import net.techbrew.journeymap.server.FileService;
import net.techbrew.journeymap.server.LogService;
import net.techbrew.journeymap.server.MapApiService;
import net.techbrew.journeymap.server.PropertyService;
import net.techbrew.journeymap.server.TileService;
import net.techbrew.journeymap.thread.JMThreadFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import se.rupy.http.Daemon;

public class JMServer {
    private static final int MAXPORT = 9990;
    private static final int MAXFAILS = 5;
    private static volatile JMServer instance;
    private final Logger logger = JourneyMap.getLogger();
    private Daemon rupy;
    private int port;
    private boolean ready = false;

    private JMServer() {
        this.port = JourneyMap.getWebMapProperties().port.get();
        this.validatePort();
    }

    public static void setEnabled(Boolean enable, boolean forceAnnounce) {
        WebMapProperties webMapProperties = JourneyMap.getWebMapProperties();
        webMapProperties.enabled.set(enable);
        webMapProperties.save();
        if (instance != null) {
            try {
                instance.stop();
            }
            catch (Throwable e) {
                JourneyMap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
            }
        }
        if (enable.booleanValue()) {
            try {
                instance = new JMServer();
                if (instance.isReady()) {
                    instance.start();
                } else {
                    enable = false;
                }
            }
            catch (Throwable e) {
                JourneyMap.getLogger().log(Level.ERROR, LogFormatter.toString(e));
                enable = false;
            }
            if (!enable.booleanValue()) {
                JourneyMap.getLogger().error("Unexpected error, JMServer couldn't be started.");
            }
        }
        if (forceAnnounce) {
            ChatLog.enableAnnounceMod = true;
        }
        ChatLog.announceMod(forceAnnounce);
    }

    public static JMServer getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validatePort() {
        int hardFails = 0;
        int testPort = this.port;
        int maxPort = Math.max(9990, this.port + 1000);
        boolean validPort = false;
        while (!validPort && hardFails <= 5 && testPort <= maxPort) {
            ServerSocketChannel server = null;
            try {
                server = ServerSocketChannel.open();
                server.socket().bind(new InetSocketAddress(testPort));
                validPort = true;
            }
            catch (BindException e) {
                this.logger.warn("Port " + testPort + " already in use");
                testPort += 10;
            }
            catch (Throwable t) {
                this.logger.error("Error when testing port " + testPort + ": " + t);
                ++hardFails;
            }
            finally {
                if (server == null) continue;
                try {
                    server.close();
                }
                catch (IOException e) {}
            }
        }
        this.ready = validPort;
        if (this.ready && this.port != testPort) {
            this.logger.info("Webserver will use port " + testPort + " for this session");
            this.port = testPort;
        }
        if (!this.ready && hardFails > 5) {
            this.logger.error("Gave up finding a port for webserver after " + hardFails + " failures to test ports!");
        }
        if (!this.ready && testPort > 9990) {
            this.logger.error("Gave up finding a port for webserver after testing ports " + this.port + " - " + maxPort + " without finding one open!");
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        if (!this.ready) {
            throw new IllegalStateException("Initialization failed");
        }
        Properties props = new Properties();
        props.put("port", Integer.toString(this.port));
        props.put("delay", Integer.toString(5000));
        props.put("timeout", Integer.toString(0));
        props.put("threads", Integer.toString(5));
        Level logLevel = Level.toLevel((String)JourneyMap.getCoreProperties().logLevel.get(), (Level)Level.INFO);
        if (logLevel.intLevel() >= Level.TRACE.intLevel()) {
            props.put("debug", Boolean.TRUE.toString());
        }
        if (logLevel.intLevel() >= Level.TRACE.intLevel()) {
            props.put("verbose", Boolean.TRUE.toString());
        }
        this.rupy = new Daemon(props);
        this.rupy.add(new DataService());
        this.rupy.add(new LogService());
        this.rupy.add(new TileService());
        this.rupy.add(new ActionService());
        this.rupy.add(new FileService());
        this.rupy.add(new PropertyService());
        this.rupy.add(new DebugService());
        this.rupy.add(new MapApiService());
        this.rupy.init();
        JMThreadFactory tf = new JMThreadFactory("svr");
        ExecutorService es = Executors.newSingleThreadExecutor(tf);
        es.execute(this.rupy);
        Runtime.getRuntime().addShutdownHook(tf.newThread(new Runnable(){

            @Override
            public void run() {
                JMServer.this.stop();
            }
        }));
        this.logger.info("Started webserver on port " + this.port);
    }

    public void stop() {
        try {
            if (this.rupy.isAlive()) {
                this.rupy.stop();
                this.logger.info("Stopped webserver without errors");
            }
        }
        catch (Throwable t) {
            this.logger.info("Stopped webserver with error: " + t);
        }
    }
}

