/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.map;

import com.google.common.base.Objects;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.minecraft.client.renderer.OpenGlHelper;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.GridSpec;
import net.techbrew.journeymap.model.ImageHolder;
import net.techbrew.journeymap.model.MapType;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageCache;
import net.techbrew.journeymap.model.RegionImageSet;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.map.Tile;
import net.techbrew.journeymap.render.map.TilePos;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.task.main.ExpireTextureTask;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class TileDrawStep {
    private static final Color bgColor = new Color(34, 34, 34);
    private static final Logger logger = JourneyMap.getLogger();
    private final boolean debug = logger.isDebugEnabled();
    private final RegionCoord regionCoord;
    private final MapType mapType;
    private final Integer zoom;
    private final boolean highQuality;
    private final StatTimer drawTimer;
    private final RegionImageSet regionImageSet;
    private final StatTimer updateRegionTimer = StatTimer.get("TileDrawStep.updateRegionTexture", 5, 50);
    private final StatTimer updateScaledTimer = StatTimer.get("TileDrawStep.updateScaledTexture", 5, 50);
    private int sx1;
    private int sy1;
    private int sx2;
    private int sy2;
    private volatile TextureImpl scaledTexture;
    private volatile Future<TextureImpl> regionFuture;
    private volatile Future<TextureImpl> scaledFuture;
    private volatile ImageHolder regionTextureHolder;
    private int lastTextureFilter;
    private int lastTextureWrap;

    public TileDrawStep(RegionCoord regionCoord, MapType mapType, Integer zoom, boolean highQuality, int sx1, int sy1, int sx2, int sy2) {
        this.mapType = mapType;
        this.regionCoord = regionCoord;
        this.zoom = zoom;
        this.sx1 = sx1;
        this.sx2 = sx2;
        this.sy1 = sy1;
        this.sy2 = sy2;
        this.highQuality = highQuality && zoom != 0;
        this.drawTimer = this.highQuality ? StatTimer.get("TileDrawStep.draw(high)") : StatTimer.get("TileDrawStep.draw(low)");
        this.regionImageSet = RegionImageCache.instance().getRegionImageSet(regionCoord);
        this.regionTextureHolder = this.regionImageSet.getHolder(mapType);
        this.updateRegionTexture();
        if (highQuality) {
            this.updateScaledTexture();
        }
    }

    public static int toHashCode(RegionCoord regionCoord, MapType mapType, Integer zoom, boolean highQuality, int sx1, int sy1, int sx2, int sy2) {
        return Objects.hashCode((Object[])new Object[]{regionCoord, mapType, zoom, highQuality, sx1, sy1, sx2, sy2});
    }

    boolean draw(TilePos pos, double offsetX, double offsetZ, float alpha, int textureFilter, int textureWrap, GridSpec gridSpec) {
        boolean regionUpdatePending = this.updateRegionTexture();
        if (this.highQuality) {
            this.updateScaledTexture();
        }
        Integer textureId = -1;
        boolean useScaled = false;
        if (this.highQuality && this.scaledTexture != null) {
            textureId = this.scaledTexture.func_110552_b();
            useScaled = true;
        } else {
            textureId = !regionUpdatePending ? Integer.valueOf(this.regionTextureHolder.getTexture().func_110552_b()) : Integer.valueOf(-1);
        }
        if (textureFilter != this.lastTextureFilter) {
            this.lastTextureFilter = textureFilter;
        }
        if (textureWrap != this.lastTextureWrap) {
            this.lastTextureWrap = textureWrap;
        }
        this.drawTimer.start();
        double startX = offsetX + pos.startX;
        double startY = offsetZ + pos.startZ;
        double endX = offsetX + pos.endX;
        double endY = offsetZ + pos.endZ;
        double z = 0.0;
        double size = 512.0;
        double startU = useScaled ? 0.0 : (double)this.sx1 / 512.0;
        double startV = useScaled ? 0.0 : (double)this.sy1 / 512.0;
        double endU = useScaled ? 1.0 : (double)this.sx2 / 512.0;
        double endV = useScaled ? 1.0 : (double)this.sy2 / 512.0;
        DrawUtil.drawRectangle(startX, startY, endX - startX, endY - startY, bgColor, 200);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3553);
        if (textureId != -1) {
            GL11.glBindTexture((int)3553, (int)textureId);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (!useScaled) {
                // empty if block
            }
            GL11.glTexParameteri((int)3553, (int)10241, (int)textureFilter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)textureFilter);
            GL11.glTexParameteri((int)3553, (int)10242, (int)textureWrap);
            GL11.glTexParameteri((int)3553, (int)10243, (int)textureWrap);
            DrawUtil.drawBoundTexture(startU, startV, startX, startY, 0.0, endU, endV, endX, endY);
        }
        if (gridSpec != null) {
            gridSpec.beginTexture(textureWrap, alpha);
            DrawUtil.drawBoundTexture((double)this.sx1 / 512.0, (double)this.sy1 / 512.0, startX, startY, 0.0, (double)this.sx2 / 512.0, (double)this.sy2 / 512.0, endX, endY);
            gridSpec.finishTexture();
        }
        if (this.debug) {
            int debugX = (int)startX;
            int debugY = (int)startY;
            DrawUtil.drawRectangle(debugX, debugY, 3.0, endV * 512.0, Color.green, 200);
            DrawUtil.drawRectangle(debugX, debugY, endU * 512.0, 3.0, Color.red, 200);
            DrawUtil.drawLabel(this.toString(), debugX + 5, debugY + 10, DrawUtil.HAlign.Right, DrawUtil.VAlign.Below, Color.WHITE, 255, Color.BLUE, 255, 1.0, false);
            DrawUtil.drawLabel(String.format("Tile Render Type: %s, Scaled: %s", Tile.debugGlSettings, useScaled), debugX + 5, debugY + 20, DrawUtil.HAlign.Right, DrawUtil.VAlign.Below, Color.WHITE, 255, Color.BLUE, 255, 1.0, false);
            long imageTimestamp = useScaled ? this.scaledTexture.getLastImageUpdate() : this.regionTextureHolder.getImageTimestamp();
            long age = (System.currentTimeMillis() - imageTimestamp) / 1000L;
            DrawUtil.drawLabel(this.mapType + " tile age: " + age + " seconds old", debugX + 5, debugY + 30, DrawUtil.HAlign.Right, DrawUtil.VAlign.Below, Color.WHITE, 255, Color.BLUE, 255, 1.0, false);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTimer.stop();
        int glErr = GL11.glGetError();
        if (glErr != 0) {
            JourneyMap.getLogger().warn("GL Error in TileDrawStep: " + glErr);
            this.clearTexture();
        }
        return textureId != 1;
    }

    public void clearTexture() {
        ExpireTextureTask.queue(this.scaledTexture);
        this.scaledTexture = null;
        if (this.scaledFuture != null && !this.scaledFuture.isDone()) {
            this.scaledFuture.cancel(true);
        }
        this.scaledFuture = null;
        if (this.regionFuture != null && !this.regionFuture.isDone()) {
            this.regionFuture.cancel(true);
        }
        this.regionFuture = null;
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public int hashCode() {
        return TileDrawStep.toHashCode(this.regionCoord, this.mapType, this.zoom, this.highQuality, this.sx1, this.sy1, this.sx2, this.sy2);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("rc", (Object)this.regionCoord).add("type", (Object)this.mapType).add("high", this.highQuality).add("zoom", (Object)this.zoom).add("sx1", this.sx1).add("sy1", this.sy1).toString();
    }

    boolean hasTexture(MapType mapType) {
        if (!Objects.equal((Object)this.mapType, (Object)mapType)) {
            return false;
        }
        if (this.highQuality) {
            return this.scaledTexture != null && this.scaledTexture.isBound();
        }
        return this.regionTextureHolder.getTexture().isBound();
    }

    private boolean updateRegionTexture() {
        this.updateRegionTimer.start();
        if (this.regionFuture != null) {
            if (!this.regionFuture.isDone()) {
                this.updateRegionTimer.stop();
                return true;
            }
            this.regionFuture = null;
        }
        if (this.regionTextureHolder.hasTexture()) {
            if (this.regionTextureHolder.getTexture().isBindNeeded()) {
                this.regionTextureHolder.getTexture().bindTexture();
            }
            this.updateRegionTimer.stop();
            return false;
        }
        this.regionFuture = TextureCache.instance().scheduleTextureTask(new Callable<TextureImpl>(){

            @Override
            public TextureImpl call() throws Exception {
                return TileDrawStep.this.regionTextureHolder.getTexture();
            }
        });
        this.updateRegionTimer.stop();
        return true;
    }

    private boolean updateScaledTexture() {
        this.updateScaledTimer.start();
        if (this.scaledFuture != null) {
            if (!this.scaledFuture.isDone()) {
                this.updateScaledTimer.stop();
                return true;
            }
            try {
                this.scaledTexture = this.scaledFuture.get();
                this.scaledTexture.bindTexture();
            }
            catch (Throwable e) {
                logger.error((Object)e);
            }
            this.scaledFuture = null;
            this.updateScaledTimer.stop();
            return false;
        }
        if (this.scaledTexture == null) {
            this.scaledFuture = TextureCache.instance().scheduleTextureTask(new Callable<TextureImpl>(){

                @Override
                public TextureImpl call() throws Exception {
                    TextureImpl temp = new TextureImpl(null, TileDrawStep.this.getScaledRegionArea(), false, false);
                    temp.setDescription("scaled for " + TileDrawStep.this);
                    return temp;
                }
            });
        } else if (this.scaledTexture.getLastImageUpdate() < this.regionTextureHolder.getImageTimestamp()) {
            final TextureImpl temp = this.scaledTexture;
            this.scaledFuture = TextureCache.instance().scheduleTextureTask(new Callable<TextureImpl>(){

                @Override
                public TextureImpl call() throws Exception {
                    temp.setImage(TileDrawStep.this.getScaledRegionArea(), false);
                    return temp;
                }
            });
        }
        this.updateScaledTimer.stop();
        return true;
    }

    public BufferedImage getScaledRegionArea() {
        int scale = (int)Math.pow(2.0, this.zoom.intValue());
        int scaledSize = 512 / scale;
        try {
            BufferedImage subImage = this.regionTextureHolder.getTexture().getImage().getSubimage(this.sx1, this.sy1, scaledSize, scaledSize);
            BufferedImage scaledImage = new BufferedImage(512, 512, 2);
            Graphics2D g = RegionImageHandler.initRenderingHints(scaledImage.createGraphics());
            g.drawImage(subImage, 0, 0, 512, 512, null);
            g.dispose();
            return scaledImage;
        }
        catch (Throwable e) {
            logger.error((Object)e);
            return null;
        }
    }
}

