/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.forge.event;

import com.google.common.base.Strings;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.feature.FeatureManager;
import net.techbrew.journeymap.forge.event.EventHandlerManager;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.ui.UIManager;

@SideOnly(value=Side.CLIENT)
public class ChatEventHandler
implements EventHandlerManager.EventHandler {
    Set<String> featureControlCodes = FeatureManager.instance().getControlCodes();

    @Override
    public EnumSet<EventHandlerManager.BusType> getBus() {
        return EnumSet.of(EventHandlerManager.BusType.MinecraftForgeBus);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void invoke(ClientChatReceivedEvent event) {
        if (event.message != null) {
            try {
                String text = event.message.func_150254_d();
                if (!Strings.isNullOrEmpty((String)text)) {
                    this.checkForControlCode(text.replaceAll(EnumChatFormatting.RESET.toString(), ""));
                }
            }
            catch (Exception e) {
                JourneyMap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
    }

    private void checkForControlCode(String text) {
        if (text.contains("\u00a7")) {
            boolean resetRequired = false;
            for (String code : this.featureControlCodes) {
                if (!text.contains(code)) continue;
                FeatureManager.instance().handleControlCode(code);
                resetRequired = true;
            }
            if (resetRequired) {
                DataCache.instance().purge();
                UIManager.getInstance().reset();
            }
        }
    }
}

