/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.cartography;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ColorPalette;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.io.IconLoader;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.model.BlockMD;
import net.techbrew.journeymap.model.ChunkMD;
import net.techbrew.journeymap.task.multi.MapPlayerTask;

public class ColorCache {
    private final HashMap<BlockMD, Color> baseColors = new HashMap(256);
    private final HashMap<String, HashMap<BlockMD, Color>> biomeColors = new HashMap(32);
    private volatile IconLoader iconLoader;
    private volatile ColorPalette currentPalette;
    private String lastResourcePackNames;
    private String lastModNames;

    private ColorCache() {
    }

    public static ColorCache instance() {
        return Holder.INSTANCE;
    }

    public void ensureCurrent() {
        if (FMLClientHandler.instance().getClient().field_71441_e == null) {
            this.reset();
        } else {
            String currentResourcePackNames = Constants.getResourcePackNames();
            String currentModNames = Constants.getModNames();
            boolean resourcePackSame = false;
            boolean modPackSame = false;
            if (currentResourcePackNames.equals(this.lastResourcePackNames) && this.iconLoader != null) {
                JourneyMap.getLogger().debug("Resource Pack(s) unchanged: " + currentResourcePackNames);
                resourcePackSame = true;
            }
            if (currentModNames.equals(this.lastModNames)) {
                JourneyMap.getLogger().debug("Mod Pack(s) unchanged: " + currentModNames);
                modPackSame = true;
            }
            if (!resourcePackSame || !modPackSame) {
                this.reset();
                this.lastResourcePackNames = currentResourcePackNames;
                this.lastModNames = currentModNames;
                DataCache.instance().resetBlockMetadata();
                JourneyMap.getLogger().info(String.format("Getting color palette for Resource Pack(s): %s", currentResourcePackNames));
                this.loadColorPalette();
                MapPlayerTask.forceNearbyRemap();
            }
        }
    }

    public ColorPalette getCurrentPalette() {
        return this.currentPalette;
    }

    private void initCacheFromPalette(ColorPalette colorPalette) {
        try {
            long start = System.currentTimeMillis();
            if (colorPalette != null) {
                this.baseColors.putAll(colorPalette.getBasicColorMap());
                this.biomeColors.putAll(colorPalette.getBiomeColorMap());
                long elapsed = System.currentTimeMillis() - start;
                JourneyMap.getLogger().info(String.format("Existing color palette loaded %d colors in %dms from file: %s", colorPalette.size(), elapsed, colorPalette.getOrigin()));
            }
        }
        catch (Exception e) {
            JourneyMap.getLogger().warn("Could not load color palette: " + e);
        }
    }

    private void loadColorPalette() {
        ColorPalette palette = ColorPalette.getActiveColorPalette();
        if (palette != null) {
            this.initCacheFromPalette(palette);
        } else {
            palette = this.generateColorPalette(true, false);
        }
        this.currentPalette = palette;
    }

    private ColorPalette generateColorPalette(boolean standard, boolean permanent) {
        long start = System.currentTimeMillis();
        this.prefetchResourcePackColors();
        ColorPalette palette = null;
        try {
            String resourcePackNames = Constants.getResourcePackNames();
            String modPackNames = Constants.getModNames();
            palette = new ColorPalette(resourcePackNames, modPackNames, this.baseColors, this.biomeColors);
            palette.setPermanent(permanent);
            palette.writeToFile(standard);
            long elapsed = System.currentTimeMillis() - start;
            JourneyMap.getLogger().info(String.format("New color palette generated with %d colors in %dms for: %s", palette.size(), elapsed, palette.getOrigin()));
            return palette;
        }
        catch (Exception e) {
            JourneyMap.getLogger().error("Couldn't create ColorPalette: " + LogFormatter.toString(e));
            return null;
        }
    }

    private void prefetchResourcePackColors() {
        StatTimer timer = StatTimer.get("prefetchResourcePackColors", -1).start();
        int count = 0;
        for (Block block : GameData.getBlockRegistry()) {
            if (block.func_149688_o().equals(Material.field_151579_a)) continue;
            ArrayList subBlocks = new ArrayList();
            try {
                Item item = Item.func_150898_a((Block)block);
                if (item == null) {
                    count += this.prefetchColors(DataCache.instance().getBlockMD(block, 0));
                    continue;
                }
                block.func_149666_a(item, null, subBlocks);
                for (ItemStack subBlockStack : subBlocks) {
                    int meta = subBlockStack.func_77960_j();
                    count += this.prefetchColors(DataCache.instance().getBlockMD(block, meta));
                }
            }
            catch (Exception e) {
                JourneyMap.getLogger().error("Couldn't get subblocks for block " + block + ": " + e);
                count += this.prefetchColors(DataCache.instance().getBlockMD(block, 0));
            }
        }
        timer.stop();
    }

    private int prefetchColors(BlockMD blockMD) {
        int count = 0;
        if (blockMD.isBiomeColored()) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null) continue;
                this.getBiomeBlockColor(biome, blockMD, 0, 64, 0);
                ++count;
            }
        } else {
            this.getBaseColor(blockMD, 0, 78, 0);
            ++count;
        }
        return count;
    }

    public Integer getBlockColor(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z) {
        if (this.iconLoader == null) {
            return null;
        }
        Color color = null;
        if (!blockMD.isBiomeColored()) {
            color = this.getBaseColor(blockMD, x, y, z);
        }
        if (blockMD.isBiomeColored()) {
            color = this.getBiomeBlockColor(chunkMd, blockMD, x, y, z);
        }
        return color.getRGB();
    }

    private Color getBiomeBlockColor(ChunkMD chunkMd, BlockMD blockMD, int x, int y, int z) {
        BiomeGenBase biome = chunkMd.getChunk().func_76591_a(x, z, chunkMd.getWorldObj().func_72959_q());
        return this.getBiomeBlockColor(biome, blockMD, x, y, z);
    }

    public Color getBiomeBlockColor(BiomeGenBase biome, BlockMD blockMD, int x, int y, int z) {
        Block block = blockMD.getBlock();
        if (block instanceof BlockGrass || block instanceof BlockTallGrass || block instanceof BlockDoublePlant) {
            return this.getGrassColor(blockMD, biome, x, y, z);
        }
        if (blockMD.isWater()) {
            return this.getWaterColor(blockMD, biome, x, y, z);
        }
        if (blockMD.isFoliage() || block instanceof BlockVine) {
            return this.getFoliageColor(blockMD, biome, x, y, z);
        }
        return this.getCustomBiomeColor(blockMD, biome, x, y, z);
    }

    private Color getCustomBiomeColor(BlockMD blockMD, BiomeGenBase biome, int x, int y, int z) {
        Color color = this.getBiomeColor(blockMD, biome);
        if (color == null) {
            color = this.getBaseColor(blockMD, x, y, z);
            int tint = this.getBiomeColorMultiplier(blockMD, x, y, z);
            if (tint != 0xFFFFFF && tint != -1) {
                color = this.colorMultiplier(color, tint);
                JourneyMap.getLogger().debug("Custom biome tint set for " + blockMD + " in " + biome.field_76791_y);
            } else {
                JourneyMap.getLogger().debug("Custom biome tint not found for " + blockMD + " in " + biome.field_76791_y);
            }
            this.putBiomeColor(blockMD, biome, color);
        }
        return color;
    }

    private Color getFoliageColor(BlockMD blockMD, BiomeGenBase biome, int x, int y, int z) {
        Color color = this.getBiomeColor(blockMD, biome);
        if (color == null) {
            int leafColor = blockMD.getBlock().func_149741_i(blockMD.meta);
            int biomeColor = BiomeGenBase.field_76772_c.func_150571_c(x, y, z);
            try {
                biomeColor = biome.func_150571_c(x, y, z);
            }
            catch (Throwable t) {
                blockMD.addFlags(BlockMD.Flag.Error);
                JourneyMap.getLogger().error("Couldn't get biome foliage color: " + LogFormatter.toString(t));
            }
            int leafTimesBiome = this.colorMultiplier(biomeColor, leafColor);
            int darker = this.colorMultiplier(leafTimesBiome, -5592406);
            color = new Color(darker);
            this.putBiomeColor(blockMD, biome, color);
        }
        return color;
    }

    private Color getGrassColor(BlockMD blockMD, BiomeGenBase biome, int x, int y, int z) {
        Color color = this.getBiomeColor(blockMD, biome);
        if (color == null) {
            Color baseColor = this.getBaseColor(blockMD, x, y, z);
            int biomeColor = BiomeGenBase.field_76772_c.func_150558_b(x, y, z);
            try {
                biomeColor = biome.func_150558_b(x, y, z);
            }
            catch (Throwable t) {
                blockMD.addFlags(BlockMD.Flag.Error);
                JourneyMap.getLogger().error("Couldn't get biome grass color: " + LogFormatter.toString(t));
            }
            color = this.colorMultiplier(baseColor, biomeColor);
            this.putBiomeColor(blockMD, biome, color);
        }
        return color;
    }

    private Color getWaterColor(BlockMD blockMD, BiomeGenBase biome, int x, int y, int z) {
        Color color = this.getBiomeColor(blockMD, biome);
        if (color == null) {
            color = this.colorMultiplier(this.getBaseColor(blockMD, x, y, z), biome.field_76759_H);
            this.putBiomeColor(blockMD, biome, color);
        }
        return color;
    }

    private int getBiomeColorMultiplier(BlockMD blockMD, int x, int y, int z) {
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        try {
            return blockMD.getBlock().func_149720_d((IBlockAccess)world, x, 78, z) | 0xFF000000;
        }
        catch (NullPointerException e) {
            JourneyMap.getLogger().warn("Block throws NullPointerException when calling colorMultiplier(): " + blockMD.getBlock().func_149739_a());
            return 0xFFFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<BlockMD, Color> getBiomeColorMap(BiomeGenBase biome) {
        HashMap<String, HashMap<BlockMD, Color>> hashMap = this.biomeColors;
        synchronized (hashMap) {
            HashMap<BlockMD, Color> biomeColorMap = this.biomeColors.get(biome.field_76791_y);
            if (biomeColorMap == null) {
                biomeColorMap = new HashMap(16);
                this.biomeColors.put(biome.field_76791_y, biomeColorMap);
            }
            return biomeColorMap;
        }
    }

    private Color getBiomeColor(BlockMD blockMD, BiomeGenBase biome) {
        return this.getBiomeColorMap(biome).get(blockMD);
    }

    private void putBiomeColor(BlockMD blockMD, BiomeGenBase biome, Color color) {
        this.getBiomeColorMap(biome).put(blockMD, color);
    }

    private Color getBaseColor(BlockMD blockMD, int x, int y, int z) {
        Color color = this.baseColors.get(blockMD);
        if (color == null) {
            if (blockMD.isAir()) {
                color = Color.white;
                blockMD.setAlpha(0.0f);
                blockMD.addFlags(BlockMD.Flag.HasAir, BlockMD.Flag.OpenToSky, BlockMD.Flag.NoShadow);
            } else {
                color = this.loadBaseColor(blockMD, x, y, z);
            }
            this.baseColors.put(blockMD, color);
        }
        return color;
    }

    private Color loadBaseColor(BlockMD blockMD, int x, int y, int z) {
        Color baseColor = null;
        baseColor = this.iconLoader.loadBlockColor(blockMD);
        if (baseColor != null && !blockMD.isBiomeColored()) {
            int tint = this.getBiomeColorMultiplier(blockMD, x, y, z);
            if (tint != 0xFFFFFF && tint != -1) {
                blockMD.addFlags(BlockMD.Flag.CustomBiomeColor);
                DataCache.instance().getBlockMetadata().setFlags(blockMD.getBlock(), BlockMD.Flag.BiomeColor);
                JourneyMap.getLogger().debug("Custom biome tint discovered for " + blockMD);
            } else {
                int renderColor = blockMD.getBlock().func_149741_i(blockMD.meta & 0xF);
                if (renderColor != 0xFFFFFF && renderColor != -1) {
                    baseColor = this.colorMultiplier(baseColor, 0xFF000000 | renderColor);
                    JourneyMap.getLogger().debug("Applied render color for " + blockMD);
                }
            }
        }
        if (baseColor == null) {
            baseColor = Color.BLACK;
            if (!blockMD.hasFlag(BlockMD.Flag.TileEntity)) {
                if (this.iconLoader.failedFor(blockMD)) {
                    JourneyMap.getLogger().warn("Iconloader failed to get base color for " + blockMD);
                } else {
                    JourneyMap.getLogger().warn("Unknown failure, could not get base color for " + blockMD);
                }
            }
        }
        return baseColor;
    }

    public void reset() {
        this.iconLoader = new IconLoader();
        this.biomeColors.clear();
        this.baseColors.clear();
    }

    public String getCacheDebugHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append(LogFormatter.LINEBREAK).append("<!-- color cache --><div>");
        sb.append(LogFormatter.LINEBREAK).append("<b>Current Resource Packs: </b>").append(this.lastResourcePackNames);
        sb.append(LogFormatter.LINEBREAK).append("<table><tr valign='top'><td width='50%'>");
        sb.append(this.debugCache(DataCache.instance().getBlockMetadata().getAlphaMap(), "Block Transparency"));
        sb.append(LogFormatter.LINEBREAK).append("</td><td>");
        sb.append(LogFormatter.LINEBREAK).append(this.debugCache(DataCache.instance().getBlockMetadata().getFlagsMap(), "Block Flags"));
        sb.append(LogFormatter.LINEBREAK).append("</td></tr></table>");
        sb.append(LogFormatter.LINEBREAK).append("</div><!-- /color cache -->");
        return sb.toString();
    }

    private String debugCache(HashMap cache, String name) {
        if (cache.isEmpty()) {
            return "";
        }
        ArrayList keyList = new ArrayList(cache.keySet());
        Collections.sort(keyList, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        String biome = null;
        StringBuilder sb = new StringBuilder().append(LogFormatter.LINEBREAK).append("<h2>").append(name).append("</h2><div>");
        for (Object key : keyList) {
            String info;
            Object value = cache.get(key);
            if (key instanceof BlockMD) {
                info = ((BlockMD)key).getName();
            } else {
                info = key.toString();
                if (info.indexOf("|") >= 0) {
                    String[] infoSplit = info.split("\\|");
                    if (!infoSplit[0].equals(biome)) {
                        biome = infoSplit[0];
                        sb.append("<h3>").append(biome).append("</h3>");
                    }
                    info = infoSplit[1];
                }
            }
            if (value instanceof Color) {
                Color color = (Color)value;
                String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                sb.append(LogFormatter.LINEBREAK).append("<span class='entry' title='").append(hex).append("'>");
                sb.append("<span class='rgb' style='background-color:").append(hex).append("'></span>");
                sb.append(info).append("</span>");
                continue;
            }
            if (value instanceof Number) {
                if (Double.parseDouble(value.toString()) == 1.0) continue;
                sb.append(LogFormatter.LINEBREAK).append("<div class='other'><b>").append(info).append("</b>: ");
                sb.append(value).append("</div>");
                continue;
            }
            sb.append(LogFormatter.LINEBREAK).append("<div class='other'><b>").append(info).append("</b>: ");
            sb.append(value).append("</div>");
        }
        sb.append(LogFormatter.LINEBREAK).append("</div><!-- /").append(name).append(" -->");
        return sb.toString();
    }

    Color colorMultiplier(Color color, int mult) {
        return new Color(this.colorMultiplier(color.getRGB(), mult));
    }

    int colorMultiplier(int rgb, int mult) {
        int alpha1 = rgb >> 24 & 0xFF;
        int red1 = rgb >> 16 & 0xFF;
        int green1 = rgb >> 8 & 0xFF;
        int blue1 = rgb & 0xFF;
        int alpha2 = mult >> 24 & 0xFF;
        int red2 = mult >> 16 & 0xFF;
        int green2 = mult >> 8 & 0xFF;
        int blue2 = mult & 0xFF;
        int alpha = alpha1 * alpha2 / 255;
        int red = red1 * red2 / 255;
        int green = green1 * green2 / 255;
        int blue = blue1 * blue2 / 255;
        int result = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        return result | 0xFF000000;
    }

    private static class Holder {
        private static final ColorCache INSTANCE = new ColorCache();

        private Holder() {
        }
    }
}

