/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import pro.gravit.repackage.io.netty.resolver.HostsFileEntriesProvider;
import pro.gravit.repackage.io.netty.resolver.HostsFileEntriesProvider$Parser;
import pro.gravit.repackage.io.netty.util.NetUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

final class HostsFileEntriesProvider$ParserImpl
implements HostsFileEntriesProvider$Parser {
    private static final String WINDOWS_DEFAULT_SYSTEM_ROOT = "C:\\Windows";
    private static final String WINDOWS_HOSTS_FILE_RELATIVE_PATH = "\\system32\\drivers\\etc\\hosts";
    private static final String X_PLATFORMS_HOSTS_FILE_PATH = "/etc/hosts";
    private static final Pattern WHITESPACES = Pattern.compile("[ \t]+");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HostsFileEntriesProvider$Parser.class);
    static final HostsFileEntriesProvider$ParserImpl INSTANCE = new HostsFileEntriesProvider$ParserImpl();

    private HostsFileEntriesProvider$ParserImpl() {
    }

    @Override
    public HostsFileEntriesProvider parse() {
        return this.parse(HostsFileEntriesProvider$ParserImpl.locateHostsFile(), Charset.defaultCharset());
    }

    @Override
    public HostsFileEntriesProvider parse(Charset ... charsetArray) {
        return this.parse(HostsFileEntriesProvider$ParserImpl.locateHostsFile(), charsetArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostsFileEntriesProvider parse(File file, Charset ... charsetArray) {
        ObjectUtil.checkNotNull(file, "file");
        ObjectUtil.checkNotNull(charsetArray, "charsets");
        if (charsetArray.length == 0) {
            charsetArray = new Charset[]{Charset.defaultCharset()};
        }
        if (file.exists() && file.isFile()) {
            for (Charset charset : charsetArray) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
                try {
                    HostsFileEntriesProvider hostsFileEntriesProvider = this.parse(bufferedReader);
                    if (hostsFileEntriesProvider == HostsFileEntriesProvider.EMPTY) continue;
                    HostsFileEntriesProvider hostsFileEntriesProvider2 = hostsFileEntriesProvider;
                    return hostsFileEntriesProvider2;
                }
                finally {
                    bufferedReader.close();
                }
            }
        }
        return HostsFileEntriesProvider.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostsFileEntriesProvider parse(Reader reader) {
        ObjectUtil.checkNotNull(reader, "reader");
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string;
            HashMap<String, List<InetAddress>> hashMap = new HashMap<String, List<InetAddress>>();
            HashMap<String, List<InetAddress>> hashMap2 = new HashMap<String, List<InetAddress>>();
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                int n = string.indexOf(35);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if ((string = string.trim()).isEmpty()) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                Object[] objectArray = WHITESPACES.split(string);
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    string2 = objectArray[i];
                    if (string2.isEmpty()) continue;
                    arrayList.add(string2);
                }
                if (arrayList.size() < 2 || (objectArray = (Object[])NetUtil.createByteArrayFromIpAddressString((String)arrayList.get(0))) == null) continue;
                for (n2 = 1; n2 < arrayList.size(); ++n2) {
                    List<InetAddress> list;
                    String string3 = (String)arrayList.get(n2);
                    string2 = string3.toLowerCase(Locale.ENGLISH);
                    InetAddress inetAddress = InetAddress.getByAddress(string3, (byte[])objectArray);
                    if (inetAddress instanceof Inet4Address) {
                        list = (ArrayList<InetAddress>)hashMap.get(string2);
                        if (list == null) {
                            list = new ArrayList<InetAddress>();
                            hashMap.put(string2, list);
                        }
                    } else {
                        list = (List)hashMap2.get(string2);
                        if (list == null) {
                            list = new ArrayList();
                            hashMap2.put(string2, list);
                        }
                    }
                    list.add(inetAddress);
                }
            }
            HostsFileEntriesProvider hostsFileEntriesProvider = hashMap.isEmpty() && hashMap2.isEmpty() ? HostsFileEntriesProvider.EMPTY : new HostsFileEntriesProvider(hashMap, hashMap2);
            return hostsFileEntriesProvider;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close a reader", iOException);
            }
        }
    }

    @Override
    public HostsFileEntriesProvider parseSilently() {
        return this.parseSilently(HostsFileEntriesProvider$ParserImpl.locateHostsFile(), Charset.defaultCharset());
    }

    @Override
    public HostsFileEntriesProvider parseSilently(Charset ... charsetArray) {
        return this.parseSilently(HostsFileEntriesProvider$ParserImpl.locateHostsFile(), charsetArray);
    }

    @Override
    public HostsFileEntriesProvider parseSilently(File file, Charset ... charsetArray) {
        try {
            return this.parse(file, charsetArray);
        }
        catch (IOException iOException) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to load and parse hosts file at " + file.getPath(), iOException);
            }
            return HostsFileEntriesProvider.EMPTY;
        }
    }

    private static File locateHostsFile() {
        File file;
        if (PlatformDependent.isWindows()) {
            file = new File(System.getenv("SystemRoot") + WINDOWS_HOSTS_FILE_RELATIVE_PATH);
            if (!file.exists()) {
                file = new File("C:\\Windows\\system32\\drivers\\etc\\hosts");
            }
        } else {
            file = new File(X_PLATFORMS_HOSTS_FILE_PATH);
        }
        return file;
    }
}

