/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.channel.AbstractCoalescingBufferQueue;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

abstract class SslHandlerCoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final boolean wantsDirectBuffer;

    SslHandlerCoalescingBufferQueue(Channel channel, int n, boolean bl) {
        super(channel, n);
        this.wantsDirectBuffer = bl;
    }

    protected abstract int wrapDataSize();

    @Override
    protected ByteBuf compose(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
        return SslHandlerCoalescingBufferQueue.attemptCopyToCumulation(byteBuf, byteBuf2, this.wrapDataSize()) ? byteBuf : this.copyAndCompose(byteBufAllocator, byteBuf, byteBuf2);
    }

    @Override
    protected ByteBuf composeFirst(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n) {
        ByteBuf byteBuf2 = this.wantsDirectBuffer ? byteBufAllocator.directBuffer(n) : byteBufAllocator.heapBuffer(n);
        try {
            byteBuf2.writeBytes(byteBuf);
        }
        catch (Throwable throwable) {
            byteBuf2.release();
            PlatformDependent.throwException(throwable);
        }
        assert (!byteBuf.isReadable());
        byteBuf.release();
        return byteBuf2;
    }

    @Override
    protected ByteBuf removeEmptyValue() {
        return null;
    }

    private static boolean attemptCopyToCumulation(ByteBuf byteBuf, ByteBuf byteBuf2, int n) {
        int n2 = byteBuf2.readableBytes();
        if (n2 == 0) {
            byteBuf2.release();
            return true;
        }
        int n3 = byteBuf.capacity();
        if (n - byteBuf.readableBytes() >= n2 && (byteBuf.isWritable(n2) && n3 >= n || n3 < n && ByteBufUtil.ensureWritableSuccess(byteBuf.ensureWritable(n2, false)))) {
            byteBuf.writeBytes(byteBuf2);
            byteBuf2.release();
            return true;
        }
        return false;
    }
}

