/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslClientSessionCache$HostPort;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSession;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionCache;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionCache$NativeSslSession;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;

final class OpenSslClientSessionCache
extends OpenSslSessionCache {
    private final Map<OpenSslClientSessionCache$HostPort, Set<OpenSslSessionCache$NativeSslSession>> sessions = new HashMap<OpenSslClientSessionCache$HostPort, Set<OpenSslSessionCache$NativeSslSession>>();

    OpenSslClientSessionCache(OpenSslEngineMap openSslEngineMap) {
        super(openSslEngineMap);
    }

    @Override
    protected boolean sessionCreated(OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession) {
        assert (Thread.holdsLock(this));
        OpenSslClientSessionCache$HostPort openSslClientSessionCache$HostPort = OpenSslClientSessionCache.keyFor(openSslSessionCache$NativeSslSession.getPeerHost(), openSslSessionCache$NativeSslSession.getPeerPort());
        if (openSslClientSessionCache$HostPort == null) {
            return false;
        }
        Set<OpenSslSessionCache$NativeSslSession> set = this.sessions.get(openSslClientSessionCache$HostPort);
        if (set == null) {
            set = new HashSet<OpenSslSessionCache$NativeSslSession>(4);
            this.sessions.put(openSslClientSessionCache$HostPort, set);
        }
        set.add(openSslSessionCache$NativeSslSession);
        return true;
    }

    @Override
    protected void sessionRemoved(OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession) {
        assert (Thread.holdsLock(this));
        OpenSslClientSessionCache$HostPort openSslClientSessionCache$HostPort = OpenSslClientSessionCache.keyFor(openSslSessionCache$NativeSslSession.getPeerHost(), openSslSessionCache$NativeSslSession.getPeerPort());
        if (openSslClientSessionCache$HostPort == null) {
            return;
        }
        Set<OpenSslSessionCache$NativeSslSession> set = this.sessions.get(openSslClientSessionCache$HostPort);
        if (set != null) {
            set.remove(openSslSessionCache$NativeSslSession);
            if (set.isEmpty()) {
                this.sessions.remove(openSslClientSessionCache$HostPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean setSession(long l, OpenSslSession openSslSession, String string, int n) {
        boolean bl;
        OpenSslClientSessionCache$HostPort openSslClientSessionCache$HostPort = OpenSslClientSessionCache.keyFor(string, n);
        if (openSslClientSessionCache$HostPort == null) {
            return false;
        }
        OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession = null;
        boolean bl2 = false;
        OpenSslClientSessionCache openSslClientSessionCache = this;
        synchronized (openSslClientSessionCache) {
            Set<OpenSslSessionCache$NativeSslSession> set = this.sessions.get(openSslClientSessionCache$HostPort);
            if (set == null) {
                return false;
            }
            if (set.isEmpty()) {
                this.sessions.remove(openSslClientSessionCache$HostPort);
                return false;
            }
            ArrayList<OpenSslSessionCache$NativeSslSession> arrayList = null;
            for (OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession2 : set) {
                if (openSslSessionCache$NativeSslSession2.isValid()) {
                    openSslSessionCache$NativeSslSession = openSslSessionCache$NativeSslSession2;
                    break;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<OpenSslSessionCache$NativeSslSession>(2);
                }
                arrayList.add(openSslSessionCache$NativeSslSession2);
            }
            if (arrayList != null) {
                for (OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession2 : arrayList) {
                    this.removeSessionWithId(openSslSessionCache$NativeSslSession2.sessionId());
                }
            }
            if (openSslSessionCache$NativeSslSession == null) {
                return false;
            }
            bl = SSL.setSession((long)l, (long)openSslSessionCache$NativeSslSession.session());
            if (bl) {
                bl2 = openSslSessionCache$NativeSslSession.shouldBeSingleUse();
            }
        }
        if (bl) {
            if (bl2) {
                openSslSessionCache$NativeSslSession.invalidate();
                openSslSession.invalidate();
            }
            openSslSessionCache$NativeSslSession.setLastAccessedTime(System.currentTimeMillis());
            openSslSession.setSessionDetails(openSslSessionCache$NativeSslSession.getCreationTime(), openSslSessionCache$NativeSslSession.getLastAccessedTime(), openSslSessionCache$NativeSslSession.sessionId(), openSslSessionCache$NativeSslSession.keyValueStorage);
        }
        return bl;
    }

    private static OpenSslClientSessionCache$HostPort keyFor(String string, int n) {
        if (string == null && n < 1) {
            return null;
        }
        return new OpenSslClientSessionCache$HostPort(string, n);
    }

    @Override
    synchronized void clear() {
        super.clear();
        this.sessions.clear();
    }
}

