/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpConstants;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.Attribute;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.FileUpload;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpDataFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$TransferEncodingMechanism;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$EncoderMode;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$ErrorDataEncoderException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$WrappedFullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder$WrappedHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InternalAttribute;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedInput;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public class HttpPostRequestEncoder
implements ChunkedInput<HttpContent> {
    private static final Map.Entry[] percentEncodings = new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("\\*"), "%2A"), new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("\\+"), "%20"), new AbstractMap.SimpleImmutableEntry<Pattern, String>(Pattern.compile("~"), "%7E")};
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isChunked;
    private final List<InterfaceHttpData> bodyListDatas;
    final List<InterfaceHttpData> multipartHttpDatas;
    private final boolean isMultipart;
    String multipartDataBoundary;
    String multipartMixedBoundary;
    private boolean headerFinalized;
    private final HttpPostRequestEncoder$EncoderMode encoderMode;
    private boolean isLastChunk;
    private boolean isLastChunkSent;
    private FileUpload currentFileUpload;
    private boolean duringMixedMode;
    private long globalBodySize;
    private long globalProgress;
    private ListIterator<InterfaceHttpData> iterator;
    private ByteBuf currentBuffer;
    private InterfaceHttpData currentData;
    private boolean isKey = true;

    public HttpPostRequestEncoder(HttpRequest httpRequest, boolean bl) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, bl, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder$EncoderMode.RFC1738);
    }

    public HttpPostRequestEncoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, boolean bl) {
        this(httpDataFactory, httpRequest, bl, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder$EncoderMode.RFC1738);
    }

    public HttpPostRequestEncoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, boolean bl, Charset charset, HttpPostRequestEncoder$EncoderMode httpPostRequestEncoder$EncoderMode) {
        this.request = ObjectUtil.checkNotNull(httpRequest, "request");
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.factory = ObjectUtil.checkNotNull(httpDataFactory, "factory");
        if (HttpMethod.TRACE.equals(httpRequest.method())) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException("Cannot create a Encoder if request is a TRACE");
        }
        this.bodyListDatas = new ArrayList<InterfaceHttpData>();
        this.isLastChunk = false;
        this.isLastChunkSent = false;
        this.isMultipart = bl;
        this.multipartHttpDatas = new ArrayList<InterfaceHttpData>();
        this.encoderMode = httpPostRequestEncoder$EncoderMode;
        if (this.isMultipart) {
            this.initDataMultipart();
        }
    }

    public void cleanFiles() {
        this.factory.cleanRequestHttpData(this.request);
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    private void initDataMultipart() {
        this.multipartDataBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private void initMixedMultipart() {
        this.multipartMixedBoundary = HttpPostRequestEncoder.getNewMultipartDelimiter();
    }

    private static String getNewMultipartDelimiter() {
        return Long.toHexString(PlatformDependent.threadLocalRandom().nextLong());
    }

    public List<InterfaceHttpData> getBodyListAttributes() {
        return this.bodyListDatas;
    }

    public void setBodyHttpDatas(List<InterfaceHttpData> list) {
        ObjectUtil.checkNotNull(list, "datas");
        this.globalBodySize = 0L;
        this.bodyListDatas.clear();
        this.currentFileUpload = null;
        this.duringMixedMode = false;
        this.multipartHttpDatas.clear();
        for (InterfaceHttpData interfaceHttpData : list) {
            this.addBodyHttpData(interfaceHttpData);
        }
    }

    public void addBodyAttribute(String string, String string2) {
        String string3 = string2 != null ? string2 : "";
        Attribute attribute = this.factory.createAttribute(this.request, ObjectUtil.checkNotNull(string, "name"), string3);
        this.addBodyHttpData(attribute);
    }

    public void addBodyFileUpload(String string, File file, String string2, boolean bl) {
        this.addBodyFileUpload(string, file.getName(), file, string2, bl);
    }

    public void addBodyFileUpload(String string, String string2, File file, String string3, boolean bl) {
        ObjectUtil.checkNotNull(string, "name");
        ObjectUtil.checkNotNull(file, "file");
        if (string2 == null) {
            string2 = "";
        }
        String string4 = string3;
        String string5 = null;
        if (string3 == null) {
            string4 = bl ? "text/plain" : "application/octet-stream";
        }
        if (!bl) {
            string5 = HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value();
        }
        FileUpload fileUpload = this.factory.createFileUpload(this.request, string, string2, string4, string5, null, file.length());
        try {
            fileUpload.setContent(file);
        }
        catch (IOException iOException) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException(iOException);
        }
        this.addBodyHttpData(fileUpload);
    }

    public void addBodyFileUploads(String string, File[] fileArray, String[] stringArray, boolean[] blArray) {
        if (fileArray.length != stringArray.length && fileArray.length != blArray.length) {
            throw new IllegalArgumentException("Different array length");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.addBodyFileUpload(string, fileArray[i], stringArray[i], blArray[i]);
        }
    }

    public void addBodyHttpData(InterfaceHttpData interfaceHttpData) {
        if (this.headerFinalized) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException("Cannot add value once finalized");
        }
        this.bodyListDatas.add(ObjectUtil.checkNotNull(interfaceHttpData, "data"));
        if (!this.isMultipart) {
            if (interfaceHttpData instanceof Attribute) {
                Attribute attribute = (Attribute)interfaceHttpData;
                try {
                    String string = this.encodeAttribute(attribute.getName(), this.charset);
                    String string2 = this.encodeAttribute(attribute.getValue(), this.charset);
                    Attribute attribute2 = this.factory.createAttribute(this.request, string, string2);
                    this.multipartHttpDatas.add(attribute2);
                    this.globalBodySize += (long)(attribute2.getName().length() + 1) + attribute2.length() + 1L;
                }
                catch (IOException iOException) {
                    throw new HttpPostRequestEncoder$ErrorDataEncoderException(iOException);
                }
            } else if (interfaceHttpData instanceof FileUpload) {
                FileUpload fileUpload = (FileUpload)interfaceHttpData;
                String string = this.encodeAttribute(fileUpload.getName(), this.charset);
                String string3 = this.encodeAttribute(fileUpload.getFilename(), this.charset);
                Attribute attribute = this.factory.createAttribute(this.request, string, string3);
                this.multipartHttpDatas.add(attribute);
                this.globalBodySize += (long)(attribute.getName().length() + 1) + attribute.length() + 1L;
            }
            return;
        }
        if (interfaceHttpData instanceof Attribute) {
            InternalAttribute internalAttribute;
            if (this.duringMixedMode) {
                internalAttribute = new InternalAttribute(this.charset);
                internalAttribute.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                this.multipartHttpDatas.add(internalAttribute);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
            }
            internalAttribute = new InternalAttribute(this.charset);
            if (!this.multipartHttpDatas.isEmpty()) {
                internalAttribute.addValue("\r\n");
            }
            internalAttribute.addValue("--" + this.multipartDataBoundary + "\r\n");
            Attribute attribute = (Attribute)interfaceHttpData;
            internalAttribute.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + attribute.getName() + "\"\r\n");
            internalAttribute.addValue(HttpHeaderNames.CONTENT_LENGTH + ": " + attribute.length() + "\r\n");
            Charset charset = attribute.getCharset();
            if (charset != null) {
                internalAttribute.addValue(HttpHeaderNames.CONTENT_TYPE + ": " + "text/plain" + "; " + HttpHeaderValues.CHARSET + '=' + charset.name() + "\r\n");
            }
            internalAttribute.addValue("\r\n");
            this.multipartHttpDatas.add(internalAttribute);
            this.multipartHttpDatas.add(interfaceHttpData);
            this.globalBodySize += attribute.length() + (long)internalAttribute.size();
        } else if (interfaceHttpData instanceof FileUpload) {
            Object object;
            boolean bl;
            FileUpload fileUpload = (FileUpload)interfaceHttpData;
            InternalAttribute internalAttribute = new InternalAttribute(this.charset);
            if (!this.multipartHttpDatas.isEmpty()) {
                internalAttribute.addValue("\r\n");
            }
            if (this.duringMixedMode) {
                if (this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                    bl = true;
                } else {
                    internalAttribute.addValue("--" + this.multipartMixedBoundary + "--");
                    this.multipartHttpDatas.add(internalAttribute);
                    this.multipartMixedBoundary = null;
                    internalAttribute = new InternalAttribute(this.charset);
                    internalAttribute.addValue("\r\n");
                    bl = false;
                    this.currentFileUpload = fileUpload;
                    this.duringMixedMode = false;
                }
            } else if (this.encoderMode != HttpPostRequestEncoder$EncoderMode.HTML5 && this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                this.initMixedMultipart();
                object = (InternalAttribute)this.multipartHttpDatas.get(this.multipartHttpDatas.size() - 2);
                this.globalBodySize -= (long)((InternalAttribute)object).size();
                StringBuilder stringBuilder = new StringBuilder(139 + this.multipartDataBoundary.length() + this.multipartMixedBoundary.length() * 2 + fileUpload.getFilename().length() + fileUpload.getName().length()).append("--").append(this.multipartDataBoundary).append("\r\n").append(HttpHeaderNames.CONTENT_DISPOSITION).append(": ").append(HttpHeaderValues.FORM_DATA).append("; ").append(HttpHeaderValues.NAME).append("=\"").append(fileUpload.getName()).append("\"\r\n").append(HttpHeaderNames.CONTENT_TYPE).append(": ").append(HttpHeaderValues.MULTIPART_MIXED).append("; ").append(HttpHeaderValues.BOUNDARY).append('=').append(this.multipartMixedBoundary).append("\r\n\r\n").append("--").append(this.multipartMixedBoundary).append("\r\n").append(HttpHeaderNames.CONTENT_DISPOSITION).append(": ").append(HttpHeaderValues.ATTACHMENT);
                if (!fileUpload.getFilename().isEmpty()) {
                    stringBuilder.append("; ").append(HttpHeaderValues.FILENAME).append("=\"").append(this.currentFileUpload.getFilename()).append('\"');
                }
                stringBuilder.append("\r\n");
                ((InternalAttribute)object).setValue(stringBuilder.toString(), 1);
                ((InternalAttribute)object).setValue("", 2);
                this.globalBodySize += (long)((InternalAttribute)object).size();
                bl = true;
                this.duringMixedMode = true;
            } else {
                bl = false;
                this.currentFileUpload = fileUpload;
                this.duringMixedMode = false;
            }
            if (bl) {
                internalAttribute.addValue("--" + this.multipartMixedBoundary + "\r\n");
                if (fileUpload.getFilename().isEmpty()) {
                    internalAttribute.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.ATTACHMENT + "\r\n");
                } else {
                    internalAttribute.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.ATTACHMENT + "; " + HttpHeaderValues.FILENAME + "=\"" + fileUpload.getFilename() + "\"\r\n");
                }
            } else {
                internalAttribute.addValue("--" + this.multipartDataBoundary + "\r\n");
                if (fileUpload.getFilename().isEmpty()) {
                    internalAttribute.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + fileUpload.getName() + "\"\r\n");
                } else {
                    internalAttribute.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + fileUpload.getName() + "\"; " + HttpHeaderValues.FILENAME + "=\"" + fileUpload.getFilename() + "\"\r\n");
                }
            }
            internalAttribute.addValue(HttpHeaderNames.CONTENT_LENGTH + ": " + fileUpload.length() + "\r\n");
            internalAttribute.addValue(HttpHeaderNames.CONTENT_TYPE + ": " + fileUpload.getContentType());
            object = fileUpload.getContentTransferEncoding();
            if (object != null && ((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value())) {
                internalAttribute.addValue("\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": " + HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value() + "\r\n\r\n");
            } else if (fileUpload.getCharset() != null) {
                internalAttribute.addValue("; " + HttpHeaderValues.CHARSET + '=' + fileUpload.getCharset().name() + "\r\n\r\n");
            } else {
                internalAttribute.addValue("\r\n\r\n");
            }
            this.multipartHttpDatas.add(internalAttribute);
            this.multipartHttpDatas.add(interfaceHttpData);
            this.globalBodySize += fileUpload.length() + (long)internalAttribute.size();
        }
    }

    public HttpRequest finalizeRequest() {
        Object object;
        Object object2;
        if (!this.headerFinalized) {
            if (this.isMultipart) {
                object2 = new InternalAttribute(this.charset);
                if (this.duringMixedMode) {
                    ((InternalAttribute)object2).addValue("\r\n--" + this.multipartMixedBoundary + "--");
                }
                ((InternalAttribute)object2).addValue("\r\n--" + this.multipartDataBoundary + "--\r\n");
                this.multipartHttpDatas.add((InterfaceHttpData)object2);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
                this.globalBodySize += (long)((InternalAttribute)object2).size();
            }
        } else {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException("Header already encoded");
        }
        this.headerFinalized = true;
        object2 = this.request.headers();
        List<String> list = ((HttpHeaders)object2).getAll(HttpHeaderNames.CONTENT_TYPE);
        List<String> list2 = ((HttpHeaders)object2).getAll(HttpHeaderNames.TRANSFER_ENCODING);
        if (list != null) {
            ((HttpHeaders)object2).remove(HttpHeaderNames.CONTENT_TYPE);
            for (String string : list) {
                object = string.toLowerCase();
                if (((String)object).startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString()) || ((String)object).startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString())) continue;
                ((HttpHeaders)object2).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)string);
            }
        }
        if (this.isMultipart) {
            String string = HttpHeaderValues.MULTIPART_FORM_DATA + "; " + HttpHeaderValues.BOUNDARY + '=' + this.multipartDataBoundary;
            ((HttpHeaders)object2).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)string);
        } else {
            ((HttpHeaders)object2).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
        }
        long l = this.globalBodySize;
        if (!this.isMultipart) {
            --l;
        }
        this.iterator = this.multipartHttpDatas.listIterator();
        ((HttpHeaders)object2).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(l));
        if (l > 8096L || this.isMultipart) {
            this.isChunked = true;
            if (list2 != null) {
                ((HttpHeaders)object2).remove(HttpHeaderNames.TRANSFER_ENCODING);
                for (CharSequence charSequence : list2) {
                    if (HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(charSequence)) continue;
                    ((HttpHeaders)object2).add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)charSequence);
                }
            }
            HttpUtil.setTransferEncodingChunked(this.request, true);
            return new HttpPostRequestEncoder$WrappedHttpRequest(this.request);
        }
        object = this.nextChunk();
        if (this.request instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)this.request;
            ByteBuf byteBuf = object.content();
            if (fullHttpRequest.content() != byteBuf) {
                fullHttpRequest.content().clear().writeBytes(byteBuf);
                byteBuf.release();
            }
            return fullHttpRequest;
        }
        return new HttpPostRequestEncoder$WrappedFullHttpRequest(this.request, (HttpContent)object);
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    private String encodeAttribute(String string, Charset charset) {
        if (string == null) {
            return "";
        }
        try {
            String string2 = URLEncoder.encode(string, charset.name());
            if (this.encoderMode == HttpPostRequestEncoder$EncoderMode.RFC3986) {
                for (Map.Entry entry : percentEncodings) {
                    String string3 = (String)entry.getValue();
                    string2 = ((Pattern)entry.getKey()).matcher(string2).replaceAll(string3);
                }
            }
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException(charset.name(), unsupportedEncodingException);
        }
    }

    private ByteBuf fillByteBuf() {
        int n = this.currentBuffer.readableBytes();
        if (n > 8096) {
            return this.currentBuffer.readRetainedSlice(8096);
        }
        ByteBuf byteBuf = this.currentBuffer;
        this.currentBuffer = null;
        return byteBuf;
    }

    private HttpContent encodeNextChunkMultipart(int n) {
        ByteBuf byteBuf;
        if (this.currentData == null) {
            return null;
        }
        if (this.currentData instanceof InternalAttribute) {
            byteBuf = ((InternalAttribute)this.currentData).toByteBuf();
            this.currentData = null;
        } else {
            try {
                byteBuf = ((HttpData)this.currentData).getChunk(n);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestEncoder$ErrorDataEncoderException(iOException);
            }
            if (byteBuf.capacity() == 0) {
                this.currentData = null;
                return null;
            }
        }
        this.currentBuffer = this.currentBuffer == null ? byteBuf : Unpooled.wrappedBuffer(this.currentBuffer, byteBuf);
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            return null;
        }
        byteBuf = this.fillByteBuf();
        return new DefaultHttpContent(byteBuf);
    }

    private HttpContent encodeNextChunkUrlEncoded(int n) {
        ByteBuf byteBuf;
        String string;
        if (this.currentData == null) {
            return null;
        }
        int n2 = n;
        if (this.isKey) {
            string = this.currentData.getName();
            byteBuf = Unpooled.wrappedBuffer(string.getBytes(this.charset));
            this.isKey = false;
            this.currentBuffer = this.currentBuffer == null ? Unpooled.wrappedBuffer(byteBuf, Unpooled.wrappedBuffer("=".getBytes(this.charset))) : Unpooled.wrappedBuffer(this.currentBuffer, byteBuf, Unpooled.wrappedBuffer("=".getBytes(this.charset)));
            n2 -= byteBuf.readableBytes() + 1;
            if (this.currentBuffer.readableBytes() >= 8096) {
                byteBuf = this.fillByteBuf();
                return new DefaultHttpContent(byteBuf);
            }
        }
        try {
            byteBuf = ((HttpData)this.currentData).getChunk(n2);
        }
        catch (IOException iOException) {
            throw new HttpPostRequestEncoder$ErrorDataEncoderException(iOException);
        }
        string = null;
        if (byteBuf.readableBytes() < n2) {
            this.isKey = true;
            String string2 = string = this.iterator.hasNext() ? Unpooled.wrappedBuffer("&".getBytes(this.charset)) : null;
        }
        if (byteBuf.capacity() == 0) {
            this.currentData = null;
            if (this.currentBuffer == null) {
                if (string == null) {
                    return null;
                }
                this.currentBuffer = string;
            } else if (string != null) {
                this.currentBuffer = Unpooled.wrappedBuffer(new ByteBuf[]{this.currentBuffer, string});
            }
            if (this.currentBuffer.readableBytes() >= 8096) {
                byteBuf = this.fillByteBuf();
                return new DefaultHttpContent(byteBuf);
            }
            return null;
        }
        this.currentBuffer = this.currentBuffer == null ? (string != null ? Unpooled.wrappedBuffer(new ByteBuf[]{byteBuf, string}) : byteBuf) : (string != null ? Unpooled.wrappedBuffer(new ByteBuf[]{this.currentBuffer, byteBuf, string}) : Unpooled.wrappedBuffer(this.currentBuffer, byteBuf));
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            this.isKey = true;
            return null;
        }
        byteBuf = this.fillByteBuf();
        return new DefaultHttpContent(byteBuf);
    }

    @Override
    public void close() {
    }

    @Override
    @Deprecated
    public HttpContent readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    @Override
    public HttpContent readChunk(ByteBufAllocator byteBufAllocator) {
        if (this.isLastChunkSent) {
            return null;
        }
        HttpContent httpContent = this.nextChunk();
        this.globalProgress += (long)httpContent.content().readableBytes();
        return httpContent;
    }

    private HttpContent nextChunk() {
        HttpContent httpContent;
        if (this.isLastChunk) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        int n = this.calculateRemainingSize();
        if (n <= 0) {
            ByteBuf byteBuf = this.fillByteBuf();
            return new DefaultHttpContent(byteBuf);
        }
        if (this.currentData != null) {
            httpContent = this.isMultipart ? this.encodeNextChunkMultipart(n) : this.encodeNextChunkUrlEncoded(n);
            if (httpContent != null) {
                return httpContent;
            }
            n = this.calculateRemainingSize();
        }
        if (!this.iterator.hasNext()) {
            return this.lastChunk();
        }
        while (n > 0 && this.iterator.hasNext()) {
            this.currentData = this.iterator.next();
            httpContent = this.isMultipart ? this.encodeNextChunkMultipart(n) : this.encodeNextChunkUrlEncoded(n);
            if (httpContent == null) {
                n = this.calculateRemainingSize();
                continue;
            }
            return httpContent;
        }
        return this.lastChunk();
    }

    private int calculateRemainingSize() {
        int n = 8096;
        if (this.currentBuffer != null) {
            n -= this.currentBuffer.readableBytes();
        }
        return n;
    }

    private HttpContent lastChunk() {
        this.isLastChunk = true;
        if (this.currentBuffer == null) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        ByteBuf byteBuf = this.currentBuffer;
        this.currentBuffer = null;
        return new DefaultHttpContent(byteBuf);
    }

    @Override
    public boolean isEndOfInput() {
        return this.isLastChunkSent;
    }

    @Override
    public long length() {
        return this.isMultipart ? this.globalBodySize : this.globalBodySize - 1L;
    }

    @Override
    public long progress() {
        return this.globalProgress;
    }
}

