/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpConstants;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.QueryStringDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.Attribute;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.FileUpload;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpDataFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$SeekAheadOptimize;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$TransferEncodingMechanism;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$EndOfDataDecoderException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$MultiPartStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$NotEnoughDataDecoderException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$TooLongFormFieldException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$TooManyFormFieldsException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.InternalThreadLocalMap;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

public class HttpPostMultipartRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final int maxFields;
    private final int maxBufferedBytes;
    private Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private final String multipartDataBoundary;
    private String multipartMixedBoundary;
    private HttpPostRequestDecoder$MultiPartStatus currentStatus = HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED;
    private Map<CharSequence, Attribute> currentFieldAttributes;
    private FileUpload currentFileUpload;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;
    private static final String FILENAME_ENCODED = HttpHeaderValues.FILENAME.toString() + '*';

    public HttpPostMultipartRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        this(httpDataFactory, httpRequest, charset, 128, 1024);
    }

    public HttpPostMultipartRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset, int n, int n2) {
        this.request = ObjectUtil.checkNotNull(httpRequest, "request");
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.factory = ObjectUtil.checkNotNull(httpDataFactory, "factory");
        this.maxFields = n;
        this.maxBufferedBytes = n2;
        String string = this.request.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string == null) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException("No '" + HttpHeaderNames.CONTENT_TYPE + "' header present.");
        }
        String[] stringArray = HttpPostRequestDecoder.getMultipartDataBoundary(string);
        if (stringArray != null) {
            this.multipartDataBoundary = stringArray[0];
            if (stringArray.length > 1 && stringArray[1] != null) {
                try {
                    this.charset = Charset.forName(stringArray[1]);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalCharsetNameException);
                }
            }
        } else {
            this.multipartDataBoundary = null;
        }
        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
        try {
            if (httpRequest instanceof HttpContent) {
                this.offer((HttpContent)((Object)httpRequest));
            } else {
                this.parseBody();
            }
        }
        catch (Throwable throwable) {
            this.destroy();
            PlatformDependent.throwException(throwable);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostMultipartRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return true;
    }

    @Override
    public void setDiscardThreshold(int n) {
        this.discardThreshold = ObjectUtil.checkPositiveOrZero(n, "discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(string);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public HttpPostMultipartRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        ByteBuf byteBuf = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = byteBuf.alloc().buffer(byteBuf.readableBytes()).writeBytes(byteBuf);
        } else {
            this.undecodedChunk.writeBytes(byteBuf);
        }
        this.parseBody();
        if (this.maxBufferedBytes > 0 && this.undecodedChunk != null && this.undecodedChunk.readableBytes() > this.maxBufferedBytes) {
            throw new HttpPostRequestDecoder$TooLongFormFieldException();
        }
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            if (this.undecodedChunk.refCnt() == 1) {
                this.undecodedChunk.discardReadBytes();
            } else {
                ByteBuf byteBuf2 = this.undecodedChunk.alloc().buffer(this.undecodedChunk.readableBytes());
                byteBuf2.writeBytes(this.undecodedChunk);
                this.undecodedChunk.release();
                this.undecodedChunk = byteBuf2;
            }
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder$EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        if (this.currentFileUpload != null) {
            return this.currentFileUpload;
        }
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyMultipart();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        if (this.maxFields > 0 && this.bodyListHttpData.size() >= this.maxFields) {
            throw new HttpPostRequestDecoder$TooManyFormFieldsException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    private void parseBodyMultipart() {
        if (this.undecodedChunk == null || this.undecodedChunk.readableBytes() == 0) {
            return;
        }
        InterfaceHttpData interfaceHttpData = this.decodeMultipart(this.currentStatus);
        while (interfaceHttpData != null) {
            this.addHttpData(interfaceHttpData);
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) break;
            interfaceHttpData = this.decodeMultipart(this.currentStatus);
        }
    }

    private InterfaceHttpData decodeMultipart(HttpPostRequestDecoder$MultiPartStatus httpPostRequestDecoder$MultiPartStatus) {
        switch (httpPostRequestDecoder$MultiPartStatus) {
            case NOTSTARTED: {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case PREAMBLE: {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Should not be called with the current getStatus");
            }
            case HEADERDELIMITER: {
                return this.findMultipartDelimiter(this.multipartDataBoundary, HttpPostRequestDecoder$MultiPartStatus.DISPOSITION, HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE);
            }
            case DISPOSITION: {
                return this.findMultipartDisposition();
            }
            case FIELD: {
                Attribute attribute;
                Charset charset = null;
                Attribute attribute2 = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET);
                if (attribute2 != null) {
                    try {
                        charset = Charset.forName(attribute2.getValue());
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(unsupportedCharsetException);
                    }
                }
                Attribute attribute3 = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
                if (this.currentAttribute == null) {
                    long l;
                    attribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
                    try {
                        l = attribute != null ? Long.parseLong(attribute.getValue()) : 0L;
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                    }
                    catch (NumberFormatException numberFormatException) {
                        l = 0L;
                    }
                    try {
                        this.currentAttribute = l > 0L ? this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute3.getValue()), l) : this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute3.getValue()));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    catch (IOException iOException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                    }
                    if (charset != null) {
                        this.currentAttribute.setCharset(charset);
                    }
                }
                if (!HttpPostMultipartRequestDecoder.loadDataMultipartOptimized(this.undecodedChunk, this.multipartDataBoundary, this.currentAttribute)) {
                    return null;
                }
                attribute = this.currentAttribute;
                this.currentAttribute = null;
                this.currentFieldAttributes = null;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
                return attribute;
            }
            case FILEUPLOAD: {
                return this.getFileUpload(this.multipartDataBoundary);
            }
            case MIXEDDELIMITER: {
                return this.findMultipartDelimiter(this.multipartMixedBoundary, HttpPostRequestDecoder$MultiPartStatus.MIXEDDISPOSITION, HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER);
            }
            case MIXEDDISPOSITION: {
                return this.findMultipartDisposition();
            }
            case MIXEDFILEUPLOAD: {
                return this.getFileUpload(this.multipartMixedBoundary);
            }
            case PREEPILOGUE: {
                return null;
            }
            case EPILOGUE: {
                return null;
            }
        }
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("Shouldn't reach here.");
    }

    private static void skipControlCharacters(ByteBuf byteBuf) {
        if (!byteBuf.hasArray()) {
            try {
                HttpPostMultipartRequestDecoder.skipControlCharactersStandard(byteBuf);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
            }
            return;
        }
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(byteBuf);
        while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
            char c;
            if (Character.isISOControl(c = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF)) || Character.isWhitespace(c)) continue;
            httpPostBodyUtil$SeekAheadOptimize.setReadPosition(1);
            return;
        }
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException("Access out of bounds");
    }

    private static void skipControlCharactersStandard(ByteBuf byteBuf) {
        char c;
        while (Character.isISOControl(c = (char)byteBuf.readUnsignedByte()) || Character.isWhitespace(c)) {
        }
        byteBuf.readerIndex(byteBuf.readerIndex() - 1);
    }

    private InterfaceHttpData findMultipartDelimiter(String string, HttpPostRequestDecoder$MultiPartStatus httpPostRequestDecoder$MultiPartStatus, HttpPostRequestDecoder$MultiPartStatus httpPostRequestDecoder$MultiPartStatus2) {
        String string2;
        int n = this.undecodedChunk.readerIndex();
        try {
            HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
        }
        catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            return null;
        }
        this.skipOneLine();
        try {
            string2 = HttpPostMultipartRequestDecoder.readDelimiterOptimized(this.undecodedChunk, string, this.charset);
        }
        catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            return null;
        }
        if (string2.equals(string)) {
            this.currentStatus = httpPostRequestDecoder$MultiPartStatus;
            return this.decodeMultipart(httpPostRequestDecoder$MultiPartStatus);
        }
        if (string2.equals(string + "--")) {
            this.currentStatus = httpPostRequestDecoder$MultiPartStatus2;
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER) {
                this.currentFieldAttributes = null;
                return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER);
            }
            return null;
        }
        this.undecodedChunk.readerIndex(n);
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("No Multipart delimiter found");
    }

    private InterfaceHttpData findMultipartDisposition() {
        Object object;
        int n = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
            this.currentFieldAttributes = new TreeMap<CharSequence, Attribute>(CaseIgnoringComparator.INSTANCE);
        }
        while (!this.skipOneLine()) {
            Object object2;
            Object object3;
            try {
                HttpPostMultipartRequestDecoder.skipControlCharacters(this.undecodedChunk);
                object = HttpPostMultipartRequestDecoder.readLineOptimized(this.undecodedChunk, this.charset);
            }
            catch (HttpPostRequestDecoder$NotEnoughDataDecoderException httpPostRequestDecoder$NotEnoughDataDecoderException) {
                this.undecodedChunk.readerIndex(n);
                return null;
            }
            String[] stringArray = HttpPostMultipartRequestDecoder.splitMultipartHeader((String)object);
            if (HttpHeaderNames.CONTENT_DISPOSITION.contentEqualsIgnoreCase(stringArray[0])) {
                boolean bl;
                if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
                    bl = HttpHeaderValues.FORM_DATA.contentEqualsIgnoreCase(stringArray[1]);
                } else {
                    boolean bl2 = bl = HttpHeaderValues.ATTACHMENT.contentEqualsIgnoreCase(stringArray[1]) || HttpHeaderValues.FILE.contentEqualsIgnoreCase(stringArray[1]);
                }
                if (!bl) continue;
                for (int i = 2; i < stringArray.length; ++i) {
                    object3 = stringArray[i].split("=", 2);
                    try {
                        object2 = this.getContentDispositionAttribute((String[])object3);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(object2.getName(), (Attribute)object2);
                }
                continue;
            }
            if (HttpHeaderNames.CONTENT_TRANSFER_ENCODING.contentEqualsIgnoreCase(stringArray[0])) {
                Attribute attribute;
                try {
                    attribute = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_TRANSFER_ENCODING.toString(), HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(HttpHeaderNames.CONTENT_TRANSFER_ENCODING, attribute);
                continue;
            }
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(stringArray[0])) {
                Attribute attribute;
                try {
                    attribute = this.factory.createAttribute(this.request, HttpHeaderNames.CONTENT_LENGTH.toString(), HttpPostMultipartRequestDecoder.cleanString(stringArray[1]));
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(HttpHeaderNames.CONTENT_LENGTH, attribute);
                continue;
            }
            if (!HttpHeaderNames.CONTENT_TYPE.contentEqualsIgnoreCase(stringArray[0])) continue;
            if (HttpHeaderValues.MULTIPART_MIXED.contentEqualsIgnoreCase(stringArray[1])) {
                if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
                    String string = StringUtil.substringAfter(stringArray[2], '=');
                    this.multipartMixedBoundary = "--" + string;
                    this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER;
                    return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER);
                }
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Mixed Multipart found in a previous Mixed Multipart");
            }
            for (int i = 1; i < stringArray.length; ++i) {
                String string = HttpHeaderValues.CHARSET.toString();
                if (stringArray[i].regionMatches(true, 0, string, 0, string.length())) {
                    object3 = StringUtil.substringAfter(stringArray[i], '=');
                    try {
                        object2 = this.factory.createAttribute(this.request, string, HttpPostMultipartRequestDecoder.cleanString((String)object3));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put(HttpHeaderValues.CHARSET, (Attribute)object2);
                    continue;
                }
                if (stringArray[i].contains("=")) {
                    Attribute attribute;
                    object3 = StringUtil.substringBefore(stringArray[i], '=');
                    object2 = StringUtil.substringAfter(stringArray[i], '=');
                    try {
                        attribute = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString((String)object3), (String)object2);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                    }
                    this.currentFieldAttributes.put((CharSequence)object3, attribute);
                    continue;
                }
                try {
                    object3 = this.factory.createAttribute(this.request, HttpPostMultipartRequestDecoder.cleanString(stringArray[0]), stringArray[i]);
                }
                catch (NullPointerException nullPointerException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
                }
                this.currentFieldAttributes.put(object3.getName(), (Attribute)object3);
            }
        }
        object = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.DISPOSITION) {
            if (object != null) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD;
                return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD);
            }
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
            return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.FIELD);
        }
        if (object != null) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDFILEUPLOAD;
            return this.decodeMultipart(HttpPostRequestDecoder$MultiPartStatus.MIXEDFILEUPLOAD);
        }
        throw new HttpPostRequestDecoder$ErrorDataDecoderException("Filename not found");
    }

    private Attribute getContentDispositionAttribute(String ... stringArray) {
        String string = HttpPostMultipartRequestDecoder.cleanString(stringArray[0]);
        String string2 = stringArray[1];
        if (HttpHeaderValues.FILENAME.contentEquals(string)) {
            int n = string2.length() - 1;
            if (n > 0 && string2.charAt(0) == '\"' && string2.charAt(n) == '\"') {
                string2 = string2.substring(1, n);
            }
        } else if (FILENAME_ENCODED.equals(string)) {
            try {
                string = HttpHeaderValues.FILENAME.toString();
                String[] stringArray2 = HttpPostMultipartRequestDecoder.cleanString(string2).split("'", 3);
                string2 = QueryStringDecoder.decodeComponent(stringArray2[2], Charset.forName(stringArray2[0]));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(arrayIndexOutOfBoundsException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(unsupportedCharsetException);
            }
        } else {
            string2 = HttpPostMultipartRequestDecoder.cleanString(string2);
        }
        return this.factory.createAttribute(this.request, string, string2);
    }

    protected InterfaceHttpData getFileUpload(String string) {
        HttpData httpData;
        Object object;
        Attribute attribute = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        Charset charset = this.charset;
        HttpPostBodyUtil$TransferEncodingMechanism httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BIT7;
        if (attribute != null) {
            try {
                object = attribute.getValue().toLowerCase();
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BIT7.value())) {
                charset = CharsetUtil.US_ASCII;
            } else if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BIT8.value())) {
                charset = CharsetUtil.ISO_8859_1;
                httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BIT8;
            } else if (((String)object).equals(HttpPostBodyUtil$TransferEncodingMechanism.BINARY.value())) {
                httpPostBodyUtil$TransferEncodingMechanism = HttpPostBodyUtil$TransferEncodingMechanism.BINARY;
            } else {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("TransferEncoding Unknown: " + (String)object);
            }
        }
        if ((object = this.currentFieldAttributes.get(HttpHeaderValues.CHARSET)) != null) {
            try {
                charset = Charset.forName(object.getValue());
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(unsupportedCharsetException);
            }
        }
        if (this.currentFileUpload == null) {
            long l;
            httpData = this.currentFieldAttributes.get(HttpHeaderValues.FILENAME);
            Attribute attribute2 = this.currentFieldAttributes.get(HttpHeaderValues.NAME);
            Attribute attribute3 = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_TYPE);
            Attribute attribute4 = this.currentFieldAttributes.get(HttpHeaderNames.CONTENT_LENGTH);
            try {
                l = attribute4 != null ? Long.parseLong(attribute4.getValue()) : 0L;
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                l = 0L;
            }
            try {
                String string2 = attribute3 != null ? attribute3.getValue() : "application/octet-stream";
                this.currentFileUpload = this.factory.createFileUpload(this.request, HttpPostMultipartRequestDecoder.cleanString(attribute2.getValue()), HttpPostMultipartRequestDecoder.cleanString(httpData.getValue()), string2, httpPostBodyUtil$TransferEncodingMechanism.value(), charset, l);
            }
            catch (NullPointerException nullPointerException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(nullPointerException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
        }
        if (!HttpPostMultipartRequestDecoder.loadDataMultipartOptimized(this.undecodedChunk, string, this.currentFileUpload)) {
            return null;
        }
        if (this.currentFileUpload.isCompleted()) {
            if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FILEUPLOAD) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.HEADERDELIMITER;
                this.currentFieldAttributes = null;
            } else {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.MIXEDDELIMITER;
                this.cleanMixedAttributes();
            }
            httpData = this.currentFileUpload;
            this.currentFileUpload = null;
            return httpData;
        }
        return null;
    }

    @Override
    public void destroy() {
        this.cleanFiles();
        for (InterfaceHttpData interfaceHttpData : this.bodyListHttpData) {
            if (interfaceHttpData.refCnt() <= 0) continue;
            interfaceHttpData.release();
        }
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }

    private void cleanMixedAttributes() {
        this.currentFieldAttributes.remove(HttpHeaderValues.CHARSET);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_LENGTH);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TRANSFER_ENCODING);
        this.currentFieldAttributes.remove(HttpHeaderNames.CONTENT_TYPE);
        this.currentFieldAttributes.remove(HttpHeaderValues.FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLineOptimized(ByteBuf byteBuf, Charset charset) {
        int n;
        block7: {
            String string;
            n = byteBuf.readerIndex();
            ByteBuf byteBuf2 = null;
            if (!byteBuf.isReadable()) break block7;
            int n2 = HttpPostBodyUtil.findLineBreak(byteBuf, byteBuf.readerIndex());
            if (n2 <= 0) {
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
            }
            try {
                byteBuf2 = byteBuf.alloc().heapBuffer(n2);
                byteBuf2.writeBytes(byteBuf, n2);
                byte by = byteBuf.readByte();
                if (by == 13) {
                    byteBuf.readByte();
                }
                string = byteBuf2.toString(charset);
            }
            catch (Throwable throwable) {
                try {
                    byteBuf2.release();
                    throw throwable;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    byteBuf.readerIndex(n);
                    throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
                }
            }
            byteBuf2.release();
            return string;
        }
        byteBuf.readerIndex(n);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private static String readDelimiterOptimized(ByteBuf byteBuf, String string, Charset charset) {
        int n = byteBuf.readerIndex();
        byte[] byArray = string.getBytes(charset);
        int n2 = byArray.length;
        try {
            int n3 = HttpPostBodyUtil.findDelimiter(byteBuf, n, byArray, false);
            if (n3 < 0) {
                byteBuf.readerIndex(n);
                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            byteBuf.readerIndex(n + n3 + n2);
            if (byteBuf.isReadable()) {
                byte by = byteBuf.readByte();
                if (by == 13) {
                    by = byteBuf.readByte();
                    if (by == 10) {
                        return stringBuilder.toString();
                    }
                    byteBuf.readerIndex(n);
                    throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                }
                if (by == 10) {
                    return stringBuilder.toString();
                }
                if (by == 45) {
                    stringBuilder.append('-');
                    by = byteBuf.readByte();
                    if (by == 45) {
                        stringBuilder.append('-');
                        if (byteBuf.isReadable()) {
                            by = byteBuf.readByte();
                            if (by == 13) {
                                by = byteBuf.readByte();
                                if (by == 10) {
                                    return stringBuilder.toString();
                                }
                                byteBuf.readerIndex(n);
                                throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
                            }
                            if (by == 10) {
                                return stringBuilder.toString();
                            }
                            byteBuf.readerIndex(byteBuf.readerIndex() - 1);
                            return stringBuilder.toString();
                        }
                        return stringBuilder.toString();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            byteBuf.readerIndex(n);
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException(indexOutOfBoundsException);
        }
        byteBuf.readerIndex(n);
        throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
    }

    private static void rewriteCurrentBuffer(ByteBuf byteBuf, int n) {
        if (n == 0) {
            return;
        }
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.readableBytes();
        if (n3 == n) {
            byteBuf.readerIndex(n2);
            byteBuf.writerIndex(n2);
            return;
        }
        byteBuf.setBytes(n2, byteBuf, n2 + n, n3 - n);
        byteBuf.readerIndex(n2);
        byteBuf.writerIndex(n2 + n3 - n);
    }

    private static boolean loadDataMultipartOptimized(ByteBuf byteBuf, String string, HttpData httpData) {
        byte[] byArray;
        if (!byteBuf.isReadable()) {
            return false;
        }
        int n = byteBuf.readerIndex();
        int n2 = HttpPostBodyUtil.findDelimiter(byteBuf, n, byArray = string.getBytes(httpData.getCharset()), true);
        if (n2 < 0) {
            int n3 = byteBuf.readableBytes();
            int n4 = n3 - byArray.length - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n2 = HttpPostBodyUtil.findLastLineBreak(byteBuf, n + n4)) < 0 && httpData.definedLength() == httpData.length() + (long)n3 - 1L && byteBuf.getByte(n3 + n - 1) == 13) {
                n4 = 0;
                n2 = n3 - 1;
            }
            if (n2 < 0) {
                ByteBuf byteBuf2 = byteBuf.copy();
                try {
                    httpData.addContent(byteBuf2, false);
                }
                catch (IOException iOException) {
                    throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
                }
                byteBuf.readerIndex(n);
                byteBuf.writerIndex(n);
                return false;
            }
            if ((n2 += n4) == 0) {
                return false;
            }
            ByteBuf byteBuf3 = byteBuf.copy(n, n2);
            try {
                httpData.addContent(byteBuf3, false);
            }
            catch (IOException iOException) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
            }
            HttpPostMultipartRequestDecoder.rewriteCurrentBuffer(byteBuf, n2);
            return false;
        }
        ByteBuf byteBuf4 = byteBuf.copy(n, n2);
        try {
            httpData.addContent(byteBuf4, true);
        }
        catch (IOException iOException) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
        HttpPostMultipartRequestDecoder.rewriteCurrentBuffer(byteBuf, n2);
        return true;
    }

    private static String cleanString(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    stringBuilder.append(' ');
                    continue block4;
                }
                case '\"': {
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString().trim();
    }

    private boolean skipOneLine() {
        if (!this.undecodedChunk.isReadable()) {
            return false;
        }
        byte by = this.undecodedChunk.readByte();
        if (by == 13) {
            if (!this.undecodedChunk.isReadable()) {
                this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
                return false;
            }
            by = this.undecodedChunk.readByte();
            if (by == 10) {
                return true;
            }
            this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 2);
            return false;
        }
        if (by == 10) {
            return true;
        }
        this.undecodedChunk.readerIndex(this.undecodedChunk.readerIndex() - 1);
        return false;
    }

    private static String[] splitMultipartHeader(String string) {
        int n;
        int n2;
        char c;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        for (n3 = n2 = HttpPostBodyUtil.findNonWhitespace(string, 0); n3 < string.length() && (c = string.charAt(n3)) != ':' && !Character.isWhitespace(c); ++n3) {
        }
        for (n = n3; n < string.length(); ++n) {
            if (string.charAt(n) != ':') continue;
            ++n;
            break;
        }
        int n4 = HttpPostBodyUtil.findNonWhitespace(string, n);
        int n5 = HttpPostBodyUtil.findEndOfString(string);
        arrayList.add(string.substring(n2, n3));
        String string2 = n4 >= n5 ? "" : string.substring(n4, n5);
        String[] stringArray = string2.indexOf(59) >= 0 ? HttpPostMultipartRequestDecoder.splitMultipartHeaderValues(string2) : string2.split(",");
        for (String string3 : stringArray) {
            arrayList.add(string3.trim());
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    private static String[] splitMultipartHeaderValues(String string) {
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList(1);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c != '\"') continue;
                bl = false;
                continue;
            }
            if (c == '\"') {
                bl = true;
                continue;
            }
            if (c != ';') continue;
            arrayList.add(string.substring(n, i));
            n = i + 1;
        }
        arrayList.add(string.substring(n));
        return arrayList.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    int getCurrentAllocatedCapacity() {
        return this.undecodedChunk.capacity();
    }
}

