/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeadersFactory;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class HttpDecoderConfig
implements Cloneable {
    private int maxChunkSize = 8192;
    private boolean chunkedSupported = true;
    private boolean allowPartialChunks = true;
    private HttpHeadersFactory headersFactory = DefaultHttpHeadersFactory.headersFactory();
    private HttpHeadersFactory trailersFactory = DefaultHttpHeadersFactory.trailersFactory();
    private boolean allowDuplicateContentLengths = false;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int initialBufferSize = 128;

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public HttpDecoderConfig setInitialBufferSize(int n) {
        ObjectUtil.checkPositive(n, "initialBufferSize");
        this.initialBufferSize = n;
        return this;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public HttpDecoderConfig setMaxInitialLineLength(int n) {
        ObjectUtil.checkPositive(n, "maxInitialLineLength");
        this.maxInitialLineLength = n;
        return this;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public HttpDecoderConfig setMaxHeaderSize(int n) {
        ObjectUtil.checkPositive(n, "maxHeaderSize");
        this.maxHeaderSize = n;
        return this;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public HttpDecoderConfig setMaxChunkSize(int n) {
        ObjectUtil.checkPositive(n, "maxChunkSize");
        this.maxChunkSize = n;
        return this;
    }

    public boolean isChunkedSupported() {
        return this.chunkedSupported;
    }

    public HttpDecoderConfig setChunkedSupported(boolean bl) {
        this.chunkedSupported = bl;
        return this;
    }

    public boolean isAllowPartialChunks() {
        return this.allowPartialChunks;
    }

    public HttpDecoderConfig setAllowPartialChunks(boolean bl) {
        this.allowPartialChunks = bl;
        return this;
    }

    public HttpHeadersFactory getHeadersFactory() {
        return this.headersFactory;
    }

    public HttpDecoderConfig setHeadersFactory(HttpHeadersFactory httpHeadersFactory) {
        ObjectUtil.checkNotNull(httpHeadersFactory, "headersFactory");
        this.headersFactory = httpHeadersFactory;
        return this;
    }

    public boolean isAllowDuplicateContentLengths() {
        return this.allowDuplicateContentLengths;
    }

    public HttpDecoderConfig setAllowDuplicateContentLengths(boolean bl) {
        this.allowDuplicateContentLengths = bl;
        return this;
    }

    public HttpDecoderConfig setValidateHeaders(boolean bl) {
        DefaultHttpHeadersFactory defaultHttpHeadersFactory = DefaultHttpHeadersFactory.headersFactory().withValidation(false);
        this.headersFactory = bl ? DefaultHttpHeadersFactory.headersFactory() : defaultHttpHeadersFactory;
        this.trailersFactory = bl ? DefaultHttpHeadersFactory.trailersFactory() : defaultHttpHeadersFactory;
        return this;
    }

    public HttpHeadersFactory getTrailersFactory() {
        return this.trailersFactory;
    }

    public HttpDecoderConfig setTrailersFactory(HttpHeadersFactory httpHeadersFactory) {
        ObjectUtil.checkNotNull(httpHeadersFactory, "trailersFactory");
        this.trailersFactory = httpHeadersFactory;
        return this;
    }

    public HttpDecoderConfig clone() {
        try {
            return (HttpDecoderConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }
}

