/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpMessage;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeadersFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessageUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class DefaultHttpRequest
extends DefaultHttpMessage
implements HttpRequest {
    private static final int HASH_CODE_PRIME = 31;
    private HttpMethod method;
    private String uri;

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string) {
        this(httpVersion, httpMethod, string, DefaultHttpHeadersFactory.headersFactory().newHeaders());
    }

    @Deprecated
    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, boolean bl) {
        this(httpVersion, httpMethod, string, DefaultHttpHeadersFactory.headersFactory().withValidation(bl));
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, HttpHeadersFactory httpHeadersFactory) {
        this(httpVersion, httpMethod, string, httpHeadersFactory.newHeaders());
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, HttpHeaders httpHeaders) {
        super(httpVersion, httpHeaders);
        this.method = ObjectUtil.checkNotNull(httpMethod, "method");
        this.uri = ObjectUtil.checkNotNull(string, "uri");
    }

    @Override
    @Deprecated
    public HttpMethod getMethod() {
        return this.method();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    @Deprecated
    public String getUri() {
        return this.uri();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpRequest setMethod(HttpMethod httpMethod) {
        this.method = ObjectUtil.checkNotNull(httpMethod, "method");
        return this;
    }

    @Override
    public HttpRequest setUri(String string) {
        this.uri = ObjectUtil.checkNotNull(string, "uri");
        return this;
    }

    @Override
    public HttpRequest setProtocolVersion(HttpVersion httpVersion) {
        super.setProtocolVersion(httpVersion);
        return this;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + this.method.hashCode();
        n = 31 * n + this.uri.hashCode();
        n = 31 * n + super.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttpRequest)) {
            return false;
        }
        DefaultHttpRequest defaultHttpRequest = (DefaultHttpRequest)object;
        return this.method().equals(defaultHttpRequest.method()) && this.uri().equalsIgnoreCase(defaultHttpRequest.uri()) && super.equals(object);
    }

    public String toString() {
        return HttpMessageUtil.appendRequest(new StringBuilder(256), this).toString();
    }
}

