/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.ByteToMessageDecoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.DecompressionException;
import pro.gravit.repackage.io.netty.handler.codec.compression.Zstd;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZstdDecoder$MutableByteBufInputStream;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZstdDecoder$State;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;

public final class ZstdDecoder
extends ByteToMessageDecoder {
    private final ZstdDecoder$MutableByteBufInputStream inputStream;
    private ZstdInputStreamNoFinalizer zstdIs;
    private ZstdDecoder$State currentState;

    public ZstdDecoder() {
        try {
            Zstd.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        this.inputStream = new ZstdDecoder$MutableByteBufInputStream(null);
        this.currentState = ZstdDecoder$State.DECOMPRESS_DATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            if (this.currentState == ZstdDecoder$State.CORRUPTED) {
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            int n = byteBuf.readableBytes();
            this.inputStream.current = byteBuf;
            ReferenceCounted referenceCounted = null;
            try {
                int n2;
                do {
                    if (referenceCounted == null) {
                        referenceCounted = channelHandlerContext.alloc().heapBuffer(n * 2);
                    }
                    while ((n2 = ((ByteBuf)referenceCounted).writeBytes((InputStream)this.zstdIs, ((ByteBuf)referenceCounted).writableBytes())) != -1 && ((ByteBuf)referenceCounted).isWritable()) {
                    }
                    if (!((ByteBuf)referenceCounted).isReadable()) continue;
                    list.add(referenceCounted);
                    referenceCounted = null;
                } while (n2 != -1);
            }
            finally {
                if (referenceCounted != null) {
                    referenceCounted.release();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = ZstdDecoder$State.CORRUPTED;
            throw new DecompressionException(exception);
        }
        finally {
            this.inputStream.current = null;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        super.handlerAdded(channelHandlerContext);
        this.zstdIs = new ZstdInputStreamNoFinalizer((InputStream)this.inputStream);
        this.zstdIs.setContinuous(true);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        try {
            ZstdDecoder.closeSilently((Closeable)this.zstdIs);
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

