/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import java.util.zip.Adler32;
import java.util.zip.Checksum;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.MessageToByteEncoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.ByteBufChecksum;
import pro.gravit.repackage.io.netty.handler.codec.compression.FastLz;

public class FastLzFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int level;
    private final ByteBufChecksum checksum;

    public FastLzFrameEncoder() {
        this(0, null);
    }

    public FastLzFrameEncoder(int n) {
        this(n, null);
    }

    public FastLzFrameEncoder(boolean bl) {
        this(0, bl ? new Adler32() : null);
    }

    public FastLzFrameEncoder(int n, Checksum checksum) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException(String.format("level: %d (expected: %d or %d or %d)", n, 0, 1, 2));
        }
        this.level = n;
        this.checksum = checksum == null ? null : ByteBufChecksum.wrapChecksum(checksum);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        ByteBufChecksum byteBufChecksum = this.checksum;
        while (byteBuf.isReadable()) {
            int n;
            int n2;
            int n3;
            int n4 = byteBuf.readerIndex();
            int n5 = Math.min(byteBuf.readableBytes(), 65535);
            int n6 = byteBuf2.writerIndex();
            byteBuf2.setMedium(n6, 4607066);
            int n7 = n6 + 4 + (byteBufChecksum != null ? 4 : 0);
            if (n5 < 32) {
                n3 = 0;
                byteBuf2.ensureWritable(n7 + 2 + n5);
                n2 = n7 + 2;
                if (byteBufChecksum != null) {
                    byteBufChecksum.reset();
                    byteBufChecksum.update(byteBuf, n4, n5);
                    byteBuf2.setInt(n6 + 4, (int)byteBufChecksum.getValue());
                }
                byteBuf2.setBytes(n2, byteBuf, n4, n5);
                n = n5;
            } else {
                if (byteBufChecksum != null) {
                    byteBufChecksum.reset();
                    byteBufChecksum.update(byteBuf, n4, n5);
                    byteBuf2.setInt(n6 + 4, (int)byteBufChecksum.getValue());
                }
                n2 = FastLz.calculateOutputBufferLength(n5);
                byteBuf2.ensureWritable(n7 + 4 + n2);
                int n8 = n7 + 4;
                int n9 = FastLz.compress(byteBuf, byteBuf.readerIndex(), n5, byteBuf2, n8, this.level);
                if (n9 < n5) {
                    n3 = 1;
                    n = n9;
                    byteBuf2.setShort(n7, n);
                    n7 += 2;
                } else {
                    n3 = 0;
                    byteBuf2.setBytes(n7 + 2, byteBuf, n4, n5);
                    n = n5;
                }
            }
            byteBuf2.setShort(n7, n5);
            byteBuf2.setByte(n6 + 3, n3 | (byteBufChecksum != null ? 16 : 0));
            byteBuf2.writerIndex(n7 + 2 + n);
            byteBuf.skipBytes(n5);
        }
        return;
    }
}

