/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.unix;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import pro.gravit.repackage.io.netty.channel.unix.Errors;
import pro.gravit.repackage.io.netty.channel.unix.Limits;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class FileDescriptor {
    private static final AtomicIntegerFieldUpdater<FileDescriptor> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(FileDescriptor.class, "state");
    private static final int STATE_CLOSED_MASK = 1;
    private static final int STATE_INPUT_SHUTDOWN_MASK = 2;
    private static final int STATE_OUTPUT_SHUTDOWN_MASK = 4;
    private static final int STATE_ALL_MASK = 7;
    volatile int state;
    final int fd;

    public FileDescriptor(int n) {
        ObjectUtil.checkPositiveOrZero(n, "fd");
        this.fd = n;
    }

    public final int intValue() {
        return this.fd;
    }

    protected boolean markClosed() {
        int n;
        do {
            if (!FileDescriptor.isClosed(n = this.state)) continue;
            return false;
        } while (!this.casState(n, n | 7));
        return true;
    }

    public void close() {
        int n;
        if (this.markClosed() && (n = FileDescriptor.close(this.fd)) < 0) {
            throw Errors.newIOException("close", n);
        }
    }

    public boolean isOpen() {
        return !FileDescriptor.isClosed(this.state);
    }

    public final int write(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = FileDescriptor.write(this.fd, byteBuffer, n, n2);
        if (n3 >= 0) {
            return n3;
        }
        return Errors.ioResult("write", n3);
    }

    public final int writeAddress(long l, int n, int n2) {
        int n3 = FileDescriptor.writeAddress(this.fd, l, n, n2);
        if (n3 >= 0) {
            return n3;
        }
        return Errors.ioResult("writeAddress", n3);
    }

    public final long writev(ByteBuffer[] byteBufferArray, int n, int n2, long l) {
        long l2 = FileDescriptor.writev(this.fd, byteBufferArray, n, Math.min(Limits.IOV_MAX, n2), l);
        if (l2 >= 0L) {
            return l2;
        }
        return Errors.ioResult("writev", (int)l2);
    }

    public final long writevAddresses(long l, int n) {
        long l2 = FileDescriptor.writevAddresses(this.fd, l, n);
        if (l2 >= 0L) {
            return l2;
        }
        return Errors.ioResult("writevAddresses", (int)l2);
    }

    public final int read(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = FileDescriptor.read(this.fd, byteBuffer, n, n2);
        if (n3 > 0) {
            return n3;
        }
        if (n3 == 0) {
            return -1;
        }
        return Errors.ioResult("read", n3);
    }

    public final int readAddress(long l, int n, int n2) {
        int n3 = FileDescriptor.readAddress(this.fd, l, n, n2);
        if (n3 > 0) {
            return n3;
        }
        if (n3 == 0) {
            return -1;
        }
        return Errors.ioResult("readAddress", n3);
    }

    public String toString() {
        return "FileDescriptor{fd=" + this.fd + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FileDescriptor)) {
            return false;
        }
        return this.fd == ((FileDescriptor)object).fd;
    }

    public int hashCode() {
        return this.fd;
    }

    public static FileDescriptor from(String string) {
        int n = FileDescriptor.open(ObjectUtil.checkNotNull(string, "path"));
        if (n < 0) {
            throw Errors.newIOException("open", n);
        }
        return new FileDescriptor(n);
    }

    public static FileDescriptor from(File file) {
        return FileDescriptor.from(ObjectUtil.checkNotNull(file, "file").getPath());
    }

    public static FileDescriptor[] pipe() {
        long l = FileDescriptor.newPipe();
        if (l < 0L) {
            throw Errors.newIOException("newPipe", (int)l);
        }
        return new FileDescriptor[]{new FileDescriptor((int)(l >>> 32)), new FileDescriptor((int)l)};
    }

    final boolean casState(int n, int n2) {
        return stateUpdater.compareAndSet(this, n, n2);
    }

    static boolean isClosed(int n) {
        return (n & 1) != 0;
    }

    static boolean isInputShutdown(int n) {
        return (n & 2) != 0;
    }

    static boolean isOutputShutdown(int n) {
        return (n & 4) != 0;
    }

    static int inputShutdown(int n) {
        return n | 2;
    }

    static int outputShutdown(int n) {
        return n | 4;
    }

    private static native int open(String var0);

    private static native int close(int var0);

    private static native int write(int var0, ByteBuffer var1, int var2, int var3);

    private static native int writeAddress(int var0, long var1, int var3, int var4);

    private static native long writev(int var0, ByteBuffer[] var1, int var2, int var3, long var4);

    private static native long writevAddresses(int var0, long var1, int var3);

    private static native int read(int var0, ByteBuffer var1, int var2, int var3);

    private static native int readAddress(int var0, long var1, int var3, int var4);

    private static native long newPipe();
}

