/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.socket.nio;

import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Map;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.ChannelOption;
import pro.gravit.repackage.io.netty.channel.DefaultChannelConfig;
import pro.gravit.repackage.io.netty.channel.MessageSizeEstimator;
import pro.gravit.repackage.io.netty.channel.RecvByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.WriteBufferWaterMark;
import pro.gravit.repackage.io.netty.channel.socket.DuplexChannelConfig;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioChannelOption;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel$1;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

final class NioDomainSocketChannel$NioDomainSocketChannelConfig
extends DefaultChannelConfig
implements DuplexChannelConfig {
    private volatile boolean allowHalfClosure;
    private volatile int maxBytesPerGatheringWrite;
    private final SocketChannel javaChannel;
    final /* synthetic */ NioDomainSocketChannel this$0;

    private NioDomainSocketChannel$NioDomainSocketChannelConfig(NioDomainSocketChannel nioDomainSocketChannel, NioDomainSocketChannel nioDomainSocketChannel2, SocketChannel socketChannel) {
        this.this$0 = nioDomainSocketChannel;
        super(nioDomainSocketChannel2);
        this.maxBytesPerGatheringWrite = Integer.MAX_VALUE;
        this.javaChannel = socketChannel;
        this.calculateMaxBytesPerGatheringWrite();
    }

    @Override
    public boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setAllowHalfClosure(boolean bl) {
        this.allowHalfClosure = bl;
        return this;
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        ArrayList<ChannelOption> arrayList = new ArrayList<ChannelOption>();
        arrayList.add(ChannelOption.SO_RCVBUF);
        arrayList.add(ChannelOption.SO_SNDBUF);
        for (ChannelOption channelOption : NioChannelOption.getOptions(this.jdkChannel())) {
            arrayList.add(channelOption);
        }
        return this.getOptions(super.getOptions(), arrayList.toArray(new ChannelOption[0]));
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (channelOption instanceof NioChannelOption) {
            return NioChannelOption.getOption(this.jdkChannel(), (NioChannelOption)channelOption);
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t) {
        if (channelOption == ChannelOption.SO_RCVBUF) {
            this.validate(channelOption, t);
            this.setReceiveBufferSize((Integer)t);
        } else if (channelOption == ChannelOption.SO_SNDBUF) {
            this.validate(channelOption, t);
            this.setSendBufferSize((Integer)t);
        } else {
            if (channelOption instanceof NioChannelOption) {
                return NioChannelOption.setOption(this.jdkChannel(), (NioChannelOption)channelOption, t);
            }
            return super.setOption(channelOption, t);
        }
        return true;
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private int getReceiveBufferSize() {
        try {
            return this.javaChannel.getOption(StandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private NioDomainSocketChannel$NioDomainSocketChannelConfig setReceiveBufferSize(int n) {
        try {
            this.javaChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)n);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
        return this;
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private int getSendBufferSize() {
        try {
            return this.javaChannel.getOption(StandardSocketOptions.SO_SNDBUF);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private NioDomainSocketChannel$NioDomainSocketChannelConfig setSendBufferSize(int n) {
        try {
            this.javaChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)n);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setConnectTimeoutMillis(int n) {
        super.setConnectTimeoutMillis(n);
        return this;
    }

    @Override
    @Deprecated
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setMaxMessagesPerRead(int n) {
        super.setMaxMessagesPerRead(n);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setWriteSpinCount(int n) {
        super.setWriteSpinCount(n);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setAutoClose(boolean bl) {
        super.setAutoClose(bl);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setWriteBufferHighWaterMark(int n) {
        super.setWriteBufferHighWaterMark(n);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setWriteBufferLowWaterMark(int n) {
        super.setWriteBufferLowWaterMark(n);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public NioDomainSocketChannel$NioDomainSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    @Override
    protected void autoReadCleared() {
        NioDomainSocketChannel.access$500(this.this$0);
    }

    void setMaxBytesPerGatheringWrite(int n) {
        this.maxBytesPerGatheringWrite = n;
    }

    int getMaxBytesPerGatheringWrite() {
        return this.maxBytesPerGatheringWrite;
    }

    private void calculateMaxBytesPerGatheringWrite() {
        int n = this.getSendBufferSize() << 1;
        if (n > 0) {
            this.setMaxBytesPerGatheringWrite(n);
        }
    }

    private SocketChannel jdkChannel() {
        return this.javaChannel;
    }

    /* synthetic */ NioDomainSocketChannel$NioDomainSocketChannelConfig(NioDomainSocketChannel nioDomainSocketChannel, NioDomainSocketChannel nioDomainSocketChannel2, SocketChannel socketChannel, NioDomainSocketChannel$1 nioDomainSocketChannel$1) {
        this(nioDomainSocketChannel, nioDomainSocketChannel2, socketChannel);
    }
}

