/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer.search;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import pro.gravit.repackage.io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import pro.gravit.repackage.io.netty.buffer.search.AhoCorasicSearchProcessorFactory$Context;
import pro.gravit.repackage.io.netty.buffer.search.AhoCorasicSearchProcessorFactory$Processor;

public class AhoCorasicSearchProcessorFactory
extends AbstractMultiSearchProcessorFactory {
    private final int[] jumpTable;
    private final int[] matchForNeedleId;
    static final int BITS_PER_SYMBOL = 8;
    static final int ALPHABET_SIZE = 256;

    AhoCorasicSearchProcessorFactory(byte[] ... byArray) {
        byte[][] object = byArray;
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            byte[] byArray2 = object[i];
            if (byArray2.length != 0) continue;
            throw new IllegalArgumentException("Needle must be non empty");
        }
        AhoCorasicSearchProcessorFactory$Context ahoCorasicSearchProcessorFactory$Context = AhoCorasicSearchProcessorFactory.buildTrie(byArray);
        this.jumpTable = ahoCorasicSearchProcessorFactory$Context.jumpTable;
        this.matchForNeedleId = ahoCorasicSearchProcessorFactory$Context.matchForNeedleId;
        this.linkSuffixes();
        for (n = 0; n < this.jumpTable.length; ++n) {
            if (this.matchForNeedleId[this.jumpTable[n] >> 8] < 0) continue;
            this.jumpTable[n] = -this.jumpTable[n];
        }
    }

    private static AhoCorasicSearchProcessorFactory$Context buildTrie(byte[][] byArray) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(256);
        for (int i = 0; i < 256; ++i) {
            arrayList.add(-1);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(-1);
        for (int i = 0; i < byArray.length; ++i) {
            byte[] byArray2 = byArray[i];
            int n2 = 0;
            for (byte by : byArray2) {
                int n3 = by & 0xFF;
                int n4 = n2 + n3;
                if ((Integer)arrayList.get(n4) == -1) {
                    arrayList.set(n4, arrayList.size());
                    for (int j = 0; j < 256; ++j) {
                        arrayList.add(-1);
                    }
                    arrayList2.add(-1);
                }
                n2 = (Integer)arrayList.get(n4);
            }
            arrayList2.set(n2 >> 8, i);
        }
        AhoCorasicSearchProcessorFactory$Context ahoCorasicSearchProcessorFactory$Context = new AhoCorasicSearchProcessorFactory$Context(null);
        ahoCorasicSearchProcessorFactory$Context.jumpTable = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            ahoCorasicSearchProcessorFactory$Context.jumpTable[n] = (Integer)arrayList.get(n);
        }
        ahoCorasicSearchProcessorFactory$Context.matchForNeedleId = new int[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            ahoCorasicSearchProcessorFactory$Context.matchForNeedleId[n] = (Integer)arrayList2.get(n);
        }
        return ahoCorasicSearchProcessorFactory$Context;
    }

    private void linkSuffixes() {
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        arrayDeque.add(0);
        int[] nArray = new int[this.matchForNeedleId.length];
        Arrays.fill(nArray, -1);
        while (!arrayDeque.isEmpty()) {
            int n;
            int n2 = (Integer)arrayDeque.remove();
            int n3 = n2 >> 8;
            int n4 = n = nArray[n3] == -1 ? 0 : nArray[n3];
            if (this.matchForNeedleId[n3] == -1) {
                this.matchForNeedleId[n3] = this.matchForNeedleId[n >> 8];
            }
            for (int i = 0; i < 256; ++i) {
                int n5 = n2 | i;
                int n6 = n | i;
                int n7 = this.jumpTable[n5];
                int n8 = this.jumpTable[n6];
                if (n7 != -1) {
                    nArray[n7 >> 8] = n2 > 0 && n8 != -1 ? n8 : 0;
                    arrayDeque.add(n7);
                    continue;
                }
                this.jumpTable[n5] = n8 != -1 ? n8 : 0;
            }
        }
    }

    @Override
    public AhoCorasicSearchProcessorFactory$Processor newSearchProcessor() {
        return new AhoCorasicSearchProcessorFactory$Processor(this.jumpTable, this.matchForNeedleId);
    }
}

