/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$AllocationStatistics;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$Chunk;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$ChunkAllocator;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

@SuppressJava6Requirement(reason="Guarded by version check")
final class AdaptivePoolingAllocator$Magazine
extends AdaptivePoolingAllocator$AllocationStatistics {
    private static final AtomicReferenceFieldUpdater<AdaptivePoolingAllocator$Magazine, AdaptivePoolingAllocator$Chunk> NEXT_IN_LINE;
    private static final AdaptivePoolingAllocator$Chunk MAGAZINE_FREED;
    private AdaptivePoolingAllocator$Chunk current;
    private volatile AdaptivePoolingAllocator$Chunk nextInLine;
    private final AtomicLong usedMemory;
    private final StampedLock allocationLock;
    static final /* synthetic */ boolean $assertionsDisabled;

    AdaptivePoolingAllocator$Magazine(AdaptivePoolingAllocator adaptivePoolingAllocator) {
        this(adaptivePoolingAllocator, true);
    }

    AdaptivePoolingAllocator$Magazine(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl) {
        super(adaptivePoolingAllocator, bl, null);
        this.allocationLock = bl ? new StampedLock() : null;
        this.usedMemory = new AtomicLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAllocate(int n, int n2, int n3, AdaptivePoolingAllocator.AdaptiveByteBuf adaptiveByteBuf) {
        if (this.allocationLock == null) {
            return this.allocate(n, n2, n3, adaptiveByteBuf);
        }
        long l = this.allocationLock.tryWriteLock();
        if (l != 0L) {
            try {
                boolean bl = this.allocate(n, n2, n3, adaptiveByteBuf);
                return bl;
            }
            finally {
                this.allocationLock.unlockWrite(l);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocate(int n, int n2, int n3, AdaptivePoolingAllocator.AdaptiveByteBuf adaptiveByteBuf) {
        this.recordAllocationSize(n2);
        AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk = this.current;
        if (adaptivePoolingAllocator$Chunk != null) {
            if (adaptivePoolingAllocator$Chunk.remainingCapacity() > n) {
                adaptivePoolingAllocator$Chunk.readInitInto(adaptiveByteBuf, n, n3);
                return true;
            }
            this.current = null;
            if (adaptivePoolingAllocator$Chunk.remainingCapacity() == n) {
                try {
                    adaptivePoolingAllocator$Chunk.readInitInto(adaptiveByteBuf, n, n3);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    adaptivePoolingAllocator$Chunk.release();
                }
            }
        }
        AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk2 = adaptivePoolingAllocator$Chunk;
        if (!$assertionsDisabled && this.current != null) {
            throw new AssertionError();
        }
        if (this.nextInLine != null) {
            adaptivePoolingAllocator$Chunk = NEXT_IN_LINE.getAndSet(this, null);
            if (adaptivePoolingAllocator$Chunk == MAGAZINE_FREED) {
                this.restoreMagazineFreed();
                return false;
            }
        } else {
            adaptivePoolingAllocator$Chunk = (AdaptivePoolingAllocator$Chunk)AdaptivePoolingAllocator.access$600(this.parent).poll();
            if (adaptivePoolingAllocator$Chunk == null) {
                adaptivePoolingAllocator$Chunk = this.newChunkAllocation(n);
            }
        }
        this.current = adaptivePoolingAllocator$Chunk;
        if (!$assertionsDisabled && this.current == null) {
            throw new AssertionError();
        }
        if (adaptivePoolingAllocator$Chunk2 != null) {
            if (adaptivePoolingAllocator$Chunk2.remainingCapacity() < 4096) {
                adaptivePoolingAllocator$Chunk2.release();
            } else {
                this.transferChunk(adaptivePoolingAllocator$Chunk2);
            }
        }
        if (adaptivePoolingAllocator$Chunk.remainingCapacity() > n) {
            adaptivePoolingAllocator$Chunk.readInitInto(adaptiveByteBuf, n, n3);
        } else {
            if (adaptivePoolingAllocator$Chunk.remainingCapacity() == n) {
                try {
                    adaptivePoolingAllocator$Chunk.readInitInto(adaptiveByteBuf, n, n3);
                }
                finally {
                    adaptivePoolingAllocator$Chunk.release();
                    this.current = null;
                }
            }
            AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk3 = this.newChunkAllocation(n);
            try {
                adaptivePoolingAllocator$Chunk3.readInitInto(adaptiveByteBuf, n, n3);
                if (adaptivePoolingAllocator$Chunk.remainingCapacity() < 4096) {
                    adaptivePoolingAllocator$Chunk.release();
                    this.current = adaptivePoolingAllocator$Chunk3;
                } else {
                    this.transferChunk(adaptivePoolingAllocator$Chunk3);
                }
                adaptivePoolingAllocator$Chunk3 = null;
            }
            finally {
                if (adaptivePoolingAllocator$Chunk3 != null) {
                    if (!$assertionsDisabled && this.current != null) {
                        throw new AssertionError();
                    }
                    adaptivePoolingAllocator$Chunk3.release();
                }
            }
        }
        return true;
    }

    private void restoreMagazineFreed() {
        AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk = NEXT_IN_LINE.getAndSet(this, MAGAZINE_FREED);
        if (adaptivePoolingAllocator$Chunk != null && adaptivePoolingAllocator$Chunk != MAGAZINE_FREED) {
            adaptivePoolingAllocator$Chunk.release();
        }
    }

    private void transferChunk(AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk) {
        if (NEXT_IN_LINE.compareAndSet(this, null, adaptivePoolingAllocator$Chunk) || AdaptivePoolingAllocator.access$700(this.parent, adaptivePoolingAllocator$Chunk)) {
            return;
        }
        AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk2 = NEXT_IN_LINE.get(this);
        if (adaptivePoolingAllocator$Chunk2 != null && adaptivePoolingAllocator$Chunk.remainingCapacity() > adaptivePoolingAllocator$Chunk2.remainingCapacity() && NEXT_IN_LINE.compareAndSet(this, adaptivePoolingAllocator$Chunk2, adaptivePoolingAllocator$Chunk)) {
            if (adaptivePoolingAllocator$Chunk2 != MAGAZINE_FREED) {
                adaptivePoolingAllocator$Chunk2.release();
            }
            return;
        }
        adaptivePoolingAllocator$Chunk.release();
    }

    private AdaptivePoolingAllocator$Chunk newChunkAllocation(int n) {
        int n2 = Math.max(n * 10, this.preferredChunkSize());
        AdaptivePoolingAllocator$ChunkAllocator adaptivePoolingAllocator$ChunkAllocator = AdaptivePoolingAllocator.access$800(this.parent);
        return new AdaptivePoolingAllocator$Chunk(adaptivePoolingAllocator$ChunkAllocator.allocate(n2, n2), this, true);
    }

    boolean trySetNextInLine(AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk) {
        return NEXT_IN_LINE.compareAndSet(this, null, adaptivePoolingAllocator$Chunk);
    }

    void free() {
        this.restoreMagazineFreed();
        long l = this.allocationLock.writeLock();
        try {
            if (this.current != null) {
                this.current.release();
                this.current = null;
            }
        }
        finally {
            this.allocationLock.unlockWrite(l);
        }
    }

    static /* synthetic */ AtomicLong access$300(AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine) {
        return adaptivePoolingAllocator$Magazine.usedMemory;
    }

    static {
        $assertionsDisabled = !AdaptivePoolingAllocator.class.desiredAssertionStatus();
        NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(AdaptivePoolingAllocator$Magazine.class, AdaptivePoolingAllocator$Chunk.class, "nextInLine");
        MAGAZINE_FREED = new AdaptivePoolingAllocator$Chunk();
    }
}

