/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.bootstrap;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.repackage.io.netty.bootstrap.AbstractBootstrap;
import pro.gravit.repackage.io.netty.bootstrap.ChannelInitializerExtension;
import pro.gravit.repackage.io.netty.bootstrap.ServerBootstrap$1;
import pro.gravit.repackage.io.netty.bootstrap.ServerBootstrapConfig;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelOption;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.EventLoopGroup;
import pro.gravit.repackage.io.netty.channel.ServerChannel;
import pro.gravit.repackage.io.netty.util.AttributeKey;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class ServerBootstrap
extends AbstractBootstrap<ServerBootstrap, ServerChannel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new ConcurrentHashMap();
    private final ServerBootstrapConfig config = new ServerBootstrapConfig(this);
    private volatile EventLoopGroup childGroup;
    private volatile ChannelHandler childHandler;

    public ServerBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerBootstrap(ServerBootstrap serverBootstrap) {
        super(serverBootstrap);
        this.childGroup = serverBootstrap.childGroup;
        this.childHandler = serverBootstrap.childHandler;
        Map<ChannelOption<?>, Object> map = serverBootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(serverBootstrap.childOptions);
        }
        this.childAttrs.putAll(serverBootstrap.childAttrs);
    }

    @Override
    public ServerBootstrap group(EventLoopGroup eventLoopGroup) {
        return this.group(eventLoopGroup, eventLoopGroup);
    }

    public ServerBootstrap group(EventLoopGroup eventLoopGroup, EventLoopGroup eventLoopGroup2) {
        super.group(eventLoopGroup);
        if (this.childGroup != null) {
            throw new IllegalStateException("childGroup set already");
        }
        this.childGroup = ObjectUtil.checkNotNull(eventLoopGroup2, "childGroup");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServerBootstrap childOption(ChannelOption<T> channelOption, T t) {
        ObjectUtil.checkNotNull(channelOption, "childOption");
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            if (t == null) {
                this.childOptions.remove(channelOption);
            } else {
                this.childOptions.put(channelOption, t);
            }
        }
        return this;
    }

    public <T> ServerBootstrap childAttr(AttributeKey<T> attributeKey, T t) {
        ObjectUtil.checkNotNull(attributeKey, "childKey");
        if (t == null) {
            this.childAttrs.remove(attributeKey);
        } else {
            this.childAttrs.put(attributeKey, t);
        }
        return this;
    }

    public ServerBootstrap childHandler(ChannelHandler channelHandler) {
        this.childHandler = ObjectUtil.checkNotNull(channelHandler, "childHandler");
        return this;
    }

    @Override
    void init(Channel channel) {
        ServerBootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        ServerBootstrap.setAttributes(channel, this.newAttributesArray());
        ChannelPipeline channelPipeline = channel.pipeline();
        EventLoopGroup eventLoopGroup = this.childGroup;
        ChannelHandler channelHandler = this.childHandler;
        Map.Entry[] entryArray = ServerBootstrap.newOptionsArray(this.childOptions);
        Map.Entry[] entryArray2 = ServerBootstrap.newAttributesArray(this.childAttrs);
        Collection<ChannelInitializerExtension> collection = this.getInitializerExtensions();
        channelPipeline.addLast(new ServerBootstrap$1(this, eventLoopGroup, channelHandler, entryArray, entryArray2, collection));
        if (!collection.isEmpty() && channel instanceof ServerChannel) {
            ServerChannel serverChannel = (ServerChannel)channel;
            for (ChannelInitializerExtension channelInitializerExtension : collection) {
                try {
                    channelInitializerExtension.postInitializeServerListenerChannel(serverChannel);
                }
                catch (Exception exception) {
                    logger.warn("Exception thrown from postInitializeServerListenerChannel", exception);
                }
            }
        }
    }

    @Override
    public ServerBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.childGroup == null) {
            logger.warn("childGroup is not set. Using parentGroup instead.");
            this.childGroup = this.config.group();
        }
        return this;
    }

    @Override
    public ServerBootstrap clone() {
        return new ServerBootstrap(this);
    }

    @Deprecated
    public EventLoopGroup childGroup() {
        return this.childGroup;
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<ChannelOption<?>, Object> childOptions() {
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            return ServerBootstrap.copiedMap(this.childOptions);
        }
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return ServerBootstrap.copiedMap(this.childAttrs);
    }

    public final ServerBootstrapConfig config() {
        return this.config;
    }

    static /* synthetic */ ServerBootstrapConfig access$000(ServerBootstrap serverBootstrap) {
        return serverBootstrap.config;
    }

    static /* synthetic */ InternalLogger access$100() {
        return logger;
    }
}

