/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.api;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.activity.Activity;
import de.jcm.discordgamesdk.activity.ActivityButton;
import de.jcm.discordgamesdk.activity.ActivityButtonsMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.KRAFTOK7so5aQv;
import pro.gravit.launcher.KrAftOKCCaEFHX;
import pro.gravit.launcher.krAfTOktT7GXBC;
import pro.gravit.launcher.kraftOkpHzXpFA;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class DiscordActivityService {
    private final Map<String, String> params = new ConcurrentHashMap<String, String>();
    private String details;
    private String state;
    private String largeKey;
    private String smallKey;
    private String largeText;
    private String smallText;
    private String partyId;
    private int partySize;
    private int partyMaxSize;
    private final List<ActivityButton> buttons = new ArrayList<ActivityButton>(2);

    public DiscordActivityService() {
        this.setParam("launcherVersion", Version.getVersion().getVersionString());
        this.setParam("javaVersion", Integer.toString(JVMHelper.JVM_VERSION));
        this.setParam("javaBits", Integer.toString(JVMHelper.JVM_BITS));
        this.setParam("os", JVMHelper.OS_TYPE.name);
    }

    public void applyToActivity(Activity activity) {
        if (this.details != null) {
            activity.setDetails(this.details);
        }
        if (this.state != null) {
            activity.setState(this.state);
        }
        if (this.largeKey != null) {
            activity.assets().setLargeImage(this.largeKey);
        }
        if (this.smallKey != null) {
            activity.assets().setSmallImage(this.smallKey);
        }
        if (this.smallText != null) {
            activity.assets().setSmallText(this.smallText);
        }
        if (this.largeText != null) {
            activity.assets().setLargeText(this.largeText);
        }
        if (this.partyId != null) {
            activity.party().setID(this.partyId);
        }
        if (this.partyMaxSize != 0) {
            activity.party().size().setCurrentSize(this.partySize);
            activity.party().size().setMaxSize(this.partyMaxSize);
        }
        if (!this.buttons.isEmpty()) {
            activity.setActivityButtonsMode(ActivityButtonsMode.BUTTONS);
            ArrayList<ActivityButton> arrayList = new ArrayList<ActivityButton>(activity.getButtons());
            for (ActivityButton activityButton : arrayList) {
                activity.removeButton(activityButton);
            }
            for (ActivityButton activityButton : this.buttons) {
                activity.addButton(activityButton);
            }
        }
    }

    public void updateActivity() {
        Core core = KRAFTOK7so5aQv.KRAftOK3uPm1oe();
        if (core == null) {
            return;
        }
        this.applyToActivity(KRAFTOK7so5aQv.KrAFTok19hAkYg());
        core.activityManager().updateActivity(KRAFTOK7so5aQv.KrAFTok19hAkYg());
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String string) {
        this.details = this.replaceParams(string);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = this.replaceParams(string);
    }

    public String getLargeKey() {
        return this.largeKey;
    }

    public void setLargeKey(String string) {
        this.largeKey = this.replaceParams(string);
    }

    public String getSmallKey() {
        return this.smallKey;
    }

    public void setSmallKey(String string) {
        this.smallKey = this.replaceParams(string);
    }

    public String getLargeText() {
        return this.largeText;
    }

    public void setLargeText(String string) {
        this.largeText = this.replaceParams(string);
    }

    public String getSmallText() {
        return this.smallText;
    }

    public void setSmallText(String string) {
        this.smallText = this.replaceParams(string);
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String string) {
        this.partyId = this.replaceParams(string);
        this.updateActivity();
    }

    public int getPartySize() {
        return this.partySize;
    }

    public void setPartySize(int n) {
        this.partySize = n;
        this.updateActivity();
    }

    public int getPartyMaxSize() {
        return this.partyMaxSize;
    }

    public void setPartyMaxSize(int n) {
        this.partyMaxSize = n;
        this.updateActivity();
    }

    public void setParam(String string, String string2) {
        String string3 = this.params.put(string, string2);
        if (string3 != null) {
            this.updateActivity();
        }
    }

    public void addButton(ActivityButton activityButton) {
        this.buttons.add(activityButton);
    }

    public void clearButtons() {
        this.buttons.clear();
    }

    public String getParam(String string) {
        return this.params.get(string);
    }

    public Map<String, String> getUnmodifiableParamsMap() {
        return Collections.unmodifiableMap(this.params);
    }

    public String replaceParams(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (entry.getValue() == null) {
                LogHelper.warning("DiscordGame: Param %s null", entry.getKey());
                continue;
            }
            string2 = string2.replaceAll("%" + entry.getKey() + "%", entry.getValue());
        }
        return string2;
    }

    public void updateLoginStage() {
        this.setParam("username", "");
        this.setParam("uuid", "");
        this.setScope(krAfTOktT7GXBC.krAFtOKZdhYMep);
    }

    public void updateAuthorizedStage(PlayerProfile playerProfile) {
        this.onPlayerProfile(playerProfile);
        this.setScope(krAfTOktT7GXBC.KRAfTOKzBBJomr);
    }

    public void updateClientStage(kraftOkpHzXpFA kraftOkpHzXpFA2) {
        this.setParam("profileVersion", kraftOkpHzXpFA2.krAFtOKZdhYMep.getVersion().toString());
        this.setParam("profileName", kraftOkpHzXpFA2.krAFtOKZdhYMep.getTitle());
        this.setParam("profileUUID", kraftOkpHzXpFA2.krAFtOKZdhYMep.getUUID().toString());
        this.setParam("profileHash", kraftOkpHzXpFA2.krAFtOKZdhYMep.getUUID().toString().replaceAll("-", ""));
        this.onPlayerProfile(kraftOkpHzXpFA2.KrAFTOK5Awb29u);
        this.setScope(krAfTOktT7GXBC.KrafToKF4eK8g5);
    }

    public void onPlayerProfile(PlayerProfile playerProfile) {
        this.setParam("username", playerProfile.username);
        this.setParam("uuid", playerProfile.uuid.toString());
        if (playerProfile.assets.get("AVATAR") != null) {
            this.setParam("avatarUrl", playerProfile.assets.get((Object)"AVATAR").url);
        }
    }

    private void setScope(KrAftOKCCaEFHX krAftOKCCaEFHX) {
        LogHelper.dev(krAftOKCCaEFHX.toString());
        this.setDetails(krAftOKCCaEFHX.KRAftOK3uPm1oe());
        this.setState(krAftOKCCaEFHX.KrAFTok19hAkYg());
        this.setLargeKey(krAftOKCCaEFHX.kRafTOkUyp65cK());
        this.setLargeText(krAftOKCCaEFHX.kraFtOkiAvWbzC());
        this.setSmallKey(krAftOKCCaEFHX.KRafToKsvhHFte());
        this.setSmallText(krAftOKCCaEFHX.KrAFTOK5Awb29u());
        this.clearButtons();
        if (krAftOKCCaEFHX.krAFtOKZdhYMep()) {
            this.addButton(new ActivityButton(krAftOKCCaEFHX.KRAfTOKzBBJomr(), krAftOKCCaEFHX.KrafToKF4eK8g5()));
        }
        if (krAftOKCCaEFHX.KRafToKOVY7Ikz()) {
            this.addButton(new ActivityButton(krAftOKCCaEFHX.kraFTOkCRQX9uA(), krAftOKCCaEFHX.krAfTOKhCiArNe()));
        }
        this.updateActivity();
    }

    public void resetStartTime() {
        KRAFTOK7so5aQv.KrAFTok19hAkYg().timestamps().setStart(Instant.now());
    }
}

