/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.impl.Command;
import de.jcm.discordgamesdk.user.DiscordUser;
import de.jcm.discordgamesdk.user.PremiumType;
import java.util.function.BiConsumer;

public class UserManager {
    private final Core.CorePrivate core;
    public static final int USER_FLAG_PARTNER = 2;
    public static final int USER_FLAG_HYPE_SQUAD_EVENTS = 4;
    public static final int USER_FLAG_HYPE_SQUAD_HOUSE1 = 64;
    public static final int USER_FLAG_HYPE_SQUAD_HOUSE2 = 128;
    public static final int USER_FLAG_HYPE_SQUAD_HOUSE3 = 256;

    UserManager(Core.CorePrivate corePrivate) {
        this.core = corePrivate;
    }

    public DiscordUser getCurrentUser() {
        if (this.core.currentUser == null) {
            throw new GameSDKException(Result.NOT_FOUND);
        }
        return this.core.currentUser;
    }

    public void getUser(long l, BiConsumer<Result, DiscordUser> biConsumer) {
        this.core.sendCommand(Command.Type.GET_USER, new DiscordUser(l), command -> {
            DiscordUser discordUser = this.core.getGson().fromJson(command.getData(), DiscordUser.class);
            biConsumer.accept(this.core.checkError((Command)command), discordUser);
        });
    }

    public PremiumType getCurrentUserPremiumType() {
        throw new RuntimeException("not implemented");
    }

    public boolean currentUserHasFlag(int n) {
        return (this.core.currentUser.getFlags() & n) != 0;
    }
}

