/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.gui.options;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.gliby.voicechat.client.VoiceChatClient;
import net.gliby.voicechat.client.device.Device;
import net.gliby.voicechat.client.gui.GuiBoostSlider;
import net.gliby.voicechat.client.gui.GuiCustomButton;
import net.gliby.voicechat.client.gui.GuiDropDownMenu;
import net.gliby.voicechat.client.gui.GuiScreenDonate;
import net.gliby.voicechat.client.gui.GuiScreenLocalMute;
import net.gliby.voicechat.client.gui.options.GuiScreenOptionsUI;
import net.gliby.voicechat.client.gui.options.GuiScreenOptionsWizard;
import net.gliby.voicechat.client.gui.options.GuiScreenVoiceChatOptionsAdvanced;
import net.gliby.voicechat.client.sound.MicrophoneTester;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiScreenVoiceChatOptions
extends GuiScreen {
    private final VoiceChatClient voiceChat;
    private final MicrophoneTester tester;
    private GuiCustomButton advancedOptions;
    private GuiCustomButton mutePlayer;
    private GuiBoostSlider boostSlider;
    private GuiBoostSlider voiceVolume;
    private GuiDropDownMenu dropDown;
    private GuiButton UIPosition;
    private GuiButton microphoneMode;
    private List<String> warningMessages;
    private String updateMessage;

    public GuiScreenVoiceChatOptions(VoiceChatClient voiceChat) {
        this.voiceChat = voiceChat;
        this.tester = new MicrophoneTester(voiceChat);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 899: {
                if (this.dropDown.dropDownMenu) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenVoiceChatOptionsAdvanced(this.voiceChat, this));
                break;
            }
            case 898: {
                if (this.dropDown.dropDownMenu) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenOptionsWizard(this.voiceChat, this));
                break;
            }
            case 0: {
                if (!(button instanceof GuiDropDownMenu) || this.voiceChat.getSettings().getDeviceHandler().isEmpty()) break;
                ((GuiDropDownMenu)button).dropDownMenu = !((GuiDropDownMenu)button).dropDownMenu;
                break;
            }
            case 1: {
                this.voiceChat.getSettings().getConfiguration().save();
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenDonate(this.voiceChat.getModInfo(), VoiceChatClient.getModMetadata(), this));
                break;
            }
            case 2: {
                if (!this.tester.recording) {
                    this.tester.start();
                } else {
                    this.tester.stop();
                }
                button.field_146126_j = this.tester.recording ? I18n.func_135052_a((String)"menu.microphoneStopTest", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.microphoneTest", (Object[])new Object[0]);
                break;
            }
            case 3: {
                this.voiceChat.getSettings().getConfiguration().save();
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 4: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenOptionsUI(this.voiceChat, this));
                break;
            }
            case 897: {
                if (this.dropDown.dropDownMenu) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenLocalMute(this, this.voiceChat));
                break;
            }
            case 5: {
                if (!this.dropDown.dropDownMenu) {
                    this.microphoneMode.field_146125_m = true;
                    this.microphoneMode.field_146124_l = true;
                    this.voiceChat.getSettings().setSpeakMode(this.voiceChat.getSettings().getSpeakMode() == 0 ? 1 : 0);
                    this.microphoneMode.field_146126_j = I18n.func_135052_a((String)"menu.speakMode", (Object[])new Object[0]) + ": " + (this.voiceChat.getSettings().getSpeakMode() == 0 ? I18n.func_135052_a((String)"menu.speakModePushToTalk", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.speakModeToggleToTalk", (Object[])new Object[0]));
                    break;
                }
                if (!this.voiceChat.getSettings().getDeviceHandler().isEmpty()) break;
                this.microphoneMode.field_146125_m = false;
                this.microphoneMode.field_146124_l = false;
            }
        }
    }

    public void func_73863_a(int x, int y, float tick) {
        this.func_146276_q_();
        GL11.glPushMatrix();
        float scale = 1.5f;
        GL11.glTranslatef((float)((float)(this.field_146294_l / 2) - (float)(this.field_146289_q.func_78256_a("Gliby's Voice Chat Options") / 2) * 1.5f), (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)0.0f);
        this.func_73731_b(this.field_146289_q, "Gliby's Voice Chat Options", 0, 6, -1);
        GL11.glPopMatrix();
        for (int i = 0; i < this.warningMessages.size(); ++i) {
            int warnY = i * this.field_146289_q.field_78288_b + this.field_146295_m / 2 + 66 - this.field_146289_q.field_78288_b * this.warningMessages.size() / 2;
            this.func_73732_a(this.field_146289_q, this.warningMessages.get(i), this.field_146294_l / 2, warnY, -1);
        }
        super.func_73863_a(x, y, tick);
    }

    public boolean inBounds(int x, int y, int posX, int posY, int width, int height) {
        return x >= posX && y >= posY && x < posX + width && y < posY + height;
    }

    public void func_73866_w_() {
        String[] array = new String[this.voiceChat.getSettings().getDeviceHandler().getDevices().size()];
        for (int i = 0; i < this.voiceChat.getSettings().getDeviceHandler().getDevices().size(); ++i) {
            array[i] = this.voiceChat.getSettings().getDeviceHandler().getDevices().get(i).getName();
        }
        int heightOffset = 55;
        this.dropDown = new GuiDropDownMenu(0, this.field_146294_l / 2 - 152, this.field_146295_m / 2 - 55, 150, 20, this.voiceChat.getSettings().getInputDevice() != null ? this.voiceChat.getSettings().getInputDevice().getName() : "None", array);
        this.microphoneMode = new GuiButton(5, this.field_146294_l / 2 - 152, this.field_146295_m / 2 + 25 - 55, 150, 20, I18n.func_135052_a((String)"menu.speakMode", (Object[])new Object[0]) + ": " + (this.voiceChat.getSettings().getSpeakMode() == 0 ? I18n.func_135052_a((String)"menu.speakModePushToTalk", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.speakModeToggleToTalk", (Object[])new Object[0])));
        this.UIPosition = new GuiButton(4, this.field_146294_l / 2 + 2, this.field_146295_m / 2 + 25 - 55, 150, 20, I18n.func_135052_a((String)"menu.uiOptions", (Object[])new Object[0]));
        this.voiceVolume = new GuiBoostSlider(910, this.field_146294_l / 2 + 2, this.field_146295_m / 2 - 25 - 55, "", I18n.func_135052_a((String)"menu.worldVolume", (Object[])new Object[0]) + ": " + (this.voiceChat.getSettings().getWorldVolume() == 0.0f ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : String.valueOf((int)(this.voiceChat.getSettings().getWorldVolume() * 100.0f)) + "%"), 0.0f);
        this.voiceVolume.sliderValue = this.voiceChat.getSettings().getWorldVolume();
        this.boostSlider = new GuiBoostSlider(900, this.field_146294_l / 2 + 2, this.field_146295_m / 2 - 55, "", I18n.func_135052_a((String)"menu.boost", (Object[])new Object[0]) + ": " + ((int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) <= 0 ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : "" + (int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) + "db"), 0.0f);
        this.boostSlider.sliderValue = this.voiceChat.getSettings().getInputBoost();
        this.advancedOptions = new GuiCustomButton(899, this.field_146294_l / 2 + 2, this.field_146295_m / 2 + 49 - 55, 150, 20, I18n.func_135052_a((String)"menu.advancedOptions", (Object[])new Object[0]));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 151, this.field_146295_m - 34, 75, 20, I18n.func_135052_a((String)"menu.gman.supportGliby", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 152, this.field_146295_m / 2 - 25 - 55, 150, 20, !this.tester.recording ? I18n.func_135052_a((String)"menu.microphoneTest", (Object[])new Object[0]) : I18n.func_135052_a((String)"menu.microphoneStopTest", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 75, this.field_146295_m - 34, 150, 20, I18n.func_135052_a((String)"menu.returnToGame", (Object[])new Object[0])));
        this.field_146292_n.add(this.advancedOptions);
        this.field_146292_n.add(new GuiCustomButton(898, this.field_146294_l / 2 - 152, this.field_146295_m / 2 + 49 - 55, 150, 20, I18n.func_135052_a((String)"menu.openOptionsWizard", (Object[])new Object[0])));
        this.field_146292_n.add(this.UIPosition);
        this.field_146292_n.add(this.microphoneMode);
        this.field_146292_n.add(this.boostSlider);
        this.field_146292_n.add(this.voiceVolume);
        this.mutePlayer = new GuiCustomButton(897, this.field_146294_l / 2 - 152, this.field_146295_m / 2 + 73 - 55, 304, 20, I18n.func_135052_a((String)"menu.mutePlayers", (Object[])new Object[0]));
        this.field_146292_n.add(this.mutePlayer);
        this.field_146292_n.add(this.dropDown);
        if (this.voiceChat.getSettings().getDeviceHandler().isEmpty()) {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = false;
            ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = false;
            this.boostSlider.field_146124_l = false;
            this.mutePlayer.field_146124_l = false;
            this.microphoneMode.field_146124_l = false;
            this.mutePlayer.field_146124_l = false;
        }
        super.func_73866_w_();
        this.warningMessages = new ArrayList<String>();
        if (this.voiceChat.getSettings().getDeviceHandler().isEmpty()) {
            this.warningMessages.add(EnumChatFormatting.DARK_RED + "No input devices found, add input device and restart Minecraft.");
        }
        if (this.voiceChat.getModInfo().updateNeeded()) {
            this.updateMessage = I18n.func_135052_a((String)"menu.downloadLatest", (Object[])new Object[0]) + "\u00a7b " + this.voiceChat.getModInfo().updateURL;
            this.warningMessages.add(this.updateMessage);
            this.warningMessages.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"menu.modOutdated", (Object[])new Object[0]));
        }
        if (this.field_146297_k.func_71356_B() && !this.field_146297_k.func_71401_C().func_71344_c()) {
            this.warningMessages.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"menu.warningSingleplayer", (Object[])new Object[0]));
        }
        if (!this.voiceChat.getClientNetwork().isConnected() && !this.field_146297_k.func_71356_B()) {
            this.warningMessages.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"Server doesn't support voice chat.", (Object[])new Object[0]));
        }
    }

    public void func_73869_a(char c, int key) {
        if (key == 1) {
            this.voiceChat.getSettings().getConfiguration().save();
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_73864_a(int x, int y, int b) {
        if (b == 0) {
            if (!this.voiceChat.getModInfo().updateNeeded()) {
                // empty if block
            }
            for (int i = 0; i < this.warningMessages.size(); ++i) {
                String s = this.warningMessages.get(i);
                if (!s.equals(this.updateMessage)) continue;
                int warnY = i * this.field_146289_q.field_78288_b + this.field_146295_m / 2 + 66 - this.field_146289_q.field_78288_b * this.warningMessages.size() / 2;
                int length = this.field_146289_q.func_78256_a(s);
                if (!this.inBounds(x, y, this.field_146294_l / 2 - length / 2, warnY, length, this.field_146289_q.field_78288_b)) continue;
                this.openURL(this.voiceChat.modInfo.updateURL);
            }
            if (this.dropDown.getMouseOverInteger() != -1 && this.dropDown.dropDownMenu && !this.voiceChat.getSettings().getDeviceHandler().isEmpty()) {
                Device device = this.voiceChat.getSettings().getDeviceHandler().getDevices().get(this.dropDown.getMouseOverInteger());
                if (device == null) {
                    return;
                }
                this.voiceChat.getSettings().setInputDevice(device);
                this.dropDown.setDisplayString(device.getName());
            }
        }
        super.func_73864_a(x, y, b);
    }

    public void func_146281_b() {
        if (this.tester.recording) {
            this.tester.stop();
        }
    }

    private void openURL(String par1URI) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(par1URI));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void func_73876_c() {
        this.voiceChat.getSettings().setWorldVolume(this.voiceVolume.sliderValue);
        this.voiceChat.getSettings().setInputBoost(this.boostSlider.sliderValue);
        this.voiceVolume.setDisplayString(I18n.func_135052_a((String)"menu.worldVolume", (Object[])new Object[0]) + ": " + (this.voiceChat.getSettings().getWorldVolume() == 0.0f ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : (int)(this.voiceChat.getSettings().getWorldVolume() * 100.0f) + "%"));
        this.boostSlider.setDisplayString(I18n.func_135052_a((String)"menu.boost", (Object[])new Object[0]) + ": " + ((int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) <= 0 ? I18n.func_135052_a((String)"options.off", (Object[])new Object[0]) : (int)(this.voiceChat.getSettings().getInputBoost() * 5.0f) + "db"));
        this.advancedOptions.allowed = !this.dropDown.dropDownMenu;
        this.mutePlayer.allowed = !this.dropDown.dropDownMenu;
    }
}

