/*
 * Decompiled with CFR 0.152.
 */
package net.gliby.voicechat.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.gliby.voicechat.VoiceChat;
import net.gliby.voicechat.client.Settings;
import net.gliby.voicechat.client.gui.GuiBoostSlider;
import net.gliby.voicechat.client.gui.GuiPlaceableInterface;
import net.gliby.voicechat.client.gui.GuiUIPlacementSpeak;
import net.gliby.voicechat.client.gui.GuiUIPlacementVoicePlate;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiUIPlacement
extends GuiScreen {
    private final List<GuiPlaceableInterface> placeables = new ArrayList<GuiPlaceableInterface>();
    private final GuiScreen parent;
    private int offsetX;
    private int offsetY;
    public String[] positionTypes = new String[2];
    private GuiButton positionTypeButton;
    private GuiButton resetButton;
    private GuiBoostSlider scaleSlider;
    private GuiPlaceableInterface selectedUIPlaceable;
    private GuiPlaceableInterface lastSelected;

    public static void drawRectLines(int par0, int par1, int par2, int par3, int par4) {
        int j1;
        if (par0 < par2) {
            j1 = par0;
            par0 = par2;
            par2 = j1;
        }
        if (par1 < par3) {
            j1 = par1;
            par1 = par3;
            par3 = j1;
        }
        float f = (float)(par4 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par4 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par4 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par4 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        tessellator.func_78371_b(2);
        tessellator.func_78377_a((double)par0, (double)par3, 0.0);
        tessellator.func_78377_a((double)par2, (double)par3, 0.0);
        tessellator.func_78377_a((double)par2, (double)par1, 0.0);
        tessellator.func_78377_a((double)par0, (double)par1, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public GuiUIPlacement(GuiScreen parent) {
        this.parent = parent;
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && this.lastSelected != null) {
            this.lastSelected.positionType = this.lastSelected.positionType >= 1 ? 0 : ++this.lastSelected.positionType;
        }
        if (button.field_146127_k == 1 && this.lastSelected != null) {
            if (this.lastSelected.info.positionType == 0) {
                this.lastSelected.x = this.lastSelected.info.x * (float)this.field_146294_l;
                this.lastSelected.y = this.lastSelected.info.y * (float)this.field_146295_m;
            } else {
                this.lastSelected.x = this.lastSelected.info.x;
                this.lastSelected.y = this.lastSelected.info.y;
            }
        }
    }

    public void drawRectWH(int x, int y, int width, int height, int color) {
        GuiUIPlacement.func_73734_a((int)x, (int)y, (int)(width + x), (int)(height + y), (int)color);
    }

    public void func_73863_a(int x, int y, float tick) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"menu.pressESCtoReturn", (Object[])new Object[0]), this.field_146294_l / 2, 2, -1);
        if (this.selectedUIPlaceable != null) {
            this.selectedUIPlaceable.x = x - this.offsetX;
            this.selectedUIPlaceable.y = y - this.offsetY;
            if (!Mouse.isButtonDown((int)0)) {
                this.selectedUIPlaceable = null;
            }
        }
        if (this.lastSelected != null) {
            this.scaleSlider.setDisplayString(I18n.func_135052_a((String)"menu.scale", (Object[])new Object[0]) + ": " + (int)(this.lastSelected.scale * 100.0f) + "%");
            this.scaleSlider.sliderValue = this.lastSelected.scale;
            boolean rightSide = this.inBounds(this.lastSelected.x + (float)this.lastSelected.width + 151.0f, this.lastSelected.y + 42.0f, this.field_146294_l, 0.0f, this.field_146294_l, this.field_146295_m * 2);
            boolean topSide = this.inBounds(this.lastSelected.x + (float)this.lastSelected.width - 75.0f, this.lastSelected.y, -this.field_146294_l, -this.field_146295_m, this.field_146294_l * 2, this.field_146295_m);
            boolean bottomSide = this.inBounds(this.lastSelected.x + (float)this.lastSelected.width, this.lastSelected.y + 66.0f, 0.0f, this.field_146295_m, this.field_146294_l * 2, this.field_146295_m);
            this.positionTypeButton.field_146128_h = (int)(this.lastSelected.x + (float)(rightSide ? -100 : this.lastSelected.width + 2));
            this.positionTypeButton.field_146129_i = (int)(this.lastSelected.y - (bottomSide ? this.lastSelected.y + 66.0f - (float)this.field_146295_m : (topSide ? this.lastSelected.y - 0.0f : 0.0f)));
            this.scaleSlider.field_146128_h = (int)(this.lastSelected.x + (float)(rightSide ? -154 : this.lastSelected.width + 2));
            this.scaleSlider.field_146129_i = (int)(this.lastSelected.y + 22.0f - (bottomSide ? this.lastSelected.y + 66.0f - (float)this.field_146295_m : (topSide ? this.lastSelected.y - 0.0f : 0.0f)));
            this.resetButton.field_146128_h = (int)(this.lastSelected.x + (float)(rightSide ? -100 : this.lastSelected.width + 2));
            this.resetButton.field_146129_i = (int)(this.lastSelected.y + 44.0f - (bottomSide ? this.lastSelected.y + 66.0f - (float)this.field_146295_m : (topSide ? this.lastSelected.y - 0.0f : 0.0f)));
            this.positionTypeButton.field_146126_j = I18n.func_135052_a((String)"menu.position", (Object[])new Object[0]) + ": " + this.positionTypes[this.lastSelected.positionType];
            this.positionTypeButton.func_146112_a(this.field_146297_k, x, y);
            this.resetButton.func_146112_a(this.field_146297_k, x, y);
            this.scaleSlider.func_146112_a(this.field_146297_k, x, y);
            this.lastSelected.scale = this.scaleSlider.sliderValue;
        }
        for (int i = 0; i < this.placeables.size(); ++i) {
            GuiPlaceableInterface placeable = this.placeables.get(i);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)placeable.x, (float)placeable.y, (float)0.0f);
            placeable.draw(this.field_146297_k, this, x, y, tick);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)placeable.x, (float)placeable.y, (float)0.0f);
            GL11.glLineWidth((float)4.0f);
            GuiUIPlacement.drawRectLines(0, 0, placeable.width, placeable.height, this.selectedUIPlaceable == placeable ? -16711936 : -1);
            GL11.glLineWidth((float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public boolean inBounds(float mouseX, float mouseY, float x, float y, float width, float height) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public void func_73866_w_() {
        this.positionTypes[0] = I18n.func_135052_a((String)"menu.positionAutomatic", (Object[])new Object[0]);
        this.positionTypes[1] = I18n.func_135052_a((String)"menu.positionAbsolute", (Object[])new Object[0]);
        if (this.scaleSlider == null) {
            this.placeables.add(new GuiUIPlacementSpeak(VoiceChat.getProxyInstance().getSettings().getUIPositionSpeak(), this.field_146294_l, this.field_146295_m));
            this.placeables.add(new GuiUIPlacementVoicePlate(VoiceChat.getProxyInstance().getSettings().getUIPositionPlate(), this.field_146294_l, this.field_146295_m));
        }
        this.positionTypeButton = new GuiButton(0, 2, 2, 96, 20, "Position: Automatic");
        this.field_146292_n.add(this.positionTypeButton);
        this.resetButton = new GuiButton(1, 2, 2, 96, 20, I18n.func_135052_a((String)"menu.resetLocation", (Object[])new Object[0]));
        this.field_146292_n.add(this.resetButton);
        this.scaleSlider = new GuiBoostSlider(2, 2, 2, "", "Scale: 100%", 0.0f);
        this.field_146292_n.add(this.scaleSlider);
        for (int i = 0; i < this.placeables.size(); ++i) {
            GuiPlaceableInterface placeableInterface = this.placeables.get(i);
            if (placeableInterface.positionType != 0) continue;
            this.resize(placeableInterface);
        }
    }

    public void func_73869_a(char par1, int par2) {
        if (this.lastSelected != null) {
            if (par2 == 200) {
                this.lastSelected.y -= 1.0f;
            }
            if (par2 == 208) {
                this.lastSelected.y += 1.0f;
            }
            if (par2 == 205) {
                this.lastSelected.x += 1.0f;
            }
            if (par2 == 203) {
                this.lastSelected.x -= 1.0f;
            }
        }
        if (par2 == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    public void func_73864_a(int x, int y, int b) {
        if (b == 0) {
            if (this.selectedUIPlaceable == null) {
                for (int i = 0; i < this.placeables.size(); ++i) {
                    GuiPlaceableInterface placeable = this.placeables.get(i);
                    if (!this.inBounds(x, y, placeable.x, placeable.y, placeable.width, placeable.height)) continue;
                    this.offsetX = (int)Math.abs((float)x - placeable.x);
                    this.offsetY = (int)Math.abs((float)y - placeable.y);
                    this.lastSelected = this.selectedUIPlaceable = placeable;
                }
            } else {
                this.selectedUIPlaceable = null;
            }
        }
        super.func_73864_a(x, y, b);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.save();
    }

    private void resize(GuiPlaceableInterface placeable) {
        placeable.update((int)((float)this.field_146294_l * (placeable.x * 1.0f / (float)placeable.screenWidth)), (int)((float)this.field_146295_m * (placeable.y * 1.0f / (float)placeable.screenHeight)), this.field_146294_l, this.field_146295_m);
    }

    public void save() {
        Settings settings = VoiceChat.getProxyInstance().getSettings();
        for (int i = 0; i < this.placeables.size(); ++i) {
            GuiPlaceableInterface placeable = this.placeables.get(i);
            if (placeable.positionType == 0) {
                placeable.positionUI.x = placeable.x * 1.0f / (float)placeable.screenWidth;
                placeable.positionUI.y = placeable.y * 1.0f / (float)placeable.screenHeight;
            } else {
                placeable.positionUI.x = placeable.x;
                placeable.positionUI.y = placeable.y;
            }
            placeable.positionUI.type = placeable.positionType;
            placeable.positionUI.scale = placeable.scale;
        }
        settings.getConfiguration().save();
    }

    public void func_73876_c() {
    }
}

