/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.task;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.CoordXZ;
import com.wimbli.WorldBorder.DynMapFeatures;
import com.wimbli.WorldBorder.WorldBorder;
import com.wimbli.WorldBorder.WorldFileData;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WorldTrimTask {
    private static WorldTrimTask INSTANCE = null;
    private final WorldServer world;
    private final WorldFileData worldData;
    private final BorderData border;
    private final ICommandSender requester;
    private List<CoordXZ> regionChunks = new ArrayList<CoordXZ>(1024);
    private List<CoordXZ> trimChunks = new ArrayList<CoordXZ>(1024);
    private int tickFrequency = 1;
    private int chunksPerRun = 1;
    private boolean readyToGo = false;
    private boolean paused = false;
    private boolean deleteError = false;
    private int currentRegion = -1;
    private int currentChunk = 0;
    private int regionX = 0;
    private int regionZ = 0;
    private int counter = 0;
    private long lastReport = Util.now();
    private int reportTarget = 0;
    private int reportTotal = 0;
    private int reportTrimmedRegions = 0;
    private int reportTrimmedChunks = 0;

    public static WorldTrimTask getInstance() {
        return INSTANCE;
    }

    public static WorldTrimTask create(ICommandSender player, String worldName, int trimDistance, int chunksPerRun, int tickFrequency) {
        if (INSTANCE != null) {
            throw new IllegalStateException("There can only be one WorldTrimTask");
        }
        try {
            INSTANCE = new WorldTrimTask(player, worldName, trimDistance, chunksPerRun, tickFrequency);
            return INSTANCE;
        }
        catch (Exception e) {
            INSTANCE = null;
            throw e;
        }
    }

    public void start() {
        if (INSTANCE != this) {
            throw new IllegalStateException("Cannot start a stopped task");
        }
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void stop() {
        if (INSTANCE != this) {
            throw new IllegalStateException("Task has already been stopped");
        }
        FMLCommonHandler.instance().bus().unregister((Object)this);
        this.regionChunks.clear();
        this.trimChunks.clear();
        INSTANCE = null;
    }

    public void pause() {
        this.pause(!this.paused);
    }

    public void pause(boolean pause) {
        this.paused = pause;
        if (pause) {
            this.reportProgress();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    private WorldTrimTask(ICommandSender player, String worldName, int trimDistance, int chunksPerRun, int tickFrequency) {
        this.requester = player;
        this.tickFrequency = tickFrequency;
        this.chunksPerRun = chunksPerRun;
        this.world = Worlds.getWorld(worldName);
        if (this.world == null) {
            throw new IllegalArgumentException("World \"" + worldName + "\" not found!");
        }
        BorderData borderData = this.border = Config.Border(worldName) == null ? null : Config.Border(worldName).copy();
        if (this.border == null) {
            throw new IllegalStateException("No border found for world \"" + worldName + "\"!");
        }
        this.worldData = new WorldFileData((World)this.world, this.requester);
        this.border.setRadiusX(this.border.getRadiusX() + trimDistance);
        this.border.setRadiusZ(this.border.getRadiusZ() + trimDistance);
        this.reportTarget = this.worldData.regionFileCount() * 3072;
        if (!this.nextFile()) {
            return;
        }
        this.readyToGo = true;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (WorldBorder.SERVER.func_71259_af() % this.tickFrequency != 0) {
            return;
        }
        if (!this.readyToGo || this.paused) {
            return;
        }
        this.readyToGo = false;
        long loopStartTime = Util.now();
        this.counter = 0;
        while (this.counter <= this.chunksPerRun) {
            if (this.paused) {
                return;
            }
            long now = Util.now();
            if (now > this.lastReport + 5000L) {
                this.reportProgress();
            }
            if (now > loopStartTime + 45L) {
                this.readyToGo = true;
                return;
            }
            if (this.regionChunks.isEmpty()) {
                this.addCornerChunks();
            } else if (this.currentChunk == 4) {
                if (this.trimChunks.isEmpty()) {
                    this.counter += 4;
                    this.nextFile();
                    continue;
                }
                this.addEdgeChunks();
                this.addInnerChunks();
            } else {
                if (this.currentChunk == 124 && this.trimChunks.size() == 124) {
                    this.counter += 16;
                    this.trimChunks = this.regionChunks;
                    this.unloadChunks();
                    ++this.reportTrimmedRegions;
                    File regionFile = this.worldData.regionFile(this.currentRegion);
                    try {
                        Files.delete(regionFile.toPath());
                        Log.trace("Deleted region file '%s' for world '%s'", regionFile.getAbsolutePath(), Worlds.getWorldName((World)this.world));
                    }
                    catch (Exception e) {
                        Log.warn("Exception when deleting region file '%s': %s", regionFile.getName(), e.getMessage().replaceAll("\n", ""));
                        this.deleteError = true;
                        this.wipeChunks();
                    }
                    DynMapFeatures.renderRegion((World)this.world, new CoordXZ(this.regionX, this.regionZ));
                    this.nextFile();
                    continue;
                }
                if (this.currentChunk == 1024) {
                    this.counter += 32;
                    this.unloadChunks();
                    this.wipeChunks();
                    this.nextFile();
                    continue;
                }
            }
            CoordXZ chunk = this.regionChunks.get(this.currentChunk);
            if (!this.isChunkInsideBorder(chunk)) {
                this.trimChunks.add(chunk);
            }
            ++this.currentChunk;
            ++this.counter;
        }
        this.reportTotal += this.counter;
        this.readyToGo = true;
    }

    private boolean nextFile() {
        this.reportTotal = this.currentRegion * 3072;
        ++this.currentRegion;
        this.currentChunk = 0;
        this.regionZ = 0;
        this.regionX = 0;
        this.regionChunks = new ArrayList<CoordXZ>(1024);
        this.trimChunks = new ArrayList<CoordXZ>(1024);
        if (this.currentRegion >= this.worldData.regionFileCount()) {
            this.paused = true;
            this.readyToGo = false;
            this.finish();
            return false;
        }
        this.counter += 16;
        CoordXZ coord = this.worldData.regionFileCoordinates(this.currentRegion);
        if (coord == null) {
            return false;
        }
        this.regionX = coord.x;
        this.regionZ = coord.z;
        return true;
    }

    private void addCornerChunks() {
        this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX), CoordXZ.regionToChunk(this.regionZ)));
        this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + 31, CoordXZ.regionToChunk(this.regionZ)));
        this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX), CoordXZ.regionToChunk(this.regionZ) + 31));
        this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + 31, CoordXZ.regionToChunk(this.regionZ) + 31));
    }

    private void addEdgeChunks() {
        int chunkZ;
        int chunkX = 0;
        for (chunkZ = 1; chunkZ < 31; ++chunkZ) {
            this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
        }
        chunkX = 31;
        for (chunkZ = 1; chunkZ < 31; ++chunkZ) {
            this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
        }
        chunkZ = 0;
        for (chunkX = 1; chunkX < 31; ++chunkX) {
            this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
        }
        chunkZ = 31;
        for (chunkX = 1; chunkX < 31; ++chunkX) {
            this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
        }
        this.counter += 4;
    }

    private void addInnerChunks() {
        for (int chunkX = 1; chunkX < 31; ++chunkX) {
            for (int chunkZ = 1; chunkZ < 31; ++chunkZ) {
                this.regionChunks.add(new CoordXZ(CoordXZ.regionToChunk(this.regionX) + chunkX, CoordXZ.regionToChunk(this.regionZ) + chunkZ));
            }
        }
        this.counter += 32;
    }

    private void unloadChunks() {
        for (CoordXZ unload : this.trimChunks) {
            this.world.field_73059_b.func_73241_b(unload.x, unload.z);
        }
        this.world.field_73059_b.func_73156_b();
        this.counter += this.trimChunks.size();
    }

    private void wipeChunks() {
        File regionFile = this.worldData.regionFile(this.currentRegion);
        if (!regionFile.canWrite()) {
            if (!regionFile.setWritable(true)) {
                throw new RuntimeException();
            }
            if (!regionFile.canWrite()) {
                this.sendMessage("Error! region file is locked and can't be trimmed: " + regionFile.getName());
                return;
            }
        }
        int offsetX = CoordXZ.regionToChunk(this.regionX);
        int offsetZ = CoordXZ.regionToChunk(this.regionZ);
        int chunkCount = 0;
        try (RandomAccessFile unChunk = new RandomAccessFile(regionFile, "rwd");){
            for (CoordXZ wipe : this.trimChunks) {
                if (!this.worldData.doesChunkExist(wipe.x, wipe.z)) continue;
                long wipePos = 4 * (wipe.x - offsetX + (wipe.z - offsetZ) * 32);
                unChunk.seek(wipePos);
                unChunk.writeInt(0);
                ++chunkCount;
            }
            DynMapFeatures.renderChunks((World)this.world, this.trimChunks);
            this.reportTrimmedChunks += chunkCount;
        }
        catch (FileNotFoundException ex) {
            this.sendMessage("Error! Could not open region file to wipe individual chunks: " + regionFile.getName());
        }
        catch (IOException ex) {
            this.sendMessage("Error! Could not modify region file to wipe individual chunks: " + regionFile.getName());
        }
        this.counter += this.trimChunks.size();
    }

    private boolean isChunkInsideBorder(CoordXZ chunk) {
        return this.border.insideBorder(CoordXZ.chunkToBlock(chunk.x) + 8, CoordXZ.chunkToBlock(chunk.z) + 8);
    }

    private void finish() {
        this.reportTotal = this.reportTarget;
        this.reportProgress();
        this.sendMessage("Task successfully completed for world \"" + Worlds.getWorldName((World)this.world) + "\"!");
        if (this.deleteError) {
            this.sendMessage("One or more region files could not be deleted. It may be that the world spawn point covers those regions, or the server is running on Windows. Restart the server and retry trimming without players logged in.");
        }
        this.stop();
    }

    private void reportProgress() {
        this.lastReport = Util.now();
        double perc = (double)this.reportTotal / (double)this.reportTarget * 100.0;
        this.sendMessage(this.reportTrimmedRegions + " entire region(s) and " + this.reportTrimmedChunks + " individual chunk(s) trimmed so far (" + Config.COORD_FORMAT.format(perc) + "%% done" + ")");
    }

    private void sendMessage(String text) {
        Log.info("[Trim] " + text, new Object[0]);
        if (this.requester instanceof EntityPlayerMP) {
            Util.chat(this.requester, "[Trim] " + text, new Object[0]);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Log.debug("WorldTrimTask cleaned up for %s", Worlds.getWorldName((World)this.world));
    }
}

