/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.stats;

import com.google.gson.JsonObject;
import net.minecraft.potion.PotionEffect;
import toast.mobProperties.EffectHelper;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobStatsInfo;

public class EntryStatsPotion
extends EntryAbstract {
    private final int potionId;
    private final double[] amplifiers;
    private final double[] durations;
    private final boolean ambient;
    private final boolean override;

    public EntryStatsPotion(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.potionId = FileHelper.readPotion((JsonObject)node, (String)path, (String)"id").field_76415_H;
        this.amplifiers = FileHelper.readCounts(node, path, "amplifier", 0.0, 0.0);
        this.durations = FileHelper.readCounts(node, path, "duration", 2.147483647E9, 2.147483647E9);
        this.ambient = FileHelper.readBoolean(node, path, "ambient", false);
        this.override = FileHelper.readBoolean(node, path, "override", false);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"id"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"amplifier", "duration", "ambient", "override"};
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        int amplifier = FileHelper.getCount(this.amplifiers, mobStats.random);
        int duration = FileHelper.getCount(this.durations, mobStats.random);
        if (this.override) {
            EffectHelper.addPotionEffect(mobStats.theEntity, this.potionId, duration, amplifier, this.ambient);
        } else {
            mobStats.theEntity.func_70690_d(new PotionEffect(this.potionId, duration, amplifier, this.ambient));
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        int amplifier = FileHelper.getCount(this.amplifiers, itemStats.random);
        int duration = FileHelper.getCount(this.durations, itemStats.random);
        EffectHelper.addPotionEffect(itemStats.theItem, this.potionId, duration, amplifier, this.ambient);
    }
}

