/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.item;

import com.google.gson.JsonObject;
import net.minecraft.enchantment.Enchantment;
import toast.mobProperties.EffectHelper;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.ItemStatsInfo;

public class EntryItemEnchant
extends EntryAbstract {
    private final int effectId;
    private final double[] levels;

    public EntryItemEnchant(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        Enchantment enchant = FileHelper.readEnchant(node, path, "id", false);
        this.effectId = enchant == null ? -1 : enchant.field_77352_x;
        this.levels = FileHelper.readCounts(node, path, "level", 1.0, 1.0);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[0];
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"id", "level"};
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        try {
            int level = FileHelper.getCount(this.levels, itemStats.random);
            if (this.effectId < 0) {
                EffectHelper.enchantItem(itemStats.random, itemStats.theItem, level);
            } else {
                EffectHelper.enchantItem(itemStats.theItem, this.effectId, level);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

