/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.drops;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class Schematic {
    private final short xSize;
    private final short ySize;
    private final short zSize;
    public final Block[] blocks;
    public final byte[] metadata;
    public final NBTTagCompound[] tileEntities;
    public final NBTTagCompound[] entities;

    public Schematic(NBTTagCompound tag) {
        this.xSize = tag.func_74765_d("Width");
        this.ySize = tag.func_74765_d("Height");
        this.zSize = tag.func_74765_d("Length");
        byte[] blockIds = tag.func_74770_j("Blocks");
        this.blocks = new Block[blockIds.length];
        int i = blockIds.length;
        while (i-- > 0) {
            this.blocks[i] = Block.func_149729_e((int)(blockIds[i] & 0xFF));
        }
        this.metadata = tag.func_74770_j("Data");
        NBTTagList tagList = tag.func_150295_c("TileEntities", 10);
        this.tileEntities = new NBTTagCompound[tagList.func_74745_c()];
        i = tagList.func_74745_c();
        while (i-- > 0) {
            this.tileEntities[i] = (NBTTagCompound)tagList.func_150305_b(i).func_74737_b();
        }
        tagList = tag.func_150295_c("Entities", 10);
        this.entities = new NBTTagCompound[tagList.func_74745_c()];
        i = tagList.func_74745_c();
        while (i-- > 0) {
            this.entities[i] = (NBTTagCompound)tagList.func_150305_b(i).func_74737_b();
        }
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public void place(World world, int x, int y, int z, byte update, byte blockOverride, byte airOverride) {
        HashSet<ChunkCoordinates> skipTileEntities = new HashSet<ChunkCoordinates>();
        for (int y0 = 0; y0 < this.ySize; ++y0) {
            for (int z0 = 0; z0 < this.zSize; ++z0) {
                for (int x0 = 0; x0 < this.xSize; ++x0) {
                    Block blockReplacing;
                    byte override;
                    int index = (y0 * this.zSize + z0) * this.xSize + x0;
                    byte by = override = this.blocks[index] == Blocks.field_150350_a ? airOverride : blockOverride;
                    if (!(override == 1 || (blockReplacing = world.func_147439_a(x + x0, y + y0, z + z0)) == Blocks.field_150350_a || override != 0 && blockReplacing.func_149688_o().func_76222_j())) {
                        skipTileEntities.add(new ChunkCoordinates(x + x0, y + y0, z + z0));
                        continue;
                    }
                    world.func_147465_d(x + x0, y + y0, z + z0, this.blocks[index], this.metadata[index] & 0xF, (int)update);
                }
            }
        }
        int i = this.entities.length;
        while (i-- > 0) {
            NBTTagCompound tag = Schematic.copyEntityTagRel(this.entities[i], x, y, z);
            Entity entity = EntityList.func_75615_a((NBTTagCompound)tag, (World)world);
            if (entity == null) continue;
            world.func_72838_d(entity);
            Entity rider = entity;
            NBTTagCompound riderTag = tag;
            while (riderTag.func_150297_b("Riding", (int)tag.func_74732_a())) {
                Entity mount = EntityList.func_75615_a((NBTTagCompound)riderTag.func_74775_l("Riding"), (World)world);
                if (mount != null) {
                    world.func_72838_d(mount);
                    rider.func_70078_a(mount);
                }
                rider = mount;
                riderTag = riderTag.func_74775_l("Riding");
            }
        }
        int i2 = this.tileEntities.length;
        while (i2-- > 0) {
            NBTTagCompound tag = (NBTTagCompound)this.tileEntities[i2].func_74737_b();
            tag.func_74768_a("x", tag.func_74762_e("x") + x);
            tag.func_74768_a("y", tag.func_74762_e("y") + y);
            tag.func_74768_a("z", tag.func_74762_e("z") + z);
            TileEntity tileEntity = world.func_147438_o(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            if (tileEntity == null || skipTileEntities.contains(new ChunkCoordinates(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e))) continue;
            tileEntity.func_145839_a(tag);
        }
    }

    private static NBTTagCompound copyEntityTagRel(NBTTagCompound copyFrom, int x, int y, int z) {
        NBTTagCompound copyTo = new NBTTagCompound();
        for (String name : copyFrom.func_150296_c()) {
            NBTBase tag = copyFrom.func_74781_a(name);
            if (name.equals("Pos")) {
                NBTTagList posFrom = (NBTTagList)tag;
                NBTTagList posTo = new NBTTagList();
                posTo.func_74742_a((NBTBase)new NBTTagDouble(posFrom.func_150309_d(0) + (double)x));
                posTo.func_74742_a((NBTBase)new NBTTagDouble(posFrom.func_150309_d(1) + (double)y));
                posTo.func_74742_a((NBTBase)new NBTTagDouble(posFrom.func_150309_d(2) + (double)z));
                copyTo.func_74782_a(name, (NBTBase)posTo);
                continue;
            }
            if (name.equals("Riding")) {
                copyTo.func_74782_a(name, (NBTBase)Schematic.copyEntityTagRel((NBTTagCompound)tag, x, y, z));
                continue;
            }
            copyTo.func_74782_a(name, tag.func_74737_b());
        }
        return copyTo;
    }
}

