/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import com.google.gson.JsonObject;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.biome.BiomeGenBase;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties._MobPropertiesMod;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;
import toast.mobProperties.entry.NBTStatsInfo;
import toast.mobProperties.entry.PropertyGroup;

public class PropertyGroupConditional
extends PropertyGroup {
    private static Method worldDifficultyMethod;
    private final boolean inverted;
    private final String category;

    public static boolean isCategoryActive(boolean invert, String category, EntityLivingBase entity) {
        return PropertyGroupConditional.isCategoryActive(invert, category, entity, null, 0, false, false, false);
    }

    public static boolean isCategoryActive(boolean invert, String category, EntityLivingBase entity, DamageSource source, int looting, boolean recentlyHit, boolean rare, boolean superRare) {
        if (category.equals("recently_hit")) {
            return recentlyHit != invert;
        }
        if (category.equals("rare")) {
            return rare != invert;
        }
        if (category.equals("rare_super")) {
            return superRare != invert;
        }
        if (category.startsWith("above_looting_")) {
            try {
                return looting > Integer.parseInt(category.substring(14)) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.startsWith("damage_type_")) {
            try {
                return source.func_76355_l() == category.substring(12) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killed_with_fire")) {
            try {
                return source.func_76347_k() != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killed_with_magic")) {
            try {
                return source.func_82725_o() != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killed_with_projectile")) {
            try {
                return source.func_76352_a() != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killed_with_indirect")) {
            try {
                return source.func_76346_g() != source.func_76364_f() != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killed_with_explosion")) {
            try {
                return source.func_94541_c() != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killed_with_unblockable")) {
            try {
                return source.func_76363_c() != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.startsWith("killed_by_")) {
            try {
                return ((Class)EntityList.field_75625_b.get(category.substring(10))).isAssignableFrom(source.func_76346_g().getClass()) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killer_on_ground")) {
            try {
                return source.func_76346_g().field_70122_E != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killer_burning")) {
            try {
                return source.func_76346_g().func_70027_ad() != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killer_wet")) {
            try {
                return source.func_76346_g().func_70026_G() != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.equals("killer_submerged")) {
            try {
                return (source.func_76346_g().func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)((EntityLivingBase)source.func_76346_g()))) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.startsWith("killer_has_potion_")) {
            try {
                return ((EntityLivingBase)source.func_76346_g()).func_70644_a(FileHelper.readPotion(category.substring(18), entity.getClass().getName() + "\\killer", true)) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.startsWith("check_killer_nbt_")) {
            try {
                String[] path = category.substring(17).split("/");
                String[] data = PropertyGroupConditional.getOperatorData(path[path.length - 1]);
                path[path.length - 1] = data[0];
                return PropertyGroupConditional.compareNBT(source.func_76346_g(), path, data) != invert;
            }
            catch (Exception path) {
                return invert;
            }
        }
        if (category.equals("killer_wither_skeleton")) {
            try {
                return ((EntitySkeleton)source.func_76346_g()).func_82202_m() == 1 != invert;
            }
            catch (Exception path) {
                return invert;
            }
        }
        if (category.equals("on_ground")) {
            return entity.field_70122_E != invert;
        }
        if (category.equals("burning")) {
            return entity.func_70027_ad() != invert;
        }
        if (category.equals("wet")) {
            return entity.func_70026_G() != invert;
        }
        if (category.equals("submerged")) {
            return (entity.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_77510_g((EntityLivingBase)entity)) != invert;
        }
        if (category.startsWith("has_potion_")) {
            try {
                return entity.func_70644_a(FileHelper.readPotion(category.substring(11), entity.getClass().getName(), true)) != invert;
            }
            catch (Exception path) {
                return invert;
            }
        }
        if (category.startsWith("check_nbt_")) {
            try {
                String[] path = category.substring(10).split("/");
                String[] data = PropertyGroupConditional.getOperatorData(path[path.length - 1]);
                path[path.length - 1] = data[0];
                return PropertyGroupConditional.compareNBT((Entity)entity, path, data) != invert;
            }
            catch (Exception path) {
                return invert;
            }
        }
        if (category.equals("wither_skeleton")) {
            return (entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_82202_m() == 1) != invert;
        }
        if (category.equals("raining")) {
            return entity.field_70170_p.func_72896_J() != invert;
        }
        if (category.equals("thundering")) {
            return entity.field_70170_p.func_72911_I() != invert;
        }
        if (category.equals("can_see_sky")) {
            return entity.field_70170_p.func_72937_j((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u), (int)Math.floor(entity.field_70161_v)) != invert;
        }
        if (category.startsWith("moon_phase_")) {
            return entity.field_70170_p.field_73011_w.func_76559_b(entity.field_70170_p.func_72820_D()) == PropertyGroupConditional.getMoonPhaseId(category.substring(11)) != invert;
        }
        if (category.startsWith("beyond_")) {
            try {
                double distance = Double.parseDouble(category.substring(7));
                ChunkCoordinates spawnPoint = entity.field_70170_p.func_72861_E();
                return entity.func_70092_e((double)spawnPoint.field_71574_a, (double)spawnPoint.field_71572_b, (double)spawnPoint.field_71573_c) > distance * distance != invert;
            }
            catch (Exception distance) {
                return invert;
            }
        }
        if (category.startsWith("difficulty_")) {
            return entity.field_70170_p.field_73013_u == PropertyGroupConditional.getDifficulty(category.substring(11)) != invert;
        }
        if (category.startsWith("past_world_difficulty_")) {
            try {
                long difficulty = (long)(Double.parseDouble(category.substring(22)) * 24000.0);
                if (worldDifficultyMethod != null) {
                    return (Long)worldDifficultyMethod.invoke(null, new Object[0]) > difficulty != invert;
                }
                category = "past_world_time_" + difficulty;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("past_day_time_")) {
            try {
                return (int)(entity.field_70170_p.func_72912_H().func_76073_f() % 24000L) > Integer.parseInt(category.substring(14)) != invert;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("past_world_time_")) {
            try {
                return entity.field_70170_p.func_72912_H().func_76073_f() > Long.parseLong(category.substring(16)) != invert;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("in_dimension_")) {
            try {
                if (entity.field_70170_p != null) {
                    return entity.field_70170_p.field_73011_w.field_76574_g == Integer.parseInt(category.substring(13)) != invert;
                }
                return entity.field_71093_bK == Integer.parseInt(category.substring(13)) != invert;
            }
            catch (Exception ex) {
                return invert;
            }
        }
        if (category.startsWith("on_block_")) {
            try {
                Block block = FileHelper.readBlock(category.substring(9), entity.getClass().getName(), true);
                int x = (int)Math.floor(entity.field_70165_t);
                int yMin = (int)Math.floor(entity.field_70163_u) - 1;
                int yMax = (int)Math.floor(entity.field_70163_u) + (int)Math.floor(entity.field_70131_O);
                int z = (int)Math.floor(entity.field_70161_v);
                for (int y = yMin; y <= yMax; ++y) {
                    if (entity.field_70170_p.func_147439_a(x, y, z) == block == invert) continue;
                    return true;
                }
                return invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("below_")) {
            try {
                return (int)entity.field_70163_u < Integer.parseInt(category.substring(6)) != invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("in_biome_type_")) {
            try {
                return entity.field_70170_p.func_72807_a((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70161_v)).func_150569_a(PropertyGroupConditional.getBiomeType(category.substring(14))) != invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("in_biome_")) {
            try {
                return entity.field_70170_p.func_72807_a((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70161_v)) == PropertyGroupConditional.getBiome(category.substring(9)) != invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("biome_temp_")) {
            try {
                return entity.field_70170_p.func_72807_a((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70161_v)).func_150561_m() == PropertyGroupConditional.getTempCategory(category.substring(11)) != invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("biome_height_below_")) {
            try {
                return entity.field_70170_p.func_72807_a((int)((int)Math.floor((double)entity.field_70165_t)), (int)((int)Math.floor((double)entity.field_70161_v))).field_76748_D < PropertyGroupConditional.getBiomeHeight(category.substring(19)) != invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("is_humid")) {
            try {
                return entity.field_70170_p.func_72807_a((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70161_v)).func_76736_e() != invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("rainfall_above_")) {
            try {
                return entity.field_70170_p.func_72807_a((int)((int)Math.floor((double)entity.field_70165_t)), (int)((int)Math.floor((double)entity.field_70161_v))).field_76751_G > Float.parseFloat(category.substring(15)) != invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("biome_temp_above_")) {
            try {
                return entity.field_70170_p.func_72807_a((int)((int)Math.floor((double)entity.field_70165_t)), (int)((int)Math.floor((double)entity.field_70161_v))).field_76750_F > Float.parseFloat(category.substring(17)) != invert;
            }
            catch (Exception block) {
                return invert;
            }
        }
        if (category.startsWith("temp_above_")) {
            try {
                int x = (int)Math.floor(entity.field_70165_t);
                int z = (int)Math.floor(entity.field_70161_v);
                return entity.field_70170_p.func_72807_a(x, z).func_150564_a(x, (int)Math.floor(entity.field_70163_u), z) > Float.parseFloat(category.substring(11)) != invert;
            }
            catch (Exception x) {
                return invert;
            }
        }
        if (category.startsWith("player_online_")) {
            try {
                return entity.field_70170_p.func_72924_a(category.substring(14)) != null != invert;
            }
            catch (Exception x) {
                return invert;
            }
        }
        if (category.startsWith("player_count_above_")) {
            try {
                return entity.field_70170_p.field_73010_i.size() > Integer.parseInt(category.substring(19)) != invert;
            }
            catch (Exception x) {
                return invert;
            }
        }
        if (category.startsWith("player_level_above_")) {
            try {
                int level = 0;
                for (int i = 0; i < entity.field_70170_p.field_73010_i.size(); ++i) {
                    level += ((EntityPlayer)entity.field_70170_p.field_73010_i.get((int)i)).field_71068_ca;
                }
                return level > Integer.parseInt(category.substring(19)) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        if (category.startsWith("nearest_player_level_above_")) {
            try {
                return entity.field_70170_p.func_72890_a((Entity)entity, (double)-1.0).field_71068_ca > Integer.parseInt(category.substring(27)) != invert;
            }
            catch (Exception exception) {
                return invert;
            }
        }
        throw new RuntimeException("[ERROR] Conditional property has invalid condition! (" + category + ") for " + entity.getClass().getName());
    }

    private static String[] getOperatorData(String last) {
        String[] operators;
        for (String operator : operators = new String[]{"==", ">", "<", ">=", "<="}) {
            String[] split = last.split(operator, 2);
            if (split.length != 2) continue;
            return new String[]{split[0], operator, split[1]};
        }
        return new String[]{last, null, null};
    }

    private static boolean compareNBT(Entity entity, String[] path, String[] data) {
        double value;
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_70109_d(tag);
        for (String pathStep : path) {
            if (tag instanceof NBTTagCompound) {
                if (!tag.func_74764_b(pathStep)) {
                    tag = null;
                    break;
                }
                tag = tag.func_74781_a(pathStep);
                continue;
            }
            if (tag instanceof NBTTagList) {
                int index = Integer.parseInt(pathStep);
                if (((NBTTagList)tag).func_74745_c() <= index) {
                    tag = null;
                    break;
                }
                tag = ((NBTTagList)tag).func_74744_a(index);
                continue;
            }
            return false;
        }
        if (data[1] == null) {
            return tag != null && ((NBTBase.NBTPrimitive)tag).func_150290_f() == 1;
        }
        try {
            value = Double.parseDouble(data[2]);
        }
        catch (NumberFormatException ex) {
            return data[1].equals("==") && data[2].equals(((NBTTagString)tag).func_150285_a_());
        }
        double actual = tag == null ? 0.0 : ((NBTBase.NBTPrimitive)tag).func_150286_g();
        if (data[1].equals("==")) {
            return actual == value;
        }
        if (data[1].equals(">")) {
            return actual > value;
        }
        if (data[1].equals("<")) {
            return actual < value;
        }
        if (data[1].equals(">=")) {
            return actual >= value;
        }
        if (data[1].equals("<=")) {
            return actual <= value;
        }
        return false;
    }

    private static int getMoonPhaseId(String phase) {
        if ("FULL".equalsIgnoreCase(phase)) {
            return 0;
        }
        if ("WANING_GIBBOUS".equalsIgnoreCase(phase)) {
            return 1;
        }
        if ("THIRD_QUARTER".equalsIgnoreCase(phase) || "WANING_HALF".equalsIgnoreCase(phase)) {
            return 2;
        }
        if ("WANING_CRESCENT".equalsIgnoreCase(phase)) {
            return 3;
        }
        if ("NEW".equalsIgnoreCase(phase)) {
            return 4;
        }
        if ("WAXING_CRESCENT".equalsIgnoreCase(phase)) {
            return 5;
        }
        if ("FIRST_QUARTER".equalsIgnoreCase(phase) || "WAXING_HALF".equalsIgnoreCase(phase)) {
            return 6;
        }
        if ("WAXING_GIBBOUS".equalsIgnoreCase(phase)) {
            return 7;
        }
        try {
            return Integer.parseInt(phase) % 8;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private static EnumDifficulty getDifficulty(String id) {
        if ("PEACEFUL".equalsIgnoreCase(id)) {
            return EnumDifficulty.PEACEFUL;
        }
        if ("EASY".equalsIgnoreCase(id)) {
            return EnumDifficulty.EASY;
        }
        if ("NORMAL".equalsIgnoreCase(id)) {
            return EnumDifficulty.NORMAL;
        }
        if ("HARD".equalsIgnoreCase(id)) {
            return EnumDifficulty.HARD;
        }
        try {
            return EnumDifficulty.func_151523_a((int)Integer.parseInt(id));
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static BiomeGenBase getBiome(String id) {
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (!biome.field_76791_y.equals(id)) continue;
            return biome;
        }
        try {
            int biomeId = Integer.parseInt(id);
            _MobPropertiesMod.console("[WARNING]  Usage of numerical biome id! (" + id + "=\"" + BiomeGenBase.func_150565_n()[biomeId].field_76791_y + "\") in conditional check!");
            return BiomeGenBase.func_150565_n()[biomeId];
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static BiomeGenBase getBiomeType(String id) {
        if ("BEACH".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76787_r;
        }
        if ("DESERT".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76769_d;
        }
        if ("END".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76779_k;
        }
        if ("FOREST".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76767_f;
        }
        if ("HELL".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76778_j;
        }
        if ("HILLS".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76770_e;
        }
        if ("JUNGLE".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76782_w;
        }
        if ("MESA".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_150589_Z;
        }
        if ("MUSHROOM".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76789_p;
        }
        if ("OCEAN".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76771_b;
        }
        if ("PLAINS".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76772_c;
        }
        if ("RIVER".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76781_i;
        }
        if ("SAVANNA".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_150588_X;
        }
        if ("SNOW".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76774_n;
        }
        if ("STONE_BEACH".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_150576_N;
        }
        if ("SWAMP".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76780_h;
        }
        if ("TAIGA".equalsIgnoreCase(id)) {
            return BiomeGenBase.field_76768_g;
        }
        return PropertyGroupConditional.getBiome(id);
    }

    private static BiomeGenBase.TempCategory getTempCategory(String temp) {
        if ("OCEAN".equalsIgnoreCase(temp)) {
            return BiomeGenBase.TempCategory.OCEAN;
        }
        if ("COLD".equalsIgnoreCase(temp)) {
            return BiomeGenBase.TempCategory.COLD;
        }
        if ("MEDIUM".equalsIgnoreCase(temp)) {
            return BiomeGenBase.TempCategory.MEDIUM;
        }
        if ("WARM".equalsIgnoreCase(temp)) {
            return BiomeGenBase.TempCategory.WARM;
        }
        return null;
    }

    private static float getBiomeHeight(String height) {
        try {
            return (float)Integer.parseInt(height) / 32.0f - 2.0f;
        }
        catch (Exception exception) {
            if ("DEFAULT".equalsIgnoreCase(height)) {
                return 0.1f;
            }
            if ("SHORES".equalsIgnoreCase(height)) {
                return 0.0f;
            }
            if ("LOW_PLAINS".equalsIgnoreCase(height)) {
                return 0.125f;
            }
            if ("MID_PLAINS".equalsIgnoreCase(height)) {
                return 0.2f;
            }
            if ("LOW_HILLS".equalsIgnoreCase(height)) {
                return 0.45f;
            }
            if ("MID_HILLS".equalsIgnoreCase(height)) {
                return 1.0f;
            }
            if ("SHALLOW_WATERS".equalsIgnoreCase(height)) {
                return -0.5f;
            }
            if ("OCEANS".equalsIgnoreCase(height)) {
                return -1.0f;
            }
            if ("LOW_ISLANDS".equalsIgnoreCase(height)) {
                return 0.2f;
            }
            if ("PARTLY_SUBMERGED".equalsIgnoreCase(height)) {
                return -0.2f;
            }
            if ("ROCKY_WATERS".equalsIgnoreCase(height)) {
                return 0.1f;
            }
            if ("HIGH_PLATEAUS".equalsIgnoreCase(height)) {
                return 1.5f;
            }
            if ("DEEP_OCEANS".equalsIgnoreCase(height)) {
                return -1.8f;
            }
            return Float.NaN;
        }
    }

    public PropertyGroupConditional(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader, String function, boolean invert) {
        super(path, root, index, node, loader);
        this.inverted = invert;
        this.category = function;
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, mobStats.theEntity)) {
            super.init(mobStats);
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        if (itemStats.parent instanceof MobDropsInfo) {
            MobDropsInfo mobDrops = (MobDropsInfo)itemStats.parent;
            if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, mobDrops.theEntity, mobDrops.theSource, mobDrops.looting, mobDrops.recentlyHit, mobDrops.rare, mobDrops.superRare)) {
                super.modifyItem(itemStats);
            }
        } else if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, itemStats.theEntity)) {
            super.modifyItem(itemStats);
        }
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        if (nbtStats.parent instanceof MobDropsInfo) {
            MobDropsInfo mobDrops = (MobDropsInfo)nbtStats.parent;
            if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, mobDrops.theEntity, mobDrops.theSource, mobDrops.looting, mobDrops.recentlyHit, mobDrops.rare, mobDrops.superRare)) {
                super.addTags(nbtStats);
            }
        } else if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, nbtStats.theEntity)) {
            super.addTags(nbtStats);
        }
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        if (PropertyGroupConditional.isCategoryActive(this.inverted, this.category, mobDrops.theEntity, mobDrops.theSource, mobDrops.looting, mobDrops.recentlyHit, mobDrops.rare, mobDrops.superRare)) {
            super.modifyDrops(mobDrops);
        }
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        StringBuffer condition = new StringBuffer("");
        if (this.inverted) {
            condition.append("!");
        }
        condition.append("if_");
        condition.append(this.category);
        conditions.add(condition.toString());
        super.addDrops(dropsList, attempts, chance, conditions);
    }

    static {
        try {
            worldDifficultyMethod = Class.forName("toast.apocalypse.WorldDifficultyManager").getMethod("getWorldDifficulty", new Class[0]);
            _MobPropertiesMod.console("Successfully hooked into Apocalypse's world difficulty!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

