/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import toast.mobProperties.EffectHelper;
import toast.mobProperties.IProperty;

public class MobStatsInfo {
    public static final String MODIFIER_NAME = "MobProperties|Modifier";
    public static final UUID[] MODIFIER_UUIDS = new UUID[3];
    public final EntityLivingBase theEntity;
    public final float originalDamage;
    public final Random random;
    public final HashMap<String, double[]> modifierMap = new HashMap();
    public final ArrayList<String> addDropsList = new ArrayList();

    public MobStatsInfo(EntityLivingBase entity) {
        this.theEntity = entity;
        this.originalDamage = entity.func_110143_aJ() / entity.func_110138_aP();
        this.random = entity.func_70681_au();
    }

    public void addModifier(String name, double value, int operation) {
        double[] values = this.modifierMap.get(name);
        if (values == null) {
            values = new double[MODIFIER_UUIDS.length];
            values[2] = Double.NaN;
            this.modifierMap.put(name, values);
        }
        if (operation < 2) {
            int n = operation;
            values[n] = values[n] + value;
        } else if (Double.isNaN(values[operation])) {
            values[operation] = value;
        } else {
            int n = operation;
            values[n] = values[n] * (1.0 + value);
        }
    }

    public void setModifier(String name, double value, int operation) {
        double[] values = this.modifierMap.get(name);
        if (values == null) {
            values = new double[MODIFIER_UUIDS.length];
            values[2] = Double.NaN;
            this.modifierMap.put(name, values);
        }
        values[operation] = value;
    }

    public void addDrop(IProperty entry) {
        this.addDropsList.add(entry.getJsonString());
    }

    public void save() {
        for (Map.Entry<String, double[]> entry : this.modifierMap.entrySet()) {
            IAttributeInstance attribute = this.theEntity.func_110140_aT().func_111152_a(entry.getKey());
            if (attribute == null) continue;
            for (int op = 0; op < MODIFIER_UUIDS.length; ++op) {
                if (entry.getValue()[op] == 0.0 || Double.isNaN(entry.getValue()[op]) || attribute.func_111127_a(MODIFIER_UUIDS[op]) != null) continue;
                attribute.func_111121_a(new AttributeModifier(MODIFIER_UUIDS[op], MODIFIER_NAME, entry.getValue()[op], op));
            }
        }
        this.theEntity.func_70606_j(this.theEntity.func_110138_aP() * this.originalDamage);
        EffectHelper.saveDrops(this);
    }

    static {
        int i = MODIFIER_UUIDS.length;
        while (i-- > 0) {
            MobStatsInfo.MODIFIER_UUIDS[i] = UUID.fromString("70A57" + i + "F4-87F1-4D6B-BBCA-266A93B73C72");
        }
    }
}

