/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.NBTTagList;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IProperty;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.DropsHelper;
import toast.mobProperties.api.IPropertyDrops;
import toast.mobProperties.entry.EntryCommand;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;
import toast.mobProperties.entry.NBTStatsInfo;
import toast.mobProperties.entry.PropertyChoose;
import toast.mobProperties.entry.PropertyExternal;
import toast.mobProperties.entry.PropertyGroup;
import toast.mobProperties.entry.PropertyGroupConditional;
import toast.mobProperties.entry.drops.EntryDropsAdd;
import toast.mobProperties.entry.drops.EntryDropsDefault;
import toast.mobProperties.entry.drops.EntryDropsRemove;
import toast.mobProperties.entry.drops.EntryDropsSchematic;
import toast.mobProperties.entry.drops.EntryDropsSetBlock;
import toast.mobProperties.entry.drops.EntryDropsSpawn;
import toast.mobProperties.entry.drops.EntryDropsXP;

public class MobDrops
implements IProperty,
IPropertyReader,
IPropertyDrops {
    private final double[] counts;
    private final IProperty[] entries;

    public MobDrops(String entityName, NBTTagList dropData) {
        this.counts = new double[]{1.0, 1.0};
        int length = dropData.func_74745_c();
        this.entries = new IProperty[length];
        for (int i = 0; i < length; ++i) {
            String line = dropData.func_150307_f(i);
            JsonObject node = FileHelper.loadFunctionFromString(entityName, line, i);
            if (node == null) continue;
            this.entries[i] = this.readLine(entityName, node, i, (JsonElement)node);
        }
    }

    public MobDrops(String path, JsonObject root, JsonArray nodes) {
        this.counts = new double[]{1.0, 1.0};
        int length = nodes.size();
        this.entries = new IProperty[length];
        for (int i = 0; i < length; ++i) {
            this.entries[i] = this.readLine(path, root, i, nodes.get(i));
        }
    }

    public MobDrops(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        FileHelper.verify(node, path, this);
        this.counts = FileHelper.readCounts(node, path, "count", 1.0, 1.0);
        JsonArray nodes = node.getAsJsonArray("functions");
        if (nodes == null) {
            throw new MobPropertyException("Missing or invalid functions!", path);
        }
        path = path + "\\functions";
        int length = nodes.size();
        this.entries = new IProperty[length];
        for (int i = 0; i < length; ++i) {
            this.entries[i] = this.readLine(path, root, i, nodes.get(i));
        }
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"functions"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"count"};
    }

    @Override
    public String getJsonString() {
        throw new UnsupportedOperationException("Non-functions are not used as Json strings!");
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        int count = FileHelper.getCount(this.counts);
        while (count-- > 0) {
            for (IProperty entry : this.entries) {
                if (entry == null) continue;
                mobStats.addDrop(entry);
            }
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        throw new UnsupportedOperationException("Non-item properties can not modify items!");
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        throw new UnsupportedOperationException("Non-nbt properties can not modify nbt!");
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        for (IProperty entry : this.entries) {
            if (entry == null) continue;
            entry.modifyDrops(mobDrops);
        }
    }

    @Override
    public IProperty readLine(String path, JsonObject root, int index, JsonElement node) {
        path = path + "\\entry_" + (index + 1);
        if (!node.isJsonObject()) {
            throw new MobPropertyException("Invalid node (object expected)!", path);
        }
        JsonObject objNode = node.getAsJsonObject();
        String function = null;
        try {
            function = objNode.get("function").getAsString();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (function == null) {
            throw new MobPropertyException("Missing function name!", path);
        }
        path = path + "(" + function + ")";
        if (function.equals("all")) {
            return new PropertyGroup(path, root, index, objNode, this);
        }
        if (function.equals("choose")) {
            return new PropertyChoose(path, root, index, objNode, this);
        }
        if (function.equals("external")) {
            return new PropertyExternal(path, root, index, objNode, this);
        }
        if (function.equals("command")) {
            return new EntryCommand(path, root, index, objNode, this);
        }
        if (function.equals("default")) {
            return new EntryDropsDefault(path, root, index, objNode, this);
        }
        if (function.equals("add")) {
            return new EntryDropsAdd(path, root, index, objNode, this);
        }
        if (function.equals("remove")) {
            return new EntryDropsRemove(path, root, index, objNode, this);
        }
        if (function.equals("spawn")) {
            return new EntryDropsSpawn(path, root, index, objNode, this);
        }
        if (function.equals("xp")) {
            return new EntryDropsXP(path, root, index, objNode, this);
        }
        if (function.equals("set_block")) {
            return new EntryDropsSetBlock(path, root, index, objNode, this);
        }
        if (function.equals("schematic")) {
            return new EntryDropsSchematic(path, root, index, objNode, this);
        }
        boolean inverted = false;
        if (function.startsWith(Character.toString('!'))) {
            inverted = true;
            function = function.substring(1);
        }
        if (function.startsWith("if_")) {
            return new PropertyGroupConditional(path, root, index, objNode, this, function.substring(3), inverted);
        }
        throw new MobPropertyException("Invalid function name!", path);
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        if ((chance = DropsHelper.adjustAttemptsAndChance(this.counts, attempts, chance)) > 0.0) {
            for (IProperty entry : this.entries) {
                if (!(entry instanceof IPropertyDrops)) continue;
                ((IPropertyDrops)((Object)entry)).addDrops(dropsList, DropsHelper.copy(attempts), chance, DropsHelper.copy(conditions));
            }
        }
    }
}

