/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.event;

import com.creativemd.creativecore.common.event.CreativeCoreCallHandler;
import com.creativemd.creativecore.common.event.TickHandler;
import com.creativemd.creativecore.core.CreativeCore;
import com.n247s.api.eventapi.eventsystem.CallHandler;
import com.n247s.api.eventapi.eventsystem.EventBus;
import com.n247s.api.eventapi.eventsystem.EventType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;

public class CreativeCoreEventBus
extends EventBus {
    public ArrayList<EventType> eventsToRaise = new ArrayList();

    public CreativeCoreEventBus() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.initClient();
        } else {
            this.initServer();
        }
    }

    @Override
    public void initServer() {
        TickHandler.ServerEvents.add(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        TickHandler.ClientEvents.add(this);
    }

    @Override
    public boolean raiseEvent(EventType event, boolean force) {
        if (event.isCancelable() || force) {
            if (!this.EventList.containsKey(event.getClass())) {
                this.EventList.put(event.getClass(), new CreativeCoreCallHandler(event.getClass()));
            }
            return ((CreativeCoreCallHandler)this.EventList.get(event.getClass())).CallInstances(event);
        }
        this.eventsToRaise.add(event);
        return false;
    }

    @Override
    public boolean raiseEvent(EventType eventType) {
        try {
            Class<?> eventClass = eventType.getClass();
            if (!this.EventList.containsKey(eventClass)) {
                this.EventList.put(eventClass, new CreativeCoreCallHandler(eventClass));
            }
            return ((CreativeCoreCallHandler)this.EventList.get(eventClass)).CallInstances(eventType);
        }
        catch (Exception e) {
            CreativeCore.logger.catching((Throwable)e);
            return false;
        }
    }

    public void bindCreativeCoreCallHandler(CreativeCoreCallHandler callHandler) {
        if (this.EventList.containsKey(callHandler.getEventType())) {
            this.EventList.remove(callHandler.getEventType());
        }
        this.EventList.put(callHandler.getEventType(), callHandler);
    }

    @Override
    public void removeAllEventListeners() {
        for (Object value : this.EventList.values()) {
            ((CreativeCoreCallHandler)value).getInstanceMap().clear();
        }
        this.EventList.clear();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.removeTickEventClient();
        } else {
            this.removeTickEventServer();
        }
    }

    @Override
    public void removeTickEventServer() {
        TickHandler.ServerEvents.remove(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void removeTickEventClient() {
        TickHandler.ClientEvents.remove(this);
    }

    @Override
    public CallHandler getCallHandlerFromEventType(Class<? extends EventType> eventTypeClass) {
        if (!this.EventList.containsKey(eventTypeClass)) {
            this.EventList.put(eventTypeClass, new CreativeCoreCallHandler(eventTypeClass));
        }
        return (CallHandler)this.EventList.get(eventTypeClass);
    }
}

