/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api2.storage.INBTSaveLoad;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class PropertyContainer
implements IPropertyContainer,
INBTSaveLoad<NBTTagCompound> {
    private final NBTTagCompound nbtInfo = new NBTTagCompound();

    @Override
    public <T> T getProperty(IPropertyType<T> prop) {
        if (prop == null) {
            return null;
        }
        return this.getProperty(prop, prop.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getProperty(IPropertyType<T> prop, T def) {
        if (prop == null) {
            return def;
        }
        NBTTagCompound nBTTagCompound = this.nbtInfo;
        synchronized (nBTTagCompound) {
            NBTTagCompound jProp = this.getDomain(prop.getKey());
            if (!jProp.func_74764_b(prop.getKey().func_110623_a())) {
                return def;
            }
            return prop.readValue(jProp.func_74781_a(prop.getKey().func_110623_a()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProperty(IPropertyType<?> prop) {
        if (prop == null) {
            return false;
        }
        NBTTagCompound nBTTagCompound = this.nbtInfo;
        synchronized (nBTTagCompound) {
            return this.getDomain(prop.getKey()).func_74764_b(prop.getKey().func_110623_a());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProperty(IPropertyType<?> prop) {
        if (prop == null) {
            return;
        }
        NBTTagCompound nBTTagCompound = this.nbtInfo;
        synchronized (nBTTagCompound) {
            NBTTagCompound jProp = this.getDomain(prop.getKey());
            if (!jProp.func_74764_b(prop.getKey().func_110623_a())) {
                return;
            }
            jProp.func_82580_o(prop.getKey().func_110623_a());
            if (jProp.func_82582_d()) {
                this.nbtInfo.func_82580_o(prop.getKey().func_110624_b());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void setProperty(IPropertyType<T> prop, T value) {
        if (prop == null || value == null) {
            return;
        }
        NBTTagCompound nBTTagCompound = this.nbtInfo;
        synchronized (nBTTagCompound) {
            NBTTagCompound dom = this.getDomain(prop.getKey());
            dom.func_74782_a(prop.getKey().func_110623_a(), prop.writeValue(value));
            this.nbtInfo.func_74782_a(prop.getKey().func_110624_b(), (NBTBase)dom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllProps() {
        NBTTagCompound nBTTagCompound = this.nbtInfo;
        synchronized (nBTTagCompound) {
            ArrayList keys = new ArrayList(this.nbtInfo.func_150296_c());
            for (String key : keys) {
                this.nbtInfo.func_82580_o(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound nBTTagCompound = this.nbtInfo;
        synchronized (nBTTagCompound) {
            this.merge(nbt, this.nbtInfo);
            return nbt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound nBTTagCompound = this.nbtInfo;
        synchronized (nBTTagCompound) {
            for (String key : this.nbtInfo.func_150296_c()) {
                this.nbtInfo.func_82580_o(key);
            }
            this.merge(this.nbtInfo, nbt);
        }
    }

    private NBTTagCompound getDomain(ResourceLocation res) {
        return this.nbtInfo.func_74775_l(res.func_110624_b());
    }

    private void merge(NBTTagCompound parent, NBTTagCompound other) {
        for (String s : other.func_150296_c()) {
            NBTBase nbtbase = other.func_74781_a(s);
            if (nbtbase.func_74732_a() == 10) {
                if (parent.func_150297_b(s, 10)) {
                    NBTTagCompound nbttagcompound = parent.func_74775_l(s);
                    this.merge(nbttagcompound, (NBTTagCompound)nbtbase);
                    continue;
                }
                parent.func_74782_a(s, nbtbase.func_74737_b());
                continue;
            }
            parent.func_74782_a(s, nbtbase.func_74737_b());
        }
    }
}

