/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui2.editors.designer.PanelToolController;
import betterquesting.network.handlers.NetQuestEdit;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ToolboxToolFrame
implements IToolboxTool {
    private CanvasQuestLine gui;

    @Override
    public void initTool(CanvasQuestLine gui) {
        this.gui = gui;
    }

    @Override
    public void refresh(CanvasQuestLine gui) {
    }

    @Override
    public void disableTool() {
    }

    @Override
    public void drawCanvas(int mx, int my, float partialTick) {
    }

    @Override
    public void drawOverlay(int mx, int my, float partialTick) {
    }

    @Override
    public void onSelection(List<PanelButtonQuest> buttons) {
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (click != 0 || !this.gui.getTransform().contains(mx, my)) {
            return false;
        }
        PanelButtonQuest btn = this.gui.getButtonAt(mx, my);
        if (btn == null) {
            return false;
        }
        if (PanelToolController.selected.size() > 0 && !PanelToolController.selected.contains(btn)) {
            return false;
        }
        List<PanelButtonQuest> btnList = PanelToolController.selected.size() > 0 ? PanelToolController.selected : Collections.singletonList(btn);
        this.changeFrame(btnList);
        return true;
    }

    private void changeFrame(List<PanelButtonQuest> btnList) {
        boolean state = ((IQuest)((DBEntry)btnList.get(0).getStoredValue()).getValue()).getProperty(NativeProps.MAIN) == false;
        NBTTagList dataList = new NBTTagList();
        for (PanelButtonQuest btn : btnList) {
            ((IQuest)((DBEntry)btn.getStoredValue()).getValue()).setProperty(NativeProps.MAIN, state);
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74768_a("questID", ((DBEntry)btn.getStoredValue()).getID());
            entry.func_74782_a("config", (NBTBase)((IQuest)((DBEntry)btn.getStoredValue()).getValue()).writeToNBT(new NBTTagCompound()));
            dataList.func_74742_a((NBTBase)entry);
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)dataList);
        payload.func_74768_a("action", 0);
        NetQuestEdit.sendEdit(payload);
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyPressed(char c, int key) {
        if (PanelToolController.selected.size() <= 0 || key != 28) {
            return false;
        }
        this.changeFrame(PanelToolController.selected);
        return true;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }

    @Override
    public boolean clampScrolling() {
        return true;
    }

    @Override
    public boolean useSelection() {
        return true;
    }
}

