/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.gui2.editors.designer.PanelToolController;
import betterquesting.client.toolbox.ToolboxTabMain;
import betterquesting.network.handlers.NetChapterEdit;
import betterquesting.network.handlers.NetQuestEdit;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.QuestLineEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ToolboxToolCopy
implements IToolboxTool {
    private CanvasQuestLine gui = null;
    private final List<GrabEntry> grabList = new ArrayList<GrabEntry>();

    @Override
    public void initTool(CanvasQuestLine gui) {
        this.gui = gui;
        this.grabList.clear();
    }

    @Override
    public void disableTool() {
        this.grabList.clear();
    }

    @Override
    public void refresh(CanvasQuestLine gui) {
        if (this.grabList.size() <= 0) {
            return;
        }
        ArrayList<GrabEntry> tmp = new ArrayList<GrabEntry>();
        block0: for (GrabEntry grab : this.grabList) {
            for (PanelButtonQuest btn : PanelToolController.selected) {
                if (((DBEntry)btn.getStoredValue()).getID() != ((DBEntry)grab.btn.getStoredValue()).getID()) continue;
                tmp.add(new GrabEntry(btn, grab.offX, grab.offY));
                continue block0;
            }
        }
        this.grabList.clear();
        this.grabList.addAll(tmp);
    }

    @Override
    public void drawCanvas(int mx, int my, float partialTick) {
        if (this.grabList.size() <= 0) {
            return;
        }
        int snap = Math.max(1, ToolboxTabMain.INSTANCE.getSnapValue());
        int dx = mx;
        int dy = my;
        dx = (dx % snap + snap) % snap;
        dy = (dy % snap + snap) % snap;
        dx = mx - dx;
        dy = my - dy;
        for (GrabEntry grab : this.grabList) {
            ((GrabEntry)grab).btn.rect.x = dx + grab.offX;
            ((GrabEntry)grab).btn.rect.y = dy + grab.offY;
            grab.btn.drawPanel(dx, dy, partialTick);
        }
    }

    @Override
    public void drawOverlay(int mx, int my, float partialTick) {
        if (this.grabList.size() > 0) {
            ToolboxTabMain.INSTANCE.drawGrid(this.gui);
        }
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return this.grabList.size() <= 0 ? null : Collections.emptyList();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.grabList.size() > 0) {
            this.grabList.clear();
            return true;
        }
        if (click != 0 || !this.gui.getTransform().contains(mx, my)) {
            return false;
        }
        if (this.grabList.size() <= 0) {
            PanelButtonQuest btnClicked = this.gui.getButtonAt(mx, my);
            if (btnClicked != null) {
                if (PanelToolController.selected.size() > 0) {
                    if (!PanelToolController.selected.contains(btnClicked)) {
                        return false;
                    }
                    for (PanelButtonQuest btn : PanelToolController.selected) {
                        GuiRectangle rect = new GuiRectangle(btn.rect);
                        this.grabList.add(new GrabEntry(new PanelButtonQuest(rect, -1, "", (DBEntry)btn.getStoredValue()), rect.x - btnClicked.rect.x, rect.y - btnClicked.rect.y));
                    }
                } else {
                    this.grabList.add(new GrabEntry(new PanelButtonQuest(new GuiRectangle(btnClicked.rect), -1, "", (DBEntry)btnClicked.getStoredValue()), 0, 0));
                }
                return true;
            }
            return false;
        }
        IQuestLine qLine = this.gui.getQuestLine();
        int lID = QuestLineDatabase.INSTANCE.getID(qLine);
        int[] nextIDs = this.getNextIDs(this.grabList.size());
        HashMap<Integer, Integer> remappedIDs = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.grabList.size(); ++i) {
            remappedIDs.put(((DBEntry)this.grabList.get(i).btn.getStoredValue()).getID(), nextIDs[i]);
        }
        NBTTagList qdList = new NBTTagList();
        for (int i = 0; i < this.grabList.size(); ++i) {
            GrabEntry grab = this.grabList.get(i);
            IQuest quest = (IQuest)((DBEntry)grab.btn.getStoredValue()).getValue();
            int qID = nextIDs[i];
            if (qLine.getValue(qID) == null) {
                qLine.add(qID, new QuestLineEntry(((GrabEntry)grab).btn.rect.x, ((GrabEntry)grab).btn.rect.y, ((GrabEntry)grab).btn.rect.w, ((GrabEntry)grab).btn.rect.h));
            }
            NBTTagCompound questTags = quest.writeToNBT(new NBTTagCompound());
            int[] oldIDs = Arrays.copyOf(quest.getRequirements(), quest.getRequirements().length);
            for (int n = 0; n < oldIDs.length; ++n) {
                if (!remappedIDs.containsKey(oldIDs[n])) continue;
                oldIDs[n] = (Integer)remappedIDs.get(oldIDs[n]);
            }
            questTags.func_74783_a("preRequisites", oldIDs);
            NBTTagCompound tagEntry = new NBTTagCompound();
            tagEntry.func_74768_a("questID", qID);
            tagEntry.func_74782_a("config", (NBTBase)questTags);
            qdList.func_74742_a((NBTBase)tagEntry);
        }
        this.grabList.clear();
        NBTTagCompound quPayload = new NBTTagCompound();
        quPayload.func_74782_a("data", (NBTBase)qdList);
        quPayload.func_74768_a("action", 3);
        NetQuestEdit.sendEdit(quPayload);
        NBTTagCompound chPayload = new NBTTagCompound();
        NBTTagList cdList = new NBTTagList();
        NBTTagCompound tagEntry = new NBTTagCompound();
        tagEntry.func_74768_a("chapterID", lID);
        tagEntry.func_74782_a("config", (NBTBase)qLine.writeToNBT(new NBTTagCompound(), null));
        cdList.func_74742_a((NBTBase)tagEntry);
        chPayload.func_74782_a("data", (NBTBase)cdList);
        chPayload.func_74768_a("action", 0);
        NetChapterEdit.sendEdit(chPayload);
        return true;
    }

    private int[] getNextIDs(int num) {
        List listDB = QuestDatabase.INSTANCE.getEntries();
        int[] nxtIDs = new int[num];
        if (listDB.size() <= 0 || listDB.get(listDB.size() - 1).getID() == listDB.size() - 1) {
            for (int i = 0; i < num; ++i) {
                nxtIDs[i] = listDB.size() + i;
            }
            return nxtIDs;
        }
        int n1 = 0;
        int n2 = 0;
        for (int i = 0; i < num; ++i) {
            while (n2 < listDB.size() && listDB.get(n2).getID() == n1) {
                ++n1;
                ++n2;
            }
            nxtIDs[i] = n1++;
        }
        return nxtIDs;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyPressed(char c, int keyCode) {
        return this.grabList.size() > 0;
    }

    @Override
    public boolean clampScrolling() {
        return this.grabList.size() <= 0;
    }

    @Override
    public void onSelection(List<PanelButtonQuest> buttons) {
    }

    @Override
    public boolean useSelection() {
        return this.grabList.size() <= 0;
    }

    private class GrabEntry {
        private final PanelButtonQuest btn;
        private final int offX;
        private final int offY;

        private GrabEntry(PanelButtonQuest btn, int offX, int offY) {
            this.btn = btn;
            this.offX = offX;
            this.offY = offY;
        }
    }
}

