/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.controls.io;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.controls.IValueIO;
import net.minecraft.util.MathHelper;

public class FloatSimpleIO
implements IValueIO<Float> {
    private boolean lerp = false;
    private float lerpSpd = 0.02f;
    private boolean clamp = true;
    private final float min;
    private final float max;
    protected float v;
    protected float s;
    private long t;

    public FloatSimpleIO() {
        this(0.0f, 0.0f, 1.0f);
    }

    public FloatSimpleIO(float startVal, float min, float max) {
        this.v = startVal;
        this.s = startVal;
        this.min = min;
        this.max = max;
        this.t = System.currentTimeMillis();
    }

    public FloatSimpleIO setClamp(boolean enable) {
        this.clamp = enable;
        return this;
    }

    public FloatSimpleIO setLerp(boolean enable, float speed) {
        this.lerp = enable;
        this.lerpSpd = speed;
        return this;
    }

    @Override
    public Float readValue() {
        if (this.lerp && this.s != this.v) {
            if (Math.abs(this.s - this.v) < 0.001f) {
                this.s = this.v;
                return Float.valueOf(this.v);
            }
            long d = System.currentTimeMillis() - this.t;
            this.s = RenderUtils.lerpFloat(this.s, this.v, (float)MathHelper.func_151237_a((double)((double)d * (double)this.lerpSpd), (double)0.0, (double)1.0));
            if (d > 0L) {
                this.t = System.currentTimeMillis();
            }
            return Float.valueOf(this.s);
        }
        return Float.valueOf(this.v);
    }

    @Override
    public void writeValue(Float value) {
        if (this.s == this.v) {
            this.t = System.currentTimeMillis();
        }
        this.v = this.clamp ? MathHelper.func_76131_a((float)value.floatValue(), (float)this.min, (float)this.max) : value.floatValue();
    }

    @Override
    public Float readValueRaw() {
        return Float.valueOf(this.v);
    }

    @Override
    public void writeValueRaw(Float value) {
        this.s = this.v = this.clamp ? MathHelper.func_76131_a((float)value.floatValue(), (float)this.min, (float)this.max) : value.floatValue();
    }
}

